/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.shim;

import org.apache.fory.Fory;
import org.apache.fory.collection.ForyObjectMap;
import org.apache.fory.collection.ObjectMap;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.serializer.collection.CollectionSerializer;
import org.apache.fory.serializer.collection.MapSerializers;
import org.apache.fory.util.Preconditions;

public class ShimDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ShimDispatcher.class);
    private final ForyObjectMap<String, Class<? extends Serializer>> className2ShimSerializerClass = new ObjectMap<String, Class<? extends Serializer>>(4, 0.75f);
    private final Fory fory;

    public ShimDispatcher(Fory fory) {
        this.fory = fory;
    }

    public void initialize() {
        this.register("com.alibaba.fastjson.JSONObject", MapSerializers.StringKeyMapSerializer.class);
        this.register("com.alibaba.fastjson.JSONArray", CollectionSerializer.class);
    }

    public boolean contains(Class<?> clazz) {
        return this.className2ShimSerializerClass.containsKey(clazz.getName());
    }

    public void register(String className, Class<? extends Serializer> serializerClass) {
        Preconditions.checkArgument(className != null, "Class name cannot be null");
        Preconditions.checkArgument(serializerClass != null, "Serializer class cannot be null");
        if (this.className2ShimSerializerClass.containsKey(className)) {
            throw new IllegalArgumentException("Class " + className + " has already been registered with serializer:" + serializerClass.getName());
        }
        this.className2ShimSerializerClass.put(className, serializerClass);
    }

    public Serializer<?> getSerializer(Class<?> clazz) {
        String className = clazz.getName();
        if (!this.className2ShimSerializerClass.containsKey(className)) {
            return null;
        }
        Class<? extends Serializer> serializerClass = this.className2ShimSerializerClass.get(className);
        try {
            return Serializers.newSerializer(this.fory, clazz, serializerClass);
        }
        catch (Throwable e) {
            LOG.warn("Construct shim serializer failed for class [{}] with serializer class [{}]", (Object)className, (Object)serializerClass);
            return null;
        }
    }
}

