/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine.dataregion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.iot.log.GetConsensusReqReaderPlan;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.BaseStateMachine;
import org.apache.iotdb.db.consensus.statemachine.dataregion.DataExecutionVisitor;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.SearchNode;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.snapshot.SnapshotLoader;
import org.apache.iotdb.db.storageengine.dataregion.snapshot.SnapshotTaker;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRegionStateMachine
extends BaseStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(DataRegionStateMachine.class);
    private static final FragmentInstanceManager QUERY_INSTANCE_MANAGER = FragmentInstanceManager.getInstance();
    protected DataRegion region;
    private static final int MAX_WRITE_RETRY_TIMES = 5;
    private static final long WRITE_RETRY_WAIT_TIME_IN_MS = 1000L;

    public DataRegionStateMachine(DataRegion region) {
        this.region = region;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isReadOnly() {
        return CommonDescriptor.getInstance().getConfig().isReadOnly();
    }

    public boolean takeSnapshot(File snapshotDir) {
        try {
            SnapshotTaker snapshotTaker = new SnapshotTaker(this.region);
            snapshotTaker.cleanSnapshot();
            return snapshotTaker.takeFullSnapshot(snapshotDir.getAbsolutePath(), true);
        }
        catch (Exception e) {
            logger.error("Exception occurs when taking snapshot for {}-{} in {}", new Object[]{this.region.getDatabaseName(), this.region.getDataRegionIdString(), snapshotDir, e});
            return false;
        }
    }

    public boolean takeSnapshot(File snapshotDir, String snapshotTmpId, String snapshotId) {
        try {
            return new SnapshotTaker(this.region).takeFullSnapshot(snapshotDir.getAbsolutePath(), snapshotTmpId, snapshotId, true);
        }
        catch (Exception e) {
            logger.error("Exception occurs when taking snapshot for {}-{} in {}", new Object[]{this.region.getDatabaseName(), this.region.getDataRegionIdString(), snapshotDir, e});
            return false;
        }
    }

    public boolean clearSnapshot() {
        return SnapshotTaker.clearSnapshotOfDataRegion(this.region);
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        DataRegion newRegion = new SnapshotLoader(latestSnapshotRootDir.getAbsolutePath(), this.region.getDatabaseName(), this.region.getDataRegionIdString()).loadSnapshotForStateMachine();
        if (newRegion == null) {
            logger.error("Fail to load snapshot from {}", (Object)latestSnapshotRootDir);
            return;
        }
        this.region = newRegion;
        try {
            StorageEngine.getInstance().setDataRegion(new DataRegionId(Integer.parseInt(this.region.getDataRegionIdString())), this.region);
            ChunkCache.getInstance().clear();
            TimeSeriesMetadataCache.getInstance().clear();
            BloomFilterCache.getInstance().clear();
        }
        catch (Exception e) {
            logger.error("Exception occurs when replacing data region in storage engine.", (Throwable)e);
        }
    }

    protected PlanNode grabPlanNode(IndexedConsensusRequest indexedRequest) {
        ArrayList<SearchNode> searchNodes = new ArrayList<SearchNode>();
        Object onlyOne = null;
        for (IConsensusRequest req : indexedRequest.getRequests()) {
            PlanNode planNode = this.getPlanNode(req);
            if (planNode instanceof SearchNode) {
                ((SearchNode)planNode).setSearchIndex(indexedRequest.getSearchIndex());
                searchNodes.add((SearchNode)planNode);
                continue;
            }
            logger.warn("Unexpected PlanNode type {}, which is not SearchNode", planNode.getClass());
            if (onlyOne == null) {
                onlyOne = planNode;
                continue;
            }
            throw new IllegalArgumentException(String.format("There are two types of PlanNode in one request: %s and %s", onlyOne.getClass(), planNode.getClass()));
        }
        if (onlyOne != null) {
            if (!searchNodes.isEmpty()) {
                throw new IllegalArgumentException(String.format("There are two types of PlanNode in one request: %s and SearchNode", onlyOne.getClass()));
            }
            return onlyOne;
        }
        return ((SearchNode)searchNodes.get(0)).merge(searchNodes);
    }

    public List<File> getSnapshotFiles(File latestSnapshotRootDir) {
        try {
            return new SnapshotLoader(latestSnapshotRootDir.getAbsolutePath(), this.region.getDatabaseName(), this.region.getDataRegionIdString()).getSnapshotFileInfo();
        }
        catch (IOException e) {
            logger.error("Meets error when getting snapshot files for {}-{}", new Object[]{this.region.getDatabaseName(), this.region.getDataRegionIdString(), e});
            return null;
        }
    }

    public TSStatus write(IConsensusRequest request) {
        try {
            return this.write((PlanNode)request);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    protected TSStatus write(PlanNode planNode) {
        TSStatus result = null;
        int retryTime = 0;
        while (retryTime < 5 && DataRegionStateMachine.needRetry((result = planNode.accept(new DataExecutionVisitor(), this.region)).getCode())) {
            logger.debug("write operation failed because {}, retryTime: {}.", (Object)result.getCode(), (Object)(++retryTime));
            if (retryTime == 5) {
                logger.error("write operation still failed after {} retry times, because {}.", (Object)5, (Object)result.getCode());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return result;
    }

    public DataSet read(IConsensusRequest request) {
        FragmentInstance fragmentInstance;
        if (request instanceof GetConsensusReqReaderPlan) {
            return this.region.getWALNode().orElseThrow(UnsupportedOperationException::new);
        }
        try {
            fragmentInstance = this.getFragmentInstance(request);
        }
        catch (IllegalArgumentException e) {
            logger.error("Get fragment instance failed", (Throwable)e);
            return null;
        }
        return QUERY_INSTANCE_MANAGER.execDataQueryFragmentInstance(fragmentInstance, this.region);
    }

    public boolean hasPipeReleaseRegionRelatedResource(ConsensusGroupId groupId) {
        return PipeDataNodeAgent.task().hasPipeReleaseRegionRelatedResource(groupId.getId());
    }

    public boolean hasReleaseAllRegionRelatedResource(ConsensusGroupId groupId) {
        boolean releaseAllResource = true;
        return releaseAllResource &= this.hasPipeReleaseRegionRelatedResource(groupId);
    }

    public File getSnapshotRoot() {
        String snapshotDir = "";
        try {
            snapshotDir = IoTDBDescriptor.getInstance().getConfig().getRatisDataRegionSnapshotDir() + File.separator + this.region.getDatabaseName() + "-" + this.region.getDataRegionIdString();
            return new File(snapshotDir).getCanonicalFile();
        }
        catch (IOException | NullPointerException e) {
            logger.warn("{}: cannot get the canonical file of {} due to {}", new Object[]{this, snapshotDir, e});
            return null;
        }
    }

    public static boolean needRetry(int statusCode) {
        return statusCode == TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode();
    }
}

