/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.nio.charset.StandardCharsets;
import org.apache.james.jdkim.api.HashMethod;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.api.SigningAlgorithm;
import org.apache.james.jdkim.tagvalue.SignatureRecordImpl;
import org.apache.james.jdkim.tagvalue.SignatureRecordTemplate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SignatureRecordTemplateTest {
    @Test
    public void testBasic() {
        new SignatureRecordTemplate("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=");
    }

    @Test
    public void testWrongOrMissingVersion() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SignatureRecordTemplate("a=rsa-sha1; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        b=Kw/TqnjB4L5ZC7DX1ibiNkuIw630uHZvzuozn/e6yTm3U8ObWEz/rJK5GO8RSrF56JrCA/xo8W2CGmyNmpQYbEpLl5P9/NcJSYUmln/O6GSa4Usyv4FdEU4FVjkyW0ToGFHNkw9Mm0urveA4Lcfk9gClJczXnvGBdiv/bkVBEJk=")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("mandatory").hasMessageContaining("v");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SignatureRecordTemplate("v=2; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=")).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Invalid").hasMessageContaining("version").hasMessageContaining("2");
    }

    @Test
    public void testMissingRequired() {
        Assertions.assertThatThrownBy(() -> new SignatureRecordTemplate("v=1; \r\n         s=beta;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n")).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testDomainMismatch() {
        Assertions.assertThatThrownBy(() -> new SignatureRecordTemplate("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta; i=@agmail.com;\r\n        h=domainkey-signature:received:received:message-id:date:from:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=")).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testMissingFrom() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SignatureRecordTemplate("v=1; a=rsa-sha256; c=relaxed/relaxed;\r\n        d=gmail.com; s=beta; i=@subdomain.gmail.com;\r\n        h=domainkey-signature:received:received:message-id:date:fram:to:subject:mime-version:content-type;\r\n        bh=9sd6eO/xnGLInYGPFN86r9q27iClGpwfkl4PBc5XEuQ=;\r\n        b=tGQtBQg1sO+JKopOylApWLngylEqeMcXwCEUQN+S2PSpi9c1G9Nm5df9pMShus3iFaQb0PPvTfpw++cAC8/N0p3Gi/lVLc+Yh7xWEIPZ3Nxd3xqTQy7grIkBpV0q6559dEhhfFoEyLS0OK/IrqFIUVDRIMnsMjimXV7u+Sgoi7Q=")).isInstanceOf(IllegalStateException.class)).hasMessage("From field not signed");
    }

    @Test
    public void testWrongHashSyntaxes() {
        SignatureRecordTemplate sr = new SignatureRecordTemplate("v=1; a=nothyphenedword; bh=abcdef; b=1235345987; h=from:to; s=select; d=example.com");
        Assertions.assertThatThrownBy(() -> ((SignatureRecord)sr).getHashAlgo()).hasMessageContaining("hash");
        Assertions.assertThatThrownBy(() -> ((SignatureRecord)sr).getHashMethod()).hasMessageContaining("hash");
    }

    @Test
    public void testExpired() {
        Assertions.assertThatThrownBy(() -> new SignatureRecordTemplate("v=1; c=simple; h=from:to; s=select; d=example.com; a=rsa-sha1; x=0; bh=abcdef; b=1235345987;")).hasMessageContaining("expired");
    }

    @Test
    public void should_return_a_full_signature_record_when_provided_the_signature() {
        SignatureRecordTemplate template = new SignatureRecordTemplate("v=1; c=simple; h=from:to; s=select; d=example.com;");
        byte[] bodyHash = "bodyHash".getBytes(StandardCharsets.UTF_8);
        byte[] signature = "signature".getBytes(StandardCharsets.UTF_8);
        SignatureRecordImpl signatureRecord = template.toSignatureRecord(SigningAlgorithm.RSA, HashMethod.SHA256, bodyHash, signature);
        Assertions.assertThat((byte[])signatureRecord.getBodyHash()).isEqualTo((Object)bodyHash);
        Assertions.assertThat((byte[])signatureRecord.getSignature()).isEqualTo((Object)signature);
    }
}

