/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.rfc3986.IRI;
import org.apache.jena.rfc3986.Issue;
import org.apache.jena.rfc3986.URNComponents;

class ParseURNComponents {
    public static final char CH_QMARK = '?';
    public static final char CH_HASH = '#';
    public static final char CH_EQUALS = '=';
    public static final char CH_PLUS = '+';
    public static final String R_STR = "?+";
    public static final String Q_STR = "?=";
    public static final String F_STR = "#";
    public static final char F_CH = '#';
    private static BiConsumer<Issue, String> noopHandler = (issue, msg) -> {};
    private static int AnyIChar = 322;
    private static int AnyASCIIChar = 2;
    private static Pattern pattern = Pattern.compile("^(?:\\?\\+[0-9a-z]+)?(?:\\?=[0-9a-z]+)?(?:#[0-9a-z]*)?$", AnyIChar);
    private static Pattern patternComponents = Pattern.compile("^(?:\\?\\+([?+0-9a-z]+))?(?:\\?=([?+=0-9a-z]+))?(?:#(.*))?$", AnyIChar);

    ParseURNComponents() {
    }

    public static URNComponents parseURNComponents(IRI iri2) {
        int x;
        String rqString = iri2.query();
        String fString = iri2.fragment();
        if (rqString == null && fString == null) {
            return null;
        }
        if (rqString == null || rqString.isEmpty()) {
            if (fString == null) {
                return null;
            }
            return ParseURNComponents.createValidURNComponents(null, null, fString);
        }
        BiConsumer<Issue, String> handler = (issue, msg) -> new URNComponentException((String)msg);
        int N = rqString.length();
        int rCompStart = -1;
        int rCompFinish = -1;
        String rComponent = null;
        int qCompStart = -1;
        int qCompFinish = -1;
        String qComponent = null;
        String fComponent = fString;
        if (ParseURNComponents.lookingAtChar1(rqString, 0, N, '+')) {
            char ch;
            rCompStart = 1;
            for (x = 0; !(x >= N || (ch = rqString.charAt(x)) == '?' && ParseURNComponents.lookingAtChar1(rqString, x + 1, N, '=')); ++x) {
            }
            rCompFinish = x;
            if (rCompFinish - rCompStart < 1) {
                handler.accept(Issue.urn_bad_components, "URN r-component must be at least one character");
                return null;
            }
            rComponent = rqString.substring(rCompStart, rCompFinish);
            if (x < N) {
                ++x;
            }
        }
        if (x < N) {
            if (ParseURNComponents.lookingAtChar1(rqString, x, N, '=')) {
                qCompFinish = N;
                qCompStart = x + 1;
                if (qCompFinish - qCompStart < 1) {
                    handler.accept(Issue.urn_bad_components, "URN r-component must be at least one character");
                    return null;
                }
                qComponent = rqString.substring(qCompStart, qCompFinish);
            } else {
                handler.accept(Issue.urn_bad_components, "Unexpected characters in query string");
                return null;
            }
        }
        return ParseURNComponents.createValidURNComponents(rComponent, qComponent, fComponent);
    }

    public static boolean validateURNComponents(String string, int start, BiConsumer<Issue, String> handler) {
        int N = string.length();
        int x = start;
        if (N == 0) {
            return true;
        }
        boolean startIsQmark = ParseURNComponents.lookingAtChar1(string, start, N, '?');
        boolean startIsFrag = ParseURNComponents.lookingAtChar1(string, start, N, '#');
        if (!startIsQmark && !startIsFrag) {
            handler.accept(Issue.urn_bad_components, "Does not start with a r-, q- or f- component");
            return false;
        }
        if (startIsQmark) {
            if ((x = ParseURNComponents.findValidateR(string, x, handler)) == -1) {
                return false;
            }
            if (x == N) {
                return true;
            }
            if ((x = ParseURNComponents.findValidateQ(string, x, handler)) == -1) {
                return false;
            }
            if (x == N) {
                return true;
            }
            if (x == start) {
                handler.accept(Issue.urn_bad_components, "Query string does not start with an r- or q- component");
                return false;
            }
        }
        return (x = ParseURNComponents.findValidateF(string, x, handler)) != -1;
    }

    public static URNComponents parseURNComponents(String componentsString) {
        return ParseURNComponents.parseURNComponents(componentsString, 0, noopHandler);
    }

    public static URNComponents parseURNComponents(String string, int start, BiConsumer<Issue, String> handler) {
        int N = string.length();
        if (N == 0) {
            return null;
        }
        boolean startIsQmark = ParseURNComponents.lookingAtChar1(string, start, N, '?');
        boolean startIsFrag = ParseURNComponents.lookingAtChar1(string, start, N, '#');
        if (!startIsQmark && !startIsFrag) {
            handler.accept(Issue.urn_bad_components, "Does not start with an r-, q- or f- component");
            return null;
        }
        int rCompStart = -1;
        int rCompFinish = -1;
        int qCompStart = -1;
        int qCompFinish = -1;
        int fCompStart = -1;
        int fCompFinish = -1;
        int x = start;
        int xEnd = -1;
        if (startIsQmark) {
            xEnd = ParseURNComponents.findValidateR(string, x, handler);
            if (xEnd == -1) {
                return null;
            }
            if (xEnd != x) {
                rCompStart = x + 2;
                rCompFinish = xEnd;
            }
            if ((xEnd = ParseURNComponents.findValidateQ(string, x = xEnd, handler)) == -1) {
                return null;
            }
            if (xEnd == start) {
                handler.accept(Issue.urn_bad_components, "Query string not start with an r- or q- component");
                return null;
            }
            if (xEnd != x) {
                qCompStart = x + 2;
                qCompFinish = xEnd;
            }
            x = xEnd;
        }
        if ((xEnd = ParseURNComponents.findValidateF(string, x, handler)) == -1) {
            return null;
        }
        if (xEnd != N) {
            return null;
        }
        if (xEnd != x) {
            fCompStart = x + 1;
            fCompFinish = xEnd;
        }
        String rComponent = ParseURNComponents.slice(string, rCompStart, rCompFinish);
        String qComponent = ParseURNComponents.slice(string, qCompStart, qCompFinish);
        String fComponent = ParseURNComponents.slice(string, fCompStart, fCompFinish);
        if (rComponent != null && rComponent.isEmpty()) {
            handler.accept(Issue.urn_bad_components, "URN r-component must be at least one character");
            return null;
        }
        if (qComponent != null && qComponent.isEmpty()) {
            handler.accept(Issue.urn_bad_components, "URN q-component must be at least one character");
            return null;
        }
        if (rComponent == null && qComponent == null && fComponent == null) {
            handler.accept(Issue.urn_bad_components, "Bad URN components");
            return null;
        }
        return ParseURNComponents.createValidURNComponents(rComponent, qComponent, fComponent);
    }

    private static String slice(String string, int start, int finish) {
        if (start == -1) {
            return null;
        }
        return string.substring(start, finish);
    }

    private static int findValidateR(String string, int start, BiConsumer<Issue, String> handler) {
        int compStart;
        int x;
        int N = string.length();
        boolean found = ParseURNComponents.lookingAtChar2(string, start, N, '?', '+');
        if (!found) {
            return start;
        }
        char ch = '\u0000';
        for (x = compStart = start + 2; !(x >= N || (ch = string.charAt(x)) == '#' || ch == '?' && ParseURNComponents.lookingAtChar1(string, x + 1, N, '=')); ++x) {
        }
        int compFinish = x;
        if (compStart == compFinish) {
            handler.accept(Issue.urn_bad_components, "URN r-component must be at least one character");
            return -1;
        }
        return compFinish;
    }

    private static int findValidateQ(String string, int start, BiConsumer<Issue, String> handler) {
        int compStart;
        int x;
        int N = string.length();
        boolean found = ParseURNComponents.lookingAtChar2(string, start, N, '?', '=');
        if (!found) {
            return start;
        }
        char ch = '\u0000';
        for (x = compStart = start + 2; x < N && (ch = string.charAt(x)) != '#'; ++x) {
        }
        int compFinish = x;
        if (compStart == compFinish) {
            handler.accept(Issue.urn_bad_components, "URN q-component must be at least one character");
            return -1;
        }
        return compFinish;
    }

    private static int findValidateF(String string, int start, BiConsumer<Issue, String> handler) {
        int N = string.length();
        boolean found = ParseURNComponents.lookingAtChar1(string, start, N, '#');
        if (!found) {
            return start;
        }
        return N;
    }

    private static boolean lookingAtChar1(String string, int index, int N, char ch1) {
        int idx = index;
        if (idx >= N) {
            return false;
        }
        char x1 = string.charAt(idx);
        return x1 == '\u0000' || x1 == ch1;
    }

    private static boolean lookingAtChar2(String string, int index, int N, char ch1, char ch2) {
        return ParseURNComponents.lookingAtChar1(string, index, N, ch1) && ParseURNComponents.lookingAtChar1(string, index + 1, N, ch2);
    }

    private static URNComponents createValidURNComponents(String rComp, String qComp, String fComp) {
        if (rComp != null && rComp.isEmpty()) {
            return null;
        }
        if (qComp != null && qComp.isEmpty()) {
            return null;
        }
        return new URNComponents(rComp, qComp, fComp);
    }

    static URNComponents parseURNcomponentsRegex(String componentsString) {
        Matcher m = patternComponents.matcher(componentsString);
        if (!m.matches()) {
            return null;
        }
        String r = m.group(1);
        String q = m.group(2);
        String f = m.group(3);
        return ParseURNComponents.createValidURNComponents(r, q, f);
    }

    static class URNComponentException
    extends RuntimeException {
        URNComponentException(String msg) {
            super(msg);
        }

        @Override
        public URNComponentException fillInStackTrace() {
            return this;
        }
    }
}

