/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import org.apache.sis.xml.TransformVersion;

class TransformingNamespaces
implements NamespaceContext {
    final NamespaceContext context;
    final TransformVersion version;

    static NamespaceContext asXML(NamespaceContext context2, TransformVersion version2) {
        if (context2 != null) {
            context2 = context2 instanceof Inverse && ((Inverse)context2).version == version2 ? ((Inverse)context2).context : new TransformingNamespaces(context2, version2);
        }
        return context2;
    }

    static NamespaceContext asJAXB(NamespaceContext context2, TransformVersion version2) {
        if (context2 != null) {
            context2 = context2.getClass() == TransformingNamespaces.class && ((TransformingNamespaces)context2).version == version2 ? ((TransformingNamespaces)context2).context : new Inverse(context2, version2);
        }
        return context2;
    }

    private TransformingNamespaces(NamespaceContext context2, TransformVersion version2) {
        this.context = context2;
        this.version = version2;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.version.exportNS(this.context.getNamespaceURI(prefix));
    }

    @Override
    public String getPrefix(String namespaceURI) {
        String p = this.context.getPrefix(this.version.importNS(namespaceURI));
        if (p != null) {
            return p;
        }
        Iterator<Map.Entry<String, String>> it = this.version.exports();
        while (it.hasNext()) {
            Map.Entry<String, String> e2 = it.next();
            if (!namespaceURI.equals(e2.getValue()) || (p = this.context.getPrefix(e2.getKey())) == null) continue;
            return p;
        }
        return this.context.getPrefix(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return new Prefixes(this.context, this.version.exports(), namespaceURI);
    }

    private static final class Inverse
    extends TransformingNamespaces {
        Inverse(NamespaceContext context2, TransformVersion version2) {
            super(context2, version2);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.version.importNS(this.context.getNamespaceURI(prefix));
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.context.getPrefix(this.version.exportNS(namespaceURI));
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return this.context.getPrefixes(this.version.exportNS(namespaceURI));
        }
    }

    private static final class Prefixes
    implements Iterator<String> {
        private final String namespaceURI;
        private final NamespaceContext context;
        private final Iterator<Map.Entry<String, String>> exports;
        private Iterator<String> prefixes;
        private String next;

        Prefixes(NamespaceContext context2, Iterator<Map.Entry<String, String>> exports, String namespaceURI) {
            this.context = context2;
            this.exports = exports;
            this.namespaceURI = namespaceURI;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                while (this.prefixes == null) {
                    if (!this.exports.hasNext()) {
                        return false;
                    }
                    Map.Entry<String, String> e2 = this.exports.next();
                    if (!this.namespaceURI.equals(e2.getValue())) continue;
                    this.prefixes = this.context.getPrefixes(e2.getKey());
                }
                if (this.prefixes.hasNext()) {
                    this.next = this.prefixes.next();
                    continue;
                }
                this.prefixes = null;
            }
            return true;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String n = this.next;
            this.next = null;
            return n;
        }
    }
}

