/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDFOps;
import org.apache.jena.riot.writer.StreamWriterTriX;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class WriterTriX
implements WriterDatasetRIOT,
WriterGraphRIOT {
    private static String rdfXMLLiteral = XMLLiteralType.rdfXMLLiteral.getURI();

    @Override
    public Lang getLang() {
        return Lang.TRIX;
    }

    @Override
    public void write(OutputStream out, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        IndentedWriter iOut = new IndentedWriter(out);
        this.write(iOut, datasetGraph, prefixMap, baseURI, null);
    }

    @Override
    public void write(Writer out, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        IndentedWriter iOut = RiotLib.create(out);
        this.write(iOut, datasetGraph, prefixMap, baseURI, null);
    }

    private void write(IndentedWriter out, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        StreamWriterTriX w = new StreamWriterTriX(out, prefixMap);
        StreamRDFOps.datasetToStream(datasetGraph, w);
    }

    @Override
    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        IndentedWriter iOut = new IndentedWriter(out);
        WriterTriX.write(iOut, graph, prefixMap, baseURI, null);
    }

    @Override
    public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        IndentedWriter iOut = RiotLib.create(out);
        WriterTriX.write(iOut, graph, prefixMap, baseURI, null);
    }

    private static void write(IndentedWriter out, Graph graph, PrefixMap prefixMap, String baseURI, Object context2) {
        StreamWriterTriX w = new StreamWriterTriX(out, prefixMap);
        StreamRDFOps.graphToStream(graph, w);
    }
}

