/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.pojotools;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.pojotools.Matcher;
import org.apache.juneau.pojotools.MatcherFactory;
import org.apache.juneau.pojotools.NumberMatcherFactory;
import org.apache.juneau.pojotools.PojoTool;
import org.apache.juneau.pojotools.SearchArgs;
import org.apache.juneau.pojotools.StringMatcherFactory;
import org.apache.juneau.pojotools.TimeMatcherFactory;

public final class PojoSearcher
implements PojoTool<SearchArgs> {
    public static final PojoSearcher DEFAULT = new PojoSearcher();
    final MatcherFactory[] factories;

    public PojoSearcher(MatcherFactory ... factories) {
        this.factories = factories;
    }

    public PojoSearcher() {
        this(NumberMatcherFactory.DEFAULT, TimeMatcherFactory.DEFAULT, StringMatcherFactory.DEFAULT);
    }

    @Override
    public Object run(BeanSession session, Object input, SearchArgs args) {
        ClassMeta<Object> type = session.getClassMetaForObject(input);
        Map<String, String> search = args.getSearch();
        if (search.isEmpty() || type == null || !type.isCollectionOrArray()) {
            return input;
        }
        ArrayList<Object> l = null;
        RowMatcher rowMatcher = new RowMatcher(session, search);
        if (type.isCollection()) {
            Collection c = (Collection)input;
            l = new ArrayList(c.size());
            for (Object o : c) {
                if (!rowMatcher.matches(o)) continue;
                l.add(o);
            }
        } else {
            int size = Array.getLength(input);
            l = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                Object o = Array.get(input, i);
                if (!rowMatcher.matches(o)) continue;
                l.add(o);
            }
        }
        return l;
    }

    private class ColumnMatcher {
        String searchPattern;
        Matcher[] matchers;
        BeanSession bs;

        ColumnMatcher(BeanSession bs, String searchPattern) {
            this.bs = bs;
            this.searchPattern = searchPattern;
            this.matchers = new Matcher[PojoSearcher.this.factories.length];
        }

        boolean matches(Object o) {
            ClassMeta<Object> cm = this.bs.getClassMetaForObject(o);
            if (cm == null) {
                return false;
            }
            if (cm.isCollection()) {
                for (Object o2 : (Collection)o) {
                    if (!this.matches(o2)) continue;
                    return true;
                }
                return false;
            }
            if (cm.isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    if (!this.matches(Array.get(o, i))) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < PojoSearcher.this.factories.length; ++i) {
                if (!PojoSearcher.this.factories[i].canMatch(cm)) continue;
                if (this.matchers[i] == null) {
                    this.matchers[i] = PojoSearcher.this.factories[i].create(this.searchPattern);
                }
                return this.matchers[i].matches(cm, o);
            }
            return false;
        }
    }

    private class RowMatcher {
        Map<String, ColumnMatcher> entryMatchers = new HashMap<String, ColumnMatcher>();
        BeanSession bs;

        RowMatcher(BeanSession bs, Map query) {
            this.bs = bs;
            for (Map.Entry e : query.entrySet()) {
                this.entryMatchers.put(StringUtils.stringify(e.getKey()), new ColumnMatcher(bs, StringUtils.stringify(e.getValue())));
            }
        }

        boolean matches(Object o) {
            if (o == null) {
                return false;
            }
            ClassMeta<Object> cm = this.bs.getClassMetaForObject(o);
            if (cm.isMapOrBean()) {
                BeanMap<Object> m = cm.isMap() ? (BeanMap<Object>)o : this.bs.toBeanMap(o);
                for (Map.Entry<String, ColumnMatcher> e : this.entryMatchers.entrySet()) {
                    String key = e.getKey();
                    Object val = null;
                    val = m instanceof BeanMap ? m.getRaw(key) : (Object)m.get(key);
                    if (e.getValue().matches(val)) continue;
                    return false;
                }
                return true;
            }
            if (cm.isCollection()) {
                for (Object o2 : (Collection)o) {
                    if (this.matches(o2)) continue;
                    return false;
                }
                return true;
            }
            if (cm.isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    if (this.matches(Array.get(o, i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

