/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Value;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.Contact;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.License;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.Tag;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.jsonschema.annotation.ExternalDocs;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestParamType;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.SwaggerException;
import org.apache.juneau.rest.annotation.MethodSwagger;
import org.apache.juneau.rest.annotation.ResourceSwagger;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.util.AnnotationUtils;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.ASet;
import org.apache.juneau.utils.MessageBundle;

final class SwaggerGenerator {
    private final VarResolverSession vr;
    private final Locale locale;
    private final RestContext context;
    private final JsonParser jp = JsonParser.create().ignoreUnknownBeanProperties().build();
    private final JsonSchemaGeneratorSession js;
    private final Class<?> c;
    private final Object resource;
    private final MessageBundle mb;

    public SwaggerGenerator(RestContext context, VarResolverSession vr, Locale locale) {
        this.vr = vr;
        this.locale = locale;
        this.context = context;
        this.js = context.getJsonSchemaGenerator().createSession();
        this.c = context.getResource().getClass();
        this.resource = context.getResource();
        this.mb = context.getMessages();
    }

    /*
     * Could not resolve type clashes
     */
    public Swagger getSwagger() throws Exception {
        String s;
        Object info;
        ResourceSwagger r;
        ObjectMap sInfo;
        ClassInfo rci = ClassInfo.of(this.resource.getClass());
        rci.getSimpleName();
        ObjectMap omSwagger = this.context.getClasspathResource(ObjectMap.class, MediaType.JSON, rci.getSimpleName() + ".json", this.locale);
        if (omSwagger == null) {
            omSwagger = this.context.getClasspathResource(ObjectMap.class, MediaType.JSON, rci.getSimpleName() + ".json", this.locale);
        }
        if (omSwagger == null) {
            omSwagger = new ObjectMap();
        }
        for (Annotation rr : rci.getAnnotationsParentFirst(RestResource.class)) {
            sInfo = omSwagger.getObjectMap("info", true);
            sInfo.appendSkipEmpty("title", this.firstNonEmpty(sInfo.getString("title"), this.resolve(rr.title())));
            sInfo.appendSkipEmpty("description", this.firstNonEmpty(sInfo.getString("description"), this.resolve(rr.description())));
            r = rr.swagger();
            omSwagger.appendAll(this.parseMap(r.value(), "@ResourceSwagger(value) on class {0}", this.c));
            if (!AnnotationUtils.empty(r)) {
                info = omSwagger.getObjectMap("info", true);
                ((ObjectMap)info).appendSkipEmpty("title", this.resolve(r.title()));
                ((ObjectMap)info).appendSkipEmpty("description", this.resolve(r.description()));
                ((ObjectMap)info).appendSkipEmpty("version", this.resolve(r.version()));
                ((ObjectMap)info).appendSkipEmpty("termsOfService", this.resolve(r.termsOfService()));
                ((ObjectMap)info).appendSkipEmpty("contact", this.merge(((ObjectMap)info).getObjectMap("contact"), this.toMap(r.contact(), "@ResourceSwagger(contact) on class {0}", this.c)));
                ((ObjectMap)info).appendSkipEmpty("license", this.merge(((ObjectMap)info).getObjectMap("license"), this.toMap(r.license(), "@ResourceSwagger(license) on class {0}", this.c)));
            }
            omSwagger.appendSkipEmpty("externalDocs", this.merge(omSwagger.getObjectMap("externalDocs"), this.toMap(r.externalDocs(), "@ResourceSwagger(externalDocs) on class {0}", this.c)));
            omSwagger.appendSkipEmpty("tags", this.merge(omSwagger.getObjectList("tags"), this.toList(r.tags(), "@ResourceSwagger(tags) on class {0}", this.c)));
        }
        for (Annotation rr : rci.getAnnotationsParentFirst(Rest.class)) {
            sInfo = omSwagger.getObjectMap("info", true);
            sInfo.appendSkipEmpty("title", this.firstNonEmpty(sInfo.getString("title"), this.resolve(rr.title())));
            sInfo.appendSkipEmpty("description", this.firstNonEmpty(sInfo.getString("description"), this.resolve(rr.description())));
            r = rr.swagger();
            omSwagger.appendAll(this.parseMap(r.value(), "@ResourceSwagger(value) on class {0}", this.c));
            if (!AnnotationUtils.empty(r)) {
                info = omSwagger.getObjectMap("info", true);
                ((ObjectMap)info).appendSkipEmpty("title", this.resolve(r.title()));
                ((ObjectMap)info).appendSkipEmpty("description", this.resolve(r.description()));
                ((ObjectMap)info).appendSkipEmpty("version", this.resolve(r.version()));
                ((ObjectMap)info).appendSkipEmpty("termsOfService", this.resolve(r.termsOfService()));
                ((ObjectMap)info).appendSkipEmpty("contact", this.merge(((ObjectMap)info).getObjectMap("contact"), this.toMap(r.contact(), "@ResourceSwagger(contact) on class {0}", this.c)));
                ((ObjectMap)info).appendSkipEmpty("license", this.merge(((ObjectMap)info).getObjectMap("license"), this.toMap(r.license(), "@ResourceSwagger(license) on class {0}", this.c)));
            }
            omSwagger.appendSkipEmpty("externalDocs", this.merge(omSwagger.getObjectMap("externalDocs"), this.toMap(r.externalDocs(), "@ResourceSwagger(externalDocs) on class {0}", this.c)));
            omSwagger.appendSkipEmpty("tags", this.merge(omSwagger.getObjectList("tags"), this.toList(r.tags(), "@ResourceSwagger(tags) on class {0}", this.c)));
        }
        omSwagger.appendSkipEmpty("externalDocs", this.parseMap(this.mb.findFirstString(this.locale, "externalDocs"), "Messages/externalDocs on class {0}", this.c));
        ObjectMap info2 = omSwagger.getObjectMap("info", true);
        info2.appendSkipEmpty("title", this.resolve(this.mb.findFirstString(this.locale, "title")));
        info2.appendSkipEmpty("description", this.resolve(this.mb.findFirstString(this.locale, "description")));
        info2.appendSkipEmpty("version", this.resolve(this.mb.findFirstString(this.locale, "version")));
        info2.appendSkipEmpty("termsOfService", this.resolve(this.mb.findFirstString(this.locale, "termsOfService")));
        info2.appendSkipEmpty("contact", this.parseMap(this.mb.findFirstString(this.locale, "contact"), "Messages/contact on class {0}", this.c));
        info2.appendSkipEmpty("license", this.parseMap(this.mb.findFirstString(this.locale, "license"), "Messages/license on class {0}", this.c));
        if (info2.isEmpty()) {
            omSwagger.remove("info");
        }
        ObjectList produces = omSwagger.getObjectList("produces", true);
        ObjectList consumes = omSwagger.getObjectList("consumes", true);
        if (consumes.isEmpty()) {
            consumes.addAll(this.context.getConsumes());
        }
        if (produces.isEmpty()) {
            produces.addAll(this.context.getProduces());
        }
        LinkedHashMap<Object, Object> tagMap = new LinkedHashMap<Object, Object>();
        if (omSwagger.containsKey("tags")) {
            for (Object om : omSwagger.getObjectList("tags").elements(ObjectMap.class)) {
                String name = ((ObjectMap)om).getString("name");
                if (name == null) {
                    throw new SwaggerException(null, "Tag definition found without name in swagger JSON.", new Object[0]);
                }
                tagMap.put(name, om);
            }
        }
        if ((s = this.mb.findFirstString(this.locale, "tags")) != null) {
            for (Object m : this.parseListOrCdl(s, "Messages/tags on class {0}", this.c).elements(ObjectMap.class)) {
                String name = ((ObjectMap)m).getString("name");
                if (name == null) {
                    throw new SwaggerException(null, "Tag definition found without name in resource bundle on class {0}", new Object[]{this.c});
                }
                if (tagMap.containsKey(name)) {
                    ((ObjectMap)tagMap.get(name)).putAll(m);
                    continue;
                }
                tagMap.put(name, m);
            }
        }
        ObjectMap definitions = omSwagger.getObjectMap("definitions", true);
        for (String defId : definitions.keySet()) {
            this.js.addBeanDef(defId, definitions.getObjectMap(defId));
        }
        for (RestMethodContext sm : this.context.getCallMethods().values()) {
            List<MediaType> mProduces;
            List<MediaType> mConsumes;
            Iterator<Comparable<Integer>> mpi;
            BeanSession bs = sm.createBeanSession();
            Method m = sm.method;
            MethodInfo mi = MethodInfo.of(m);
            RestMethod rm = mi.getAnnotation(RestMethod.class);
            String mn = m.getName();
            ObjectMap op = this.getOperation(omSwagger, sm.getPathPattern(), sm.getHttpMethod().toLowerCase());
            MethodSwagger ms = rm.swagger();
            op.appendAll(this.parseMap(ms.value(), "@MethodSwagger(value) on class {0} method {1}", this.c, m));
            op.appendSkipEmpty("operationId", this.firstNonEmpty(this.resolve(ms.operationId()), op.getString("operationId"), mn));
            op.appendSkipEmpty("summary", this.firstNonEmpty(this.resolve(ms.summary()), this.resolve(this.mb.findFirstString(this.locale, mn + ".summary")), op.getString("summary"), this.resolve(rm.summary())));
            op.appendSkipEmpty("description", this.firstNonEmpty(this.resolve(ms.description()), this.resolve(this.mb.findFirstString(this.locale, mn + ".description")), op.getString("description"), this.resolve(rm.description())));
            op.appendSkipEmpty("deprecated", this.firstNonEmpty(this.resolve(ms.deprecated()), m.getAnnotation(Deprecated.class) != null || m.getDeclaringClass().getAnnotation(Deprecated.class) != null ? "true" : null));
            op.appendSkipEmpty("tags", this.merge(this.parseListOrCdl(this.mb.findFirstString(this.locale, mn + ".tags"), "Messages/tags on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.tags(), "@MethodSwagger(tags) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("schemes", this.merge(this.parseListOrCdl(this.mb.findFirstString(this.locale, mn + ".schemes"), "Messages/schemes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.schemes(), "@MethodSwagger(schemes) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("consumes", this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(this.locale, mn + ".consumes"), "Messages/consumes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.consumes(), "@MethodSwagger(consumes) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("produces", this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(this.locale, mn + ".produces"), "Messages/produces on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.produces(), "@MethodSwagger(produces) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("parameters", this.merge(this.parseList(this.mb.findFirstString(this.locale, mn + ".parameters"), "Messages/parameters on class {0} method {1}", this.c, m), this.parseList(ms.parameters(), "@MethodSwagger(parameters) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("responses", this.merge(this.parseMap(this.mb.findFirstString(this.locale, mn + ".responses"), "Messages/responses on class {0} method {1}", this.c, m), this.parseMap(ms.responses(), "@MethodSwagger(responses) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("externalDocs", this.merge(op.getObjectMap("externalDocs"), this.parseMap(this.mb.findFirstString(this.locale, mn + ".externalDocs"), "Messages/externalDocs on class {0} method {1}", this.c, m), this.toMap(ms.externalDocs(), "@MethodSwagger(externalDocs) on class {0} method {1}", this.c, m)));
            if (op.containsKey("tags")) {
                for (Object tag : op.getObjectList("tags").elements(String.class)) {
                    if (tagMap.containsKey(tag)) continue;
                    tagMap.put(tag, new ObjectMap().append("name", tag));
                }
            }
            ObjectMap paramMap = new ObjectMap();
            if (op.containsKey("parameters")) {
                Object tag;
                tag = op.getObjectList("parameters").elements(ObjectMap.class).iterator();
                while (tag.hasNext()) {
                    ObjectMap param = (ObjectMap)tag.next();
                    paramMap.put(param.getString("in") + '.' + ("body".equals(param.getString("in")) ? "body" : param.getString("name")), param);
                }
            }
            for (RestMethodParam mp : this.context.getRestMethodParams(m)) {
                RestParamType in = mp.getParamType();
                mpi = mp.getMethodParamInfo();
                if (!in.isAny(RestParamType.BODY, RestParamType.QUERY, RestParamType.FORM_DATA, RestParamType.HEADER, RestParamType.PATH)) continue;
                String key = in.toString() + '.' + (in == RestParamType.BODY ? "body" : mp.getName());
                ObjectMap param = paramMap.getObjectMap(key, true);
                param.append("in", (Object)in);
                if (in != RestParamType.BODY) {
                    param.append("name", mp.name);
                }
                try {
                    if (mpi != null) {
                        if (in == RestParamType.BODY) {
                            for (Annotation a : ((ParamInfo)((Object)mpi)).getAnnotationsParentFirst(Body.class)) {
                                this.merge(param, (Body)a);
                            }
                        } else if (in == RestParamType.QUERY) {
                            for (Annotation a : ((ParamInfo)((Object)mpi)).getAnnotationsParentFirst(Query.class)) {
                                this.merge(param, (Query)a);
                            }
                        } else if (in == RestParamType.FORM_DATA) {
                            for (Annotation a : ((ParamInfo)((Object)mpi)).getAnnotationsParentFirst(FormData.class)) {
                                this.merge(param, (FormData)a);
                            }
                        } else if (in == RestParamType.HEADER) {
                            for (Annotation a : ((ParamInfo)((Object)mpi)).getAnnotationsParentFirst(Header.class)) {
                                this.merge(param, (Header)a);
                            }
                        } else if (in == RestParamType.PATH) {
                            for (Annotation a : ((ParamInfo)((Object)mpi)).getAnnotationsParentFirst(Path.class)) {
                                this.merge(param, (Path)a);
                            }
                        }
                    }
                }
                catch (ParseException e) {
                    throw new SwaggerException(e, "Malformed swagger JSON object encountered in {0} class {1} method parameter {2}", new Object[]{in, this.c, mpi});
                }
                if (!(in != RestParamType.BODY && in != RestParamType.PATH || param.containsKeyNotEmpty("required"))) {
                    param.put("required", true);
                }
                if (in == RestParamType.BODY) {
                    param.appendSkipEmpty("schema", this.getSchema(param.getObjectMap("schema"), mp.getType(), bs));
                    this.addBodyExamples(sm, param, false, mp.getType());
                    continue;
                }
                this.mergePartSchema(param, this.getSchema(param.getObjectMap("schema"), mp.getType(), bs));
                this.addParamExample(sm, param, in, mp.getType());
            }
            if (!paramMap.isEmpty()) {
                op.put("parameters", paramMap.values());
            }
            ObjectMap responses = op.getObjectMap("responses", true);
            for (ClassInfo eci : mi.getExceptionTypes()) {
                if (!eci.hasAnnotation(Response.class)) continue;
                Iterator<MethodInfo> la = eci.getAnnotationsParentFirst(Response.class);
                Set<Integer> codes = SwaggerGenerator.getCodes(la, 500);
                mpi = la.iterator();
                while (mpi.hasNext()) {
                    Response a = (Response)mpi.next();
                    for (Integer code : codes) {
                        ObjectMap om = responses.getObjectMap(String.valueOf(code), true);
                        this.merge(om, a);
                        if (om.containsKey("schema")) continue;
                        om.appendSkipEmpty("schema", this.getSchema(om.getObjectMap("schema"), eci.inner(), bs));
                    }
                }
                for (MethodInfo ecmi : eci.getAllMethodsParentFirst()) {
                    ResponseHeader a = ecmi.getAnnotation(ResponseHeader.class);
                    if (a == null) {
                        a = ecmi.getResolvedReturnType().getAnnotation(ResponseHeader.class);
                    }
                    if (a == null) continue;
                    String ha = a.name();
                    for (Integer code : codes) {
                        ObjectMap header = responses.getObjectMap(String.valueOf(code), true).getObjectMap("headers", true).getObjectMap(ha, true);
                        this.merge(header, a);
                        this.mergePartSchema(header, this.getSchema(header, ecmi.getReturnType().innerType(), bs));
                    }
                }
            }
            if (mi.hasAnnotation(Response.class) || mi.getResolvedReturnType().hasAnnotation(Response.class)) {
                List<Response> la = mi.getAnnotationsParentFirst(Response.class);
                Set<Integer> codes = SwaggerGenerator.getCodes(la, 200);
                for (Response a : la) {
                    for (Integer code : codes) {
                        ObjectMap om = responses.getObjectMap(String.valueOf(code), true);
                        this.merge(om, a);
                        if (!om.containsKey("schema")) {
                            om.appendSkipEmpty("schema", this.getSchema(om.getObjectMap("schema"), m.getGenericReturnType(), bs));
                        }
                        this.addBodyExamples(sm, om, true, m.getGenericReturnType());
                    }
                }
                if (mi.getReturnType().hasAnnotation(Response.class)) {
                    for (MethodInfo ecmi : mi.getReturnType().getAllMethodsParentFirst()) {
                        if (!ecmi.hasAnnotation(ResponseHeader.class)) continue;
                        ResponseHeader a = ecmi.getAnnotation(ResponseHeader.class);
                        String ha = a.name();
                        for (Integer code : codes) {
                            ObjectMap header = responses.getObjectMap(String.valueOf(code), true).getObjectMap("headers", true).getObjectMap(ha, true);
                            this.merge(header, a);
                            this.mergePartSchema(header, this.getSchema(header, ecmi.getReturnType().innerType(), bs));
                        }
                    }
                }
            } else if (m.getGenericReturnType() != Void.TYPE) {
                RestMethodParam[] om = responses.getObjectMap("200", true);
                if (!om.containsKey("schema")) {
                    om.appendSkipEmpty("schema", this.getSchema(om.getObjectMap("schema"), m.getGenericReturnType(), bs));
                }
                this.addBodyExamples(sm, (ObjectMap)om, true, m.getGenericReturnType());
            }
            for (RestMethodParam mp : this.context.getRestMethodParams(m)) {
                Set<Integer> codes;
                List<Annotation> la;
                RestParamType in = mp.getParamType();
                ParamInfo mpi2 = mp.getMethodParamInfo();
                if (in == RestParamType.RESPONSE_HEADER) {
                    la = mpi2.getAnnotationsParentFirst(ResponseHeader.class);
                    codes = SwaggerGenerator.getCodes2(la, 200);
                    for (Annotation a : la) {
                        for (Integer code : codes) {
                            ObjectMap header = responses.getObjectMap(String.valueOf(code), true).getObjectMap("headers", true).getObjectMap(mp.name, true);
                            this.merge(header, (ResponseHeader)a);
                            this.mergePartSchema(header, this.getSchema(header, Value.getParameterType(mp.type), bs));
                        }
                    }
                    continue;
                }
                if (in != RestParamType.RESPONSE) continue;
                la = mpi2.getAnnotationsParentFirst(Response.class);
                codes = SwaggerGenerator.getCodes(la, 200);
                for (Annotation a : la) {
                    for (Integer code : codes) {
                        ObjectMap response = responses.getObjectMap(String.valueOf(code), true);
                        this.merge(response, (Response)a);
                    }
                }
                Type type = Value.getParameterType(mp.type);
                if (type == null) continue;
                for (String code : responses.keySet()) {
                    ObjectMap om = responses.getObjectMap(code);
                    if (om.containsKey("schema")) continue;
                    om.appendSkipEmpty("schema", this.getSchema(om.getObjectMap("schema"), type, bs));
                }
            }
            for (Map.Entry e : responses.entrySet()) {
                String key = (String)e.getKey();
                ObjectMap val = responses.getObjectMap(key);
                if (!StringUtils.isDecimal(key)) continue;
                val.appendIf(false, true, true, "description", RestUtils.getHttpResponseText(Integer.parseInt(key)));
            }
            if (responses.isEmpty()) {
                op.remove("responses");
            } else {
                op.put("responses", new TreeMap<String, Object>(responses));
            }
            if (!op.containsKey("consumes") && !(mConsumes = sm.supportedContentTypes).equals(consumes)) {
                op.put("consumes", mConsumes);
            }
            if (op.containsKey("produces") || (mProduces = sm.supportedAcceptTypes).equals(produces)) continue;
            op.put("produces", mProduces);
        }
        if (this.js.getBeanDefs() != null) {
            for (Map.Entry<String, ObjectMap> e : this.js.getBeanDefs().entrySet()) {
                definitions.put(e.getKey(), this.fixSwaggerExtensions(e.getValue()));
            }
        }
        if (definitions.isEmpty()) {
            omSwagger.remove("definitions");
        }
        if (!tagMap.isEmpty()) {
            omSwagger.put("tags", tagMap.values());
        }
        if (consumes.isEmpty()) {
            omSwagger.remove("consumes");
        }
        if (produces.isEmpty()) {
            omSwagger.remove("produces");
        }
        try {
            String swaggerJson = omSwagger.toString(SimpleJsonSerializer.DEFAULT_READABLE);
            return this.jp.parse(swaggerJson, Swagger.class);
        }
        catch (Exception e) {
            throw new RestServletException("Error detected in swagger.", new Object[0]).initCause(e);
        }
    }

    private ObjectMap resolve(ObjectMap om) throws ParseException {
        ObjectMap om2 = null;
        if (om.containsKey("_value")) {
            om = om.modifiable();
            om2 = this.parseMap(om.remove("_value"));
        } else {
            om2 = new ObjectMap();
        }
        for (Map.Entry<String, Object> e : om.entrySet()) {
            Object val = e.getValue();
            if (val instanceof ObjectMap) {
                val = this.resolve((ObjectMap)val);
            } else if (val instanceof ObjectList) {
                val = this.resolve((ObjectList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            om2.put(e.getKey(), val);
        }
        return om2;
    }

    private ObjectList resolve(ObjectList om) throws ParseException {
        ObjectList ol2 = new ObjectList();
        for (Object val : om) {
            if (val instanceof ObjectMap) {
                val = this.resolve((ObjectMap)val);
            } else if (val instanceof ObjectList) {
                val = this.resolve((ObjectList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            ol2.add(val);
        }
        return ol2;
    }

    private String resolve(String[] ss) {
        if (ss.length == 0) {
            return null;
        }
        return this.resolve(SwaggerGenerator.joinnl(ss));
    }

    private String resolve(String s) {
        if (s == null) {
            return null;
        }
        return this.vr.resolve(s.trim());
    }

    private ObjectMap parseMap(String[] o, String location, Object ... args) throws ParseException {
        if (o.length == 0) {
            return ObjectMap.EMPTY_MAP;
        }
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private ObjectMap parseMap(String o, String location, Object ... args) throws ParseException {
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private ObjectMap parseMap(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            o = SwaggerGenerator.joinnl((String[])o);
        }
        if (o instanceof String) {
            String s = o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if ("IGNORE".equalsIgnoreCase(s = this.resolve(s))) {
                return new ObjectMap().append("ignore", true);
            }
            if (!StringUtils.isObjectMap(s, true)) {
                s = "{" + s + "}";
            }
            return new ObjectMap(s);
        }
        if (o instanceof ObjectMap) {
            return (ObjectMap)o;
        }
        throw new SwaggerException(null, "Unexpected data type ''{0}''.  Expected ObjectMap or String.", new Object[]{o.getClass().getName()});
    }

    private ObjectList parseList(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? SwaggerGenerator.joinnl((String[])o) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if (!StringUtils.isObjectList(s = this.resolve(s), true)) {
                s = "[" + s + "]";
            }
            return new ObjectList(s);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private ObjectList parseListOrCdl(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? SwaggerGenerator.joinnl((String[])o) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            s = this.resolve(s);
            return StringUtils.parseListOrCdl(s);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private ObjectMap newMap(ObjectMap om, String[] value, String location, Object ... locationArgs) throws ParseException {
        if (value.length == 0) {
            return om == null ? new ObjectMap() : om;
        }
        ObjectMap om2 = this.parseMap(SwaggerGenerator.joinnl(value), location, locationArgs);
        if (om == null) {
            return om2;
        }
        return om.appendAll(om2);
    }

    private ObjectMap merge(ObjectMap ... maps) {
        ObjectMap m = maps[0];
        for (int i = 1; i < maps.length; ++i) {
            if (maps[i] == null) continue;
            if (m == null) {
                m = new ObjectMap();
            }
            m.putAll(maps[i]);
        }
        return m;
    }

    private ObjectList merge(ObjectList ... lists) {
        ObjectList l = lists[0];
        for (int i = 1; i < lists.length; ++i) {
            if (lists[i] == null) continue;
            if (l == null) {
                l = new ObjectList();
            }
            l.addAll(lists[i]);
        }
        return l;
    }

    @SafeVarargs
    private final <T> T firstNonEmpty(T ... t) {
        return ObjectUtils.firstNonEmpty(t);
    }

    private ObjectMap toMap(ExternalDocs a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return null;
        }
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("description", this.resolve(SwaggerGenerator.joinnl(a.description())));
        om.appendSkipEmpty("url", this.resolve(a.url()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap toMap(Contact a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return null;
        }
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("name", this.resolve(a.name()));
        om.appendSkipEmpty("url", this.resolve(a.url()));
        om.appendSkipEmpty("email", this.resolve(a.email()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap toMap(License a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return null;
        }
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("name", this.resolve(a.name()));
        om.appendSkipEmpty("url", this.resolve(a.url()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap toMap(Tag a, String location, Object ... locationArgs) throws ParseException {
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("name", this.resolve(a.name()));
        om.appendSkipEmpty("description", this.resolve(SwaggerGenerator.joinnl(a.description())));
        om.appendSkipNull("externalDocs", this.merge(om.getObjectMap("externalDocs"), this.toMap(a.externalDocs(), location, locationArgs)));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectList toList(Tag[] aa, String location, Object ... locationArgs) throws ParseException {
        if (aa.length == 0) {
            return null;
        }
        ObjectList ol = new ObjectList();
        for (Tag a : aa) {
            ol.add(this.toMap(a, location, locationArgs));
        }
        return SwaggerGenerator.nullIfEmpty(ol);
    }

    private ObjectMap getSchema(ObjectMap schema, Type type, BeanSession bs) throws Exception {
        if (type == Swagger.class) {
            return null;
        }
        schema = SwaggerGenerator.newMap(schema);
        ClassMeta cm = bs.getClassMeta(type, new Type[0]);
        if (schema.getBoolean("ignore", false).booleanValue()) {
            return null;
        }
        if (schema.containsKey("type") || schema.containsKey("$ref")) {
            return schema;
        }
        ObjectMap om = this.fixSwaggerExtensions(schema.appendAll(this.js.getSchema(cm)));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap fixSwaggerExtensions(ObjectMap om) {
        om.appendSkipNull("discriminator", om.remove("x-discriminator"));
        om.appendSkipNull("readOnly", om.remove("x-readOnly"));
        om.appendSkipNull("xml", om.remove("x-xml"));
        om.appendSkipNull("externalDocs", om.remove("x-externalDocs"));
        om.appendSkipNull("example", om.remove("x-example"));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private void addBodyExamples(RestMethodContext sm, ObjectMap piri, boolean response, Type type) throws Exception {
        ObjectMap schema;
        String sex = piri.getString("x-example");
        if (sex == null && (schema = this.resolveRef(piri.getObjectMap("schema"))) != null) {
            sex = schema.getString("example", schema.getString("x-example"));
        }
        if (StringUtils.isEmpty(sex)) {
            return;
        }
        Object example = null;
        if (StringUtils.isJson(sex)) {
            example = this.jp.parse(sex, type, new Type[0]);
        } else {
            ClassMeta cm = this.js.getClassMeta(type, new Type[0]);
            if (cm.hasStringMutater()) {
                example = cm.getStringMutater().mutate(sex);
            }
        }
        String examplesKey = response ? "examples" : "x-examples";
        ObjectMap examples = piri.getObjectMap(examplesKey);
        if (examples == null) {
            examples = new ObjectMap();
        }
        List<MediaType> mediaTypes = response ? sm.getSerializers().getSupportedMediaTypes() : sm.getParsers().getSupportedMediaTypes();
        for (MediaType mt : mediaTypes) {
            Serializer s2;
            if (mt == MediaType.HTML || (s2 = sm.getSerializers().getSerializer(mt)) == null) continue;
            SerializerSessionArgs args = SerializerSessionArgs.create().locale(this.locale).mediaType(mt).useWhitespace(true);
            try {
                String eVal = s2.createSession(args).serializeToString(example);
                examples.put(s2.getPrimaryMediaType().toString(), eVal);
            }
            catch (Exception e) {
                System.err.println("Could not serialize to media type [" + mt + "]: " + e.getLocalizedMessage());
            }
        }
        if (!examples.isEmpty()) {
            piri.put(examplesKey, examples);
        }
    }

    private void addParamExample(RestMethodContext sm, ObjectMap piri, RestParamType in, Type type) throws Exception {
        String s = piri.getString("x-example");
        if (StringUtils.isEmpty(s)) {
            return;
        }
        ObjectMap examples = piri.getObjectMap("x-examples");
        if (examples == null) {
            examples = new ObjectMap();
        }
        String paramName = piri.getString("name");
        if (in == RestParamType.QUERY) {
            s = "?" + StringUtils.urlEncodeLax(paramName) + "=" + StringUtils.urlEncodeLax(s);
        } else if (in == RestParamType.FORM_DATA) {
            s = paramName + "=" + s;
        } else if (in == RestParamType.HEADER) {
            s = paramName + ": " + s;
        } else if (in == RestParamType.PATH) {
            s = sm.getPathPattern().replace("{" + paramName + "}", StringUtils.urlEncodeLax(s));
        }
        examples.put("example", s);
        if (!examples.isEmpty()) {
            piri.put("x-examples", examples);
        }
    }

    private ObjectMap resolveRef(ObjectMap m) {
        String ref;
        if (m == null) {
            return null;
        }
        if (m.containsKey("$ref") && this.js.getBeanDefs() != null && (ref = m.getString("$ref")).startsWith("#/definitions/")) {
            return this.js.getBeanDefs().get(ref.substring(14));
        }
        return m;
    }

    private ObjectMap getOperation(ObjectMap om, String path, String httpMethod) {
        if (!om.containsKey("paths")) {
            om.put("paths", new ObjectMap());
        }
        if (!(om = om.getObjectMap("paths")).containsKey(path)) {
            om.put(path, new ObjectMap());
        }
        if (!(om = om.getObjectMap(path)).containsKey(httpMethod)) {
            om.put(httpMethod, new ObjectMap());
        }
        return om.getObjectMap(httpMethod);
    }

    private static ObjectMap newMap(ObjectMap om) {
        if (om == null) {
            return new ObjectMap();
        }
        return om.modifiable();
    }

    private ObjectMap merge(ObjectMap om, Body a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll(this.parseMap(a.value()));
        }
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("description", this.resolve(a.description())).appendSkipEmpty("x-example", this.resolve(a.example())).appendSkipEmpty("x-examples", this.parseMap(a.examples())).appendSkipFalse("required", a.required()).appendSkipEmpty("schema", this.merge(om.getObjectMap("schema"), a.schema()));
    }

    private ObjectMap merge(ObjectMap om, Query a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.appendSkipFalse("allowEmptyValue", a.allowEmptyValue()).appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("default", SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", a.format()).appendSkipEmpty("items", this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipFalse("required", a.required()).appendSkipEmpty("type", a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, FormData a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.appendSkipFalse("allowEmptyValue", a.allowEmptyValue()).appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("default", SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", a.format()).appendSkipEmpty("items", this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipFalse("required", a.required()).appendSkipEmpty("type", a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, Header a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("default", SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", a.format()).appendSkipEmpty("items", this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipFalse("required", a.required()).appendSkipEmpty("type", a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, Path a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("description", this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", a.format()).appendSkipEmpty("items", this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipEmpty("type", a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, Schema a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll(this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("additionalProperties", this.toObjectMap(a.additionalProperties())).appendSkipEmpty("allOf", SwaggerGenerator.joinnl(a.allOf())).appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("default", SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("discriminator", a.discriminator()).appendSkipEmpty("description", this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", this.resolve(a.example())).appendSkipEmpty("examples", this.parseMap(a.examples())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("externalDocs", this.merge(om.getObjectMap("externalDocs"), a.externalDocs())).appendSkipEmpty("format", a.format()).appendSkipEmpty("ignore", a.ignore() ? "true" : null).appendSkipEmpty("items", this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipMinusOne("maxProperties", a.maxProperties()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipMinusOne("minProperties", a.minProperties()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipEmpty("properties", this.toObjectMap(a.properties())).appendSkipFalse("readOnly", a.readOnly()).appendSkipFalse("required", a.required()).appendSkipEmpty("title", a.title()).appendSkipEmpty("type", a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("xml", SwaggerGenerator.joinnl(a.xml())).appendSkipEmpty("$ref", a.$ref());
    }

    private ObjectMap merge(ObjectMap om, ExternalDocs a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll(this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("description", this.resolve(a.description())).appendSkipEmpty("url", a.url());
    }

    private ObjectMap merge(ObjectMap om, Items a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll(this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("default", SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("format", a.format()).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("items", this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("type", a.type()).appendSkipEmpty("$ref", a.$ref());
    }

    private ObjectMap merge(ObjectMap om, SubItems a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll(this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("default", SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", a.format()).appendSkipEmpty("items", this.toObjectMap(a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipEmpty("type", a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("$ref", a.$ref());
    }

    private ObjectMap merge(ObjectMap om, Response a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("description", this.resolve(a.description())).appendSkipEmpty("x-example", this.resolve(a.example())).appendSkipEmpty("examples", this.parseMap(a.examples())).appendSkipEmpty("headers", this.merge(om.getObjectMap("headers"), a.headers())).appendSkipEmpty("schema", this.merge(om.getObjectMap("schema"), a.schema()));
    }

    private ObjectMap merge(ObjectMap om, ResponseHeader[] a) throws ParseException {
        if (a.length == 0) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        for (ResponseHeader aa : a) {
            String name = StringUtils.firstNonEmpty(aa.name(), aa.value());
            if (StringUtils.isEmpty(name)) {
                throw new RuntimeException("@ResponseHeader used without name or value.");
            }
            om.getObjectMap(name, true).putAll(this.merge(null, aa));
        }
        return om;
    }

    private ObjectMap merge(ObjectMap om, ResponseHeader a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("default", SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", a.format()).appendSkipEmpty("items", this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipEmpty("type", a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("$ref", a.$ref());
    }

    private ObjectMap mergePartSchema(ObjectMap param, ObjectMap schema) {
        if (schema != null) {
            param.appendIf(false, true, true, "collectionFormat", schema.remove("collectionFormat")).appendIf(false, true, true, "default", schema.remove("default")).appendIf(false, true, true, "description", schema.remove("enum")).appendIf(false, true, true, "enum", schema.remove("enum")).appendIf(false, true, true, "x-example", schema.remove("x-example")).appendIf(false, true, true, "exclusiveMaximum", schema.remove("exclusiveMaximum")).appendIf(false, true, true, "exclusiveMinimum", schema.remove("exclusiveMinimum")).appendIf(false, true, true, "format", schema.remove("format")).appendIf(false, true, true, "items", schema.remove("items")).appendIf(false, true, true, "maximum", schema.remove("maximum")).appendIf(false, true, true, "maxItems", schema.remove("maxItems")).appendIf(false, true, true, "maxLength", schema.remove("maxLength")).appendIf(false, true, true, "minimum", schema.remove("minimum")).appendIf(false, true, true, "minItems", schema.remove("minItems")).appendIf(false, true, true, "minLength", schema.remove("minLength")).appendIf(false, true, true, "multipleOf", schema.remove("multipleOf")).appendIf(false, true, true, "pattern", schema.remove("pattern")).appendIf(false, true, true, "required", schema.remove("required")).appendIf(false, true, true, "type", schema.remove("type")).appendIf(false, true, true, "uniqueItems", schema.remove("uniqueItems"));
            if ("object".equals(param.getString("type")) && !schema.isEmpty()) {
                param.put("schema", schema);
            }
        }
        return param;
    }

    private ObjectMap toObjectMap(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SwaggerGenerator.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        if (!StringUtils.isObjectMap(s, true)) {
            s = "{" + s + "}";
        }
        s = this.resolve(s);
        return new ObjectMap(s);
    }

    private Set<String> toSet(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SwaggerGenerator.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        s = this.resolve(s);
        ASet<String> set = new ASet<String>();
        for (Object o : StringUtils.parseListOrCdl(s)) {
            set.add(o.toString());
        }
        return set;
    }

    static String joinnl(String[] ss) {
        if (ss.length == 0) {
            return "";
        }
        return StringUtils.joinnl(ss).trim();
    }

    private static Set<Integer> getCodes(List<Response> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (Response a : la) {
            for (int i : a.value()) {
                codes.add(i);
            }
            for (int i : a.code()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static Set<Integer> getCodes2(List<ResponseHeader> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (ResponseHeader a : la) {
            for (int i : a.code()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static ObjectMap nullIfEmpty(ObjectMap m) {
        return m == null || m.isEmpty() ? null : m;
    }

    private static ObjectList nullIfEmpty(ObjectList l) {
        return l == null || l.isEmpty() ? null : l;
    }
}

