/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerSessionArgs;

public class HttpPart {
    private final String name;
    private final Object opart;
    private final String spart;
    private final HttpPartType partType;
    private final HttpPartSchema schema;
    private final HttpPartSerializer serializer;
    private final HttpPartParser parser;
    private final SerializerSessionArgs sargs;
    private final ParserSessionArgs pargs;

    public HttpPart(String name, HttpPartType partType, HttpPartSchema schema, HttpPartSerializer serializer, SerializerSessionArgs args, Object part) {
        this.name = name;
        this.partType = partType;
        this.schema = schema;
        this.serializer = serializer;
        this.sargs = args;
        this.opart = part;
        this.spart = null;
        this.parser = null;
        this.pargs = null;
    }

    public HttpPart(String name, HttpPartType partType, HttpPartSchema schema, HttpPartParser parser, ParserSessionArgs args, String part) {
        this.name = name;
        this.partType = partType;
        this.schema = schema;
        this.parser = parser;
        this.pargs = args;
        this.spart = part;
        this.serializer = null;
        this.sargs = null;
        this.opart = null;
    }

    public String getName() {
        return this.name;
    }

    public String asString() throws SchemaValidationException, SerializeException {
        if (this.spart != null) {
            return this.spart;
        }
        return this.serializer.createPartSession(this.sargs).serialize(this.partType, this.schema, this.opart);
    }

    public <T> T asType(Class<T> c) throws SchemaValidationException, ParseException {
        return this.parser.createPartSession(this.pargs).parse(this.partType, this.schema, this.spart, c);
    }
}

