/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.properties;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaPropertiesEnsemble {
    public static final Logger LOG = LoggerFactory.getLogger(MetaPropertiesEnsemble.class);
    public static final MetaPropertiesEnsemble EMPTY = new MetaPropertiesEnsemble(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), Optional.empty());
    public static final String META_PROPERTIES_NAME = "meta.properties";
    private final Set<String> emptyLogDirs;
    private final Set<String> errorLogDirs;
    private final Map<String, MetaProperties> logDirProps;
    private final Optional<String> metadataLogDir;

    MetaPropertiesEnsemble(Set<String> emptyLogDirs, Set<String> errorLogDirs, Map<String, MetaProperties> logDirProps, Optional<String> metadataLogDir) {
        this.emptyLogDirs = Collections.unmodifiableSet(new TreeSet<String>(emptyLogDirs));
        this.errorLogDirs = Collections.unmodifiableSet(new TreeSet<String>(errorLogDirs));
        this.logDirProps = Collections.unmodifiableMap(new TreeMap<String, MetaProperties>(logDirProps));
        this.metadataLogDir = metadataLogDir;
    }

    public Set<String> emptyLogDirs() {
        return this.emptyLogDirs;
    }

    public Set<String> errorLogDirs() {
        return this.errorLogDirs;
    }

    public Map<String, MetaProperties> logDirProps() {
        return this.logDirProps;
    }

    public Iterator<Map.Entry<String, Optional<MetaProperties>>> nonFailedDirectoryProps() {
        return new Iterator<Map.Entry<String, Optional<MetaProperties>>>(){
            private final Iterator<String> emptyLogDirsIterator;
            private final Iterator<Map.Entry<String, MetaProperties>> logDirsIterator;
            {
                this.emptyLogDirsIterator = MetaPropertiesEnsemble.this.emptyLogDirs.iterator();
                this.logDirsIterator = MetaPropertiesEnsemble.this.logDirProps.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.emptyLogDirsIterator.hasNext() || this.logDirsIterator.hasNext();
            }

            @Override
            public Map.Entry<String, Optional<MetaProperties>> next() {
                if (this.emptyLogDirsIterator.hasNext()) {
                    return new AbstractMap.SimpleImmutableEntry<String, Optional<MetaProperties>>(this.emptyLogDirsIterator.next(), Optional.empty());
                }
                Map.Entry<String, MetaProperties> entry = this.logDirsIterator.next();
                return new AbstractMap.SimpleImmutableEntry<String, Optional<MetaProperties>>(entry.getKey(), Optional.of(entry.getValue()));
            }
        };
    }

    public Optional<String> metadataLogDir() {
        return this.metadataLogDir;
    }

    public void verify(Optional<String> expectedClusterId, OptionalInt expectedNodeId, EnumSet<VerificationFlag> verificationFlags) {
        HashMap<Uuid, String> seenUuids = new HashMap<Uuid, String>();
        if (verificationFlags.contains((Object)VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID) && this.logDirProps.isEmpty()) {
            throw new RuntimeException("No readable meta.properties files found.");
        }
        for (Map.Entry<String, MetaProperties> entry : this.logDirProps.entrySet()) {
            String logDir = entry.getKey();
            String path = new File(logDir, META_PROPERTIES_NAME).toString();
            MetaProperties metaProps = entry.getValue();
            if (verificationFlags.contains((Object)VerificationFlag.REQUIRE_V0) && !metaProps.version().equals((Object)MetaPropertiesVersion.V0)) {
                throw new RuntimeException("Found unexpected version in " + path + ". ZK-based brokers that are not migrating only support version 0 (which is implicit when the `version` field is missing).");
            }
            if (!metaProps.clusterId().isPresent()) {
                if (metaProps.version().alwaysHasClusterId()) {
                    throw new RuntimeException("cluster.id was not specified in the v1 file: " + path);
                }
            } else if (!expectedClusterId.isPresent()) {
                expectedClusterId = metaProps.clusterId();
            } else if (!metaProps.clusterId().get().equals(expectedClusterId.get())) {
                throw new RuntimeException("Invalid cluster.id in: " + path + ". Expected " + expectedClusterId.get() + ", but read " + metaProps.clusterId().get());
            }
            if (!metaProps.nodeId().isPresent()) {
                if (metaProps.version().alwaysHasNodeId()) {
                    throw new RuntimeException("node.id was not specified in " + path);
                }
            } else if (!expectedNodeId.isPresent()) {
                expectedNodeId = metaProps.nodeId();
            } else if (metaProps.nodeId().getAsInt() != expectedNodeId.getAsInt()) {
                throw new RuntimeException("Stored node id " + metaProps.nodeId().getAsInt() + " doesn't match previous node id " + expectedNodeId.getAsInt() + " in " + path + ". If you moved your data, make sure your configured node id matches. If you intend to create a new node, you should remove all data in your data directories.");
            }
            if (!metaProps.directoryId().isPresent()) continue;
            if (DirectoryId.reserved((Uuid)metaProps.directoryId().get())) {
                throw new RuntimeException("Invalid resrved directory ID " + metaProps.directoryId().get() + " found in " + logDir);
            }
            String prevLogDir = seenUuids.put(metaProps.directoryId().get(), logDir);
            if (prevLogDir == null) continue;
            throw new RuntimeException("Duplicate directory ID " + metaProps.directoryId() + " found. It was the ID of " + prevLogDir + ", but also of " + logDir);
        }
        if (verificationFlags.contains((Object)VerificationFlag.REQUIRE_METADATA_LOG_DIR) && !this.metadataLogDir.isPresent()) {
            throw new RuntimeException("No metadata log directory was specified.");
        }
        if (this.metadataLogDir.isPresent() && this.errorLogDirs.contains(this.metadataLogDir.get())) {
            throw new RuntimeException("Encountered I/O error in metadata log directory " + this.metadataLogDir.get() + ". Cannot continue.");
        }
    }

    public OptionalInt nodeId() {
        for (MetaProperties metaProps : this.logDirProps.values()) {
            if (!metaProps.nodeId().isPresent()) continue;
            return metaProps.nodeId();
        }
        return OptionalInt.empty();
    }

    public Optional<String> clusterId() {
        for (MetaProperties metaProps : this.logDirProps.values()) {
            if (!metaProps.clusterId().isPresent()) continue;
            return metaProps.clusterId();
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(MetaPropertiesEnsemble.class)) {
            return false;
        }
        MetaPropertiesEnsemble other = (MetaPropertiesEnsemble)o;
        return this.emptyLogDirs.equals(other.emptyLogDirs) && this.errorLogDirs.equals(other.errorLogDirs) && this.logDirProps.equals(other.logDirProps) && this.metadataLogDir.equals(other.metadataLogDir);
    }

    public int hashCode() {
        return Objects.hash(this.emptyLogDirs, this.errorLogDirs, this.logDirProps, this.metadataLogDir);
    }

    public String toString() {
        TreeMap outputMap = new TreeMap();
        this.emptyLogDirs.forEach(e -> outputMap.put(e, "EMPTY"));
        this.errorLogDirs.forEach(e -> outputMap.put(e, "ERROR"));
        this.logDirProps.forEach((key, value) -> outputMap.put(key, value.toString()));
        return "MetaPropertiesEnsemble(metadataLogDir=" + this.metadataLogDir + ", dirs={" + outputMap.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.joining(", ")) + "})";
    }

    public static enum VerificationFlag {
        REQUIRE_V0,
        REQUIRE_METADATA_LOG_DIR,
        REQUIRE_AT_LEAST_ONE_VALID;

    }

    public static class Copier {
        private final MetaPropertiesEnsemble prev;
        private final Set<String> emptyLogDirs;
        private final Set<String> errorLogDirs;
        private final Map<String, MetaProperties> logDirProps;
        private Optional<String> metaLogDir;
        private Random random = new Random();
        private PreWriteHandler preWriteHandler = (logDir, isNew, metaProperties) -> LOG.info("Writing out {} {}{}meta.properties file containing {}", new Object[]{isNew ? "new" : "changed", logDir, File.separator, metaProperties});
        private WriteErrorHandler writeErrorHandler = (logDir, e) -> {
            LOG.error("Error while writing meta.properties to {}", (Object)logDir, (Object)e);
            throw e;
        };

        public Copier(MetaPropertiesEnsemble prev) {
            this.prev = prev;
            this.emptyLogDirs = new HashSet<String>(prev.emptyLogDirs());
            this.errorLogDirs = new HashSet<String>(prev.errorLogDirs());
            this.logDirProps = new HashMap<String, MetaProperties>(prev.logDirProps());
            this.metaLogDir = prev.metadataLogDir;
        }

        public Copier setRandom(Random random) {
            this.random = random;
            return this;
        }

        public Set<String> emptyLogDirs() {
            return this.emptyLogDirs;
        }

        public Set<String> errorLogDirs() {
            return this.errorLogDirs;
        }

        public Map<String, MetaProperties> logDirProps() {
            return this.logDirProps;
        }

        public Copier setLogDirProps(String logDir, MetaProperties metaProps) {
            this.emptyLogDirs.remove(logDir);
            this.errorLogDirs.remove(logDir);
            this.logDirProps.put(logDir, metaProps);
            return this;
        }

        public Optional<String> metaLogDir() {
            return this.metaLogDir;
        }

        public Copier setMetaLogDir(Optional<String> metaLogDir) {
            this.metaLogDir = metaLogDir;
            return this;
        }

        public Uuid generateValidDirectoryId() {
            Uuid uuid;
            while (true) {
                if ((uuid = new Uuid(this.random.nextLong(), this.random.nextLong())).toString().startsWith("-") || DirectoryId.reserved((Uuid)uuid)) {
                    continue;
                }
                boolean duplicate = false;
                for (MetaProperties metaProps : this.logDirProps.values()) {
                    if (!metaProps.directoryId().equals(Optional.of(uuid))) continue;
                    duplicate = true;
                    break;
                }
                if (!duplicate) break;
            }
            return uuid;
        }

        public Copier setPreWriteHandler(PreWriteHandler preWriteHandler) {
            this.preWriteHandler = preWriteHandler;
            return this;
        }

        public Copier setWriteErrorHandler(WriteErrorHandler writeErrorHandler) {
            this.writeErrorHandler = writeErrorHandler;
            return this;
        }

        public void verify() {
            for (String logDir : this.emptyLogDirs) {
                if (this.errorLogDirs.contains(logDir)) {
                    throw new RuntimeException("Error: log directory " + logDir + " is in both emptyLogDirs and errorLogDirs.");
                }
                if (!this.logDirProps.containsKey(logDir)) continue;
                throw new RuntimeException("Error: log directory " + logDir + " is in both emptyLogDirs and logDirProps.");
            }
            for (String logDir : this.errorLogDirs) {
                if (!this.logDirProps.containsKey(logDir)) continue;
                throw new RuntimeException("Error: log directory " + logDir + " is in both errorLogDirs and logDirProps.");
            }
            this.metaLogDir().ifPresent(m -> {
                if (!(this.emptyLogDirs.contains(m) || this.logDirProps.containsKey(m) || this.errorLogDirs.contains(m))) {
                    throw new RuntimeException("Error: metaLogDir " + m + " does not appear in emptyLogDirs, errorLogDirs, or logDirProps.");
                }
            });
        }

        public void writeLogDirChanges() throws IOException {
            MetaProperties metaProps;
            HashMap<String, MetaProperties> newOrChanged = new HashMap<String, MetaProperties>();
            HashSet<String> newSet = new HashSet<String>();
            for (Map.Entry<String, MetaProperties> entry : this.prev.logDirProps().entrySet()) {
                MetaProperties prevMetaProps = entry.getValue();
                if (prevMetaProps.equals(metaProps = this.logDirProps.get(entry.getKey()))) continue;
                newOrChanged.put(entry.getKey(), metaProps);
            }
            for (Map.Entry<String, MetaProperties> entry : this.logDirProps.entrySet()) {
                if (this.prev.logDirProps().containsKey(entry.getKey())) continue;
                newOrChanged.put(entry.getKey(), entry.getValue());
                newSet.add(entry.getKey());
            }
            for (Map.Entry<String, MetaProperties> entry : newOrChanged.entrySet()) {
                String logDir = entry.getKey();
                metaProps = entry.getValue();
                String metaPropsPath = new File(logDir, MetaPropertiesEnsemble.META_PROPERTIES_NAME).getAbsolutePath();
                try {
                    this.preWriteHandler.handle(logDir, newSet.contains(logDir), metaProps);
                    PropertiesUtils.writePropertiesFile(metaProps.toProperties(), metaPropsPath, true);
                }
                catch (IOException e) {
                    this.errorLogDirs.add(logDir);
                    this.logDirProps.remove(logDir);
                    this.writeErrorHandler.handle(logDir, e);
                }
            }
        }

        public MetaPropertiesEnsemble copy() {
            return new MetaPropertiesEnsemble(this.emptyLogDirs, this.errorLogDirs, this.logDirProps, this.metaLogDir);
        }
    }

    public static interface PreWriteHandler {
        public void handle(String var1, boolean var2, MetaProperties var3) throws IOException;
    }

    public static interface WriteErrorHandler {
        public void handle(String var1, IOException var2) throws IOException;
    }

    public static class Loader {
        private final TreeSet<String> logDirs = new TreeSet();
        private Optional<String> metadataLogDir = Optional.empty();

        public Loader addLogDirs(Collection<String> logDirs) {
            this.logDirs.addAll(logDirs);
            return this;
        }

        public Loader addMetadataLogDir(String metadataLogDir) {
            if (this.metadataLogDir.isPresent()) {
                throw new RuntimeException("Cannot specify more than one metadata log directory. Already specified " + this.metadataLogDir.get());
            }
            this.metadataLogDir = Optional.of(metadataLogDir);
            this.logDirs.add(metadataLogDir);
            return this;
        }

        public MetaPropertiesEnsemble load() throws IOException {
            if (this.logDirs.isEmpty()) {
                throw new RuntimeException("You must specify at least one log directory.");
            }
            HashSet<String> emptyLogDirs = new HashSet<String>();
            HashSet<String> errorLogDirs = new HashSet<String>();
            HashMap<String, MetaProperties> logDirProps = new HashMap<String, MetaProperties>();
            for (String logDir : this.logDirs) {
                String metaPropsFile = new File(logDir, MetaPropertiesEnsemble.META_PROPERTIES_NAME).getAbsolutePath();
                try {
                    Properties props = PropertiesUtils.readPropertiesFile(metaPropsFile);
                    MetaProperties meta = new MetaProperties.Builder(props).build();
                    logDirProps.put(logDir, meta);
                }
                catch (FileNotFoundException | NoSuchFileException e) {
                    emptyLogDirs.add(logDir);
                }
                catch (Exception e) {
                    LOG.error("Error while reading meta.properties file {}", (Object)metaPropsFile, (Object)e);
                    errorLogDirs.add(logDir);
                }
            }
            return new MetaPropertiesEnsemble(emptyLogDirs, errorLogDirs, logDirProps, this.metadataLogDir);
        }
    }
}

