/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public final class RemoteLogManagerConfig {
    public static final String REMOTE_STORAGE_MANAGER_CONFIG_PREFIX_PROP = "remote.log.storage.manager.impl.prefix";
    public static final String REMOTE_STORAGE_MANAGER_CONFIG_PREFIX_DOC = "Prefix used for properties to be passed to RemoteStorageManager implementation. For example this value can be <code>rsm.config.</code>.";
    public static final String DEFAULT_REMOTE_STORAGE_MANAGER_CONFIG_PREFIX = "rsm.config.";
    public static final String REMOTE_LOG_METADATA_MANAGER_CONFIG_PREFIX_PROP = "remote.log.metadata.manager.impl.prefix";
    public static final String REMOTE_LOG_METADATA_MANAGER_CONFIG_PREFIX_DOC = "Prefix used for properties to be passed to RemoteLogMetadataManager implementation. For example this value can be <code>rlmm.config.</code>.";
    public static final String DEFAULT_REMOTE_LOG_METADATA_MANAGER_CONFIG_PREFIX = "rlmm.config.";
    public static final String REMOTE_LOG_STORAGE_SYSTEM_ENABLE_PROP = "remote.log.storage.system.enable";
    public static final String REMOTE_LOG_STORAGE_SYSTEM_ENABLE_DOC = "Whether to enable tiered storage functionality in a broker or not. When it is true broker starts all the services required for the tiered storage functionality.";
    public static final boolean DEFAULT_REMOTE_LOG_STORAGE_SYSTEM_ENABLE = false;
    public static final String REMOTE_STORAGE_MANAGER_CLASS_NAME_PROP = "remote.log.storage.manager.class.name";
    public static final String REMOTE_STORAGE_MANAGER_CLASS_NAME_DOC = "Fully qualified class name of <code>RemoteStorageManager</code> implementation.";
    public static final String REMOTE_STORAGE_MANAGER_CLASS_PATH_PROP = "remote.log.storage.manager.class.path";
    public static final String REMOTE_STORAGE_MANAGER_CLASS_PATH_DOC = "Class path of the <code>RemoteStorageManager</code> implementation. If specified, the RemoteStorageManager implementation and its dependent libraries will be loaded by a dedicated classloader which searches this class path before the Kafka broker class path. The syntax of this parameter is same as the standard Java class path string.";
    public static final String REMOTE_LOG_METADATA_MANAGER_CLASS_NAME_PROP = "remote.log.metadata.manager.class.name";
    public static final String REMOTE_LOG_METADATA_MANAGER_CLASS_NAME_DOC = "Fully qualified class name of <code>RemoteLogMetadataManager</code> implementation.";
    public static final String DEFAULT_REMOTE_LOG_METADATA_MANAGER_CLASS_NAME = "org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager";
    public static final String REMOTE_LOG_METADATA_MANAGER_CLASS_PATH_PROP = "remote.log.metadata.manager.class.path";
    public static final String REMOTE_LOG_METADATA_MANAGER_CLASS_PATH_DOC = "Class path of the <code>RemoteLogMetadataManager</code> implementation. If specified, the RemoteLogMetadataManager implementation and its dependent libraries will be loaded by a dedicated classloader which searches this class path before the Kafka broker class path. The syntax of this parameter is same as the standard Java class path string.";
    public static final String REMOTE_LOG_METADATA_MANAGER_LISTENER_NAME_PROP = "remote.log.metadata.manager.listener.name";
    public static final String REMOTE_LOG_METADATA_MANAGER_LISTENER_NAME_DOC = "Listener name of the local broker to which it should get connected if needed by RemoteLogMetadataManager implementation.";
    public static final String REMOTE_LOG_METADATA_CUSTOM_METADATA_MAX_BYTES_PROP = "remote.log.metadata.custom.metadata.max.bytes";
    public static final String REMOTE_LOG_METADATA_CUSTOM_METADATA_MAX_BYTES_DOC = "The maximum size of custom metadata in bytes that the broker should accept from a remote storage plugin. If custom  metadata exceeds this limit, the updated segment metadata will not be stored, the copied data will be attempted to delete, and the remote copying task for this topic-partition will stop with an error.";
    public static final int DEFAULT_REMOTE_LOG_METADATA_CUSTOM_METADATA_MAX_BYTES = 128;
    public static final String REMOTE_LOG_INDEX_FILE_CACHE_TOTAL_SIZE_BYTES_PROP = "remote.log.index.file.cache.total.size.bytes";
    public static final String REMOTE_LOG_INDEX_FILE_CACHE_TOTAL_SIZE_BYTES_DOC = "The total size of the space allocated to store index files fetched from remote storage in the local storage.";
    public static final long DEFAULT_REMOTE_LOG_INDEX_FILE_CACHE_TOTAL_SIZE_BYTES = 0x40000000L;
    public static final String REMOTE_LOG_MANAGER_FOLLOWER_THREAD_POOL_SIZE_PROP = "remote.log.manager.follower.thread.pool.size";
    public static final String REMOTE_LOG_MANAGER_FOLLOWER_THREAD_POOL_SIZE_DOC = "Size of the thread pool used in scheduling follower tasks to read the highest-uploaded remote-offset for follower partitions.";
    public static final int DEFAULT_REMOTE_LOG_MANAGER_FOLLOWER_THREAD_POOL_SIZE = 2;
    @Deprecated(since="4.2", forRemoval=true)
    public static final String REMOTE_LOG_MANAGER_THREAD_POOL_SIZE_PROP = "remote.log.manager.thread.pool.size";
    @Deprecated(since="4.2", forRemoval=true)
    public static final String REMOTE_LOG_MANAGER_THREAD_POOL_SIZE_DOC = "Size of the thread pool used in scheduling follower tasks to read the highest-uploaded remote-offset for follower partitions. This config is deprecated since 4.2, please use <code>remote.log.manager.follower.thread.pool.size</code> instead.";
    @Deprecated(since="4.2", forRemoval=true)
    public static final int DEFAULT_REMOTE_LOG_MANAGER_THREAD_POOL_SIZE = 2;
    public static final String REMOTE_LOG_MANAGER_COPIER_THREAD_POOL_SIZE_PROP = "remote.log.manager.copier.thread.pool.size";
    public static final String REMOTE_LOG_MANAGER_COPIER_THREAD_POOL_SIZE_DOC = "Size of the thread pool used in scheduling tasks to copy segments.";
    public static final int DEFAULT_REMOTE_LOG_MANAGER_COPIER_THREAD_POOL_SIZE = 10;
    public static final String REMOTE_LOG_MANAGER_EXPIRATION_THREAD_POOL_SIZE_PROP = "remote.log.manager.expiration.thread.pool.size";
    public static final String REMOTE_LOG_MANAGER_EXPIRATION_THREAD_POOL_SIZE_DOC = "Size of the thread pool used in scheduling tasks to clean up the expired remote log segments.";
    public static final int DEFAULT_REMOTE_LOG_MANAGER_EXPIRATION_THREAD_POOL_SIZE = 10;
    public static final String REMOTE_LOG_MANAGER_TASK_INTERVAL_MS_PROP = "remote.log.manager.task.interval.ms";
    public static final String REMOTE_LOG_MANAGER_TASK_INTERVAL_MS_DOC = "Interval at which remote log manager runs the scheduled tasks like copy segments, and clean up remote log segments.";
    public static final long DEFAULT_REMOTE_LOG_MANAGER_TASK_INTERVAL_MS = 30000L;
    public static final String REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MS_PROP = "remote.log.manager.task.retry.backoff.ms";
    public static final String REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MS_DOC = "The initial amount of wait in milliseconds before the request is retried again.";
    public static final long DEFAULT_REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MS = 500L;
    public static final String REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MAX_MS_PROP = "remote.log.manager.task.retry.backoff.max.ms";
    public static final String REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MAX_MS_DOC = "The maximum amount of time in milliseconds to wait when the request is retried again. The retry duration will increase exponentially for each request failure up to this maximum wait interval.";
    public static final long DEFAULT_REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MAX_MS = 30000L;
    public static final String REMOTE_LOG_MANAGER_TASK_RETRY_JITTER_PROP = "remote.log.manager.task.retry.jitter";
    public static final String REMOTE_LOG_MANAGER_TASK_RETRY_JITTER_DOC = "The value used in defining the range for computing random jitter factor. It is applied to the effective exponential term for computing the resultant retry backoff interval. This will avoid thundering herds of requests. The default value is 0.2 and valid value should be between 0(inclusive) and 0.5(inclusive). For ex: remote.log.manager.task.retry.jitter = 0.25, then the range to compute random jitter will be [1-0.25, 1+0.25) viz [0.75, 1.25). So, jitter factor can be any random value with in that range.";
    public static final double DEFAULT_REMOTE_LOG_MANAGER_TASK_RETRY_JITTER = 0.2;
    public static final String REMOTE_LOG_READER_THREADS_PROP = "remote.log.reader.threads";
    public static final String REMOTE_LOG_READER_THREADS_DOC = "Size of the thread pool that is allocated for handling remote log reads.";
    public static final int DEFAULT_REMOTE_LOG_READER_THREADS = 10;
    public static final String REMOTE_LOG_READER_MAX_PENDING_TASKS_PROP = "remote.log.reader.max.pending.tasks";
    public static final String REMOTE_LOG_READER_MAX_PENDING_TASKS_DOC = "Maximum remote log reader thread pool task queue size. If the task queue is full, fetch requests are served with an error.";
    public static final int DEFAULT_REMOTE_LOG_READER_MAX_PENDING_TASKS = 100;
    public static final String LOG_LOCAL_RETENTION_MS_PROP = "log.local.retention.ms";
    public static final String LOG_LOCAL_RETENTION_MS_DOC = "The number of milliseconds to keep the local log segments before it gets eligible for deletion. Default value is -2, it represents <code>log.retention.ms</code> value is to be used. The effective value should always be less than or equal to <code>log.retention.ms</code> value.";
    public static final Long DEFAULT_LOG_LOCAL_RETENTION_MS = -2L;
    public static final String LOG_LOCAL_RETENTION_BYTES_PROP = "log.local.retention.bytes";
    public static final String LOG_LOCAL_RETENTION_BYTES_DOC = "The maximum size of local log segments that can grow for a partition before it gets eligible for deletion. Default value is -2, it represents <code>log.retention.bytes</code> value to be used. The effective value should always be less than or equal to <code>log.retention.bytes</code> value.";
    public static final Long DEFAULT_LOG_LOCAL_RETENTION_BYTES = -2L;
    public static final String REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND_PROP = "remote.log.manager.copy.max.bytes.per.second";
    public static final String REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND_DOC = "The maximum number of bytes that can be copied from local storage to remote storage per second. This is a global limit for all the partitions that are being copied from local storage to remote storage. The default value is Long.MAX_VALUE, which means there is no limit on the number of bytes that can be copied per second.";
    public static final Long DEFAULT_REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND = Long.MAX_VALUE;
    public static final String REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_NUM_PROP = "remote.log.manager.copy.quota.window.num";
    public static final String REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_NUM_DOC = "The number of samples to retain in memory for remote copy quota management. The default value is 11, which means there are 10 whole windows + 1 current window.";
    public static final int DEFAULT_REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_NUM = 11;
    public static final String REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_SIZE_SECONDS_PROP = "remote.log.manager.copy.quota.window.size.seconds";
    public static final String REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_SIZE_SECONDS_DOC = "The time span of each sample for remote copy quota management. The default value is 1 second.";
    public static final int DEFAULT_REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_SIZE_SECONDS = 1;
    public static final String REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND_PROP = "remote.log.manager.fetch.max.bytes.per.second";
    public static final String REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND_DOC = "The maximum number of bytes that can be fetched from remote storage to local storage per second. This is a global limit for all the partitions that are being fetched from remote storage to local storage. The default value is Long.MAX_VALUE, which means there is no limit on the number of bytes that can be fetched per second.";
    public static final Long DEFAULT_REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND = Long.MAX_VALUE;
    public static final String REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_NUM_PROP = "remote.log.manager.fetch.quota.window.num";
    public static final String REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_NUM_DOC = "The number of samples to retain in memory for remote fetch quota management. The default value is 11, which means there are 10 whole windows + 1 current window.";
    public static final int DEFAULT_REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_NUM = 11;
    public static final String REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_SIZE_SECONDS_PROP = "remote.log.manager.fetch.quota.window.size.seconds";
    public static final String REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_SIZE_SECONDS_DOC = "The time span of each sample for remote fetch quota management. The default value is 1 second.";
    public static final int DEFAULT_REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_SIZE_SECONDS = 1;
    public static final String REMOTE_FETCH_MAX_WAIT_MS_PROP = "remote.fetch.max.wait.ms";
    public static final String REMOTE_FETCH_MAX_WAIT_MS_DOC = "The maximum amount of time the server will wait before answering the fetch request containing remote fetch partitions. It's important to be aware that the request will only be responded after all remote partitions have been successfully fetched, have failed, or this timeout is exceeded.";
    public static final int DEFAULT_REMOTE_FETCH_MAX_WAIT_MS = 500;
    public static final String REMOTE_LIST_OFFSETS_REQUEST_TIMEOUT_MS_PROP = "remote.list.offsets.request.timeout.ms";
    public static final String REMOTE_LIST_OFFSETS_REQUEST_TIMEOUT_MS_DOC = "The maximum amount of time the server will wait for the remote list offsets request to complete.";
    public static final long DEFAULT_REMOTE_LIST_OFFSETS_REQUEST_TIMEOUT_MS = 30000L;
    private final AbstractConfig config;

    public static ConfigDef configDef() {
        return new ConfigDef().define(REMOTE_LOG_STORAGE_SYSTEM_ENABLE_PROP, ConfigDef.Type.BOOLEAN, (Object)false, null, ConfigDef.Importance.MEDIUM, REMOTE_LOG_STORAGE_SYSTEM_ENABLE_DOC).define(REMOTE_STORAGE_MANAGER_CONFIG_PREFIX_PROP, ConfigDef.Type.STRING, (Object)DEFAULT_REMOTE_STORAGE_MANAGER_CONFIG_PREFIX, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.MEDIUM, REMOTE_STORAGE_MANAGER_CONFIG_PREFIX_DOC).define(REMOTE_LOG_METADATA_MANAGER_CONFIG_PREFIX_PROP, ConfigDef.Type.STRING, (Object)DEFAULT_REMOTE_LOG_METADATA_MANAGER_CONFIG_PREFIX, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.MEDIUM, REMOTE_LOG_METADATA_MANAGER_CONFIG_PREFIX_DOC).define(REMOTE_STORAGE_MANAGER_CLASS_NAME_PROP, ConfigDef.Type.STRING, null, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.MEDIUM, REMOTE_STORAGE_MANAGER_CLASS_NAME_DOC).define(REMOTE_STORAGE_MANAGER_CLASS_PATH_PROP, ConfigDef.Type.STRING, null, null, ConfigDef.Importance.MEDIUM, REMOTE_STORAGE_MANAGER_CLASS_PATH_DOC).define(REMOTE_LOG_METADATA_MANAGER_CLASS_NAME_PROP, ConfigDef.Type.STRING, (Object)DEFAULT_REMOTE_LOG_METADATA_MANAGER_CLASS_NAME, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.MEDIUM, REMOTE_LOG_METADATA_MANAGER_CLASS_NAME_DOC).define(REMOTE_LOG_METADATA_MANAGER_CLASS_PATH_PROP, ConfigDef.Type.STRING, null, null, ConfigDef.Importance.MEDIUM, REMOTE_LOG_METADATA_MANAGER_CLASS_PATH_DOC).define(REMOTE_LOG_METADATA_MANAGER_LISTENER_NAME_PROP, ConfigDef.Type.STRING, null, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.MEDIUM, REMOTE_LOG_METADATA_MANAGER_LISTENER_NAME_DOC).define(REMOTE_LOG_METADATA_CUSTOM_METADATA_MAX_BYTES_PROP, ConfigDef.Type.INT, (Object)128, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, REMOTE_LOG_METADATA_CUSTOM_METADATA_MAX_BYTES_DOC).define(REMOTE_LOG_INDEX_FILE_CACHE_TOTAL_SIZE_BYTES_PROP, ConfigDef.Type.LONG, (Object)0x40000000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, REMOTE_LOG_INDEX_FILE_CACHE_TOTAL_SIZE_BYTES_DOC).define(REMOTE_LOG_MANAGER_THREAD_POOL_SIZE_PROP, ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_MANAGER_THREAD_POOL_SIZE_DOC).define(REMOTE_LOG_MANAGER_COPIER_THREAD_POOL_SIZE_PROP, ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_MANAGER_COPIER_THREAD_POOL_SIZE_DOC).define(REMOTE_LOG_MANAGER_EXPIRATION_THREAD_POOL_SIZE_PROP, ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_MANAGER_EXPIRATION_THREAD_POOL_SIZE_DOC).define(REMOTE_LOG_MANAGER_FOLLOWER_THREAD_POOL_SIZE_PROP, ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_MANAGER_FOLLOWER_THREAD_POOL_SIZE_DOC).define(REMOTE_LOG_MANAGER_TASK_INTERVAL_MS_PROP, ConfigDef.Type.LONG, (Object)30000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, REMOTE_LOG_MANAGER_TASK_INTERVAL_MS_DOC).defineInternal(REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MS_PROP, ConfigDef.Type.LONG, (Object)500L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MS_DOC).defineInternal(REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MAX_MS_PROP, ConfigDef.Type.LONG, (Object)30000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MAX_MS_DOC).defineInternal(REMOTE_LOG_MANAGER_TASK_RETRY_JITTER_PROP, ConfigDef.Type.DOUBLE, (Object)0.2, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)0.5), ConfigDef.Importance.LOW, REMOTE_LOG_MANAGER_TASK_RETRY_JITTER_DOC).define(REMOTE_LOG_READER_THREADS_PROP, ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_READER_THREADS_DOC).define(REMOTE_LOG_READER_MAX_PENDING_TASKS_PROP, ConfigDef.Type.INT, (Object)100, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_READER_MAX_PENDING_TASKS_DOC).define(LOG_LOCAL_RETENTION_MS_PROP, ConfigDef.Type.LONG, (Object)DEFAULT_LOG_LOCAL_RETENTION_MS, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)DEFAULT_LOG_LOCAL_RETENTION_MS), ConfigDef.Importance.MEDIUM, LOG_LOCAL_RETENTION_MS_DOC).define(LOG_LOCAL_RETENTION_BYTES_PROP, ConfigDef.Type.LONG, (Object)DEFAULT_LOG_LOCAL_RETENTION_BYTES, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)DEFAULT_LOG_LOCAL_RETENTION_BYTES), ConfigDef.Importance.MEDIUM, LOG_LOCAL_RETENTION_BYTES_DOC).define(REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND_PROP, ConfigDef.Type.LONG, (Object)DEFAULT_REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND_DOC).define(REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_NUM_PROP, ConfigDef.Type.INT, (Object)11, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_NUM_DOC).define(REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_SIZE_SECONDS_PROP, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_SIZE_SECONDS_DOC).define(REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND_PROP, ConfigDef.Type.LONG, (Object)DEFAULT_REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND_DOC).define(REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_NUM_PROP, ConfigDef.Type.INT, (Object)11, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_NUM_DOC).define(REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_SIZE_SECONDS_PROP, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_SIZE_SECONDS_DOC).define(REMOTE_FETCH_MAX_WAIT_MS_PROP, ConfigDef.Type.INT, (Object)500, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_FETCH_MAX_WAIT_MS_DOC).define(REMOTE_LIST_OFFSETS_REQUEST_TIMEOUT_MS_PROP, ConfigDef.Type.LONG, (Object)30000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, REMOTE_LIST_OFFSETS_REQUEST_TIMEOUT_MS_DOC);
    }

    public RemoteLogManagerConfig(AbstractConfig config) {
        this.config = config;
    }

    public boolean isRemoteStorageSystemEnabled() {
        return this.config.getBoolean(REMOTE_LOG_STORAGE_SYSTEM_ENABLE_PROP);
    }

    public String remoteStorageManagerClassName() {
        return this.config.getString(REMOTE_STORAGE_MANAGER_CLASS_NAME_PROP);
    }

    public String remoteStorageManagerClassPath() {
        return this.config.getString(REMOTE_STORAGE_MANAGER_CLASS_PATH_PROP);
    }

    public String remoteLogMetadataManagerClassName() {
        return this.config.getString(REMOTE_LOG_METADATA_MANAGER_CLASS_NAME_PROP);
    }

    public String remoteLogMetadataManagerClassPath() {
        return this.config.getString(REMOTE_LOG_METADATA_MANAGER_CLASS_PATH_PROP);
    }

    @Deprecated(since="4.2", forRemoval=true)
    public int remoteLogManagerThreadPoolSize() {
        return this.remoteLogManagerFollowerThreadPoolSize();
    }

    public int remoteLogManagerCopierThreadPoolSize() {
        return this.config.getInt(REMOTE_LOG_MANAGER_COPIER_THREAD_POOL_SIZE_PROP);
    }

    public int remoteLogManagerExpirationThreadPoolSize() {
        return this.config.getInt(REMOTE_LOG_MANAGER_EXPIRATION_THREAD_POOL_SIZE_PROP);
    }

    public int remoteLogManagerFollowerThreadPoolSize() {
        if (this.config.originals().containsKey(REMOTE_LOG_MANAGER_FOLLOWER_THREAD_POOL_SIZE_PROP)) {
            return this.config.getInt(REMOTE_LOG_MANAGER_FOLLOWER_THREAD_POOL_SIZE_PROP);
        }
        return this.config.getInt(REMOTE_LOG_MANAGER_THREAD_POOL_SIZE_PROP);
    }

    public long remoteLogManagerTaskIntervalMs() {
        return this.config.getLong(REMOTE_LOG_MANAGER_TASK_INTERVAL_MS_PROP);
    }

    public long remoteLogManagerTaskRetryBackoffMs() {
        return this.config.getLong(REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MS_PROP);
    }

    public long remoteLogManagerTaskRetryBackoffMaxMs() {
        return this.config.getLong(REMOTE_LOG_MANAGER_TASK_RETRY_BACK_OFF_MAX_MS_PROP);
    }

    public double remoteLogManagerTaskRetryJitter() {
        return this.config.getDouble(REMOTE_LOG_MANAGER_TASK_RETRY_JITTER_PROP);
    }

    public int remoteLogReaderThreads() {
        return this.config.getInt(REMOTE_LOG_READER_THREADS_PROP);
    }

    public int remoteLogReaderMaxPendingTasks() {
        return this.config.getInt(REMOTE_LOG_READER_MAX_PENDING_TASKS_PROP);
    }

    public String remoteLogMetadataManagerListenerName() {
        return this.config.getString(REMOTE_LOG_METADATA_MANAGER_LISTENER_NAME_PROP);
    }

    public int remoteLogMetadataCustomMetadataMaxBytes() {
        return this.config.getInt(REMOTE_LOG_METADATA_CUSTOM_METADATA_MAX_BYTES_PROP);
    }

    public String remoteStorageManagerPrefix() {
        return this.config.getString(REMOTE_STORAGE_MANAGER_CONFIG_PREFIX_PROP);
    }

    public String remoteLogMetadataManagerPrefix() {
        return this.config.getString(REMOTE_LOG_METADATA_MANAGER_CONFIG_PREFIX_PROP);
    }

    public Map<String, Object> remoteStorageManagerProps() {
        return this.getConfigProps(REMOTE_STORAGE_MANAGER_CONFIG_PREFIX_PROP);
    }

    public Map<String, Object> remoteLogMetadataManagerProps() {
        return this.getConfigProps(REMOTE_LOG_METADATA_MANAGER_CONFIG_PREFIX_PROP);
    }

    public Map<String, Object> getConfigProps(String configPrefixProp) {
        String prefixProp = this.config.getString(configPrefixProp);
        return prefixProp == null ? Map.of() : Collections.unmodifiableMap(this.config.originalsWithPrefix(prefixProp));
    }

    public int remoteLogManagerCopyNumQuotaSamples() {
        return this.config.getInt(REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_NUM_PROP);
    }

    public int remoteLogManagerCopyQuotaWindowSizeSeconds() {
        return this.config.getInt(REMOTE_LOG_MANAGER_COPY_QUOTA_WINDOW_SIZE_SECONDS_PROP);
    }

    public int remoteLogManagerFetchNumQuotaSamples() {
        return this.config.getInt(REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_NUM_PROP);
    }

    public int remoteLogManagerFetchQuotaWindowSizeSeconds() {
        return this.config.getInt(REMOTE_LOG_MANAGER_FETCH_QUOTA_WINDOW_SIZE_SECONDS_PROP);
    }

    public long remoteLogIndexFileCacheTotalSizeBytes() {
        return this.config.getLong(REMOTE_LOG_INDEX_FILE_CACHE_TOTAL_SIZE_BYTES_PROP);
    }

    public long remoteLogManagerCopyMaxBytesPerSecond() {
        return this.config.getLong(REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND_PROP);
    }

    public long remoteLogManagerFetchMaxBytesPerSecond() {
        return this.config.getLong(REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND_PROP);
    }

    public int remoteFetchMaxWaitMs() {
        return this.config.getInt(REMOTE_FETCH_MAX_WAIT_MS_PROP);
    }

    public long logLocalRetentionBytes() {
        return this.config.getLong(LOG_LOCAL_RETENTION_BYTES_PROP);
    }

    public long logLocalRetentionMs() {
        return this.config.getLong(LOG_LOCAL_RETENTION_MS_PROP);
    }

    public long remoteListOffsetsRequestTimeoutMs() {
        return this.config.getLong(REMOTE_LIST_OFFSETS_REQUEST_TIMEOUT_MS_PROP);
    }

    public static void main(String[] args) {
        System.out.println(RemoteLogManagerConfig.configDef().toHtml(4, config -> "remote_log_manager_" + config));
    }
}

