/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.storage.internals.log.BatchMetadata;

public class ProducerStateEntry {
    public static final int NUM_BATCHES_TO_RETAIN = 5;
    private final long producerId;
    private final Deque<BatchMetadata> batchMetadata = new ArrayDeque<BatchMetadata>();
    private short producerEpoch;
    private int coordinatorEpoch;
    private long lastTimestamp;
    private OptionalLong currentTxnFirstOffset;

    public static ProducerStateEntry empty(long producerId) {
        return new ProducerStateEntry(producerId, -1, -1, -1L, OptionalLong.empty(), Optional.empty());
    }

    public ProducerStateEntry(long producerId, short producerEpoch, int coordinatorEpoch, long lastTimestamp, OptionalLong currentTxnFirstOffset, Optional<BatchMetadata> firstBatchMetadata) {
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.coordinatorEpoch = coordinatorEpoch;
        this.lastTimestamp = lastTimestamp;
        this.currentTxnFirstOffset = currentTxnFirstOffset;
        firstBatchMetadata.ifPresent(this.batchMetadata::add);
    }

    public int firstSeq() {
        return this.isEmpty() ? -1 : this.batchMetadata.getFirst().firstSeq();
    }

    public int lastSeq() {
        return this.isEmpty() ? -1 : this.batchMetadata.getLast().lastSeq();
    }

    public long firstDataOffset() {
        return this.isEmpty() ? -1L : this.batchMetadata.getFirst().firstOffset();
    }

    public long lastDataOffset() {
        return this.isEmpty() ? -1L : this.batchMetadata.getLast().lastOffset();
    }

    public int lastOffsetDelta() {
        return this.isEmpty() ? 0 : this.batchMetadata.getLast().offsetDelta();
    }

    public boolean isEmpty() {
        return this.batchMetadata.isEmpty();
    }

    public ProducerStateEntry withProducerIdAndBatchMetadata(long producerId, Optional<BatchMetadata> batchMetadata) {
        return new ProducerStateEntry(producerId, this.producerEpoch(), this.coordinatorEpoch, this.lastTimestamp, this.currentTxnFirstOffset, batchMetadata);
    }

    public void addBatch(short producerEpoch, int lastSeq, long lastOffset, int offsetDelta, long timestamp) {
        this.maybeUpdateProducerEpoch(producerEpoch);
        this.addBatchMetadata(new BatchMetadata(lastSeq, lastOffset, offsetDelta, timestamp));
        this.lastTimestamp = timestamp;
    }

    public boolean maybeUpdateProducerEpoch(short producerEpoch) {
        if (this.producerEpoch != producerEpoch) {
            this.batchMetadata.clear();
            this.producerEpoch = producerEpoch;
            return true;
        }
        return false;
    }

    private void addBatchMetadata(BatchMetadata batch) {
        if (this.batchMetadata.size() == 5) {
            this.batchMetadata.removeFirst();
        }
        this.batchMetadata.add(batch);
    }

    public void update(ProducerStateEntry nextEntry) {
        this.update(nextEntry.producerEpoch, nextEntry.coordinatorEpoch, nextEntry.lastTimestamp, nextEntry.batchMetadata, nextEntry.currentTxnFirstOffset);
    }

    public void update(short producerEpoch, int coordinatorEpoch, long lastTimestamp) {
        this.update(producerEpoch, coordinatorEpoch, lastTimestamp, new ArrayDeque<BatchMetadata>(0), OptionalLong.empty());
    }

    private void update(short producerEpoch, int coordinatorEpoch, long lastTimestamp, Deque<BatchMetadata> batchMetadata, OptionalLong currentTxnFirstOffset) {
        this.maybeUpdateProducerEpoch(producerEpoch);
        while (!batchMetadata.isEmpty()) {
            this.addBatchMetadata(batchMetadata.removeFirst());
        }
        this.coordinatorEpoch = coordinatorEpoch;
        this.currentTxnFirstOffset = currentTxnFirstOffset;
        this.lastTimestamp = lastTimestamp;
    }

    public void setCurrentTxnFirstOffset(long firstOffset) {
        this.currentTxnFirstOffset = OptionalLong.of(firstOffset);
    }

    public Optional<BatchMetadata> findDuplicateBatch(RecordBatch batch) {
        if (batch.producerEpoch() != this.producerEpoch) {
            return Optional.empty();
        }
        return this.batchWithSequenceRange(batch.baseSequence(), batch.lastSequence());
    }

    Optional<BatchMetadata> batchWithSequenceRange(int firstSeq, int lastSeq) {
        Stream<BatchMetadata> duplicate = this.batchMetadata.stream().filter(metadata -> firstSeq == metadata.firstSeq() && lastSeq == metadata.lastSeq());
        return duplicate.findFirst();
    }

    public Collection<BatchMetadata> batchMetadata() {
        return Collections.unmodifiableCollection(this.batchMetadata);
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public long producerId() {
        return this.producerId;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public long lastTimestamp() {
        return this.lastTimestamp;
    }

    public OptionalLong currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    public String toString() {
        return "ProducerStateEntry(producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", currentTxnFirstOffset=" + String.valueOf(this.currentTxnFirstOffset) + ", coordinatorEpoch=" + this.coordinatorEpoch + ", lastTimestamp=" + this.lastTimestamp + ", batchMetadata=" + String.valueOf(this.batchMetadata) + ")";
    }
}

