/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.share.fetch.AcquisitionLockTimeoutHandler;
import org.apache.kafka.server.share.fetch.AcquisitionLockTimerTask;
import org.apache.kafka.server.share.fetch.DeliveryCountOps;
import org.apache.kafka.server.share.fetch.InFlightState;
import org.apache.kafka.server.share.fetch.RecordState;
import org.apache.kafka.server.share.metrics.SharePartitionMetrics;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.server.util.timer.TimerTask;

public class InFlightBatch {
    private final Timer timer;
    private final Time time;
    private final long firstOffset;
    private final long lastOffset;
    private final AcquisitionLockTimeoutHandler timeoutHandler;
    private final SharePartitionMetrics sharePartitionMetrics;
    private InFlightState batchState;
    private NavigableMap<Long, InFlightState> offsetState;

    public InFlightBatch(Timer timer, Time time, String memberId, long firstOffset, long lastOffset, RecordState state, int deliveryCount, AcquisitionLockTimerTask acquisitionLockTimeoutTask, AcquisitionLockTimeoutHandler timeoutHandler, SharePartitionMetrics sharePartitionMetrics) {
        this.timer = timer;
        this.time = time;
        this.firstOffset = firstOffset;
        this.lastOffset = lastOffset;
        this.timeoutHandler = timeoutHandler;
        this.sharePartitionMetrics = sharePartitionMetrics;
        this.batchState = new InFlightState(state, deliveryCount, memberId, acquisitionLockTimeoutTask);
    }

    public long firstOffset() {
        return this.firstOffset;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public RecordState batchState() {
        return this.inFlightState().state();
    }

    public String batchMemberId() {
        return this.inFlightState().memberId();
    }

    public int batchDeliveryCount() {
        return this.inFlightState().deliveryCount();
    }

    public AcquisitionLockTimerTask batchAcquisitionLockTimeoutTask() {
        return this.inFlightState().acquisitionLockTimeoutTask();
    }

    public NavigableMap<Long, InFlightState> offsetState() {
        return this.offsetState;
    }

    public void cancelAndClearAcquisitionLockTimeoutTask() {
        this.inFlightState().cancelAndClearAcquisitionLockTimeoutTask();
    }

    public boolean batchHasOngoingStateTransition() {
        return this.inFlightState().hasOngoingStateTransition();
    }

    public void archiveBatch() {
        this.inFlightState().archive();
    }

    public InFlightState tryUpdateBatchState(RecordState newState, DeliveryCountOps ops, int maxDeliveryCount, String newMemberId) {
        return this.inFlightState().tryUpdateState(newState, ops, maxDeliveryCount, newMemberId);
    }

    public InFlightState startBatchStateTransition(RecordState newState, DeliveryCountOps ops, int maxDeliveryCount, String newMemberId) {
        return this.inFlightState().startStateTransition(newState, ops, maxDeliveryCount, newMemberId);
    }

    public void maybeInitializeOffsetStateUpdate(long targetOffset, int delayMs) {
        if (this.offsetState == null) {
            this.offsetState = new ConcurrentSkipListMap<Long, InFlightState>();
            for (long offset = this.firstOffset; offset <= this.lastOffset; ++offset) {
                if (offset <= targetOffset) {
                    AcquisitionLockTimerTask timerTask = this.acquisitionLockTimerTask(this.batchState.memberId(), offset, offset, delayMs);
                    this.offsetState.put(offset, new InFlightState(this.batchState.state(), this.batchState.deliveryCount(), this.batchState.memberId(), timerTask));
                    this.timer.add((TimerTask)timerTask);
                    continue;
                }
                this.offsetState.put(offset, new InFlightState(RecordState.AVAILABLE, this.batchState.deliveryCount() - 1, ""));
            }
            this.batchState = null;
        }
    }

    public void maybeInitializeOffsetStateUpdate() {
        if (this.offsetState == null) {
            this.offsetState = new ConcurrentSkipListMap<Long, InFlightState>();
            for (long offset = this.firstOffset; offset <= this.lastOffset; ++offset) {
                if (this.batchState.acquisitionLockTimeoutTask() != null) {
                    long delayMs = this.batchState.acquisitionLockTimeoutTask().expirationMs() - this.time.hiResClockMs();
                    AcquisitionLockTimerTask timerTask = this.acquisitionLockTimerTask(this.batchState.memberId(), offset, offset, delayMs);
                    this.offsetState.put(offset, new InFlightState(this.batchState.state(), this.batchState.deliveryCount(), this.batchState.memberId(), timerTask));
                    this.timer.add((TimerTask)timerTask);
                    continue;
                }
                this.offsetState.put(offset, new InFlightState(this.batchState.state(), this.batchState.deliveryCount(), this.batchState.memberId()));
            }
            if (this.batchState.acquisitionLockTimeoutTask() != null) {
                this.batchState.cancelAndClearAcquisitionLockTimeoutTask();
            }
            this.batchState = null;
        }
    }

    public void updateAcquisitionLockTimeout(AcquisitionLockTimerTask acquisitionLockTimeoutTask) {
        this.inFlightState().updateAcquisitionLockTimeoutTask(acquisitionLockTimeoutTask);
    }

    private InFlightState inFlightState() {
        if (this.batchState == null) {
            throw new IllegalStateException("The batch state is not available as the offset state is maintained");
        }
        return this.batchState;
    }

    private AcquisitionLockTimerTask acquisitionLockTimerTask(String memberId, long firstOffset, long lastOffset, long delayMs) {
        return new AcquisitionLockTimerTask(this.time, delayMs, memberId, firstOffset, lastOffset, this.timeoutHandler, this.sharePartitionMetrics);
    }

    public String toString() {
        return "InFlightBatch(firstOffset=" + this.firstOffset + ", lastOffset=" + this.lastOffset + ", inFlightState=" + String.valueOf(this.batchState) + ", offsetState=" + String.valueOf(this.offsetState == null ? "null" : this.offsetState) + ")";
    }
}

