/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.metrics.TimeRatio;

public class QuorumControllerMetrics
implements AutoCloseable {
    private static final MetricName ACTIVE_CONTROLLER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "ActiveControllerCount");
    private static final MetricName EVENT_QUEUE_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueTimeMs");
    private static final MetricName EVENT_QUEUE_PROCESSING_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueProcessingTimeMs");
    private static final MetricName AVERAGE_IDLE_RATIO = QuorumControllerMetrics.getMetricName("ControllerEventManager", "AvgIdleRatio");
    private static final MetricName LAST_APPLIED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordOffset");
    private static final MetricName LAST_COMMITTED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastCommittedRecordOffset");
    private static final MetricName LAST_APPLIED_RECORD_TIMESTAMP = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordTimestamp");
    private static final MetricName LAST_APPLIED_RECORD_LAG_MS = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordLagMs");
    private static final MetricName TIMED_OUT_BROKER_HEARTBEAT_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "TimedOutBrokerHeartbeatCount");
    private static final MetricName EVENT_QUEUE_OPERATIONS_STARTED_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "EventQueueOperationsStartedCount");
    private static final MetricName EVENT_QUEUE_OPERATIONS_TIMED_OUT_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "EventQueueOperationsTimedOutCount");
    private static final MetricName NEW_ACTIVE_CONTROLLERS_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "NewActiveControllersCount");
    private static final String TIME_SINCE_LAST_HEARTBEAT_RECEIVED_METRIC_NAME = "TimeSinceLastHeartbeatReceivedMs";
    private static final String BROKER_ID_TAG = "broker";
    private final Optional<MetricsRegistry> registry;
    private final Time time;
    private volatile boolean active;
    private final AtomicLong lastAppliedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastCommittedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastAppliedRecordTimestamp = new AtomicLong(0L);
    private final Consumer<Long> eventQueueTimeUpdater;
    private final Consumer<Long> eventQueueProcessingTimeUpdater;
    private final TimeRatio avgIdleTimeRatio;
    private final AtomicLong timedOutHeartbeats = new AtomicLong(0L);
    private final AtomicLong operationsStarted = new AtomicLong(0L);
    private final AtomicLong operationsTimedOut = new AtomicLong(0L);
    private final AtomicLong newActiveControllers = new AtomicLong(0L);
    private final Map<Integer, Long> brokerContactTimesMs = new ConcurrentHashMap<Integer, Long>();
    private final int sessionTimeoutMs;

    private Consumer<Long> newHistogram(MetricName name, boolean biased) {
        if (this.registry.isPresent()) {
            Histogram histogram = this.registry.get().newHistogram(name, biased);
            return arg_0 -> ((Histogram)histogram).update(arg_0);
        }
        return __ -> {};
    }

    public QuorumControllerMetrics(Optional<MetricsRegistry> registry, final Time time, int sessionTimeoutMs) {
        this.registry = registry;
        this.time = time;
        this.active = false;
        registry.ifPresent(r -> r.newGauge(ACTIVE_CONTROLLER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.active ? 1 : 0;
            }
        }));
        this.eventQueueTimeUpdater = this.newHistogram(EVENT_QUEUE_TIME_MS, true);
        this.eventQueueProcessingTimeUpdater = this.newHistogram(EVENT_QUEUE_PROCESSING_TIME_MS, true);
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.avgIdleTimeRatio = new TimeRatio(1.0);
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordOffset();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_COMMITTED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastCommittedRecordOffset();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_TIMESTAMP, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordTimestamp();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LAST_APPLIED_RECORD_LAG_MS, (Gauge)new Gauge<Long>(this){
            final /* synthetic */ QuorumControllerMetrics this$0;
            {
                this.this$0 = this$0;
            }

            public Long value() {
                return time.milliseconds() - this.this$0.lastAppliedRecordTimestamp();
            }
        }));
        registry.ifPresent(r -> r.newGauge(TIMED_OUT_BROKER_HEARTBEAT_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.timedOutHeartbeats();
            }
        }));
        registry.ifPresent(r -> r.newGauge(EVENT_QUEUE_OPERATIONS_STARTED_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.operationsStarted();
            }
        }));
        registry.ifPresent(r -> r.newGauge(EVENT_QUEUE_OPERATIONS_TIMED_OUT_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.operationsTimedOut();
            }
        }));
        registry.ifPresent(r -> r.newGauge(NEW_ACTIVE_CONTROLLERS_COUNT, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.newActiveControllers();
            }
        }));
        registry.ifPresent(r -> r.newGauge(AVERAGE_IDLE_RATIO, (Gauge)new Gauge<Double>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Double value() {
                TimeRatio timeRatio = QuorumControllerMetrics.this.avgIdleTimeRatio;
                synchronized (timeRatio) {
                    return QuorumControllerMetrics.this.avgIdleTimeRatio.measure();
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIdleTime(long idleDurationMs, long currentTimeMs) {
        TimeRatio timeRatio = this.avgIdleTimeRatio;
        synchronized (timeRatio) {
            this.avgIdleTimeRatio.record((double)idleDurationMs, currentTimeMs);
        }
    }

    public void addTimeSinceLastHeartbeatMetric(final int brokerId) {
        this.brokerContactTimesMs.put(brokerId, this.time.milliseconds());
        this.registry.ifPresent(r -> r.newGauge(QuorumControllerMetrics.getBrokerIdTagMetricName("KafkaController", TIME_SINCE_LAST_HEARTBEAT_RECEIVED_METRIC_NAME, brokerId), (Gauge)new Gauge<Integer>(this){
            final /* synthetic */ QuorumControllerMetrics this$0;
            {
                this.this$0 = this$0;
            }

            public Integer value() {
                return this.this$0.timeSinceLastHeartbeatMs(brokerId);
            }
        }));
    }

    public void removeTimeSinceLastHeartbeatMetric(int brokerId) {
        this.registry.ifPresent(r -> r.removeMetric(QuorumControllerMetrics.getBrokerIdTagMetricName("KafkaController", TIME_SINCE_LAST_HEARTBEAT_RECEIVED_METRIC_NAME, brokerId)));
        this.brokerContactTimesMs.remove(brokerId);
    }

    public void removeTimeSinceLastHeartbeatMetrics() {
        for (int brokerId : this.brokerContactTimesMs.keySet()) {
            this.removeTimeSinceLastHeartbeatMetric(brokerId);
        }
        this.brokerContactTimesMs.clear();
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean active() {
        return this.active;
    }

    public void updateEventQueueTime(long durationMs) {
        this.eventQueueTimeUpdater.accept(durationMs);
    }

    public void updateEventQueueProcessingTime(long durationMs) {
        this.eventQueueProcessingTimeUpdater.accept(durationMs);
    }

    public void setLastAppliedRecordOffset(long offset) {
        this.lastAppliedRecordOffset.set(offset);
    }

    public long lastAppliedRecordOffset() {
        return this.lastAppliedRecordOffset.get();
    }

    public void setLastCommittedRecordOffset(long offset) {
        this.lastCommittedRecordOffset.set(offset);
    }

    public long lastCommittedRecordOffset() {
        return this.lastCommittedRecordOffset.get();
    }

    public void setLastAppliedRecordTimestamp(long timestamp) {
        this.lastAppliedRecordTimestamp.set(timestamp);
    }

    public long lastAppliedRecordTimestamp() {
        return this.lastAppliedRecordTimestamp.get();
    }

    public void incrementTimedOutHeartbeats() {
        this.timedOutHeartbeats.incrementAndGet();
    }

    public long timedOutHeartbeats() {
        return this.timedOutHeartbeats.get();
    }

    public void incrementOperationsStarted() {
        this.operationsStarted.incrementAndGet();
    }

    public long operationsStarted() {
        return this.operationsStarted.get();
    }

    public void incrementOperationsTimedOut() {
        this.operationsTimedOut.incrementAndGet();
    }

    public long operationsTimedOut() {
        return this.operationsTimedOut.get();
    }

    public void incrementNewActiveControllers() {
        this.newActiveControllers.incrementAndGet();
    }

    public long newActiveControllers() {
        return this.newActiveControllers.get();
    }

    public void updateBrokerContactTime(int brokerId) {
        this.brokerContactTimesMs.put(brokerId, this.time.milliseconds());
    }

    public int timeSinceLastHeartbeatMs(int brokerId) {
        Long lastTime = this.brokerContactTimesMs.get(brokerId);
        if (lastTime == null) {
            return this.sessionTimeoutMs;
        }
        return Math.min((int)(this.time.milliseconds() - lastTime), this.sessionTimeoutMs);
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> List.of(ACTIVE_CONTROLLER_COUNT, EVENT_QUEUE_TIME_MS, EVENT_QUEUE_PROCESSING_TIME_MS, LAST_APPLIED_RECORD_OFFSET, LAST_COMMITTED_RECORD_OFFSET, LAST_APPLIED_RECORD_TIMESTAMP, LAST_APPLIED_RECORD_LAG_MS, TIMED_OUT_BROKER_HEARTBEAT_COUNT, EVENT_QUEUE_OPERATIONS_STARTED_COUNT, EVENT_QUEUE_OPERATIONS_TIMED_OUT_COUNT, NEW_ACTIVE_CONTROLLERS_COUNT, AVERAGE_IDLE_RATIO).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
        this.removeTimeSinceLastHeartbeatMetrics();
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }

    private static MetricName getBrokerIdTagMetricName(String type, String name, int brokerId) {
        LinkedHashMap<String, String> brokerIdTag = new LinkedHashMap<String, String>();
        brokerIdTag.put(BROKER_ID_TAG, Integer.toString(brokerId));
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name, brokerIdTag);
    }
}

