/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import org.apache.kafka.clients.consumer.internals.Deserializers;
import org.apache.kafka.clients.consumer.internals.FetchUtils;
import org.apache.kafka.clients.consumer.internals.ShareCompletedFetch;
import org.apache.kafka.clients.consumer.internals.ShareConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ShareFetch;
import org.apache.kafka.clients.consumer.internals.ShareFetchBuffer;
import org.apache.kafka.clients.consumer.internals.ShareFetchConfig;
import org.apache.kafka.clients.consumer.internals.ShareFetchException;
import org.apache.kafka.clients.consumer.internals.ShareInFlightBatch;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class ShareFetchCollector<K, V> {
    private final Logger log;
    private final ShareConsumerMetadata metadata;
    private final SubscriptionState subscriptions;
    private final ShareFetchConfig shareFetchConfig;
    private final Deserializers<K, V> deserializers;

    public ShareFetchCollector(LogContext logContext, ShareConsumerMetadata metadata, SubscriptionState subscriptions, ShareFetchConfig shareFetchConfig, Deserializers<K, V> deserializers) {
        this.log = logContext.logger(ShareFetchCollector.class);
        this.metadata = metadata;
        this.subscriptions = subscriptions;
        this.shareFetchConfig = shareFetchConfig;
        this.deserializers = deserializers;
    }

    public ShareFetch<K, V> collect(ShareFetchBuffer fetchBuffer) {
        ShareFetch<K, V> fetch;
        block13: {
            fetch = ShareFetch.empty();
            int recordsRemaining = this.shareFetchConfig.maxPollRecords;
            try {
                while (recordsRemaining > 0) {
                    ShareCompletedFetch nextInLineFetch = fetchBuffer.nextInLineFetch();
                    if (nextInLineFetch == null || nextInLineFetch.isConsumed()) {
                        ShareCompletedFetch completedFetch = fetchBuffer.peek();
                        if (completedFetch != null) {
                            if (!completedFetch.isInitialized()) {
                                try {
                                    fetchBuffer.setNextInLineFetch(this.initialize(completedFetch));
                                }
                                catch (Exception e) {
                                    if (fetch.isEmpty()) {
                                        fetchBuffer.poll();
                                    }
                                    throw e;
                                }
                            } else {
                                fetchBuffer.setNextInLineFetch(completedFetch);
                            }
                            fetchBuffer.poll();
                            continue;
                        }
                    } else {
                        TopicIdPartition tp = nextInLineFetch.partition;
                        ShareInFlightBatch<K, V> batch = nextInLineFetch.fetchRecords(this.deserializers, recordsRemaining, this.shareFetchConfig.checkCrcs);
                        if (batch.isEmpty()) {
                            nextInLineFetch.drain();
                        }
                        recordsRemaining -= batch.numRecords();
                        fetch.add(tp, batch);
                        if (batch.getException() != null) {
                            throw new ShareFetchException(fetch, batch.getException().cause());
                        }
                        if (!batch.hasCachedException()) continue;
                    }
                    break;
                }
            }
            catch (KafkaException e) {
                if (!fetch.isEmpty()) break block13;
                throw e;
            }
        }
        return fetch;
    }

    protected ShareCompletedFetch initialize(ShareCompletedFetch completedFetch) {
        Errors error = Errors.forCode(completedFetch.partitionData.errorCode());
        if (error == Errors.NONE) {
            return this.handleInitializeSuccess(completedFetch);
        }
        this.handleInitializeErrors(completedFetch, error);
        return null;
    }

    private ShareCompletedFetch handleInitializeSuccess(ShareCompletedFetch completedFetch) {
        this.log.trace("Preparing to read {} bytes of data for partition {}", (Object)ShareFetchResponse.recordsSize(completedFetch.partitionData), (Object)completedFetch.partition.topicPartition());
        completedFetch.setInitialized();
        return completedFetch;
    }

    private void handleInitializeErrors(ShareCompletedFetch completedFetch, Errors error) {
        TopicIdPartition tp = completedFetch.partition;
        if (error == Errors.NOT_LEADER_OR_FOLLOWER || error == Errors.REPLICA_NOT_AVAILABLE || error == Errors.KAFKA_STORAGE_ERROR || error == Errors.FENCED_LEADER_EPOCH || error == Errors.OFFSET_NOT_AVAILABLE) {
            this.log.debug("Error in fetch for partition {}: {}", (Object)tp, (Object)error.exceptionName());
            FetchUtils.requestMetadataUpdate(this.metadata, this.subscriptions, tp.topicPartition());
        } else if (error == Errors.UNKNOWN_TOPIC_OR_PARTITION) {
            this.log.warn("Received unknown topic or partition error in fetch for partition {}.", (Object)tp);
            FetchUtils.requestMetadataUpdate(this.metadata, this.subscriptions, tp.topicPartition());
        } else if (error == Errors.UNKNOWN_TOPIC_ID) {
            this.log.warn("Received unknown topic ID error in fetch for partition {}.", (Object)tp);
            FetchUtils.requestMetadataUpdate(this.metadata, this.subscriptions, tp.topicPartition());
        } else if (error == Errors.INCONSISTENT_TOPIC_ID) {
            this.log.warn("Received inconsistent topic ID error in fetch for partition {}.", (Object)tp);
            FetchUtils.requestMetadataUpdate(this.metadata, this.subscriptions, tp.topicPartition());
        } else {
            if (error == Errors.TOPIC_AUTHORIZATION_FAILED) {
                this.log.warn("Not authorized to read from partition {}.", (Object)tp.topicPartition());
                throw new TopicAuthorizationException(Collections.singleton(tp.topic()));
            }
            if (error == Errors.UNKNOWN_LEADER_EPOCH) {
                this.log.debug("Received unknown leader epoch error in fetch for partition {}.", (Object)tp);
            } else if (error == Errors.UNKNOWN_SERVER_ERROR) {
                this.log.warn("Unknown server error while fetching topic-partition {}.", (Object)tp.topicPartition());
            } else {
                if (error == Errors.CORRUPT_MESSAGE) {
                    throw new KafkaException("Encountered corrupt message when fetching topic-partition " + String.valueOf(tp.topicPartition()));
                }
                throw new IllegalStateException("Unexpected error code " + error.code() + " while fetching from topic-partition " + String.valueOf(tp.topicPartition()));
            }
        }
    }
}

