/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.util.graph.traverser;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import shaded.org.eclipse.aether.collection.DependencyCollectionContext;
import shaded.org.eclipse.aether.collection.DependencyTraverser;
import shaded.org.eclipse.aether.graph.Dependency;

public final class AndDependencyTraverser
implements DependencyTraverser {
    private final Set<? extends DependencyTraverser> traversers;
    private int hashCode;

    public AndDependencyTraverser(DependencyTraverser ... traversers) {
        this.traversers = traversers != null && traversers.length > 0 ? new LinkedHashSet<DependencyTraverser>(Arrays.asList(traversers)) : Collections.emptySet();
    }

    public AndDependencyTraverser(Collection<? extends DependencyTraverser> traversers) {
        this.traversers = traversers != null && !traversers.isEmpty() ? new LinkedHashSet<DependencyTraverser>(traversers) : Collections.emptySet();
    }

    private AndDependencyTraverser(Set<DependencyTraverser> traversers) {
        this.traversers = traversers != null && !traversers.isEmpty() ? traversers : Collections.emptySet();
    }

    public static DependencyTraverser newInstance(DependencyTraverser traverser1, DependencyTraverser traverser2) {
        if (traverser1 == null) {
            return traverser2;
        }
        if (traverser2 == null || traverser2.equals(traverser1)) {
            return traverser1;
        }
        return new AndDependencyTraverser(traverser1, traverser2);
    }

    @Override
    public boolean traverseDependency(Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency cannot be null");
        for (DependencyTraverser dependencyTraverser : this.traversers) {
            if (dependencyTraverser.traverseDependency(dependency)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DependencyTraverser deriveChildTraverser(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        int seen = 0;
        LinkedHashSet<DependencyTraverser> childTraversers = null;
        for (DependencyTraverser dependencyTraverser : this.traversers) {
            DependencyTraverser childTraverser = dependencyTraverser.deriveChildTraverser(context);
            if (childTraversers != null) {
                if (childTraverser == null) continue;
                childTraversers.add(childTraverser);
                continue;
            }
            if (dependencyTraverser != childTraverser) {
                childTraversers = new LinkedHashSet<DependencyTraverser>();
                if (seen > 0) {
                    for (DependencyTraverser dependencyTraverser2 : this.traversers) {
                        if (childTraversers.size() >= seen) break;
                        childTraversers.add(dependencyTraverser2);
                    }
                }
                if (childTraverser == null) continue;
                childTraversers.add(childTraverser);
                continue;
            }
            ++seen;
        }
        if (childTraversers == null) {
            return this;
        }
        if (childTraversers.size() <= 1) {
            if (childTraversers.isEmpty()) {
                return null;
            }
            return (DependencyTraverser)childTraversers.iterator().next();
        }
        return new AndDependencyTraverser((Set<DependencyTraverser>)childTraversers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AndDependencyTraverser that = (AndDependencyTraverser)obj;
        return this.traversers.equals(that.traversers);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 17;
            this.hashCode = hash = hash * 31 + this.traversers.hashCode();
        }
        return this.hashCode;
    }
}

