/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction;

import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public final class GeronimoUserTransaction
implements UserTransaction,
Serializable {
    private static final long serialVersionUID = -7524804683512228998L;
    private transient TransactionManager transactionManager;

    public GeronimoUserTransaction(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    boolean isActive() {
        return this.transactionManager != null;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        if (this.transactionManager == null) {
            this.transactionManager = transactionManager;
        } else if (this.transactionManager != transactionManager) {
            throw new IllegalStateException("This user transaction is already associated with another transaction manager");
        }
    }

    @Override
    public int getStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.transactionManager.setRollbackOnly();
    }

    @Override
    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw new SystemException("transaction timeout must be positive or 0, not " + seconds);
        }
        this.transactionManager.setTransactionTimeout(seconds);
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.transactionManager.begin();
    }

    @Override
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.transactionManager.commit();
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.transactionManager.rollback();
    }
}

