/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc.internal;

import org.apache.kyuubi.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.io.grpc.NameResolver;
import org.apache.kyuubi.shade.io.grpc.Status;
import org.apache.kyuubi.shade.io.grpc.SynchronizationContext;
import org.apache.kyuubi.shade.io.grpc.internal.BackoffPolicyRetryScheduler;
import org.apache.kyuubi.shade.io.grpc.internal.ExponentialBackoffPolicy;
import org.apache.kyuubi.shade.io.grpc.internal.ForwardingNameResolver;
import org.apache.kyuubi.shade.io.grpc.internal.RetryScheduler;

public final class RetryingNameResolver
extends ForwardingNameResolver {
    private final NameResolver retriedNameResolver;
    private final RetryScheduler retryScheduler;
    private final SynchronizationContext syncContext;

    public static NameResolver wrap(NameResolver retriedNameResolver, NameResolver.Args args) {
        return new RetryingNameResolver(retriedNameResolver, new BackoffPolicyRetryScheduler(new ExponentialBackoffPolicy.Provider(), args.getScheduledExecutorService(), args.getSynchronizationContext()), args.getSynchronizationContext());
    }

    RetryingNameResolver(NameResolver retriedNameResolver, RetryScheduler retryScheduler, SynchronizationContext syncContext) {
        super(retriedNameResolver);
        this.retriedNameResolver = retriedNameResolver;
        this.retryScheduler = retryScheduler;
        this.syncContext = syncContext;
    }

    @Override
    public void start(NameResolver.Listener2 listener) {
        super.start(new RetryingListener(listener));
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.retryScheduler.reset();
    }

    @VisibleForTesting
    NameResolver getRetriedNameResolver() {
        return this.retriedNameResolver;
    }

    private class RetryingListener
    extends NameResolver.Listener2 {
        private NameResolver.Listener2 delegateListener;

        RetryingListener(NameResolver.Listener2 delegateListener) {
            this.delegateListener = delegateListener;
        }

        @Override
        public void onResult(NameResolver.ResolutionResult resolutionResult) {
            RetryingNameResolver.this.syncContext.execute(() -> this.onResult2(resolutionResult));
        }

        @Override
        public Status onResult2(NameResolver.ResolutionResult resolutionResult) {
            Status status = this.delegateListener.onResult2(resolutionResult);
            if (status.isOk()) {
                RetryingNameResolver.this.retryScheduler.reset();
            } else {
                RetryingNameResolver.this.retryScheduler.schedule(new DelayedNameResolverRefresh());
            }
            return status;
        }

        @Override
        public void onError(Status error) {
            this.delegateListener.onError(error);
            RetryingNameResolver.this.syncContext.execute(() -> RetryingNameResolver.this.retryScheduler.schedule(new DelayedNameResolverRefresh()));
        }
    }

    @VisibleForTesting
    class DelayedNameResolverRefresh
    implements Runnable {
        DelayedNameResolverRefresh() {
        }

        @Override
        public void run() {
            RetryingNameResolver.this.refresh();
        }
    }
}

