/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.tracing.TracingPolicy;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpServerOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, HttpServerOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "acceptUnmaskedFrames": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAcceptUnmaskedFrames((Boolean)member.getValue());
                    break;
                }
                case "alpnVersions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<HttpVersion> list = new ArrayList<HttpVersion>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(HttpVersion.valueOf((String)item));
                        }
                    });
                    obj.setAlpnVersions(list);
                    break;
                }
                case "compressionLevel": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCompressionLevel(((Number)member.getValue()).intValue());
                    break;
                }
                case "compressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "decoderInitialBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDecoderInitialBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "decompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDecompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "handle100ContinueAutomatically": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHandle100ContinueAutomatically((Boolean)member.getValue());
                    break;
                }
                case "http2ClearTextEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHttp2ClearTextEnabled((Boolean)member.getValue());
                    break;
                }
                case "http2ConnectionWindowSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2ConnectionWindowSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2RstFloodMaxRstFramePerWindow": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2RstFloodMaxRstFramePerWindow(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2RstFloodWindowDuration": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHttp2RstFloodWindowDuration(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2RstFloodWindowDurationTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHttp2RstFloodWindowDurationTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "initialSettings": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setInitialSettings(new Http2Settings((JsonObject)member.getValue()));
                    break;
                }
                case "maxChunkSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxChunkSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxFormAttributeSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxFormAttributeSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxHeaderSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxHeaderSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxInitialLineLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxInitialLineLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWebSocketFrameSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWebSocketFrameSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWebSocketMessageSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWebSocketMessageSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "perFrameWebSocketCompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPerFrameWebSocketCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "perMessageWebSocketCompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPerMessageWebSocketCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "registerWebSocketWriteHandlers": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRegisterWebSocketWriteHandlers((Boolean)member.getValue());
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTracingPolicy(TracingPolicy.valueOf((String)member.getValue()));
                    break;
                }
                case "webSocketAllowServerNoContext": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWebSocketAllowServerNoContext((Boolean)member.getValue());
                    break;
                }
                case "webSocketClosingTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWebSocketClosingTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "webSocketCompressionLevel": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWebSocketCompressionLevel(((Number)member.getValue()).intValue());
                    break;
                }
                case "webSocketPreferredClientNoContext": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWebSocketPreferredClientNoContext((Boolean)member.getValue());
                    break;
                }
                case "webSocketSubProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<HttpVersion> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((HttpVersion)((Object)((String)item)));
                        }
                    });
                    obj.setWebSocketSubProtocols(list);
                }
            }
        }
    }

    static void toJson(HttpServerOptions obj, JsonObject json) {
        HttpServerOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(HttpServerOptions obj, Map<String, Object> json) {
        JsonArray array;
        json.put("acceptUnmaskedFrames", obj.isAcceptUnmaskedFrames());
        if (obj.getAlpnVersions() != null) {
            array = new JsonArray();
            obj.getAlpnVersions().forEach(item -> array.add(item.name()));
            json.put("alpnVersions", array);
        }
        json.put("compressionLevel", obj.getCompressionLevel());
        json.put("compressionSupported", obj.isCompressionSupported());
        json.put("decoderInitialBufferSize", obj.getDecoderInitialBufferSize());
        json.put("decompressionSupported", obj.isDecompressionSupported());
        json.put("handle100ContinueAutomatically", obj.isHandle100ContinueAutomatically());
        json.put("http2ClearTextEnabled", obj.isHttp2ClearTextEnabled());
        json.put("http2ConnectionWindowSize", obj.getHttp2ConnectionWindowSize());
        json.put("http2RstFloodMaxRstFramePerWindow", obj.getHttp2RstFloodMaxRstFramePerWindow());
        json.put("http2RstFloodWindowDuration", obj.getHttp2RstFloodWindowDuration());
        if (obj.getHttp2RstFloodWindowDurationTimeUnit() != null) {
            json.put("http2RstFloodWindowDurationTimeUnit", obj.getHttp2RstFloodWindowDurationTimeUnit().name());
        }
        if (obj.getInitialSettings() != null) {
            json.put("initialSettings", obj.getInitialSettings().toJson());
        }
        json.put("maxChunkSize", obj.getMaxChunkSize());
        json.put("maxFormAttributeSize", obj.getMaxFormAttributeSize());
        json.put("maxHeaderSize", obj.getMaxHeaderSize());
        json.put("maxInitialLineLength", obj.getMaxInitialLineLength());
        json.put("maxWebSocketFrameSize", obj.getMaxWebSocketFrameSize());
        json.put("maxWebSocketMessageSize", obj.getMaxWebSocketMessageSize());
        json.put("perFrameWebSocketCompressionSupported", obj.getPerFrameWebSocketCompressionSupported());
        json.put("perMessageWebSocketCompressionSupported", obj.getPerMessageWebSocketCompressionSupported());
        json.put("registerWebSocketWriteHandlers", obj.isRegisterWebSocketWriteHandlers());
        if (obj.getTracingPolicy() != null) {
            json.put("tracingPolicy", obj.getTracingPolicy().name());
        }
        json.put("webSocketAllowServerNoContext", obj.getWebSocketAllowServerNoContext());
        json.put("webSocketClosingTimeout", obj.getWebSocketClosingTimeout());
        json.put("webSocketCompressionLevel", obj.getWebSocketCompressionLevel());
        json.put("webSocketPreferredClientNoContext", obj.getWebSocketPreferredClientNoContext());
        if (obj.getWebSocketSubProtocols() != null) {
            array = new JsonArray();
            obj.getWebSocketSubProtocols().forEach(item -> array.add(item));
            json.put("webSocketSubProtocols", array);
        }
    }
}

