/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Flowable;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.reactivestreams.Subscriber;

public final class MaybeMergeArray<T>
extends Flowable<T> {
    final MaybeSource<? extends T>[] sources;

    public MaybeMergeArray(MaybeSource<? extends T>[] sources) {
        this.sources = sources;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        MaybeSource<? extends T>[] maybes = this.sources;
        int n = maybes.length;
        SimpleQueueWithConsumerIndex queue = n <= MaybeMergeArray.bufferSize() ? new MpscFillOnceSimpleQueue(n) : new ClqSimpleQueue();
        MergeMaybeObserver<T> parent = new MergeMaybeObserver<T>(s, n, queue);
        s.onSubscribe(parent);
        AtomicThrowable e = parent.error;
        for (MaybeSource<T> maybeSource : maybes) {
            if (parent.isCancelled() || e.get() != null) {
                return;
            }
            maybeSource.subscribe(parent);
        }
    }

    static final class ClqSimpleQueue<T>
    extends ConcurrentLinkedQueue<T>
    implements SimpleQueueWithConsumerIndex<T> {
        private static final long serialVersionUID = -4025173261791142821L;
        int consumerIndex;
        final AtomicInteger producerIndex = new AtomicInteger();

        ClqSimpleQueue() {
        }

        @Override
        public boolean offer(T v1, T v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(T e) {
            this.producerIndex.getAndIncrement();
            return super.offer(e);
        }

        @Override
        public T poll() {
            Object v = super.poll();
            if (v != null) {
                ++this.consumerIndex;
            }
            return (T)v;
        }

        @Override
        public int consumerIndex() {
            return this.consumerIndex;
        }

        @Override
        public int producerIndex() {
            return this.producerIndex.get();
        }

        @Override
        public void drop() {
            this.poll();
        }
    }

    static final class MpscFillOnceSimpleQueue<T>
    extends AtomicReferenceArray<T>
    implements SimpleQueueWithConsumerIndex<T> {
        private static final long serialVersionUID = -7969063454040569579L;
        final AtomicInteger producerIndex = new AtomicInteger();
        int consumerIndex;

        MpscFillOnceSimpleQueue(int length) {
            super(length);
        }

        @Override
        public boolean offer(T value) {
            ObjectHelper.requireNonNull(value, "value is null");
            int idx = this.producerIndex.getAndIncrement();
            if (idx < this.length()) {
                this.lazySet(idx, value);
                return true;
            }
            return false;
        }

        @Override
        public boolean offer(T v1, T v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T poll() {
            int ci = this.consumerIndex;
            if (ci == this.length()) {
                return null;
            }
            AtomicInteger pi = this.producerIndex;
            do {
                Object v;
                if ((v = this.get(ci)) == null) continue;
                this.consumerIndex = ci + 1;
                this.lazySet(ci, null);
                return (T)v;
            } while (pi.get() != ci);
            return null;
        }

        @Override
        public T peek() {
            int ci = this.consumerIndex;
            if (ci == this.length()) {
                return null;
            }
            return (T)this.get(ci);
        }

        @Override
        public void drop() {
            int ci = this.consumerIndex;
            this.lazySet(ci, null);
            this.consumerIndex = ci + 1;
        }

        @Override
        public boolean isEmpty() {
            return this.consumerIndex == this.producerIndex();
        }

        @Override
        public void clear() {
            while (this.poll() != null && !this.isEmpty()) {
            }
        }

        @Override
        public int consumerIndex() {
            return this.consumerIndex;
        }

        @Override
        public int producerIndex() {
            return this.producerIndex.get();
        }
    }

    static interface SimpleQueueWithConsumerIndex<T>
    extends SimpleQueue<T> {
        @Override
        public T poll();

        public T peek();

        public void drop();

        public int consumerIndex();

        public int producerIndex();
    }

    static final class MergeMaybeObserver<T>
    extends BasicIntQueueSubscription<T>
    implements MaybeObserver<T> {
        private static final long serialVersionUID = -660395290758764731L;
        final Subscriber<? super T> actual;
        final CompositeDisposable set;
        final AtomicLong requested;
        final SimpleQueueWithConsumerIndex<Object> queue;
        final AtomicThrowable error;
        final int sourceCount;
        volatile boolean cancelled;
        boolean outputFused;
        long consumed;

        MergeMaybeObserver(Subscriber<? super T> actual, int sourceCount, SimpleQueueWithConsumerIndex<Object> queue) {
            this.actual = actual;
            this.sourceCount = sourceCount;
            this.set = new CompositeDisposable();
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
            this.queue = queue;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public T poll() throws Exception {
            Object o;
            while ((o = this.queue.poll()) == NotificationLite.COMPLETE) {
            }
            return (T)o;
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.set.dispose();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
        }

        @Override
        public void onSuccess(T value) {
            this.queue.offer(value);
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            if (this.error.addThrowable(e)) {
                this.set.dispose();
                this.queue.offer((Object)NotificationLite.COMPLETE);
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.queue.offer((Object)NotificationLite.COMPLETE);
            this.drain();
        }

        boolean isCancelled() {
            return this.cancelled;
        }

        void drainNormal() {
            int missed = 1;
            Subscriber<? super T> a = this.actual;
            SimpleQueueWithConsumerIndex<Object> q = this.queue;
            long e = this.consumed;
            do {
                Throwable ex;
                long r = this.requested.get();
                while (e != r) {
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    ex = (Throwable)this.error.get();
                    if (ex != null) {
                        q.clear();
                        a.onError(this.error.terminate());
                        return;
                    }
                    if (q.consumerIndex() == this.sourceCount) {
                        a.onComplete();
                        return;
                    }
                    Object v = q.poll();
                    if (v == null) break;
                    if (v == NotificationLite.COMPLETE) continue;
                    a.onNext(v);
                    ++e;
                }
                if (e == r) {
                    ex = (Throwable)this.error.get();
                    if (ex != null) {
                        q.clear();
                        a.onError(this.error.terminate());
                        return;
                    }
                    while (q.peek() == NotificationLite.COMPLETE) {
                        q.drop();
                    }
                    if (q.consumerIndex() == this.sourceCount) {
                        a.onComplete();
                        return;
                    }
                }
                this.consumed = e;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drainFused() {
            int missed = 1;
            Subscriber<? super T> a = this.actual;
            SimpleQueueWithConsumerIndex<Object> q = this.queue;
            do {
                boolean d;
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                Throwable ex = (Throwable)this.error.get();
                if (ex != null) {
                    q.clear();
                    a.onError(ex);
                    return;
                }
                boolean bl = d = q.producerIndex() == this.sourceCount;
                if (!q.isEmpty()) {
                    a.onNext(null);
                }
                if (!d) continue;
                a.onComplete();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.outputFused) {
                this.drainFused();
            } else {
                this.drainNormal();
            }
        }
    }
}

