/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino;

import io.trino.client.StageStats;
import io.trino.client.StatementClient;
import io.trino.client.StatementStats;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.OptionalDouble;
import org.apache.kyuubi.engine.trino.TrinoProgressMonitor$;
import org.apache.kyuubi.engine.trino.operation.progress.TrinoStage;
import org.apache.kyuubi.engine.trino.operation.progress.TrinoStageProgress;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TJobExecutionStatus;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001\u0002\n\u0014\u0001yA\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006]\u0001!\ta\f\u0005\tg\u0001A)\u0019!C\u0005i!)1\n\u0001C\u0001\u0019\")\u0001\f\u0001C\u00013\")1\f\u0001C\u00019\")Q\f\u0001C\u0001=\")!\r\u0001C\u0001G\")!\u000f\u0001C\u0005g\")Q\u0010\u0001C\u0005}\u001e1qp\u0005E\u0001\u0003\u00031aAE\n\t\u0002\u0005\r\u0001B\u0002\u0018\r\t\u0003\t)\u0001\u0003\u0005\u0002\b1\u0011\r\u0011\"\u0003M\u0011\u001d\tI\u0001\u0004Q\u0001\n5C\u0001\"a\u0003\r\u0005\u0004%IA \u0005\b\u0003\u001ba\u0001\u0015!\u0003y\u0005Q!&/\u001b8p!J|wM]3tg6{g.\u001b;pe*\u0011A#F\u0001\u0006iJLgn\u001c\u0006\u0003-]\ta!\u001a8hS:,'B\u0001\r\u001a\u0003\u0019Y\u00170^;cS*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1C&D\u0001(\u0015\tA\u0013&\u0001\u0004dY&,g\u000e\u001e\u0006\u0003))R\u0011aK\u0001\u0003S>L!!L\u0014\u0003\u001fM#\u0018\r^3nK:$8\t\\5f]R\fa\u0001P5oSRtDC\u0001\u00193!\t\t\u0004!D\u0001\u0014\u0011\u0015!\"\u00011\u0001&\u0003-\u0001(o\\4sKN\u001cX*\u00199\u0016\u0003U\u0002BAN\u001fA\u0011:\u0011qg\u000f\t\u0003q\u0005j\u0011!\u000f\u0006\u0003uu\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f\"\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0004\u001b\u0006\u0004(B\u0001\u001f\"!\t\te)D\u0001C\u0015\t\u0019E)\u0001\u0005qe><'/Z:t\u0015\t)5#A\u0005pa\u0016\u0014\u0018\r^5p]&\u0011qI\u0011\u0002\u000b)JLgn\\*uC\u001e,\u0007CA!J\u0013\tQ%I\u0001\nUe&twn\u0015;bO\u0016\u0004&o\\4sKN\u001c\u0018a\u00025fC\u0012,'o]\u000b\u0002\u001bB\u0019ajU+\u000e\u0003=S!\u0001U)\u0002\tU$\u0018\u000e\u001c\u0006\u0002%\u0006!!.\u0019<b\u0013\t!vJ\u0001\u0003MSN$\bC\u0001\u001cW\u0013\t9vH\u0001\u0004TiJLgnZ\u0001\u0005e><8/F\u0001[!\rq5+T\u0001\u000eM>|G/\u001a:Tk6l\u0017M]=\u0016\u0003U\u000bA\u0003\u001d:pOJ,7o]3e!\u0016\u00148-\u001a8uC\u001e,W#A0\u0011\u0005\u0001\u0002\u0017BA1\"\u0005\u0019!u.\u001e2mK\u0006yQ\r_3dkRLwN\\*uCR,8/F\u0001e!\t)\u0007/D\u0001g\u0015\t9\u0007.\u0001\u0004uQJLg\r\u001e\u0006\u0003S*\f1A\u001d9d\u0015\tYG.A\u0004tKJ4\u0018nY3\u000b\u00055t\u0017\u0001\u00025jm\u0016T!a\\\f\u0002\rMD\u0017\rZ3e\u0013\t\thMA\nU\u0015>\u0014W\t_3dkRLwN\\*uCR,8/A\nhKRt\u0015-\\3XSRD\u0007K]8he\u0016\u001c8\u000f\u0006\u0003ViZ\\\b\"B;\n\u0001\u0004)\u0016!A:\t\u000b]L\u0001\u0019\u0001=\u0002\u0011\r|W\u000e\u001d7fi\u0016\u0004\"\u0001I=\n\u0005i\f#aA%oi\")A0\u0003a\u0001q\u0006)Ao\u001c;bY\u0006\u0011r-\u001a;D_6\u0004H.\u001a;fIN#\u0018mZ3t+\u0005A\u0018\u0001\u0006+sS:|\u0007K]8he\u0016\u001c8/T8oSR|'\u000f\u0005\u00022\u0019M\u0011Ab\b\u000b\u0003\u0003\u0003\tq\u0001S#B\t\u0016\u00136+\u0001\u0005I\u000b\u0006#UIU*!\u00039\u0019u\nT+N\u001d~\u000btlV%E)\"\u000bqbQ(M+6su,M0X\u0013\u0012#\u0006\n\t")
public class TrinoProgressMonitor {
    private Map<TrinoStage, TrinoStageProgress> progressMap;
    private final StatementClient trino;
    private volatile boolean bitmap$0;

    private Map<TrinoStage, TrinoStageProgress> progressMap$lzycompute() {
        TrinoProgressMonitor trinoProgressMonitor = this;
        synchronized (trinoProgressMonitor) {
            if (!this.bitmap$0) {
                Map map;
                if (this.trino != null) {
                    StatementStats trinoStats = this.trino.getStats();
                    Queue stageQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
                    ListBuffer stages = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    StageStats rootStage = trinoStats.getRootStage();
                    if (rootStage != null) {
                        stageQueue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StageStats[]{rootStage}));
                    }
                    while (stageQueue.nonEmpty()) {
                        StageStats stage = (StageStats)stageQueue.dequeue();
                        String stageId = stage.getStageId();
                        TrinoStageProgress stageProgress = new TrinoStageProgress(stage.getState(), stage.getTotalSplits(), stage.getCompletedSplits(), stage.getRunningSplits(), stage.getFailedTasks());
                        stages.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TrinoStage(stageId), (Object)stageProgress)}));
                        Buffer subStages = JavaConverters$.MODULE$.asScalaBuffer(stage.getSubStages());
                        stageQueue.$plus$plus$eq((TraversableOnce)subStages.toSeq());
                    }
                    map = (Map)SortedMap$.MODULE$.apply(stages.toSeq(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                } else {
                    map = (Map)SortedMap$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                }
                this.progressMap = map;
                this.bitmap$0 = true;
            }
        }
        return this.progressMap;
    }

    private Map<TrinoStage, TrinoStageProgress> progressMap() {
        if (!this.bitmap$0) {
            return this.progressMap$lzycompute();
        }
        return this.progressMap;
    }

    public List<String> headers() {
        return TrinoProgressMonitor$.MODULE$.org$apache$kyuubi$engine$trino$TrinoProgressMonitor$$HEADERS();
    }

    public List<List<String>> rows() {
        Collection progressRows = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableOnce)this.progressMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TrinoStage stage = (TrinoStage)tuple2._1();
                TrinoStageProgress progress = (TrinoStageProgress)tuple2._2();
                int complete = progress.completedSplits();
                int total = progress.totalSplits();
                int running = progress.runningSplits();
                int failed = progress.failedTasks();
                String stageName = new StringBuilder(6).append("Stage-").append(stage.stageId()).toString();
                String nameWithProgress = this.getNameWithProgress(stageName, complete, total);
                int pending = total - complete - running;
                return Arrays.asList((Object[])new String[]{nameWithProgress, progress.state(), String.valueOf(total), String.valueOf(complete), String.valueOf(running), String.valueOf(pending), String.valueOf(failed), ""});
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJavaCollection();
        return new ArrayList<List<String>>(progressRows);
    }

    public String footerSummary() {
        return new StringOps(Predef$.MODULE$.augmentString("STAGES: %02d/%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.getCompletedStages()), BoxesRunTime.boxToInteger((int)this.progressMap().keySet().size())}));
    }

    public double progressedPercentage() {
        if (this.trino != null && this.trino.getStats() != null) {
            OptionalDouble progressPercentage = this.trino.getStats().getProgressPercentage();
            return progressPercentage.orElse(0.0);
        }
        return 0.0;
    }

    public TJobExecutionStatus executionStatus() {
        if (this.getCompletedStages() == this.progressMap().keySet().size()) {
            return TJobExecutionStatus.COMPLETE;
        }
        return TJobExecutionStatus.IN_PROGRESS;
    }

    private String getNameWithProgress(String s, int complete, int total) {
        if (s == null) {
            return "";
        }
        float percent = total == 0 ? 1.0f : (float)complete / (float)total;
        int spaceRemaining = TrinoProgressMonitor$.MODULE$.org$apache$kyuubi$engine$trino$TrinoProgressMonitor$$COLUMN_1_WIDTH() - s.length() - 1;
        String trimmedVName = s;
        if (s.length() > TrinoProgressMonitor$.MODULE$.org$apache$kyuubi$engine$trino$TrinoProgressMonitor$$COLUMN_1_WIDTH()) {
            trimmedVName = s.substring(0, TrinoProgressMonitor$.MODULE$.org$apache$kyuubi$engine$trino$TrinoProgressMonitor$$COLUMN_1_WIDTH() - 2);
            trimmedVName = new StringBuilder(2).append(trimmedVName).append("..").toString();
        } else {
            trimmedVName = new StringBuilder(1).append(trimmedVName).append(" ").toString();
        }
        int toFill = (int)((float)spaceRemaining * percent);
        return new StringBuilder(0).append(trimmedVName).append(new StringOps(Predef$.MODULE$.augmentString(".")).$times(toFill)).toString();
    }

    private int getCompletedStages() {
        IntRef completed = IntRef.create((int)0);
        this.progressMap().values().foreach((Function1 & Serializable & scala.Serializable)progress -> {
            TrinoProgressMonitor.$anonfun$getCompletedStages$1(completed, progress);
            return BoxedUnit.UNIT;
        });
        return completed.elem;
    }

    public static final /* synthetic */ void $anonfun$getCompletedStages$1(IntRef completed$1, TrinoStageProgress progress) {
        int complete = progress.completedSplits();
        int total = progress.totalSplits();
        if (total > 0 && complete == total) {
            ++completed$1.elem;
            return;
        }
    }

    public TrinoProgressMonitor(StatementClient trino) {
        this.trino = trino;
    }
}

