/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.EvictingQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.ApplicationManagerInfo$;
import org.apache.kyuubi.engine.KyuubiApplicationManager$;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.flink.FlinkProcessBuilder$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.command.CommandLineUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tEc\u0001B\u001d;\u0001\u0015C\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t%\u0016\u0005\tC\u0002\u0011\t\u0011)A\u0005-\"A!\r\u0001BC\u0002\u0013\u00053\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003e\u0011!A\u0007A!b\u0001\n\u0003J\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u0011E\u0004!Q1A\u0005\u0002UC\u0001B\u001d\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\tg\u0002\u0011)\u0019!C\u0001i\"I\u0011\u0011\u0001\u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003+A\u0001\"a\u000e\u0001\u0005\u0004%\t!\u0016\u0005\b\u0003s\u0001\u0001\u0015!\u0003W\u0011!\tY\u0004\u0001b\u0001\n\u0003)\u0006bBA\u001f\u0001\u0001\u0006IA\u0016\u0005\n\u0003\u007f\u0001!\u0019!C\u0001\u0003\u0003B\u0001\"!\u0012\u0001A\u0003%\u00111\t\u0005\n\u0003\u000f\u0002\u0001R1A\u0005\n\rDa!!\u0013\u0001\t#*\u0006BBA&\u0001\u0011ES\u000bC\u0004\u0002N\u0001!\t%a\u0014\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u00111\f\u0001\u0005B\u0005u\u0003\"CA3\u0001\t\u0007I\u0011KA4\u0011!\tY\b\u0001Q\u0001\n\u0005%\u0004bCA?\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u007fB1\"!&\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0018\"Y\u00111\u0015\u0001A\u0002\u0003\u0005\u000b\u0015BAA\u0011\u001d\ti\u000b\u0001C\u0005\u0003_Cq!!/\u0001\t\u0003\nY\f\u0003\u0004\u0002B\u0002!\t%V\u0004\b\u0003\u0007T\u0004\u0012AAc\r\u0019I$\b#\u0001\u0002H\"9\u00111\u0001\u0012\u0005\u0002\u0005%\u0007\"CAfE\t\u0007IQAAg\u0011!\t\u0019N\tQ\u0001\u000e\u0005=\u0007\"CAkE\t\u0007IQAAg\u0011!\t9N\tQ\u0001\u000e\u0005=\u0007\"CAmE\t\u0007IQAAn\u0011!\t\u0019O\tQ\u0001\u000e\u0005u\u0007\"CAsE\t\u0007IQAAt\u0011!\tyO\tQ\u0001\u000e\u0005%\b\"CAyE\t\u0007IQAAz\u0011!\tYP\tQ\u0001\u000e\u0005U\b\"CA\u007fE\t\u0007IQAA\u0000\u0011!\u00119A\tQ\u0001\u000e\t\u0005\u0001\"\u0003B\u0005E\t\u0007IQ\u0001B\u0006\u0011!\u0011\u0019B\tQ\u0001\u000e\t5\u0001\"\u0003B\u000bE\t\u0007IQ\u0001B\f\u0011!\u0011yB\tQ\u0001\u000e\te\u0001\"\u0003B\u0011E\t\u0007IQ\u0001B\u0012\u0011!\u0011YC\tQ\u0001\u000e\t\u0015\u0002\"\u0003B\u0017E\t\u0007IQ\u0001B\u0018\u0011!\u00119D\tQ\u0001\u000e\tE\u0002\"\u0003B\u001dEE\u0005I\u0011\u0001B\u001e\u0005M1E.\u001b8l!J|7-Z:t\u0005VLG\u000eZ3s\u0015\tYD(A\u0003gY&t7N\u0003\u0002>}\u00051QM\\4j]\u0016T!a\u0010!\u0002\r-LX/\u001e2j\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\u0004\u0001M!\u0001A\u0012'Q!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u0019\te.\u001f*fMB\u0011QJT\u0007\u0002y%\u0011q\n\u0010\u0002\f!J|7MQ;jY\u0012,'\u000f\u0005\u0002R%6\ta(\u0003\u0002T}\t9Aj\\4hS:<\u0017!\u00039s_bLXk]3s+\u00051\u0006CA,_\u001d\tAF\f\u0005\u0002Z\u00116\t!L\u0003\u0002\\\t\u00061AH]8pizJ!!\u0018%\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;\"\u000b!\u0002\u001d:pqf,6/\u001a:!\u0003-!w.Q:F]\u0006\u0014G.\u001a3\u0016\u0003\u0011\u0004\"aR3\n\u0005\u0019D%a\u0002\"p_2,\u0017M\\\u0001\rI>\f5/\u00128bE2,G\rI\u0001\u0005G>tg-F\u0001k!\tYg.D\u0001m\u0015\tig(\u0001\u0004d_:4\u0017nZ\u0005\u0003_2\u0014!bS=vk\nL7i\u001c8g\u0003\u0015\u0019wN\u001c4!\u0003-)gnZ5oKJ+g-\u00133\u0002\u0019\u0015tw-\u001b8f%\u00164\u0017\n\u001a\u0011\u0002\u001d\u0015DHO]1F]\u001eLg.\u001a'pOV\tQ\u000fE\u0002HmbL!a\u001e%\u0003\r=\u0003H/[8o!\tIh0D\u0001{\u0015\tYH0A\u0002m_\u001eT!!  \u0002\u0013=\u0004XM]1uS>t\u0017BA@{\u00051y\u0005/\u001a:bi&|g\u000eT8h\u0003=)\u0007\u0010\u001e:b\u000b:<\u0017N\\3M_\u001e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0007\u0002\b\u0005-\u0011QBA\b\u0003#\t\u0019\u0002E\u0002\u0002\n\u0001i\u0011A\u000f\u0005\u0006).\u0001\rA\u0016\u0005\u0006E.\u0001\r\u0001\u001a\u0005\u0006Q.\u0001\rA\u001b\u0005\u0006c.\u0001\rA\u0016\u0005\bg.\u0001\n\u00111\u0001v)!\t9!a\u0006\u0002\u001a\u0005m\u0001\"\u0002+\r\u0001\u00041\u0006\"\u00022\r\u0001\u0004!\u0007\"\u00025\r\u0001\u0004Q\u0007f\u0001\u0007\u0002 A!\u0011\u0011EA\u001a\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012aC1o]>$\u0018\r^5p]NTA!!\u000b\u0002,\u000511m\\7n_:TA!!\f\u00020\u00051qm\\8hY\u0016T!!!\r\u0002\u0007\r|W.\u0003\u0003\u00026\u0005\r\"!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\u0006Ia\r\\5oW\"{W.Z\u0001\u000bM2Lgn\u001b%p[\u0016\u0004\u0013a\u00044mS:\\W\t_3dkR\f'\r\\3\u0002!\u0019d\u0017N\\6Fq\u0016\u001cW\u000f^1cY\u0016\u0004\u0013aD3yK\u000e,H/[8o)\u0006\u0014x-\u001a;\u0016\u0005\u0005\r\u0003cA$w-\u0006\u0001R\r_3dkRLwN\u001c+be\u001e,G\u000fI\u0001\u0010aJ|\u00070_+tKJ,e.\u00192mK\u00061Qn\u001c3vY\u0016\f\u0011\"\\1j]\u000ec\u0017m]:\u0002\u0007\u0015tg/\u0006\u0002\u0002RA)q+a\u0015W-&\u0019\u0011Q\u000b1\u0003\u00075\u000b\u0007/\u0001\bdYV\u001cH/\u001a:NC:\fw-\u001a:\u0015\u0005\u0005\r\u0013AC1qa6;'/\u00138g_R\u0011\u0011q\f\t\u0004\u001b\u0006\u0005\u0014bAA2y\t1\u0012\t\u001d9mS\u000e\fG/[8o\u001b\u0006t\u0017mZ3s\u0013:4w.\u0001\u0005d_6l\u0017M\u001c3t+\t\tI\u0007E\u0003\u0002l\u0005UdK\u0004\u0003\u0002n\u0005EdbA-\u0002p%\t\u0011*C\u0002\u0002t!\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002x\u0005e$\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005M\u0004*A\u0005d_6l\u0017M\u001c3tA\u0005aAo\\6f]R+W\u000e\u001d#jeV\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000b\t*\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003\u00111\u0017\u000e\\3\u000b\t\u0005-\u0015QR\u0001\u0004]&|'BAAH\u0003\u0011Q\u0017M^1\n\t\u0005M\u0015Q\u0011\u0002\u0005!\u0006$\b.\u0001\tu_.,g\u000eV3na\u0012K'o\u0018\u0013fcR!\u0011\u0011TAP!\r9\u00151T\u0005\u0004\u0003;C%\u0001B+oSRD\u0011\"!)\u001d\u0003\u0003\u0005\r!!!\u0002\u0007a$\u0013'A\u0007u_.,g\u000eV3na\u0012K'\u000f\t\u0015\u0004;\u0005\u001d\u0006cA$\u0002*&\u0019\u00111\u0016%\u0003\u0011Y|G.\u0019;jY\u0016\f\u0011cZ3oKJ\fG/\u001a+pW\u0016tg)\u001b7f)\t\t\t\f\u0005\u0003Hm\u0006M\u0006#B$\u00026Z3\u0016bAA\\\u0011\n1A+\u001e9mKJ\nQa\u00197pg\u0016$B!!'\u0002>\"1\u0011qX\u0010A\u0002\u0011\fa\u0002Z3tiJ|\u0017\u0010\u0015:pG\u0016\u001c8/A\u0005tQ>\u0014HOT1nK\u0006\u0019b\t\\5oWB\u0013xnY3tg\n+\u0018\u000e\u001c3feB\u0019\u0011\u0011\u0002\u0012\u0014\u0005\t2ECAAc\u0003=1E*\u0013(L?\u0016CViQ0G\u00132+UCAAh\u001f\t\t\t.I\u0001<\u0003A1E*\u0013(L?\u0016CViQ0G\u00132+\u0005%A\tG\u0019&s5jX\"P\u001d\u001a{\u0006KU#G\u0013b\u000b!C\u0012'J\u001d.{6i\u0014(G?B\u0013VIR%YA\u00059\u0011\t\u0015)`\u0017\u0016KVCAAo\u001f\t\ty.\t\u0002\u0002b\u0006qa\r\\5oW:\n\u0007\u000f\u001d\u0018oC6,\u0017\u0001C!Q!~[U)\u0017\u0011\u0002\u0019e\u000b%KT0U\u0003\u001e{6*R-\u0016\u0005\u0005%xBAAvC\t\ti/A\u0005zCJtg\u0006^1hg\u0006i\u0011,\u0011*O?R\u000buiX&F3\u0002\n1#W!S\u001d~\u001b\u0006*\u0013)`\r&cUiU0L\u000bf+\"!!>\u0010\u0005\u0005]\u0018EAA}\u0003=I\u0018M\u001d8/g\"L\u0007/\f4jY\u0016\u001c\u0018\u0001F-B%:{6\u000bS%Q?\u001aKE*R*`\u0017\u0016K\u0006%A\rZ\u0003Jsu,\u0011)Q\u0019&\u001b\u0015\tV%P\u001d~s\u0015)T#`\u0017\u0016KVC\u0001B\u0001\u001f\t\u0011\u0019!\t\u0002\u0003\u0006\u0005)\u00120\u0019:o]\u0005\u0004\b\u000f\\5dCRLwN\u001c\u0018oC6,\u0017AG-B%:{\u0016\t\u0015)M\u0013\u000e\u000bE+S(O?:\u000bU*R0L\u000bf\u0003\u0013A\u0007$M\u0013:[u\fS!E\u001f>\u0003vl\u0011'B'N\u0003\u0016\t\u0016%`\u0017\u0016KVC\u0001B\u0007\u001f\t\u0011y!\t\u0002\u0003\u0012\u00051b\tT%O\u0017~C\u0015\tR(P!~\u001bE*Q*T!\u0006#\u0006*A\u000eG\u0019&s5j\u0018%B\t>{\u0005kX\"M\u0003N\u001b\u0006+\u0011+I?.+\u0015\fI\u0001\u0015\r2KejS0Q%>C\u0016lX+T\u000bJ{6*R-\u0016\u0005\teqB\u0001B\u000eC\t\u0011i\"A\tI\u0003\u0012{u\nU0Q%>C\u0016lX+T\u000bJ\u000bQC\u0012'J\u001d.{\u0006KU(Y3~+6+\u0012*`\u0017\u0016K\u0006%A\rG\u0019&s5jX*F\u0007V\u0013\u0016\nV-`\u0017\u0016KF+\u0011\"`\u0017\u0016KVC\u0001B\u0013\u001f\t\u00119#\t\u0002\u0003*\u0005q2/Z2ve&$\u0018PL6fe\n,'o\\:/Y><\u0017N\u001c\u0018lKf$\u0018MY\u0001\u001b\r2KejS0T\u000b\u000e+&+\u0013+Z?.+\u0015\fV!C?.+\u0015\fI\u0001\u001d\r2KejS0T\u000b\u000e+&+\u0013+Z?B\u0013\u0016JT\"J!\u0006culS#Z+\t\u0011\td\u0004\u0002\u00034\u0005\u0012!QG\u0001\"g\u0016\u001cWO]5us:ZWM\u001d2fe>\u001ch\u0006\\8hS:t\u0003O]5oG&\u0004\u0018\r\\\u0001\u001e\r2KejS0T\u000b\u000e+&+\u0013+Z?B\u0013\u0016JT\"J!\u0006culS#ZA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"A!\u0010+\u0007U\u0014yd\u000b\u0002\u0003BA!!1\tB'\u001b\t\u0011)E\u0003\u0003\u0003H\t%\u0013!C;oG\",7m[3e\u0015\r\u0011Y\u0005S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B(\u0005\u000b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class FlinkProcessBuilder
implements ProcBuilder,
Logging {
    private boolean proxyUserEnable;
    private final String proxyUser;
    private final boolean doAsEnabled;
    private final KyuubiConf conf;
    private final String engineRefId;
    private final Option<OperationLog> extraEngineLog;
    private final String flinkHome;
    private final String flinkExecutable;
    private final Option<String> executionTarget;
    private final Iterable<String> commands;
    private volatile java.nio.file.Path tokenTempDir;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private final String engineScalaBinaryVersion;
    private final java.nio.file.Path workingDir;
    private ProcessBuilder processBuilder;
    private volatile Throwable org$apache$kyuubi$engine$ProcBuilder$$error;
    private final int org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines;
    private final long org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout;
    private final EvictingQueue<String> lastRowsOfLog;
    private volatile boolean logCaptureThreadReleased;
    private Thread org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread;
    private volatile Process process;
    private volatile boolean processLaunched;
    private File engineLog;
    private FileFilter engineHomeDirFilter;
    private volatile byte bitmap$0;

    public static Option<OperationLog> $lessinit$greater$default$5() {
        return FlinkProcessBuilder$.MODULE$.$lessinit$greater$default$5();
    }

    public static String FLINK_SECURITY_PRINCIPAL_KEY() {
        return FlinkProcessBuilder$.MODULE$.FLINK_SECURITY_PRINCIPAL_KEY();
    }

    public static String FLINK_SECURITY_KEYTAB_KEY() {
        return FlinkProcessBuilder$.MODULE$.FLINK_SECURITY_KEYTAB_KEY();
    }

    public static String FLINK_PROXY_USER_KEY() {
        return FlinkProcessBuilder$.MODULE$.FLINK_PROXY_USER_KEY();
    }

    public static String FLINK_HADOOP_CLASSPATH_KEY() {
        return FlinkProcessBuilder$.MODULE$.FLINK_HADOOP_CLASSPATH_KEY();
    }

    public static String YARN_APPLICATION_NAME_KEY() {
        return FlinkProcessBuilder$.MODULE$.YARN_APPLICATION_NAME_KEY();
    }

    public static String YARN_SHIP_FILES_KEY() {
        return FlinkProcessBuilder$.MODULE$.YARN_SHIP_FILES_KEY();
    }

    public static String YARN_TAG_KEY() {
        return FlinkProcessBuilder$.MODULE$.YARN_TAG_KEY();
    }

    public static String APP_KEY() {
        return FlinkProcessBuilder$.MODULE$.APP_KEY();
    }

    public static String FLINK_CONF_PREFIX() {
        return FlinkProcessBuilder$.MODULE$.FLINK_CONF_PREFIX();
    }

    public static String FLINK_EXEC_FILE() {
        return FlinkProcessBuilder$.MODULE$.FLINK_EXEC_FILE();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public /* synthetic */ String org$apache$kyuubi$engine$ProcBuilder$$super$toString() {
        return super.toString();
    }

    @Override
    public String executable() {
        return ProcBuilder.executable$(this);
    }

    @Override
    public Option<String> mainResource() {
        return ProcBuilder.mainResource$(this);
    }

    @Override
    public void completeMasterUrl(KyuubiConf conf) {
        ProcBuilder.completeMasterUrl$(this, conf);
    }

    @Override
    public void validateConf() {
        ProcBuilder.validateConf$(this);
    }

    @Override
    public final Process start() {
        return ProcBuilder.start$(this);
    }

    @Override
    public boolean isClusterMode() {
        return ProcBuilder.isClusterMode$(this);
    }

    @Override
    public Throwable getError() {
        return ProcBuilder.getError$(this);
    }

    @Override
    public String toString() {
        return ProcBuilder.toString$(this);
    }

    @Override
    public String getEngineHome(String shortName) {
        return ProcBuilder.getEngineHome$(this, shortName);
    }

    @Override
    public Throwable validateEnv(String requiredEnv) {
        return ProcBuilder.validateEnv$(this, requiredEnv);
    }

    @Override
    public boolean waitEngineCompletion() {
        return ProcBuilder.waitEngineCompletion$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public String engineScalaBinaryVersion() {
        return this.engineScalaBinaryVersion;
    }

    @Override
    public java.nio.file.Path workingDir() {
        return this.workingDir;
    }

    private ProcessBuilder processBuilder$lzycompute() {
        FlinkProcessBuilder flinkProcessBuilder = this;
        synchronized (flinkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.processBuilder = ProcBuilder.processBuilder$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.processBuilder;
    }

    @Override
    public final ProcessBuilder processBuilder() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.processBuilder$lzycompute();
        }
        return this.processBuilder;
    }

    @Override
    public Throwable org$apache$kyuubi$engine$ProcBuilder$$error() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$error;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$$error_$eq(Throwable x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$error = x$1;
    }

    @Override
    public int org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines;
    }

    @Override
    public long org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout;
    }

    @Override
    public EvictingQueue<String> lastRowsOfLog() {
        return this.lastRowsOfLog;
    }

    @Override
    public boolean logCaptureThreadReleased() {
        return this.logCaptureThreadReleased;
    }

    @Override
    public void logCaptureThreadReleased_$eq(boolean x$1) {
        this.logCaptureThreadReleased = x$1;
    }

    @Override
    public Thread org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread_$eq(Thread x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread = x$1;
    }

    @Override
    public Process process() {
        return this.process;
    }

    @Override
    public void process_$eq(Process x$1) {
        this.process = x$1;
    }

    @Override
    public boolean processLaunched() {
        return this.processLaunched;
    }

    @Override
    public void processLaunched_$eq(boolean x$1) {
        this.processLaunched = x$1;
    }

    private File engineLog$lzycompute() {
        FlinkProcessBuilder flinkProcessBuilder = this;
        synchronized (flinkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.engineLog = ProcBuilder.engineLog$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.engineLog;
    }

    @Override
    public File engineLog() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.engineLog$lzycompute();
        }
        return this.engineLog;
    }

    private FileFilter engineHomeDirFilter$lzycompute() {
        FlinkProcessBuilder flinkProcessBuilder = this;
        synchronized (flinkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.engineHomeDirFilter = ProcBuilder.engineHomeDirFilter$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.engineHomeDirFilter;
    }

    @Override
    public FileFilter engineHomeDirFilter() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.engineHomeDirFilter$lzycompute();
        }
        return this.engineHomeDirFilter;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$_setter_$engineScalaBinaryVersion_$eq(String x$1) {
        this.engineScalaBinaryVersion = x$1;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$_setter_$workingDir_$eq(java.nio.file.Path x$1) {
        this.workingDir = x$1;
    }

    @Override
    public final void org$apache$kyuubi$engine$ProcBuilder$_setter_$org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines_$eq(int x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines = x$1;
    }

    @Override
    public final void org$apache$kyuubi$engine$ProcBuilder$_setter_$org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout_$eq(long x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout = x$1;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$_setter_$lastRowsOfLog_$eq(EvictingQueue<String> x$1) {
        this.lastRowsOfLog = x$1;
    }

    @Override
    public String proxyUser() {
        return this.proxyUser;
    }

    @Override
    public boolean doAsEnabled() {
        return this.doAsEnabled;
    }

    @Override
    public KyuubiConf conf() {
        return this.conf;
    }

    public String engineRefId() {
        return this.engineRefId;
    }

    @Override
    public Option<OperationLog> extraEngineLog() {
        return this.extraEngineLog;
    }

    public String flinkHome() {
        return this.flinkHome;
    }

    public String flinkExecutable() {
        return this.flinkExecutable;
    }

    public Option<String> executionTarget() {
        return this.executionTarget;
    }

    /*
     * WARNING - void declaration
     */
    private boolean proxyUserEnable$lzycompute() {
        FlinkProcessBuilder flinkProcessBuilder = this;
        synchronized (flinkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                boolean flinkDoAsEnabled = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_FLINK_DOAS_ENABLED()));
                if (flinkDoAsEnabled && !UserGroupInformation.isSecurityEnabled()) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append(KyuubiConf$.MODULE$.ENGINE_FLINK_DOAS_ENABLED().key()).append(" can only be enabled on Kerberized environment.").toString());
                    flinkDoAsEnabled = false;
                }
                this.proxyUserEnable = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.proxyUserEnable;
    }

    private boolean proxyUserEnable() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.proxyUserEnable$lzycompute();
        }
        return this.proxyUserEnable;
    }

    @Override
    public String module() {
        return "kyuubi-flink-sql-engine";
    }

    @Override
    public String mainClass() {
        return "org.apache.kyuubi.engine.flink.FlinkSQLEngine";
    }

    @Override
    public Map<String, String> env() {
        String flinkConfDir = (String)this.conf().getEnvs().getOrElse((Object)"FLINK_CONF_DIR", (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(4).append(this.flinkHome()).append(File.separator).append("conf").toString());
        Map flinkExtraEnvs = this.proxyUserEnable() ? ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FLINK_CONF_DIR"), (Object)flinkConfDir), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HADOOP_PROXY_USER"), (Object)this.proxyUser())}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.generateTokenFile())) : (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FLINK_CONF_DIR"), (Object)flinkConfDir)}));
        return this.conf().getEnvs().$plus$plus((GenTraversableOnce)flinkExtraEnvs);
    }

    @Override
    public Option<String> clusterManager() {
        Some some;
        String string;
        Option<String> option = this.executionTarget();
        if (option instanceof Some && "yarn-application".equals(string = (String)(some = (Some)option).value())) {
            return new Some((Object)"yarn");
        }
        return None$.MODULE$;
    }

    @Override
    public ApplicationManagerInfo appMgrInfo() {
        return new ApplicationManagerInfo(this.clusterManager(), ApplicationManagerInfo$.MODULE$.apply$default$2());
    }

    @Override
    public Iterable<String> commands() {
        return this.commands;
    }

    private java.nio.file.Path tokenTempDir() {
        return this.tokenTempDir;
    }

    private void tokenTempDir_$eq(java.nio.file.Path x$1) {
        this.tokenTempDir = x$1;
    }

    private Option<Tuple2<String, String>> generateTokenFile() {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_FLINK_DOAS_GENERATE_TOKEN_FILE()))) {
            return this.conf().getOption("kyuubi.engine.credentials").map((Function1 & Serializable & scala.Serializable)encodedCredentials -> {
                Credentials credentials = KyuubiHadoopUtils$.MODULE$.decodeCredentials(encodedCredentials);
                this.tokenTempDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
                String file = new StringBuilder(20).append(((Object)this.tokenTempDir()).toString()).append("/kyuubi_credentials_").append(System.currentTimeMillis()).toString();
                credentials.writeTokenStorageFile(new Path(new StringBuilder(7).append("file://").append(file).toString()), new Configuration());
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Generated hadoop token file: ").append(file).toString());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HADOOP_TOKEN_FILE_LOCATION"), (Object)file);
            });
        }
        return None$.MODULE$;
    }

    @Override
    public void close(boolean destroyProcess) {
        ProcBuilder.close$(this, destroyProcess);
        if (this.tokenTempDir() != null) {
            try {
                Utils$.MODULE$.deleteDirectoryRecursively(this.tokenTempDir().toFile(), Utils$.MODULE$.deleteDirectoryRecursively$default$2());
            }
            catch (Throwable e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Error deleting token temp dir: ").append(this.tokenTempDir()).toString(), e);
            }
            return;
        }
    }

    @Override
    public String shortName() {
        return "flink";
    }

    public static final /* synthetic */ boolean $anonfun$commands$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !((SeqLike)new .colon.colon((Object)"app.name", (List)new .colon.colon((Object)"yarn.ship-files", (List)new .colon.colon((Object)"yarn.application.name", (List)new .colon.colon((Object)"yarn.tags", (List)Nil$.MODULE$))))).contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$commands$8(Tuple2 x$2) {
        return ((String)x$2._1()).startsWith("kyuubi.");
    }

    public static final /* synthetic */ boolean $anonfun$commands$9(String x$3) {
        return StringUtils.isNotBlank((CharSequence)x$3);
    }

    public static final /* synthetic */ boolean $anonfun$commands$21(FlinkProcessBuilder $this, LinkedHashSet classpathEntries$1, String path) {
        java.nio.file.Path devHadoopJars = Paths.get(path, new String[0]).getParent().resolve(new StringBuilder(6).append("scala-").append(package$.MODULE$.SCALA_COMPILE_VERSION()).toString()).resolve("jars");
        if (!Files.exists(devHadoopJars, new LinkOption[0])) {
            throw new KyuubiException(new StringBuilder(240).append("The path ").append(devHadoopJars).append(" does not exist. Please set ").append("FLINK_HADOOP_CLASSPATH").append(" or ").append(KyuubiConf$.MODULE$.ENGINE_FLINK_EXTRA_CLASSPATH().key()).append(" ").append("to configure the location of Hadoop client jars. Alternatively,").append("you can place the required hadoop-client or flink-shaded-hadoop jars ").append("directly into the Flink lib directory: ").append($this.flinkHome()).append("/lib.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        return classpathEntries$1.add((Object)new StringBuilder(1).append(devHadoopJars).append(File.separator).append("*").toString());
    }

    public FlinkProcessBuilder(String proxyUser, boolean doAsEnabled, KyuubiConf conf, String engineRefId, Option<OperationLog> extraEngineLog) {
        ListBuffer listBuffer;
        Some some;
        String string;
        this.proxyUser = proxyUser;
        this.doAsEnabled = doAsEnabled;
        this.conf = conf;
        this.engineRefId = engineRefId;
        this.extraEngineLog = extraEngineLog;
        ProcBuilder.$init$(this);
        Logging.$init$((Logging)this);
        this.flinkHome = this.getEngineHome(this.shortName());
        this.flinkExecutable = Paths.get(this.flinkHome(), "bin", "flink").toFile().getCanonicalPath();
        this.executionTarget = conf.getOption("flink.execution.target");
        KyuubiApplicationManager$.MODULE$.tagApplication(engineRefId, this.shortName(), this.clusterManager(), conf);
        Option<String> option = this.executionTarget();
        if (option instanceof Some && "yarn-application".equals(string = (String)(some = (Some)option).value())) {
            ListBuffer buffer = new ListBuffer();
            buffer.$plus$eq((Object)this.flinkExecutable());
            buffer.$plus$eq((Object)"run-application");
            ListBuffer flinkExtraJars = new ListBuffer();
            String[] flinkSqlJars = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Paths.get(this.flinkHome(), new String[0]).resolve("opt").toFile().listFiles(new FilenameFilter(null){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().startsWith("flink-sql-client") || name.toLowerCase().startsWith("flink-sql-gateway");
                }
            }))).map((Function1 & Serializable & scala.Serializable)f -> f.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$);
            flinkExtraJars.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])flinkSqlJars)));
            Option userJars = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_FLINK_APPLICATION_JARS());
            userJars.foreach((Function1 & Serializable & scala.Serializable)jars -> flinkExtraJars.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jars.split(",")))));
            Option hiveConfDirOpt = this.env().get((Object)"HIVE_CONF_DIR");
            hiveConfDirOpt.foreach((Function1 & Serializable & scala.Serializable)hiveConfDir -> {
                java.nio.file.Path hiveConfFile = Paths.get(hiveConfDir, new String[0]).resolve("hive-site.xml");
                if (!Files.exists(hiveConfFile, new LinkOption[0])) {
                    throw new KyuubiException(new StringBuilder(90).append("The file ").append(hiveConfFile).append(" does not exists. ").append("Please put hive-site.xml when HIVE_CONF_DIR env ").append((String)hiveConfDir).append(" is configured.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
                return flinkExtraJars.$plus$eq((Object)String.valueOf(hiveConfFile));
            });
            Map externalProxyUserConf = this.proxyUserEnable() ? (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"security.module.factory.classes"), (Object)"org.apache.flink.runtime.security.modules.JaasModuleFactory;org.apache.flink.runtime.security.modules.ZookeeperModuleFactory"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"security.delegation.token.provider.hadoopfs.enabled"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"security.delegation.token.provider.hbase.enabled"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"security.delegation.token.provider.HiveServer2.enabled"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yarn.security.appmaster.delegation.token.services"), (Object)"kyuubi")})) : Predef$.MODULE$.Map().empty();
            Map customFlinkConf = conf.getAllWithPrefix("flink", "").$plus$plus((GenTraversableOnce)externalProxyUserConf);
            flinkExtraJars.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(customFlinkConf.get((Object)"yarn.ship-files")));
            Option yarnAppName = customFlinkConf.get((Object)"yarn.application.name").orElse((Function0 & Serializable & scala.Serializable)() -> this.conf().getOption("flink.app.name"));
            buffer.$plus$eq((Object)"-t");
            buffer.$plus$eq((Object)"yarn-application");
            buffer.$plus$eq((Object)new StringBuilder(18).append("-Dyarn.ship-files=").append(flinkExtraJars.mkString(";")).toString());
            buffer.$plus$eq((Object)new StringBuilder(24).append("-Dyarn.application.name=").append(yarnAppName.get()).toString());
            buffer.$plus$eq((Object)new StringBuilder(12).append("-Dyarn.tags=").append(conf.getOption("yarn.tags").get()).toString());
            buffer.$plus$eq((Object)"-Dcontainerized.master.env.FLINK_CONF_DIR=.");
            hiveConfDirOpt.foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer.$plus$eq((Object)"-Dcontainerized.master.env.HIVE_CONF_DIR=."));
            ((IterableLike)customFlinkConf.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkProcessBuilder.$anonfun$commands$6(x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return buffer.$plus$eq((Object)new StringBuilder(3).append("-D").append(k).append("=").append(v).toString());
                }
                throw new MatchError((Object)tuple2);
            });
            buffer.$plus$eq((Object)"-c");
            buffer.$plus$eq((Object)String.valueOf(this.mainClass()));
            buffer.$plus$eq((Object)String.valueOf(this.mainResource().get()));
            buffer.$plus$plus$eq((TraversableOnce)CommandLineUtils$.MODULE$.confKeyValue("kyuubi.session.user", proxyUser, CommandLineUtils$.MODULE$.confKeyValue$default$3()));
            buffer.$plus$plus$eq((TraversableOnce)CommandLineUtils$.MODULE$.confKeyValues((Iterable)conf.getAll().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FlinkProcessBuilder.$anonfun$commands$8(x$2)))));
            listBuffer = buffer;
        } else {
            boolean hasHadoopJar;
            ListBuffer buffer = new ListBuffer();
            buffer.$plus$eq((Object)this.executable());
            String memory = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_FLINK_MEMORY());
            buffer.$plus$eq((Object)new StringBuilder(4).append("-Xmx").append(memory).toString());
            Option javaOptions = ((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_FLINK_JAVA_OPTIONS())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FlinkProcessBuilder.$anonfun$commands$9(x$3)));
            Object object = javaOptions.isDefined() ? buffer.$plus$plus$eq((TraversableOnce)CommandLineUtils$.MODULE$.parseOptionString((String)javaOptions.get())) : BoxedUnit.UNIT;
            LinkedHashSet classpathEntries = new LinkedHashSet();
            this.mainResource().foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)classpathEntries.add((Object)elem)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Paths.get(this.flinkHome(), new String[0]).resolve("opt").toFile().listFiles(new FilenameFilter(null){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().startsWith("flink-sql-client") || name.toLowerCase().startsWith("flink-sql-gateway");
                }
            }))).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())))).foreach((Function1 & Serializable & scala.Serializable)jar -> BoxesRunTime.boxToBoolean((boolean)classpathEntries.add((Object)jar.getAbsolutePath())));
            classpathEntries.add((Object)new StringBuilder(4).append(this.flinkHome()).append(File.separator).append("lib").append(File.separator).append("*").toString());
            classpathEntries.add(this.env().getOrElse((Object)"FLINK_CONF_DIR", (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(4).append(this.flinkHome()).append(File.separator).append("conf").toString()));
            this.env().get((Object)"HADOOP_CONF_DIR").foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)classpathEntries.add((Object)elem)));
            this.env().get((Object)"YARN_CONF_DIR").foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)classpathEntries.add((Object)elem)));
            this.env().get((Object)"HBASE_CONF_DIR").foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)classpathEntries.add((Object)elem)));
            this.env().get((Object)"HIVE_CONF_DIR").foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)classpathEntries.add((Object)elem)));
            Option hadoopCp = this.env().get((Object)"FLINK_HADOOP_CLASSPATH");
            Option extraCp = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_FLINK_EXTRA_CLASSPATH());
            extraCp.foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)classpathEntries.add((Object)elem)));
            File[] files = Paths.get(this.flinkHome(), new String[0]).resolve("lib").toFile().listFiles(new FilenameFilter(null){

                public boolean accept(File dir, String name) {
                    return name.startsWith("hadoop-client") || name.startsWith("flink-shaded-hadoop");
                }
            });
            boolean bl = hasHadoopJar = files != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).nonEmpty();
            if (!hasHadoopJar) {
                hadoopCp.foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)classpathEntries.add((Object)elem)));
            }
            if (!hasHadoopJar && hadoopCp.isEmpty() && extraCp.isEmpty()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("No Hadoop client jars found in ").append(this.flinkHome()).append("/lib, and the conf of ").append("FLINK_HADOOP_CLASSPATH").append(" and ").append(KyuubiConf$.MODULE$.ENGINE_FLINK_EXTRA_CLASSPATH().key()).append(" is empty.").toString());
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Detected development environment.");
                this.mainResource().foreach((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)FlinkProcessBuilder.$anonfun$commands$21(this, classpathEntries, path)));
            }
            buffer.$plus$plus$eq((TraversableOnce)CommandLineUtils$.MODULE$.genClasspathOption((Iterable)classpathEntries));
            buffer.$plus$eq((Object)this.mainClass());
            buffer.$plus$plus$eq((TraversableOnce)CommandLineUtils$.MODULE$.confKeyValue("kyuubi.session.user", proxyUser, CommandLineUtils$.MODULE$.confKeyValue$default$3()));
            buffer.$plus$plus$eq((TraversableOnce)CommandLineUtils$.MODULE$.confKeyValues((Iterable)conf.getAll()));
            listBuffer = buffer;
        }
        this.commands = listBuffer;
    }

    @VisibleForTesting
    public FlinkProcessBuilder(String proxyUser, boolean doAsEnabled, KyuubiConf conf) {
        this(proxyUser, doAsEnabled, conf, "", FlinkProcessBuilder$.MODULE$.$lessinit$greater$default$5());
    }
}

