/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication.ldap;

import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.sasl.AuthenticationException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.ldap.DirSearch;
import org.apache.kyuubi.service.authentication.ldap.DirSearchFactory;
import org.apache.kyuubi.service.authentication.ldap.LdapSearch;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Y4A\u0001B\u0003\u0001%!)\u0011\u0005\u0001C\u0001E!)A\u0005\u0001C!K!)!\r\u0001C\u0005G\n\tB\nZ1q'\u0016\f'o\u00195GC\u000e$xN]=\u000b\u0005\u00199\u0011\u0001\u00027eCBT!\u0001C\u0005\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u0011!bC\u0001\bg\u0016\u0014h/[2f\u0015\taQ\"\u0001\u0004lsV,(-\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0019\u0012$\b\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005iYR\"A\u0003\n\u0005q)!\u0001\u0005#jeN+\u0017M]2i\r\u0006\u001cGo\u001c:z!\tqr$D\u0001\f\u0013\t\u00013BA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u000e\u0001\u0003-9W\r^%ogR\fgnY3\u0015\t\u0019J\u0013G\u0010\t\u00035\u001dJ!\u0001K\u0003\u0003\u0013\u0011K'oU3be\u000eD\u0007\"\u0002\u0016\u0003\u0001\u0004Y\u0013\u0001B2p]\u001a\u0004\"\u0001L\u0018\u000e\u00035R!AL\u0006\u0002\r\r|gNZ5h\u0013\t\u0001TF\u0001\u0006LsV,(-[\"p]\u001aDQA\r\u0002A\u0002M\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\u0005QZdBA\u001b:!\t1T#D\u00018\u0015\tA\u0014#\u0001\u0004=e>|GOP\u0005\u0003uU\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!(\u0006\u0005\u0006\u007f\t\u0001\raM\u0001\ta\u0006\u001c8o^8sI\"\u001a!!\u0011(\u0011\u0007Q\u0011E)\u0003\u0002D+\t1A\u000f\u001b:poN\u0004\"!\u0012'\u000e\u0003\u0019S!a\u0012%\u0002\tM\f7\u000f\u001c\u0006\u0003\u0013*\u000b\u0001b]3dkJLG/\u001f\u0006\u0002\u0017\u0006)!.\u0019<bq&\u0011QJ\u0012\u0002\u0018\u0003V$\b.\u001a8uS\u000e\fG/[8o\u000bb\u001cW\r\u001d;j_:\f4!J(aU\t\u0001v\u000b\u0005\u0002R-6\t!K\u0003\u0002T)\u0006!A.\u00198h\u0015\u0005)\u0016\u0001\u00026bm\u0006L!\u0001\u0010*,\u0003a\u0003\"!\u00170\u000e\u0003iS!a\u0017/\u0002\t5,G/\u0019\u0006\u0003;V\t!\"\u00198o_R\fG/[8o\u0013\ty&L\u0001\u0006eK\u001a\fW\u000f\u001c;Be\u001e\f\u0013!Y\u0001\u0001\u0003A\u0019'/Z1uK\u0012K'oQ8oi\u0016DH\u000f\u0006\u0003eY6t\u0007CA3k\u001b\u00051'BA4i\u0003%!\u0017N]3di>\u0014\u0018P\u0003\u0002j\u0015\u00061a.Y7j]\u001eL!a\u001b4\u0003\u0015\u0011K'oQ8oi\u0016DH\u000fC\u0003+\u0007\u0001\u00071\u0006C\u00033\u0007\u0001\u00071\u0007C\u0003@\u0007\u0001\u00071\u0007K\u0002\u0004aV\u00042\u0001\u0006\"r!\t\u00118/D\u0001i\u0013\t!\bNA\bOC6LgnZ#yG\u0016\u0004H/[8oc\r)s\n\u0019")
public class LdapSearchFactory
implements DirSearchFactory,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public DirSearch getInstance(KyuubiConf conf, String principal, String password) throws AuthenticationException {
        LdapSearch ldapSearch;
        try {
            DirContext ctx = this.createDirContext(conf, principal, password);
            ldapSearch = new LdapSearch(conf, ctx);
        }
        catch (NamingException e) {
            this.debug((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(64).append("Could not connect to the LDAP Server: Authentication failed for ").append(principal).toString());
            throw new AuthenticationException(new StringBuilder(28).append("Error validating LDAP user: ").append(principal).toString(), e);
        }
        return ldapSearch;
    }

    private DirContext createDirContext(KyuubiConf conf, String principal, String password) throws NamingException {
        Option ldapUrl = (Option)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_URL());
        Hashtable<String, String> env = new Hashtable<String, String>();
        ldapUrl.foreach((Function1 & Serializable)x$1 -> env.put("java.naming.provider.url", (String)x$1));
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.credentials", password);
        this.debug((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(44).append("Connecting using principal ").append(principal).append(" to ldap server: ").append(ldapUrl.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString());
        return new InitialDirContext(env);
    }

    public LdapSearchFactory() {
        Logging.$init$(this);
    }
}

