/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.net.bytebuddy.build;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.kyuubi.shade.net.bytebuddy.ByteBuddy;
import org.apache.kyuubi.shade.net.bytebuddy.ClassFileVersion;
import org.apache.kyuubi.shade.net.bytebuddy.asm.Advice;
import org.apache.kyuubi.shade.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.apache.kyuubi.shade.net.bytebuddy.build.Plugin;
import org.apache.kyuubi.shade.net.bytebuddy.description.annotation.AnnotationDescription;
import org.apache.kyuubi.shade.net.bytebuddy.description.field.FieldDescription;
import org.apache.kyuubi.shade.net.bytebuddy.description.field.FieldList;
import org.apache.kyuubi.shade.net.bytebuddy.description.method.MethodDescription;
import org.apache.kyuubi.shade.net.bytebuddy.description.method.MethodList;
import org.apache.kyuubi.shade.net.bytebuddy.description.modifier.FieldPersistence;
import org.apache.kyuubi.shade.net.bytebuddy.description.modifier.Ownership;
import org.apache.kyuubi.shade.net.bytebuddy.description.modifier.SyntheticState;
import org.apache.kyuubi.shade.net.bytebuddy.description.modifier.Visibility;
import org.apache.kyuubi.shade.net.bytebuddy.description.type.TypeDefinition;
import org.apache.kyuubi.shade.net.bytebuddy.description.type.TypeDescription;
import org.apache.kyuubi.shade.net.bytebuddy.dynamic.ClassFileLocator;
import org.apache.kyuubi.shade.net.bytebuddy.dynamic.DynamicType;
import org.apache.kyuubi.shade.net.bytebuddy.dynamic.scaffold.TypeValidation;
import org.apache.kyuubi.shade.net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import org.apache.kyuubi.shade.net.bytebuddy.implementation.Implementation;
import org.apache.kyuubi.shade.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.kyuubi.shade.net.bytebuddy.implementation.bytecode.StackSize;
import org.apache.kyuubi.shade.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.apache.kyuubi.shade.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.kyuubi.shade.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.kyuubi.shade.net.bytebuddy.jar.asm.Label;
import org.apache.kyuubi.shade.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.kyuubi.shade.net.bytebuddy.matcher.ElementMatchers;
import org.apache.kyuubi.shade.net.bytebuddy.utility.RandomString;
import org.apache.kyuubi.shade.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class CachedReturnPlugin
extends Plugin.ForElementMatcher
implements Plugin.Factory {
    private static final String NAME_INFIX = "_";
    private static final MethodDescription.InDefinedShape ENHANCE_VALUE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Enhance.class).getDeclaredMethods().filter(ElementMatchers.named("value"))).getOnly();
    private final boolean ignoreExistingFields;
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
    private final RandomString randomString;

    public CachedReturnPlugin() {
        this(false);
    }

    public CachedReturnPlugin(boolean ignoreExistingFields) {
        super(ElementMatchers.declaresMethod(ElementMatchers.isAnnotatedWith(Enhance.class)));
        this.ignoreExistingFields = ignoreExistingFields;
        this.randomString = new RandomString();
    }

    @Override
    public Plugin make() {
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Annotation presence is required by matcher.")
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        for (MethodDescription.InDefinedShape methodDescription : (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.not(ElementMatchers.isBridge()).and(ElementMatchers.isAnnotatedWith(Enhance.class)))) {
            if (methodDescription.isAbstract()) {
                throw new IllegalStateException("Cannot cache the value of an abstract method: " + methodDescription);
            }
            if (!methodDescription.getParameters().isEmpty()) {
                throw new IllegalStateException("Cannot cache the value of a method with parameters: " + methodDescription);
            }
            if (methodDescription.getReturnType().represents(Void.TYPE)) {
                throw new IllegalStateException("Cannot cache void result for " + methodDescription);
            }
            String name = methodDescription.getDeclaredAnnotations().ofType(Enhance.class).getValue(ENHANCE_VALUE).resolve(String.class);
            if (name.length() == 0) {
                name = methodDescription.getName() + NAME_INFIX + this.randomString.nextString();
            } else if (this.ignoreExistingFields && !((FieldList)typeDescription.getDeclaredFields().filter(ElementMatchers.named(name))).isEmpty()) {
                return builder;
            }
            builder = builder.defineField(name, (TypeDefinition)methodDescription.getReturnType().asErasure(), methodDescription.isStatic() ? Ownership.STATIC : Ownership.MEMBER, methodDescription.isStatic() ? FieldPersistence.PLAIN : FieldPersistence.TRANSIENT, Visibility.PRIVATE, SyntheticState.SYNTHETIC).visit(AdviceResolver.of(methodDescription.getReturnType()).toAdvice(name).on(ElementMatchers.is(methodDescription)));
        }
        return builder;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.ignoreExistingFields == ((CachedReturnPlugin)object).ignoreExistingFields;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.ignoreExistingFields;
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class CacheFieldOffsetMapping
    implements Advice.OffsetMapping {
        private final String name;

        protected CacheFieldOffsetMapping(String name) {
            this.name = name;
        }

        public Advice.OffsetMapping.Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Advice.ArgumentHandler argumentHandler, Advice.OffsetMapping.Sort sort) {
            return new Advice.OffsetMapping.Target.ForField.ReadWrite((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly());
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.name.equals(((CacheFieldOffsetMapping)object).name);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.name.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AdviceResolver {
        BOOLEAN(Boolean.TYPE, 21, 54, 0, 154),
        BYTE(Byte.TYPE, 21, 54, 0, 154),
        SHORT(Short.TYPE, 21, 54, 0, 154),
        CHARACTER(Character.TYPE, 21, 54, 0, 154),
        INTEGER(Integer.TYPE, 21, 54, 0, 154),
        LONG(Long.TYPE, 22, 55, 136, 154),
        FLOAT(Float.TYPE, 23, 56, 139, 154),
        DOUBLE(Double.TYPE, 24, 57, 142, 154),
        REFERENCE(Object.class, 25, 58, 0, 199);

        private final DynamicType dynamicType;

        private AdviceResolver(Class<?> type, int load, int store, int convert, int branch) {
            this.dynamicType = new ByteBuddy(ClassFileVersion.JAVA_V6).with(TypeValidation.DISABLED).subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(CachedReturnPlugin.class.getName() + "$Advice$" + (Object)((Object)this)).defineMethod("enter", type, Ownership.STATIC).withParameter(type).annotateParameter(AnnotationDescription.Builder.ofType(CacheField.class).build()).intercept(new Implementation.Simple(MethodVariableAccess.of(TypeDescription.ForLoadedType.of(type)).loadFrom(0), MethodReturn.of(TypeDescription.ForLoadedType.of(type)))).annotateMethod(AnnotationDescription.Builder.ofType(Advice.OnMethodEnter.class).define("skipOn", Advice.OnNonDefaultValue.class).build()).defineMethod("exit", Void.TYPE, Ownership.STATIC).withParameter(type).annotateParameter(AnnotationDescription.Builder.ofType(Advice.Return.class).define("readOnly", false).define("typing", Assigner.Typing.DYNAMIC).build()).withParameter(type).annotateParameter(AnnotationDescription.Builder.ofType(CacheField.class).build()).intercept(new Implementation.Simple(new ExitAdviceByteCodeAppender(load, store, convert, branch, StackSize.of(type).getSize()))).annotateMethod(AnnotationDescription.Builder.ofType(Advice.OnMethodExit.class).build()).make();
        }

        protected static AdviceResolver of(TypeDefinition typeDefinition) {
            if (typeDefinition.represents(Boolean.TYPE)) {
                return BOOLEAN;
            }
            if (typeDefinition.represents(Byte.TYPE)) {
                return BYTE;
            }
            if (typeDefinition.represents(Short.TYPE)) {
                return SHORT;
            }
            if (typeDefinition.represents(Character.TYPE)) {
                return CHARACTER;
            }
            if (typeDefinition.represents(Integer.TYPE)) {
                return INTEGER;
            }
            if (typeDefinition.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDefinition.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDefinition.represents(Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDefinition.isPrimitive()) {
                throw new IllegalArgumentException("Unexpected advice type: " + typeDefinition);
            }
            return REFERENCE;
        }

        protected Advice toAdvice(String name) {
            return Advice.withCustomMapping().bind(CacheField.class, new CacheFieldOffsetMapping(name)).to(this.dynamicType.getTypeDescription(), (ClassFileLocator)this.dynamicType);
        }

        @HashCodeAndEqualsPlugin.Enhance
        protected static class ExitAdviceByteCodeAppender
        implements ByteCodeAppender {
            private final int load;
            private final int store;
            private final int convert;
            private final int branch;
            private final int size;

            protected ExitAdviceByteCodeAppender(int load, int store, int convert, int branch, int size) {
                this.load = load;
                this.store = store;
                this.convert = convert;
                this.branch = branch;
                this.size = size;
            }

            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                Label complete = new Label();
                Label uncached = new Label();
                methodVisitor.visitVarInsn(this.load, 0);
                if (this.convert != 0) {
                    methodVisitor.visitInsn(this.convert);
                }
                methodVisitor.visitJumpInsn(this.branch, uncached);
                methodVisitor.visitVarInsn(this.load, this.size);
                methodVisitor.visitVarInsn(this.store, 0);
                methodVisitor.visitJumpInsn(167, complete);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitLabel(uncached);
                methodVisitor.visitVarInsn(this.load, 0);
                methodVisitor.visitVarInsn(this.store, this.size);
                methodVisitor.visitLabel(complete);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitInsn(177);
                return new ByteCodeAppender.Size(this.size * 2, instrumentedMethod.getStackSize());
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (this.load != ((ExitAdviceByteCodeAppender)object).load) {
                    return false;
                }
                if (this.store != ((ExitAdviceByteCodeAppender)object).store) {
                    return false;
                }
                if (this.convert != ((ExitAdviceByteCodeAppender)object).convert) {
                    return false;
                }
                if (this.branch != ((ExitAdviceByteCodeAppender)object).branch) {
                    return false;
                }
                return this.size == ((ExitAdviceByteCodeAppender)object).size;
            }

            public int hashCode() {
                return ((((this.getClass().hashCode() * 31 + this.load) * 31 + this.store) * 31 + this.convert) * 31 + this.branch) * 31 + this.size;
            }
        }
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface CacheField {
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Enhance {
        public String value() default "";
    }
}

