/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.kyuubi.plugin.spark.authz

import scala.language.implicitConversions

import org.apache.kyuubi.plugin.spark.authz.OperationType.OperationType
import org.apache.kyuubi.plugin.spark.authz.PrivilegeObjectActionType.PrivilegeObjectActionType
import org.apache.kyuubi.plugin.spark.authz.serde.FunctionType.FunctionType
import org.apache.kyuubi.plugin.spark.authz.serde.TableType.TableType

package object gen {
  implicit def classSimpleName(clz: Class[_]): String = clz.getSimpleName

  implicit def actionTypeStr(t: PrivilegeObjectActionType): String = t.toString

  implicit def functionTypeStr(t: FunctionType): String = t.toString

  implicit def operationTypeStr(t: OperationType): String = t.toString

  implicit def tableTypeStr(t: TableType): String = t.toString
}
