/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.DenseLiveDocs;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.SparseLiveDocs;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=3, time=2)
@Measurement(iterations=5, time=3)
@Fork(value=1, jvmArgsAppend={"-Xmx2g", "-Xms2g"})
public class LiveDocsPathologicalBenchmark {
    @Param(value={"100000", "500000", "1000000", "5000000", "10000000", "50000000", "100000000"})
    int maxDoc;
    private SparseLiveDocs sparseLiveDocs;
    private DenseLiveDocs denseLiveDocs;

    @Setup(value=Level.Trial)
    public void setup() {
        SparseFixedBitSet sparseSet = new SparseFixedBitSet(this.maxDoc);
        FixedBitSet fixedSet = new FixedBitSet(this.maxDoc);
        fixedSet.set(0, this.maxDoc);
        int blockSize = 4096;
        int longsPerBlock = 64;
        int bitsPerLong = 64;
        int blockIdx = 0;
        while (blockIdx * 4096 < this.maxDoc) {
            for (int longIdx = 0; longIdx < 64; ++longIdx) {
                int docId = blockIdx * 4096 + longIdx * 64;
                if (docId >= this.maxDoc) continue;
                sparseSet.set(docId);
                fixedSet.clear(docId);
            }
            ++blockIdx;
        }
        this.sparseLiveDocs = SparseLiveDocs.builder((SparseFixedBitSet)sparseSet, (int)this.maxDoc).build();
        this.denseLiveDocs = DenseLiveDocs.builder((FixedBitSet)fixedSet, (int)this.maxDoc).build();
    }

    @Benchmark
    public int sparseIterateDeleted() throws IOException {
        DocIdSetIterator it = this.sparseLiveDocs.deletedDocsIterator();
        int count = 0;
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++count;
            doc = it.nextDoc();
        }
        return count;
    }

    @Benchmark
    public int denseIterateDeleted() throws IOException {
        DocIdSetIterator it = this.denseLiveDocs.deletedDocsIterator();
        int count = 0;
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++count;
            doc = it.nextDoc();
        }
        return count;
    }
}

