/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.codecs.lucene104.ForUtil;
import org.apache.lucene.codecs.lucene104.PostingIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
@Fork(value=3, jvmArgsAppend={"-Xmx1g", "-Xms1g", "-XX:+AlwaysPreTouch"})
public class PostingIndexInputBenchmark {
    private Path path;
    private Directory dir;
    private IndexInput in;
    private PostingIndexInput postingIn;
    private final ForUtil forUtil = new ForUtil();
    private final int[] values = new int[256];
    @Param(value={"2", "3", "4", "5", "6", "7", "8", "9", "10"})
    public int bpv;

    @Setup(value=Level.Trial)
    public void setup() throws Exception {
        this.path = Files.createTempDirectory("forUtil", new FileAttribute[0]);
        this.dir = MMapDirectory.open((Path)this.path);
        try (IndexOutput out = this.dir.createOutput("docs", IOContext.DEFAULT);){
            Random r = new Random(0L);
            for (int i = 0; i < 100; ++i) {
                out.writeLong(r.nextLong());
            }
        }
        this.in = this.dir.openInput("docs", IOContext.DEFAULT);
        this.postingIn = new PostingIndexInput(this.in, this.forUtil);
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws Exception {
        if (this.dir != null) {
            this.dir.deleteFile("docs");
        }
        IOUtils.close((Closeable[])new Closeable[]{this.in, this.dir});
        this.in = null;
        this.dir = null;
        Files.deleteIfExists(this.path);
    }

    @Benchmark
    public void decode(Blackhole bh) throws IOException {
        this.in.seek(3L);
        this.postingIn.decode(this.bpv, this.values);
        bh.consume((Object)this.values);
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
    public void decodeVector(Blackhole bh) throws IOException {
        this.in.seek(3L);
        this.postingIn.decode(this.bpv, this.values);
        bh.consume((Object)this.values);
    }
}

