/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.util.twentynewsgroups;

import java.util.HashMap;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.email.UAX29URLEmailAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;

public class Message {
    private String from;
    private String[] newsgroups;
    private String subject;
    private String messageId;
    private String date;
    private String organization;
    private String body;
    private int lines;
    private static final FieldType SUBJECT_FIELD_TYPE = new FieldType();
    private static final FieldType BODY_FIELD_TYPE;

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String[] getNewsgroups() {
        return this.newsgroups;
    }

    public void setNewsgroups(String[] newsgroups) {
        this.newsgroups = newsgroups;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public int getLines() {
        return this.lines;
    }

    public void setLines(int lines) {
        this.lines = lines;
    }

    public Document toLuceneDoc() {
        Document doc = new Document();
        if (Objects.nonNull(this.getFrom())) {
            doc.add((IndexableField)new TextField("from", this.getFrom(), Field.Store.YES));
        }
        if (Objects.nonNull(this.getNewsgroups())) {
            for (String newsgroup : this.getNewsgroups()) {
                doc.add((IndexableField)new StringField("newsgroup", newsgroup, Field.Store.YES));
                doc.add((IndexableField)new SortedSetDocValuesField("newsgroup_sort", new BytesRef((CharSequence)newsgroup)));
            }
        }
        if (Objects.nonNull(this.getSubject())) {
            doc.add((IndexableField)new Field("subject", (CharSequence)this.getSubject(), (IndexableFieldType)SUBJECT_FIELD_TYPE));
        }
        if (Objects.nonNull(this.getMessageId())) {
            doc.add((IndexableField)new StringField("messageId", this.getMessageId(), Field.Store.YES));
        }
        if (Objects.nonNull(this.getDate())) {
            doc.add((IndexableField)new StoredField("date_raw", this.getDate()));
        }
        if (this.getOrganization() != null) {
            doc.add((IndexableField)new TextField("organization", this.getOrganization(), Field.Store.YES));
        }
        doc.add((IndexableField)new IntPoint("lines_range", new int[]{this.getLines()}));
        doc.add((IndexableField)new SortedNumericDocValuesField("lines_sort", (long)this.getLines()));
        doc.add((IndexableField)new StoredField("lines_raw", String.valueOf(this.getLines())));
        if (Objects.nonNull(this.getBody())) {
            doc.add((IndexableField)new Field("body", (CharSequence)this.getBody(), (IndexableFieldType)BODY_FIELD_TYPE));
        }
        return doc;
    }

    public static Analyzer createLuceneAnalyzer() {
        HashMap<String, UAX29URLEmailAnalyzer> map = new HashMap<String, UAX29URLEmailAnalyzer>();
        map.put("from", new UAX29URLEmailAnalyzer());
        return new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(), map);
    }

    static {
        SUBJECT_FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        SUBJECT_FIELD_TYPE.setTokenized(true);
        SUBJECT_FIELD_TYPE.setStored(true);
        BODY_FIELD_TYPE = new FieldType();
        BODY_FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        BODY_FIELD_TYPE.setTokenized(true);
        BODY_FIELD_TYPE.setStored(true);
        BODY_FIELD_TYPE.setStoreTermVectors(true);
        BODY_FIELD_TYPE.setStoreTermVectorPositions(true);
        BODY_FIELD_TYPE.setStoreTermVectorOffsets(true);
    }
}

