/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.TaskExecutor;
import org.apache.lucene.util.ArrayUtil;

public final class PostCollectionFaceting<C extends Collector, T, K extends Collector, R> {
    static final int MIN_DOCS_PER_SLICE = 100;
    private final CollectorManager<C, T> drillDownCollectorManager;
    private final List<CollectorManager<K, R>> drillSidewaysCollectorManagers;
    private final FacetsCollector drillDownFacetsCollector;
    private final Map<String, FacetsCollector> drillSidewaysFacetsCollectors;
    private final TaskExecutor taskExecutor;
    private final Map<String, Integer> dimToIndexMap;
    private final int numOfIndexLeafs;

    public PostCollectionFaceting(CollectorManager<C, T> drillDownCollectorManager, Map<String, ? extends CollectorManager<K, R>> drillSidewaysCollectorManagers, FacetsCollector drillDownFacetsCollector, Map<String, FacetsCollector> drillSidewaysFacetsCollectors, Executor executor) {
        this.drillDownCollectorManager = drillDownCollectorManager;
        this.drillDownFacetsCollector = drillDownFacetsCollector;
        this.drillSidewaysFacetsCollectors = drillSidewaysFacetsCollectors == null ? Map.of() : drillSidewaysFacetsCollectors;
        this.taskExecutor = executor == null ? new TaskExecutor(Runnable::run) : new TaskExecutor(executor);
        this.numOfIndexLeafs = this.calculateNumOfIndexLeafs();
        this.dimToIndexMap = new HashMap<String, Integer>();
        int ind = 0;
        if (drillSidewaysCollectorManagers == null) {
            this.drillSidewaysCollectorManagers = List.of();
        } else {
            this.drillSidewaysCollectorManagers = new ArrayList<CollectorManager<K, R>>(drillSidewaysCollectorManagers.size());
            for (Map.Entry<String, CollectorManager<K, R>> entry : drillSidewaysCollectorManagers.entrySet()) {
                if (!this.drillSidewaysFacetsCollectors.containsKey(entry.getKey())) continue;
                this.dimToIndexMap.put(entry.getKey(), ind++);
                this.drillSidewaysCollectorManagers.add(entry.getValue());
            }
        }
    }

    public PostCollectionFaceting(CollectorManager<C, T> drillDownCollectorManager, FacetsCollector drillDownFacetsCollector, Executor executor) {
        this(drillDownCollectorManager, null, drillDownFacetsCollector, null, executor);
    }

    private int calculateNumOfIndexLeafs() {
        int maxOrd = -1;
        for (FacetsCollector.MatchingDocs matchingDocs : this.drillDownFacetsCollector.getMatchingDocs()) {
            maxOrd = Math.max(maxOrd, matchingDocs.context().ord);
        }
        for (FacetsCollector facetsCollector : this.drillSidewaysFacetsCollectors.values()) {
            for (FacetsCollector.MatchingDocs matchingDocs : facetsCollector.getMatchingDocs()) {
                maxOrd = Math.max(maxOrd, matchingDocs.context().ord);
            }
        }
        return maxOrd + 1;
    }

    private FacetsCollector.MatchingDocs[][] getPerLeafMatchingDocs() {
        FacetsCollector.MatchingDocs[][] perLeafMatchingDocs = new FacetsCollector.MatchingDocs[this.numOfIndexLeafs][this.drillSidewaysCollectorManagers.size() + 1];
        Iterator<Object> iterator = this.drillDownFacetsCollector.getMatchingDocs().iterator();
        while (iterator.hasNext()) {
            FacetsCollector.MatchingDocs matchingDocs;
            perLeafMatchingDocs[matchingDocs.context().ord][0] = matchingDocs = (FacetsCollector.MatchingDocs)iterator.next();
        }
        for (Map.Entry entry : this.dimToIndexMap.entrySet()) {
            Iterator iterator2 = this.drillSidewaysFacetsCollectors.get(entry.getKey()).getMatchingDocs().iterator();
            while (iterator2.hasNext()) {
                FacetsCollector.MatchingDocs matchingDocs;
                perLeafMatchingDocs[matchingDocs.context().ord][((Integer)entry.getValue()).intValue() + 1] = matchingDocs = (FacetsCollector.MatchingDocs)iterator2.next();
            }
        }
        return perLeafMatchingDocs;
    }

    private List<Slice> getSlices(int minDocsPerSlice, FacetsCollector.MatchingDocs[][] perLeafMatchingDocs) {
        ArrayList<Slice> slices = new ArrayList<Slice>();
        int currentSliceSize = 0;
        int lastSliceEnd = -1;
        for (int leafOrd = 0; leafOrd < perLeafMatchingDocs.length; ++leafOrd) {
            for (int dimOrd = 0; dimOrd < perLeafMatchingDocs[leafOrd].length; ++dimOrd) {
                if (perLeafMatchingDocs[leafOrd][dimOrd] == null) continue;
                currentSliceSize += perLeafMatchingDocs[leafOrd][dimOrd].totalHits();
            }
            if (currentSliceSize < minDocsPerSlice) continue;
            slices.add(new Slice((FacetsCollector.MatchingDocs[][])ArrayUtil.copyOfSubArray((Object[])perLeafMatchingDocs, (int)(lastSliceEnd + 1), (int)(leafOrd + 1))));
            currentSliceSize = 0;
            lastSliceEnd = leafOrd;
        }
        if (currentSliceSize > 0) {
            slices.add(new Slice((FacetsCollector.MatchingDocs[][])ArrayUtil.copyOfSubArray((Object[])perLeafMatchingDocs, (int)(lastSliceEnd + 1), (int)perLeafMatchingDocs.length)));
        }
        return slices;
    }

    /*
     * WARNING - void declaration
     */
    public Result<T, R> collect() throws IOException {
        FacetsCollector.MatchingDocs[][] perLeafMatchingDocs = this.getPerLeafMatchingDocs();
        List<Slice> leafSlices = this.getSlices(100, perLeafMatchingDocs);
        if (leafSlices.size() == 0) {
            return this.getEmptyResult();
        }
        ArrayList<Collector> drillDownCollectors = this.drillDownCollectorManager != null ? new ArrayList<Collector>(leafSlices.size()) : null;
        ArrayList drillSidewaysCollectors = new ArrayList(leafSlices.size());
        ArrayList<Callable<Void>> listTasks = new ArrayList<Callable<Void>>(leafSlices.size());
        for (int i = 0; i < leafSlices.size(); ++i) {
            void var8_9;
            Slice slice = leafSlices.get(i);
            if (this.drillDownCollectorManager != null) {
                Collector collector = this.drillDownCollectorManager.newCollector();
                drillDownCollectors.add(collector);
            } else {
                Object var8_11 = null;
            }
            ArrayList<Collector> drillSidewaysSliceCollectors = new ArrayList<Collector>(this.drillSidewaysCollectorManagers.size());
            for (CollectorManager<K, R> manager : this.drillSidewaysCollectorManagers) {
                drillSidewaysSliceCollectors.add(manager.newCollector());
            }
            drillSidewaysCollectors.add(drillSidewaysSliceCollectors);
            listTasks.add(() -> this.lambda$collect$0(slice, (Collector)var8_9, drillSidewaysSliceCollectors));
        }
        this.taskExecutor.invokeAll(listTasks);
        HashMap<String, Object> drillSidewaysResults = new HashMap<String, Object>(this.drillSidewaysCollectorManagers.size());
        for (Map.Entry entry : this.dimToIndexMap.entrySet()) {
            List<Collector> collectors = drillSidewaysCollectors.stream().map(list -> (Collector)list.get(this.dimToIndexMap.get(entry.getKey()))).toList();
            CollectorManager<K, R> collectorManager = this.drillSidewaysCollectorManagers.get((Integer)entry.getValue());
            drillSidewaysResults.put((String)entry.getKey(), collectorManager.reduce(collectors));
        }
        Object drillDownResult = this.drillDownCollectorManager != null ? this.drillDownCollectorManager.reduce(drillDownCollectors) : null;
        return new Result(drillDownResult, drillSidewaysResults);
    }

    private Result<T, R> getEmptyResult() throws IOException {
        HashMap<String, Object> emptyResults = new HashMap<String, Object>();
        for (Map.Entry<String, Integer> entry : this.dimToIndexMap.entrySet()) {
            emptyResults.put(entry.getKey(), this.drillSidewaysCollectorManagers.get(entry.getValue()).reduce(List.of()));
        }
        Object drillDownResult = null;
        if (this.drillDownCollectorManager != null) {
            drillDownResult = this.drillDownCollectorManager.reduce(List.of());
        }
        return new Result(drillDownResult, emptyResults);
    }

    private static LeafCollector getLeafCollector(FacetsCollector.MatchingDocs matchingDocs, Collector collector) throws IOException {
        if (matchingDocs == null || collector == null) {
            return null;
        }
        return collector.getLeafCollector(matchingDocs.context());
    }

    private static MatchingDocsScorable createScorer(FacetsCollector.MatchingDocs matchingDocs, Collector collector) {
        if (matchingDocs == null || collector == null) {
            return null;
        }
        if (collector.scoreMode().needsScores()) {
            if (matchingDocs.scores() == null) {
                throw new IllegalStateException("Collector requires scores, but FacetCollector doesn't have them.");
            }
            return new MatchingDocsScorable(matchingDocs);
        }
        return null;
    }

    private Void collectSlice(Slice slice, C drillDownCollector, List<K> drillSidewaysCollectors) throws IOException {
        LeafCollector[] leafCollectors = new LeafCollector[drillSidewaysCollectors.size() + 1];
        MatchingDocsScorable[] scorables = null;
        for (FacetsCollector.MatchingDocs[] leafMatchingDocs : slice.leafMatchingDocs()) {
            leafCollectors[0] = PostCollectionFaceting.getLeafCollector(leafMatchingDocs[0], drillDownCollector);
            MatchingDocsScorable scorer = PostCollectionFaceting.createScorer(leafMatchingDocs[0], drillDownCollector);
            if (scorer != null) {
                if (scorables == null) {
                    scorables = new MatchingDocsScorable[leafCollectors.length];
                }
                scorables[0] = scorer;
                leafCollectors[0].setScorer((Scorable)scorer);
            }
            for (int i = 0; i < drillSidewaysCollectors.size(); ++i) {
                leafCollectors[i + 1] = PostCollectionFaceting.getLeafCollector(leafMatchingDocs[i + 1], (Collector)drillSidewaysCollectors.get(i));
                scorer = PostCollectionFaceting.createScorer(leafMatchingDocs[i + 1], (Collector)drillSidewaysCollectors.get(i));
                if (scorer == null) continue;
                if (scorables == null) {
                    scorables = new MatchingDocsScorable[leafCollectors.length];
                }
                scorables[i + 1] = scorer;
                leafCollectors[i + 1].setScorer((Scorable)scorer);
            }
            PostCollectionFaceting.collectLeaf(leafMatchingDocs, leafCollectors, scorables);
        }
        return null;
    }

    private static void collectLeaf(FacetsCollector.MatchingDocs[] matchingDocs, LeafCollector[] leafCollectors, MatchingDocsScorable[] scorables) throws IOException {
        assert (matchingDocs.length == leafCollectors.length);
        int currentDocToCollect = Integer.MAX_VALUE;
        DocIdSetIterator[] iterators = new DocIdSetIterator[matchingDocs.length];
        for (int i = 0; i < matchingDocs.length; ++i) {
            if (matchingDocs[i] == null || leafCollectors[i] == null) continue;
            iterators[i] = matchingDocs[i].bits().iterator();
            int firstDoc = iterators[i].nextDoc();
            if (firstDoc == Integer.MAX_VALUE || currentDocToCollect != Integer.MAX_VALUE && currentDocToCollect <= firstDoc) continue;
            currentDocToCollect = firstDoc;
        }
        while (currentDocToCollect < Integer.MAX_VALUE) {
            int nextDocToCollect = Integer.MAX_VALUE;
            for (int i = 0; i < iterators.length; ++i) {
                if (iterators[i] == null) continue;
                if (iterators[i].docID() == currentDocToCollect) {
                    assert (leafCollectors[i] != null) : "leafCollectors[" + i + "] is null but the iterator is not null";
                    if (scorables != null && scorables[i] != null) {
                        scorables[i].setCurrentDocId(currentDocToCollect);
                    }
                    leafCollectors[i].collect(currentDocToCollect);
                    int nextDoc = iterators[i].nextDoc();
                    if (nextDoc == Integer.MAX_VALUE) {
                        iterators[i] = null;
                        continue;
                    }
                    if (nextDocToCollect <= nextDoc) continue;
                    nextDocToCollect = nextDoc;
                    continue;
                }
                assert (iterators[i].docID() > currentDocToCollect) : "currentDocToCollect (" + currentDocToCollect + ") should always be greater than iterators[i].docID() (" + iterators[i].docID() + ")";
                if (nextDocToCollect <= iterators[i].docID()) continue;
                nextDocToCollect = iterators[i].docID();
            }
            assert (nextDocToCollect > currentDocToCollect);
            currentDocToCollect = nextDocToCollect;
        }
        for (LeafCollector leafCollector : leafCollectors) {
            if (leafCollector == null) continue;
            leafCollector.finish();
        }
    }

    private record Slice(FacetsCollector.MatchingDocs[][] leafMatchingDocs) {
    }

    public record Result<T, R>(T drillDownResult, Map<String, R> drillSidewaysResults) {
    }

    private static class MatchingDocsScorable
    extends Scorable {
        private final FacetsCollector.MatchingDocs matchingDocs;
        private int currentDocId = -1;

        MatchingDocsScorable(FacetsCollector.MatchingDocs matchingDocs) {
            this.matchingDocs = matchingDocs;
        }

        void setCurrentDocId(int docId) {
            this.currentDocId = docId;
        }

        public float score() throws IOException {
            assert (this.currentDocId >= 0) : "setCurrentDocId() must be called before score()";
            assert (this.matchingDocs.scores().length > this.currentDocId) : "scores array is indexed by doc ID (see FacetsCollector.MatchingDocs), so length must be greater than currentDocId";
            return this.matchingDocs.scores()[this.currentDocId];
        }
    }
}

