/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene103;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.backward_codecs.lucene103.ForUtil;
import org.apache.lucene.backward_codecs.lucene103.PostingDecodingUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.PackedInts;

final class PForUtil {
    private static final int MAX_EXCEPTIONS = 7;
    private final ForUtil forUtil = new ForUtil();

    PForUtil() {
    }

    static boolean allEqual(int[] l) {
        for (int i = 1; i < 128; ++i) {
            if (l[i] == l[0]) continue;
            return false;
        }
        return true;
    }

    void encode(int[] ints, DataOutput out) throws IOException {
        int[] histogram = new int[32];
        int maxBitsRequired = 0;
        for (int i = 0; i < 128; ++i) {
            int bits;
            int v = ints[i];
            int n = bits = PackedInts.bitsRequired((int)v);
            histogram[n] = histogram[n] + 1;
            maxBitsRequired = Math.max(maxBitsRequired, bits);
        }
        int minBits = Math.max(0, maxBitsRequired - 8);
        int cumulativeExceptions = 0;
        int patchedBitsRequired = maxBitsRequired;
        int numExceptions = 0;
        for (int b = maxBitsRequired; b >= minBits && cumulativeExceptions <= 7; cumulativeExceptions += histogram[b], --b) {
            patchedBitsRequired = b;
            numExceptions = cumulativeExceptions;
        }
        int maxUnpatchedValue = (1 << patchedBitsRequired) - 1;
        byte[] exceptions = new byte[numExceptions * 2];
        if (numExceptions > 0) {
            int exceptionCount = 0;
            for (int i = 0; i < 128; ++i) {
                if (ints[i] <= maxUnpatchedValue) continue;
                exceptions[exceptionCount * 2] = (byte)i;
                exceptions[exceptionCount * 2 + 1] = (byte)(ints[i] >>> patchedBitsRequired);
                int n = i;
                ints[n] = ints[n] & maxUnpatchedValue;
                ++exceptionCount;
            }
            assert (exceptionCount == numExceptions) : exceptionCount + " " + numExceptions;
        }
        if (PForUtil.allEqual(ints) && maxBitsRequired <= 8) {
            for (int i = 0; i < numExceptions; ++i) {
                exceptions[2 * i + 1] = (byte)(Byte.toUnsignedInt(exceptions[2 * i + 1]) << patchedBitsRequired);
            }
            out.writeByte((byte)(numExceptions << 5));
            out.writeVInt(ints[0]);
        } else {
            int token = numExceptions << 5 | patchedBitsRequired;
            out.writeByte((byte)token);
            this.forUtil.encode(ints, patchedBitsRequired, out);
        }
        out.writeBytes(exceptions, exceptions.length);
    }

    void decode(PostingDecodingUtil pdu, int[] ints) throws IOException {
        IndexInput in = pdu.in;
        int token = Byte.toUnsignedInt(in.readByte());
        int bitsPerValue = token & 0x1F;
        if (bitsPerValue == 0) {
            Arrays.fill(ints, 0, 128, in.readVInt());
        } else {
            this.forUtil.decode(bitsPerValue, pdu, ints);
        }
        int numExceptions = token >>> 5;
        for (int i = 0; i < numExceptions; ++i) {
            int n = Byte.toUnsignedInt(in.readByte());
            ints[n] = ints[n] | Byte.toUnsignedInt(in.readByte()) << bitsPerValue;
        }
    }

    static void skip(DataInput in) throws IOException {
        int token = Byte.toUnsignedInt(in.readByte());
        int bitsPerValue = token & 0x1F;
        int numExceptions = token >>> 5;
        if (bitsPerValue == 0) {
            in.readVLong();
            in.skipBytes((long)(numExceptions << 1));
        } else {
            in.skipBytes((long)(ForUtil.numBytes(bitsPerValue) + (numExceptions << 1)));
        }
    }
}

