/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene99;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;
import org.apache.lucene.util.quantization.ScalarQuantizer;

public abstract class OffHeapQuantizedByteVectorValues
extends QuantizedByteVectorValues {
    final int dimension;
    final int size;
    final int numBytes;
    final ScalarQuantizer scalarQuantizer;
    final VectorSimilarityFunction similarityFunction;
    final FlatVectorsScorer vectorsScorer;
    final boolean compress;
    final IndexInput slice;
    final byte[] binaryValue;
    final ByteBuffer byteBuffer;
    final int byteSize;
    int lastOrd = -1;
    final float[] scoreCorrectionConstant = new float[1];

    static void decompressBytes(byte[] compressed, int numBytes) {
        if (numBytes == compressed.length) {
            return;
        }
        if (numBytes << 1 != compressed.length) {
            throw new IllegalArgumentException("numBytes: " + numBytes + " does not match compressed length: " + compressed.length);
        }
        for (int i = 0; i < numBytes; ++i) {
            compressed[numBytes + i] = (byte)(compressed[i] & 0xF);
            compressed[i] = (byte)((compressed[i] & 0xFF) >> 4);
        }
    }

    static byte[] compressedArray(int dimension, byte bits) {
        if (bits <= 4) {
            return new byte[dimension + 1 >> 1];
        }
        return null;
    }

    static void compressBytes(byte[] raw, byte[] compressed) {
        if (compressed.length != raw.length + 1 >> 1) {
            throw new IllegalArgumentException("compressed length: " + compressed.length + " does not match raw length: " + raw.length);
        }
        for (int i = 0; i < compressed.length; ++i) {
            int v = raw[i] << 4 | raw[compressed.length + i];
            compressed[i] = (byte)v;
        }
    }

    OffHeapQuantizedByteVectorValues(int dimension, int size, ScalarQuantizer scalarQuantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, boolean compress, IndexInput slice) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.scalarQuantizer = scalarQuantizer;
        this.compress = compress;
        this.numBytes = scalarQuantizer.getBits() <= 4 && compress ? dimension + 1 >> 1 : dimension;
        this.byteSize = this.numBytes + 4;
        this.byteBuffer = ByteBuffer.allocate(dimension);
        this.binaryValue = this.byteBuffer.array();
        this.similarityFunction = similarityFunction;
        this.vectorsScorer = vectorsScorer;
    }

    public ScalarQuantizer getScalarQuantizer() {
        return this.scalarQuantizer;
    }

    public int dimension() {
        return this.dimension;
    }

    public int size() {
        return this.size;
    }

    public byte[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.binaryValue;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.numBytes);
        this.slice.readFloats(this.scoreCorrectionConstant, 0, 1);
        OffHeapQuantizedByteVectorValues.decompressBytes(this.binaryValue, this.numBytes);
        this.lastOrd = targetOrd;
        return this.binaryValue;
    }

    public float getScoreCorrectionConstant(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.scoreCorrectionConstant[0];
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.numBytes);
        this.slice.readFloats(this.scoreCorrectionConstant, 0, 1);
        return this.scoreCorrectionConstant[0];
    }

    public IndexInput getSlice() {
        return this.slice;
    }

    public int getVectorByteLength() {
        return this.numBytes;
    }

    static OffHeapQuantizedByteVectorValues load(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, ScalarQuantizer scalarQuantizer, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, boolean compress, long quantizedVectorDataOffset, long quantizedVectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.isEmpty()) {
            return new EmptyOffHeapVectorValues(dimension, similarityFunction, vectorsScorer);
        }
        IndexInput bytesSlice = vectorData.slice("quantized-vector-data", quantizedVectorDataOffset, quantizedVectorDataLength);
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, size, scalarQuantizer, compress, similarityFunction, vectorsScorer, bytesSlice);
        }
        return new SparseOffHeapVectorValues(configuration, dimension, size, scalarQuantizer, compress, vectorData, similarityFunction, vectorsScorer, bytesSlice);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapQuantizedByteVectorValues {
        public EmptyOffHeapVectorValues(int dimension, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer) {
            super(dimension, 0, new ScalarQuantizer(-1.0f, 1.0f, 7), similarityFunction, vectorsScorer, false, null);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        public EmptyOffHeapVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] vectorValue(int targetOrd) {
            throw new UnsupportedOperationException();
        }

        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        public VectorScorer scorer(float[] target) {
            return null;
        }
    }

    public static class DenseOffHeapVectorValues
    extends OffHeapQuantizedByteVectorValues {
        public DenseOffHeapVectorValues(int dimension, int size, ScalarQuantizer scalarQuantizer, boolean compress, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
            super(dimension, size, scalarQuantizer, similarityFunction, vectorsScorer, compress, slice);
        }

        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.scalarQuantizer, this.compress, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        public VectorScorer scorer(float[] target) throws IOException {
            DenseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer vectorScorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                public float score() throws IOException {
                    return vectorScorer.score(iterator.index());
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapQuantizedByteVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, ScalarQuantizer scalarQuantizer, boolean compress, IndexInput dataIn, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) throws IOException {
            super(dimension, size, scalarQuantizer, similarityFunction, vectorsScorer, compress, slice);
            this.configuration = configuration;
            this.dataIn = dataIn;
            this.ordToDoc = configuration.getDirectMonotonicReader(dataIn);
            this.disi = configuration.getIndexedDISI(dataIn);
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator((IndexedDISI)this.disi);
        }

        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dimension, this.size, this.scalarQuantizer, this.compress, this.dataIn, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get((long)ord);
        }

        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                public int length() {
                    return size;
                }
            };
        }

        public VectorScorer scorer(float[] target) throws IOException {
            SparseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer vectorScorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                public float score() throws IOException {
                    return vectorScorer.score(iterator.index());
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }
}

