/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.mutable.MutableValue;

public class ValueSourceGroupSelector
extends GroupSelector<MutableValue> {
    private final ValueSource valueSource;
    private final Map<Object, Object> context;
    private Set<MutableValue> secondPassGroups;
    private boolean includeEmpty;
    private FunctionValues.ValueFiller filler;

    public ValueSourceGroupSelector(ValueSource valueSource, Map<Object, Object> context) {
        this.valueSource = valueSource;
        this.context = context;
    }

    @Override
    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        FunctionValues values = this.valueSource.getValues(this.context, readerContext);
        this.filler = values.getValueFiller();
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
    }

    @Override
    public GroupSelector.State advanceTo(int doc) throws IOException {
        this.filler.fillValue(doc);
        MutableValue value = this.filler.getValue();
        if (!value.exists()) {
            return this.includeEmpty ? GroupSelector.State.ACCEPT : GroupSelector.State.SKIP;
        }
        if (this.secondPassGroups != null && !this.secondPassGroups.contains(value)) {
            return GroupSelector.State.SKIP;
        }
        return GroupSelector.State.ACCEPT;
    }

    @Override
    public MutableValue currentValue() throws IOException {
        return this.filler.getValue();
    }

    @Override
    public MutableValue copyValue() {
        return this.filler.getValue().duplicate();
    }

    @Override
    public void setGroups(Collection<SearchGroup<MutableValue>> searchGroups) {
        this.secondPassGroups = new HashSet<MutableValue>();
        for (SearchGroup<MutableValue> group : searchGroups) {
            if (!((MutableValue)group.groupValue).exists()) {
                this.includeEmpty = true;
                continue;
            }
            this.secondPassGroups.add((MutableValue)group.groupValue);
        }
    }
}

