/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene104;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene103.blocktree.Lucene103BlockTreeTermsReader;
import org.apache.lucene.codecs.lucene103.blocktree.Lucene103BlockTreeTermsWriter;
import org.apache.lucene.codecs.lucene104.Lucene104PostingsReader;
import org.apache.lucene.codecs.lucene104.Lucene104PostingsWriter;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.util.IOUtils;

public final class Lucene104PostingsFormat
extends PostingsFormat {
    public static final String META_EXTENSION = "psm";
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    public static final int BLOCK_SIZE = 256;
    static final int BLOCK_MASK = 255;
    public static final int LEVEL1_FACTOR = 32;
    public static final int LEVEL1_NUM_DOCS = 8192;
    static final int LEVEL1_MASK = 8191;
    static final String TERMS_CODEC = "Lucene104PostingsWriterTerms";
    static final String META_CODEC = "Lucene104PostingsWriterMeta";
    static final String DOC_CODEC = "Lucene104PostingsWriterDoc";
    static final String POS_CODEC = "Lucene104PostingsWriterPos";
    static final String PAY_CODEC = "Lucene104PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    private final int version;
    private final int minTermBlockSize;
    private final int maxTermBlockSize;

    public static Class<? extends ImpactsEnum> getImpactsEnumImpl() {
        return Lucene104PostingsReader.BlockPostingsEnum.class;
    }

    public Lucene104PostingsFormat() {
        this(25, 48);
    }

    public Lucene104PostingsFormat(int minTermBlockSize, int maxTermBlockSize) {
        this(minTermBlockSize, maxTermBlockSize, 0);
    }

    public Lucene104PostingsFormat(int minTermBlockSize, int maxTermBlockSize, int version) {
        super("Lucene104");
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Version out of range: " + version);
        }
        this.version = version;
        Lucene103BlockTreeTermsWriter.validateSettings(minTermBlockSize, maxTermBlockSize);
        this.minTermBlockSize = minTermBlockSize;
        this.maxTermBlockSize = maxTermBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        Lucene103BlockTreeTermsWriter lucene103BlockTreeTermsWriter;
        block3: {
            Lucene104PostingsWriter postingsWriter = new Lucene104PostingsWriter(state, this.version);
            boolean success = false;
            try {
                Lucene103BlockTreeTermsWriter ret = new Lucene103BlockTreeTermsWriter(state, postingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
                success = true;
                lucene103BlockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return lucene103BlockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        Lucene103BlockTreeTermsReader lucene103BlockTreeTermsReader;
        block3: {
            Lucene104PostingsReader postingsReader = new Lucene104PostingsReader(state);
            boolean success = false;
            try {
                Lucene103BlockTreeTermsReader ret = new Lucene103BlockTreeTermsReader(postingsReader, state);
                success = true;
                lucene103BlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return lucene103BlockTreeTermsReader;
    }

    public static final class IntBlockTermState
    extends BlockTermState {
        public long docStartFP;
        public long posStartFP;
        public long payStartFP;
        public long lastPosBlockOffset = -1L;
        public int singletonDocID = -1;

        @Override
        public IntBlockTermState clone() {
            IntBlockTermState other = new IntBlockTermState();
            other.copyFrom(this);
            return other;
        }

        @Override
        public void copyFrom(TermState _other) {
            super.copyFrom(_other);
            IntBlockTermState other = (IntBlockTermState)_other;
            this.docStartFP = other.docStartFP;
            this.posStartFP = other.posStartFP;
            this.payStartFP = other.payStartFP;
            this.lastPosBlockOffset = other.lastPosBlockOffset;
            this.singletonDocID = other.singletonDocID;
        }

        @Override
        public String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

