/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene104;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene104.Lucene104ScalarQuantizedVectorScorer;
import org.apache.lucene.codecs.lucene104.Lucene104ScalarQuantizedVectorsFormat;
import org.apache.lucene.codecs.lucene104.Lucene104ScalarQuantizedVectorsReader;
import org.apache.lucene.codecs.lucene104.OffHeapScalarQuantizedVectorValues;
import org.apache.lucene.codecs.lucene104.QuantizedByteVectorValues;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.FloatArrayList;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;
import org.apache.lucene.util.quantization.OptimizedScalarQuantizer;

public class Lucene104ScalarQuantizedVectorsWriter
extends FlatVectorsWriter {
    private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Lucene104ScalarQuantizedVectorsWriter.class);
    private final SegmentWriteState segmentWriteState;
    private final List<FieldWriter> fields = new ArrayList<FieldWriter>();
    private final IndexOutput meta;
    private final IndexOutput vectorData;
    private final Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding;
    private final FlatVectorsWriter rawVectorDelegate;
    private final Lucene104ScalarQuantizedVectorScorer vectorsScorer;
    private boolean finished;

    public Lucene104ScalarQuantizedVectorsWriter(SegmentWriteState state, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, FlatVectorsWriter rawVectorDelegate, Lucene104ScalarQuantizedVectorScorer vectorsScorer) throws IOException {
        super(vectorsScorer);
        this.encoding = encoding;
        this.vectorsScorer = vectorsScorer;
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vemq");
        String vectorDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "veq");
        this.rawVectorDelegate = rawVectorDelegate;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorData = state.directory.createOutput(vectorDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "Lucene104ScalarQuantizedVectorsFormatMeta", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorData, "Lucene104ScalarQuantizedVectorsFormatData", 0, state.segmentInfo.getId(), state.segmentSuffix);
        }
        catch (Throwable t) {
            IOUtils.closeWhileHandlingException(this);
            throw t;
        }
    }

    @Override
    public FlatFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        KnnFieldVectorsWriter rawVectorDelegate = this.rawVectorDelegate.addField(fieldInfo);
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            FieldWriter fieldWriter = new FieldWriter(fieldInfo, (FlatFieldVectorsWriter<float[]>)rawVectorDelegate);
            this.fields.add(fieldWriter);
            return fieldWriter;
        }
        return rawVectorDelegate;
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        this.rawVectorDelegate.flush(maxDoc, sortMap);
        for (FieldWriter field : this.fields) {
            if (VectorSimilarityFunction.COSINE == field.fieldInfo.getVectorSimilarityFunction()) {
                field.normalizeVectors();
            }
            int vectorCount = field.flatFieldVectorsWriter.getVectors().size();
            float[] clusterCenter = new float[field.dimensionSums.length];
            if (vectorCount > 0) {
                for (int i = 0; i < field.dimensionSums.length; ++i) {
                    clusterCenter[i] = field.dimensionSums[i] / (float)vectorCount;
                }
                if (VectorSimilarityFunction.COSINE == field.fieldInfo.getVectorSimilarityFunction()) {
                    VectorUtil.l2normalize(clusterCenter);
                }
            }
            if (this.segmentWriteState.infoStream.isEnabled("QVEC")) {
                this.segmentWriteState.infoStream.message("QVEC", "Vectors' count:" + vectorCount);
            }
            OptimizedScalarQuantizer quantizer = new OptimizedScalarQuantizer(field.fieldInfo.getVectorSimilarityFunction());
            if (sortMap == null) {
                this.writeField(field, clusterCenter, maxDoc, quantizer);
            } else {
                this.writeSortingField(field, clusterCenter, maxDoc, sortMap, quantizer);
            }
            field.finish();
        }
    }

    private void writeField(FieldWriter fieldData, float[] clusterCenter, int maxDoc, OptimizedScalarQuantizer quantizer) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        this.writeVectors(fieldData, clusterCenter, quantizer);
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        float centroidDp = !fieldData.getVectors().isEmpty() ? VectorUtil.dotProduct(clusterCenter, clusterCenter) : 0.0f;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, clusterCenter, centroidDp, fieldData.getDocsWithFieldSet());
    }

    private void writeVectors(FieldWriter fieldData, float[] clusterCenter, OptimizedScalarQuantizer scalarQuantizer) throws IOException {
        byte[] scratch = new byte[this.encoding.getDiscreteDimensions(fieldData.fieldInfo.getVectorDimension())];
        byte[] vector = switch (this.encoding) {
            default -> throw new MatchException(null, null);
            case Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.UNSIGNED_BYTE, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.SEVEN_BIT -> scratch;
            case Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.PACKED_NIBBLE, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.SINGLE_BIT_QUERY_NIBBLE, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.DIBIT_QUERY_NIBBLE -> new byte[this.encoding.getDocPackedLength(scratch.length)];
        };
        for (int i = 0; i < fieldData.getVectors().size(); ++i) {
            float[] v = fieldData.getVectors().get(i);
            OptimizedScalarQuantizer.QuantizationResult corrections = scalarQuantizer.scalarQuantize(v, scratch, this.encoding.getBits(), clusterCenter);
            switch (this.encoding) {
                case PACKED_NIBBLE: {
                    OffHeapScalarQuantizedVectorValues.packNibbles(scratch, vector);
                    break;
                }
                case SINGLE_BIT_QUERY_NIBBLE: {
                    OptimizedScalarQuantizer.packAsBinary(scratch, vector);
                    break;
                }
                case DIBIT_QUERY_NIBBLE: {
                    OptimizedScalarQuantizer.transposeDibit(scratch, vector);
                    break;
                }
            }
            this.vectorData.writeBytes(vector, vector.length);
            this.vectorData.writeInt(Float.floatToIntBits(corrections.lowerInterval()));
            this.vectorData.writeInt(Float.floatToIntBits(corrections.upperInterval()));
            this.vectorData.writeInt(Float.floatToIntBits(corrections.additionalCorrection()));
            this.vectorData.writeInt(corrections.quantizedComponentSum());
        }
    }

    private void writeSortingField(FieldWriter fieldData, float[] clusterCenter, int maxDoc, Sorter.DocMap sortMap, OptimizedScalarQuantizer scalarQuantizer) throws IOException {
        int[] ordMap = new int[fieldData.getDocsWithFieldSet().cardinality()];
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        Lucene104ScalarQuantizedVectorsWriter.mapOldOrdToNewOrd(fieldData.getDocsWithFieldSet(), sortMap, null, ordMap, newDocsWithField);
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        this.writeSortedVectors(fieldData, clusterCenter, ordMap, scalarQuantizer);
        long quantizedVectorLength = this.vectorData.getFilePointer() - vectorDataOffset;
        float centroidDp = VectorUtil.dotProduct(clusterCenter, clusterCenter);
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, quantizedVectorLength, clusterCenter, centroidDp, newDocsWithField);
    }

    private void writeSortedVectors(FieldWriter fieldData, float[] clusterCenter, int[] ordMap, OptimizedScalarQuantizer scalarQuantizer) throws IOException {
        byte[] scratch = new byte[this.encoding.getDiscreteDimensions(fieldData.fieldInfo.getVectorDimension())];
        byte[] vector = switch (this.encoding) {
            default -> throw new MatchException(null, null);
            case Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.UNSIGNED_BYTE, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.SEVEN_BIT -> scratch;
            case Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.PACKED_NIBBLE, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.SINGLE_BIT_QUERY_NIBBLE, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.DIBIT_QUERY_NIBBLE -> new byte[this.encoding.getDocPackedLength(scratch.length)];
        };
        for (int ordinal : ordMap) {
            float[] v = fieldData.getVectors().get(ordinal);
            OptimizedScalarQuantizer.QuantizationResult corrections = scalarQuantizer.scalarQuantize(v, scratch, this.encoding.getBits(), clusterCenter);
            switch (this.encoding) {
                case PACKED_NIBBLE: {
                    OffHeapScalarQuantizedVectorValues.packNibbles(scratch, vector);
                    break;
                }
                case SINGLE_BIT_QUERY_NIBBLE: {
                    OptimizedScalarQuantizer.packAsBinary(scratch, vector);
                    break;
                }
                case DIBIT_QUERY_NIBBLE: {
                    OptimizedScalarQuantizer.transposeDibit(scratch, vector);
                    break;
                }
            }
            this.vectorData.writeBytes(vector, vector.length);
            this.vectorData.writeInt(Float.floatToIntBits(corrections.lowerInterval()));
            this.vectorData.writeInt(Float.floatToIntBits(corrections.upperInterval()));
            this.vectorData.writeInt(Float.floatToIntBits(corrections.additionalCorrection()));
            this.vectorData.writeInt(corrections.quantizedComponentSum());
        }
    }

    private void writeMeta(FieldInfo field, int maxDoc, long vectorDataOffset, long vectorDataLength, float[] clusterCenter, float centroidDp, DocsWithFieldSet docsWithField) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVInt(field.getVectorDimension());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        int count = docsWithField.cardinality();
        this.meta.writeVInt(count);
        if (count > 0) {
            this.meta.writeVInt(this.encoding.getWireNumber());
            ByteBuffer buffer = ByteBuffer.allocate(field.getVectorDimension() * 4).order(ByteOrder.LITTLE_ENDIAN);
            buffer.asFloatBuffer().put(clusterCenter);
            this.meta.writeBytes(buffer.array(), buffer.array().length);
            this.meta.writeInt(Float.floatToIntBits(centroidDp));
        }
        OrdToDocDISIReaderConfiguration.writeStoredMeta(16, this.meta, this.vectorData, count, maxDoc, docsWithField);
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.rawVectorDelegate.finish();
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.vectorData != null) {
            CodecUtil.writeFooter(this.vectorData);
        }
    }

    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        if (!fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
            return;
        }
        float[] mergedCentroid = new float[fieldInfo.getVectorDimension()];
        int vectorCount = Lucene104ScalarQuantizedVectorsWriter.mergeAndRecalculateCentroids(mergeState, fieldInfo, mergedCentroid);
        this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
        float[] centroid = mergedCentroid;
        if (this.segmentWriteState.infoStream.isEnabled("QVEC")) {
            this.segmentWriteState.infoStream.message("QVEC", "Vectors' count:" + vectorCount);
        }
        FloatVectorValues floatVectorValues = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
        if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
            floatVectorValues = new NormalizedFloatVectorValues(floatVectorValues);
        }
        QuantizedFloatVectorValues quantizedVectorValues = new QuantizedFloatVectorValues(floatVectorValues, new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction()), this.encoding, centroid);
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        DocsWithFieldSet docsWithField = Lucene104ScalarQuantizedVectorsWriter.writeVectorData(this.vectorData, quantizedVectorValues);
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        float centroidDp = docsWithField.cardinality() > 0 ? VectorUtil.dotProduct(centroid, centroid) : 0.0f;
        this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, centroid, centroidDp, docsWithField);
    }

    static DocsWithFieldSet writeVectorData(IndexOutput output, QuantizedByteVectorValues quantizedByteVectorValues) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        KnnVectorValues.DocIndexIterator iterator = quantizedByteVectorValues.iterator();
        int docV = iterator.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            byte[] binaryValue = quantizedByteVectorValues.vectorValue(iterator.index());
            output.writeBytes(binaryValue, binaryValue.length);
            OptimizedScalarQuantizer.QuantizationResult corrections = quantizedByteVectorValues.getCorrectiveTerms(iterator.index());
            output.writeInt(Float.floatToIntBits(corrections.lowerInterval()));
            output.writeInt(Float.floatToIntBits(corrections.upperInterval()));
            output.writeInt(Float.floatToIntBits(corrections.additionalCorrection()));
            output.writeInt(corrections.quantizedComponentSum());
            docsWithField.add(docV);
            docV = iterator.nextDoc();
        }
        return docsWithField;
    }

    static DocsWithFieldSet writeBinarizedVectorAndQueryData(IndexOutput binarizedVectorData, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, IndexOutput binarizedQueryData, FloatVectorValues floatVectorValues, float[] centroid, OptimizedScalarQuantizer binaryQuantizer) throws IOException {
        if (!encoding.isAsymmetric()) {
            throw new IllegalArgumentException("encoding and queryEncoding must be different");
        }
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        int discretizedDims = encoding.getDiscreteDimensions(floatVectorValues.dimension());
        byte[][] quantizationScratch = new byte[][]{new byte[discretizedDims], new byte[discretizedDims]};
        byte[] toIndex = new byte[encoding.getDocPackedLength(discretizedDims)];
        byte[] toQuery = new byte[encoding.getQueryPackedLength(discretizedDims)];
        KnnVectorValues.DocIndexIterator iterator = floatVectorValues.iterator();
        int docV = iterator.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            OptimizedScalarQuantizer.QuantizationResult[] r = binaryQuantizer.multiScalarQuantize(floatVectorValues.vectorValue(iterator.index()), quantizationScratch, new byte[]{encoding.getBits(), encoding.getQueryBits()}, centroid);
            switch (encoding) {
                case SINGLE_BIT_QUERY_NIBBLE: {
                    OptimizedScalarQuantizer.packAsBinary(quantizationScratch[0], toIndex);
                    break;
                }
                case DIBIT_QUERY_NIBBLE: {
                    OptimizedScalarQuantizer.transposeDibit(quantizationScratch[0], toIndex);
                    break;
                }
                case UNSIGNED_BYTE: 
                case SEVEN_BIT: 
                case PACKED_NIBBLE: {
                    throw new IllegalArgumentException("Unsupported asymmetric encoding: " + String.valueOf((Object)encoding));
                }
            }
            binarizedVectorData.writeBytes(toIndex, toIndex.length);
            binarizedVectorData.writeInt(Float.floatToIntBits(r[0].lowerInterval()));
            binarizedVectorData.writeInt(Float.floatToIntBits(r[0].upperInterval()));
            binarizedVectorData.writeInt(Float.floatToIntBits(r[0].additionalCorrection()));
            binarizedVectorData.writeInt(r[0].quantizedComponentSum());
            docsWithField.add(docV);
            OptimizedScalarQuantizer.transposeHalfByte(quantizationScratch[1], toQuery);
            binarizedQueryData.writeBytes(toQuery, toQuery.length);
            binarizedQueryData.writeInt(Float.floatToIntBits(r[1].lowerInterval()));
            binarizedQueryData.writeInt(Float.floatToIntBits(r[1].upperInterval()));
            binarizedQueryData.writeInt(Float.floatToIntBits(r[1].additionalCorrection()));
            binarizedQueryData.writeInt(r[1].quantizedComponentSum());
            docV = iterator.nextDoc();
        }
        return docsWithField;
    }

    @Override
    public CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        float cDotC;
        if (!fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            return this.rawVectorDelegate.mergeOneFieldToIndex(fieldInfo, mergeState);
        }
        float[] mergedCentroid = new float[fieldInfo.getVectorDimension()];
        int vectorCount = Lucene104ScalarQuantizedVectorsWriter.mergeAndRecalculateCentroids(mergeState, fieldInfo, mergedCentroid);
        this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
        float[] centroid = mergedCentroid;
        float f = cDotC = vectorCount > 0 ? VectorUtil.dotProduct(centroid, centroid) : 0.0f;
        if (this.segmentWriteState.infoStream.isEnabled("QVEC")) {
            this.segmentWriteState.infoStream.message("QVEC", "Vectors' count:" + vectorCount);
        }
        return this.mergeOneFieldToIndex(this.segmentWriteState, fieldInfo, mergeState, centroid, cDotC);
    }

    private CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(SegmentWriteState segmentWriteState, FieldInfo fieldInfo, MergeState mergeState, float[] centroid, float cDotC) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        IndexOutput tempQuantizedVectorData = null;
        IndexOutput tempScoreQuantizedVectorData = null;
        IndexInput quantizedDataInput = null;
        IndexInput quantizedScoreDataInput = null;
        OptimizedScalarQuantizer quantizer = new OptimizedScalarQuantizer(fieldInfo.getVectorSimilarityFunction());
        try {
            String tempScoreQuantizedVectorName;
            tempQuantizedVectorData = segmentWriteState.directory.createTempOutput(this.vectorData.getName(), "temp", segmentWriteState.context);
            String tempQuantizedVectorName = tempQuantizedVectorData.getName();
            if (this.encoding.isAsymmetric()) {
                tempScoreQuantizedVectorData = segmentWriteState.directory.createTempOutput(this.vectorData.getName() + "_score", "temp", segmentWriteState.context);
                tempScoreQuantizedVectorName = tempScoreQuantizedVectorData.getName();
            } else {
                tempScoreQuantizedVectorName = null;
            }
            FloatVectorValues floatVectorValues = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
            if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                floatVectorValues = new NormalizedFloatVectorValues(floatVectorValues);
            }
            DocsWithFieldSet docsWithField = this.encoding.isAsymmetric() ? Lucene104ScalarQuantizedVectorsWriter.writeBinarizedVectorAndQueryData(tempQuantizedVectorData, this.encoding, tempScoreQuantizedVectorData, floatVectorValues, centroid, quantizer) : Lucene104ScalarQuantizedVectorsWriter.writeVectorData(tempQuantizedVectorData, new QuantizedFloatVectorValues(floatVectorValues, quantizer, this.encoding, centroid));
            CodecUtil.writeFooter(tempQuantizedVectorData);
            IOUtils.close(tempQuantizedVectorData);
            quantizedDataInput = segmentWriteState.directory.openInput(tempQuantizedVectorName, segmentWriteState.context);
            this.vectorData.copyBytes(quantizedDataInput, quantizedDataInput.length() - (long)CodecUtil.footerLength());
            long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
            CodecUtil.retrieveChecksum(quantizedDataInput);
            if (tempScoreQuantizedVectorData != null) {
                CodecUtil.writeFooter(tempScoreQuantizedVectorData);
                IOUtils.close(tempScoreQuantizedVectorData);
                quantizedScoreDataInput = segmentWriteState.directory.openInput(tempScoreQuantizedVectorName, segmentWriteState.context);
            }
            this.writeMeta(fieldInfo, segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, centroid, cDotC, docsWithField);
            IndexInput finalQuantizedDataInput = quantizedDataInput;
            IndexInput finalQuantizedScoreDataInput = quantizedScoreDataInput;
            tempQuantizedVectorData = null;
            tempScoreQuantizedVectorData = null;
            quantizedDataInput = null;
            quantizedScoreDataInput = null;
            OffHeapScalarQuantizedVectorValues.DenseOffHeapVectorValues vectorValues = new OffHeapScalarQuantizedVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), centroid, cDotC, quantizer, this.encoding, fieldInfo.getVectorSimilarityFunction(), this.vectorsScorer, finalQuantizedDataInput);
            OffHeapScalarQuantizedVectorValues.DenseOffHeapVectorValues scoreVectorValues = null;
            if (finalQuantizedScoreDataInput != null) {
                scoreVectorValues = new OffHeapScalarQuantizedVectorValues.DenseOffHeapVectorValues(true, fieldInfo.getVectorDimension(), docsWithField.cardinality(), centroid, cDotC, quantizer, this.encoding, fieldInfo.getVectorSimilarityFunction(), this.vectorsScorer, finalQuantizedScoreDataInput);
            }
            RandomVectorScorerSupplier scorerSupplier = scoreVectorValues == null ? this.vectorsScorer.getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), vectorValues) : this.vectorsScorer.getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), scoreVectorValues, vectorValues);
            return new QuantizedCloseableRandomVectorScorerSupplier(scorerSupplier, vectorValues, () -> {
                IOUtils.close(finalQuantizedDataInput, finalQuantizedScoreDataInput);
                if (tempScoreQuantizedVectorName != null) {
                    IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempScoreQuantizedVectorName);
                }
                IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempQuantizedVectorName);
            });
        }
        catch (Throwable t) {
            IOUtils.closeWhileHandlingException(tempQuantizedVectorData, tempScoreQuantizedVectorData, quantizedDataInput, quantizedScoreDataInput);
            if (tempQuantizedVectorData != null) {
                IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempQuantizedVectorData.getName());
            }
            if (tempScoreQuantizedVectorData != null) {
                IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempScoreQuantizedVectorData.getName());
            }
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.vectorData, this.rawVectorDelegate);
    }

    static float[] getCentroid(KnnVectorsReader vectorsReader, String fieldName) {
        if (vectorsReader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
            PerFieldKnnVectorsFormat.FieldsReader candidateReader = (PerFieldKnnVectorsFormat.FieldsReader)vectorsReader;
            vectorsReader = candidateReader.getFieldReader(fieldName);
        }
        if (vectorsReader instanceof Lucene104ScalarQuantizedVectorsReader) {
            Lucene104ScalarQuantizedVectorsReader reader = (Lucene104ScalarQuantizedVectorsReader)vectorsReader;
            return reader.getCentroid(fieldName);
        }
        return null;
    }

    static int mergeAndRecalculateCentroids(MergeState mergeState, FieldInfo fieldInfo, float[] mergedCentroid) throws IOException {
        boolean recalculate = false;
        int totalVectorCount = 0;
        for (int i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
            KnnVectorsReader knnVectorsReader = mergeState.knnVectorsReaders[i];
            if (knnVectorsReader == null || knnVectorsReader.getFloatVectorValues(fieldInfo.name) == null) continue;
            float[] centroid = Lucene104ScalarQuantizedVectorsWriter.getCentroid(knnVectorsReader, fieldInfo.name);
            int vectorCount = knnVectorsReader.getFloatVectorValues(fieldInfo.name).size();
            if (vectorCount == 0) continue;
            totalVectorCount += vectorCount;
            if (centroid == null || mergeState.liveDocs[i] != null) {
                recalculate = true;
                break;
            }
            for (int j = 0; j < centroid.length; ++j) {
                int n = j;
                mergedCentroid[n] = mergedCentroid[n] + centroid[j] * (float)vectorCount;
            }
        }
        if (totalVectorCount == 0) {
            return 0;
        }
        if (recalculate) {
            return Lucene104ScalarQuantizedVectorsWriter.calculateCentroid(mergeState, fieldInfo, mergedCentroid);
        }
        for (int j = 0; j < mergedCentroid.length; ++j) {
            mergedCentroid[j] = mergedCentroid[j] / (float)totalVectorCount;
        }
        if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
            VectorUtil.l2normalize(mergedCentroid);
        }
        return totalVectorCount;
    }

    static int calculateCentroid(MergeState mergeState, FieldInfo fieldInfo, float[] centroid) throws IOException {
        int i;
        assert (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32));
        Arrays.fill(centroid, 0.0f);
        int count = 0;
        for (i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
            FloatVectorValues vectorValues;
            KnnVectorsReader knnVectorsReader = mergeState.knnVectorsReaders[i];
            if (knnVectorsReader == null || (vectorValues = mergeState.knnVectorsReaders[i].getFloatVectorValues(fieldInfo.name)) == null) continue;
            KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                ++count;
                float[] vector = vectorValues.vectorValue(iterator.index());
                for (int j = 0; j < vector.length; ++j) {
                    int n = j;
                    centroid[n] = centroid[n] + vector[j];
                }
                doc = iterator.nextDoc();
            }
        }
        if (count == 0) {
            return count;
        }
        i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / (float)count;
        }
        if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
            VectorUtil.l2normalize(centroid);
        }
        return count;
    }

    @Override
    public long ramBytesUsed() {
        long total = SHALLOW_RAM_BYTES_USED;
        for (FieldWriter field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    static class FieldWriter
    extends FlatFieldVectorsWriter<float[]> {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldWriter.class);
        private final FieldInfo fieldInfo;
        private boolean finished;
        private final FlatFieldVectorsWriter<float[]> flatFieldVectorsWriter;
        private final float[] dimensionSums;
        private final FloatArrayList magnitudes = new FloatArrayList();

        FieldWriter(FieldInfo fieldInfo, FlatFieldVectorsWriter<float[]> flatFieldVectorsWriter) {
            this.fieldInfo = fieldInfo;
            this.flatFieldVectorsWriter = flatFieldVectorsWriter;
            this.dimensionSums = new float[fieldInfo.getVectorDimension()];
        }

        @Override
        public List<float[]> getVectors() {
            return this.flatFieldVectorsWriter.getVectors();
        }

        public void normalizeVectors() {
            for (int i = 0; i < this.flatFieldVectorsWriter.getVectors().size(); ++i) {
                float[] vector = this.flatFieldVectorsWriter.getVectors().get(i);
                float magnitude = this.magnitudes.get(i);
                int j = 0;
                while (j < vector.length) {
                    int n = j++;
                    vector[n] = vector[n] / magnitude;
                }
            }
        }

        @Override
        public DocsWithFieldSet getDocsWithFieldSet() {
            return this.flatFieldVectorsWriter.getDocsWithFieldSet();
        }

        @Override
        public void finish() throws IOException {
            if (this.finished) {
                return;
            }
            assert (this.flatFieldVectorsWriter.isFinished());
            this.finished = true;
        }

        @Override
        public boolean isFinished() {
            return this.finished && this.flatFieldVectorsWriter.isFinished();
        }

        @Override
        public void addValue(int docID, float[] vectorValue) throws IOException {
            this.flatFieldVectorsWriter.addValue(docID, vectorValue);
            if (this.fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                float dp = VectorUtil.dotProduct(vectorValue, vectorValue);
                float divisor = (float)Math.sqrt(dp);
                this.magnitudes.add(divisor);
                for (int i = 0; i < vectorValue.length; ++i) {
                    int n = i;
                    this.dimensionSums[n] = this.dimensionSums[n] + vectorValue[i] / divisor;
                }
            } else {
                for (int i = 0; i < vectorValue.length; ++i) {
                    int n = i;
                    this.dimensionSums[n] = this.dimensionSums[n] + vectorValue[i];
                }
            }
        }

        @Override
        public float[] copyValue(float[] vectorValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long ramBytesUsed() {
            long size = SHALLOW_SIZE;
            size += this.flatFieldVectorsWriter.ramBytesUsed();
            return size += this.magnitudes.ramBytesUsed();
        }
    }

    static final class NormalizedFloatVectorValues
    extends FloatVectorValues {
        private final FloatVectorValues values;
        private final float[] normalizedVector;

        NormalizedFloatVectorValues(FloatVectorValues values) {
            this.values = values;
            this.normalizedVector = new float[values.dimension()];
        }

        @Override
        public int dimension() {
            return this.values.dimension();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public int ordToDoc(int ord) {
            return this.values.ordToDoc(ord);
        }

        @Override
        public float[] vectorValue(int ord) throws IOException {
            System.arraycopy(this.values.vectorValue(ord), 0, this.normalizedVector, 0, this.normalizedVector.length);
            VectorUtil.l2normalize(this.normalizedVector);
            return this.normalizedVector;
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.values.iterator();
        }

        @Override
        public NormalizedFloatVectorValues copy() throws IOException {
            return new NormalizedFloatVectorValues(this.values.copy());
        }
    }

    static class QuantizedFloatVectorValues
    extends QuantizedByteVectorValues {
        private OptimizedScalarQuantizer.QuantizationResult corrections;
        private final byte[] quantized;
        private final byte[] packed;
        private final float[] centroid;
        private final float centroidDP;
        private final FloatVectorValues values;
        private final OptimizedScalarQuantizer quantizer;
        private final Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding;
        private int lastOrd = -1;

        QuantizedFloatVectorValues(FloatVectorValues delegate, OptimizedScalarQuantizer quantizer, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, float[] centroid) {
            this.values = delegate;
            this.quantizer = quantizer;
            this.encoding = encoding;
            this.quantized = new byte[encoding.getDiscreteDimensions(delegate.dimension())];
            this.packed = switch (encoding) {
                default -> throw new MatchException(null, null);
                case Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.UNSIGNED_BYTE, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.SEVEN_BIT -> this.quantized;
                case Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.PACKED_NIBBLE, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.SINGLE_BIT_QUERY_NIBBLE, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.DIBIT_QUERY_NIBBLE -> new byte[encoding.getDocPackedLength(this.quantized.length)];
            };
            this.centroid = centroid;
            this.centroidDP = VectorUtil.dotProduct(centroid, centroid);
        }

        @Override
        public OptimizedScalarQuantizer.QuantizationResult getCorrectiveTerms(int ord) {
            if (ord != this.lastOrd) {
                throw new IllegalStateException("attempt to retrieve corrective terms for different ord " + ord + " than the quantization was done for: " + this.lastOrd);
            }
            return this.corrections;
        }

        @Override
        public byte[] vectorValue(int ord) throws IOException {
            if (ord != this.lastOrd) {
                this.quantize(ord);
                this.lastOrd = ord;
            }
            return this.packed;
        }

        @Override
        public int dimension() {
            return this.values.dimension();
        }

        @Override
        public OptimizedScalarQuantizer getQuantizer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding getScalarEncoding() {
            return this.encoding;
        }

        @Override
        public float[] getCentroid() throws IOException {
            return this.centroid;
        }

        @Override
        public float getCentroidDP() {
            return this.centroidDP;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public QuantizedByteVectorValues copy() throws IOException {
            return new QuantizedFloatVectorValues(this.values.copy(), this.quantizer, this.encoding, this.centroid);
        }

        private void quantize(int ord) throws IOException {
            this.corrections = this.quantizer.scalarQuantize(this.values.vectorValue(ord), this.quantized, this.encoding.getBits(), this.centroid);
            switch (this.encoding) {
                case PACKED_NIBBLE: {
                    OffHeapScalarQuantizedVectorValues.packNibbles(this.quantized, this.packed);
                    break;
                }
                case SINGLE_BIT_QUERY_NIBBLE: {
                    OptimizedScalarQuantizer.packAsBinary(this.quantized, this.packed);
                    break;
                }
                case DIBIT_QUERY_NIBBLE: {
                    OptimizedScalarQuantizer.transposeDibit(this.quantized, this.packed);
                    break;
                }
            }
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.values.iterator();
        }

        @Override
        public int ordToDoc(int ord) {
            return this.values.ordToDoc(ord);
        }
    }

    static class QuantizedCloseableRandomVectorScorerSupplier
    implements CloseableRandomVectorScorerSupplier {
        private final RandomVectorScorerSupplier supplier;
        private final KnnVectorValues vectorValues;
        private final Closeable onClose;

        QuantizedCloseableRandomVectorScorerSupplier(RandomVectorScorerSupplier supplier, KnnVectorValues vectorValues, Closeable onClose) {
            this.supplier = supplier;
            this.onClose = onClose;
            this.vectorValues = vectorValues;
        }

        @Override
        public UpdateableRandomVectorScorer scorer() throws IOException {
            return this.supplier.scorer();
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return this.supplier.copy();
        }

        @Override
        public void close() throws IOException {
            this.onClose.close();
        }

        @Override
        public int totalVectorCount() {
            return this.vectorValues.size();
        }
    }
}

