/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.LongsRef;

public final class FreqAndNormBuffer {
    public int[] freqs = IntsRef.EMPTY_INTS;
    public long[] norms = LongsRef.EMPTY_LONGS;
    public int size;

    public void growNoCopy(int minSize) {
        if (this.freqs.length < minSize) {
            this.freqs = new int[ArrayUtil.oversize(minSize, 4)];
            this.norms = new long[this.freqs.length];
        }
    }

    public void add(int freq, long norm) {
        if (this.freqs.length == this.size) {
            this.freqs = ArrayUtil.grow(this.freqs, this.size + 1);
            this.norms = ArrayUtil.growExact(this.norms, this.freqs.length);
        }
        this.freqs[this.size] = freq;
        this.norms[this.size] = norm;
        ++this.size;
    }
}

