/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.search.AbstractDocIdSetIterator;
import org.apache.lucene.util.FixedBitSet;

public class SkipBlockRangeIterator
extends AbstractDocIdSetIterator {
    private final DocValuesSkipper skipper;
    private final long minValue;
    private final long maxValue;

    public SkipBlockRangeIterator(DocValuesSkipper skipper, long minValue, long maxValue) {
        this.skipper = skipper;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public int nextDoc() throws IOException {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int target) throws IOException {
        if (target <= this.skipper.maxDocID(0)) {
            if (this.doc > -1) {
                this.doc = target;
                return this.doc;
            }
        } else {
            this.skipper.advance(target);
        }
        this.skipper.advance(this.minValue, this.maxValue);
        this.doc = Math.max(target, this.skipper.minDocID(0));
        return this.doc;
    }

    @Override
    public long cost() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int docIDRunEnd() throws IOException {
        int maxDoc = this.skipper.maxDocID(0);
        for (int nextLevel = 1; nextLevel < this.skipper.numLevels() && this.skipper.minValue(nextLevel) < this.maxValue && this.skipper.maxValue(nextLevel) > this.minValue; ++nextLevel) {
            maxDoc = this.skipper.maxDocID(nextLevel);
        }
        return maxDoc + 1;
    }

    @Override
    public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
        while (this.doc < upTo) {
            int end = Math.min(upTo, this.docIDRunEnd());
            bitSet.set(this.doc - offset, end - offset);
            this.advance(end);
        }
    }
}

