/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Locale;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FilteredDocIdSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LiveDocs;

public final class DenseLiveDocs
implements LiveDocs {
    private final FixedBitSet liveDocs;
    private final int maxDoc;
    private final int deletedCount;

    public static Builder builder(FixedBitSet liveDocs, int maxDoc) {
        return new Builder(liveDocs, maxDoc);
    }

    private DenseLiveDocs(FixedBitSet liveDocs, int maxDoc, int deletedCount) {
        assert (liveDocs.length() >= maxDoc);
        this.maxDoc = maxDoc;
        this.liveDocs = liveDocs;
        this.deletedCount = deletedCount;
    }

    @Override
    public boolean get(int index) {
        return this.liveDocs.get(index);
    }

    @Override
    public int length() {
        return this.maxDoc;
    }

    @Override
    public DocIdSetIterator liveDocsIterator() {
        return new BitSetIterator(this.liveDocs, this.maxDoc - this.deletedCount);
    }

    @Override
    public DocIdSetIterator deletedDocsIterator() {
        return new FilteredDocIdSetIterator(this.maxDoc, this.deletedCount, doc -> !this.liveDocs.get(doc));
    }

    @Override
    public int deletedCount() {
        return this.deletedCount;
    }

    public long ramBytesUsed() {
        return this.liveDocs.ramBytesUsed();
    }

    public String toString() {
        return "DenseLiveDocs(maxDoc=" + this.maxDoc + ", deleted=" + this.deletedCount() + ", deletionRate=" + String.format(Locale.ROOT, "%.2f%%", 100.0 * (double)this.deletedCount() / (double)this.maxDoc) + ")";
    }

    public static final class Builder {
        private final FixedBitSet liveDocs;
        private final int maxDoc;
        private Integer deletedCount;

        private Builder(FixedBitSet liveDocs, int maxDoc) {
            this.liveDocs = liveDocs;
            this.maxDoc = maxDoc;
        }

        public Builder withDeletedCount(int deletedCount) {
            this.deletedCount = deletedCount;
            return this;
        }

        public DenseLiveDocs build() {
            int count;
            int n = count = this.deletedCount != null ? this.deletedCount : this.maxDoc - this.liveDocs.cardinality();
            if (count < 0 || count > this.maxDoc) {
                throw new IllegalArgumentException("deletedCount=" + count + " is outside valid range [0, " + this.maxDoc + "]");
            }
            assert (count == this.maxDoc - this.liveDocs.cardinality()) : "deletedCount=" + count + " does not match maxDoc - liveDocs.cardinality()=" + (this.maxDoc - this.liveDocs.cardinality());
            return new DenseLiveDocs(this.liveDocs, this.maxDoc, count);
        }
    }
}

