/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.function.IntPredicate;
import org.apache.lucene.search.DocIdSetIterator;

final class FilteredDocIdSetIterator
extends DocIdSetIterator {
    private final int maxDoc;
    private final int cost;
    private final IntPredicate predicate;
    private int doc = -1;

    FilteredDocIdSetIterator(int maxDoc, int cost, IntPredicate predicate) {
        this.maxDoc = maxDoc;
        this.cost = cost;
        this.predicate = predicate;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() {
        return this.advance(this.doc + 1);
    }

    @Override
    public int advance(int target) {
        if (target >= this.maxDoc) {
            this.doc = Integer.MAX_VALUE;
            return this.doc;
        }
        this.doc = target;
        while (this.doc < this.maxDoc) {
            if (this.predicate.test(this.doc)) {
                return this.doc;
            }
            ++this.doc;
        }
        this.doc = Integer.MAX_VALUE;
        return this.doc;
    }

    @Override
    public long cost() {
        return this.cost;
    }
}

