/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;

public final class TernaryLongHeap {
    private final int initialCapacity;
    private long[] heap;
    private int size = 0;
    private static final int ARITY = 3;

    public TernaryLongHeap(int size, long initialValue) {
        this(size <= 0 ? 1 : size);
        Arrays.fill(this.heap, 1, size + 1, initialValue);
        this.size = size;
    }

    public TernaryLongHeap(int initialCapacity) {
        if (initialCapacity < 1 || initialCapacity >= ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("initialCapacity must be > 0 and < " + (ArrayUtil.MAX_ARRAY_LENGTH - 1) + "; got: " + initialCapacity);
        }
        int heapSize = initialCapacity + 1;
        this.initialCapacity = initialCapacity;
        this.heap = new long[heapSize];
    }

    public long push(long element) {
        ++this.size;
        if (this.size == this.heap.length) {
            this.heap = ArrayUtil.grow(this.heap, (this.size * 3 + 1) / 2);
        }
        this.heap[this.size] = element;
        TernaryLongHeap.upHeap(this.heap, this.size, 3);
        return this.heap[1];
    }

    public boolean insertWithOverflow(long value) {
        if (this.size >= this.initialCapacity) {
            if (value < this.heap[1]) {
                return false;
            }
            this.updateTop(value);
            return true;
        }
        this.push(value);
        return true;
    }

    public long top() {
        return this.heap[1];
    }

    public long pop() {
        if (this.size > 0) {
            long result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            --this.size;
            TernaryLongHeap.downHeap(this.heap, 1, this.size, 3);
            return result;
        }
        throw new IllegalStateException("The heap is empty");
    }

    public long updateTop(long value) {
        this.heap[1] = value;
        TernaryLongHeap.downHeap(this.heap, 1, this.size, 3);
        return this.heap[1];
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void pushAll(TernaryLongHeap other) {
        for (int i = 1; i <= other.size; ++i) {
            this.push(other.heap[i]);
        }
    }

    public long get(int i) {
        return this.heap[i];
    }

    long[] getHeapArray() {
        return this.heap;
    }

    static void upHeap(long[] heap, int i, int arity) {
        int parent;
        long parentVal;
        long value = heap[i];
        while (i > 1 && value < (parentVal = heap[parent = (i - 2) / arity + 1])) {
            heap[i] = parentVal;
            i = parent;
        }
        heap[i] = value;
    }

    static void downHeap(long[] heap, int i, int size, int arity) {
        int firstChild;
        long value = heap[i];
        while ((firstChild = arity * (i - 1) + 2) <= size) {
            int lastChild = Math.min(firstChild + arity - 1, size);
            int best = firstChild;
            long bestVal = heap[firstChild];
            for (int c = firstChild + 1; c <= lastChild; ++c) {
                long v = heap[c];
                if (v >= bestVal) continue;
                bestVal = v;
                best = c;
            }
            if (bestVal >= value) break;
            heap[i] = bestVal;
            i = best;
        }
        heap[i] = value;
    }
}

