/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.HnswGraphProvider;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.internal.hppc.IntIntHashMap;
import org.apache.lucene.search.TaskExecutor;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.hnsw.HnswBuilder;
import org.apache.lucene.util.hnsw.HnswConcurrentMergeBuilder;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.IncrementalHnswGraphMerger;
import org.apache.lucene.util.hnsw.InitializedHnswGraphBuilder;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;

public class ConcurrentHnswMerger
extends IncrementalHnswGraphMerger {
    private final TaskExecutor taskExecutor;
    private final int numWorker;

    public ConcurrentHnswMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, TaskExecutor taskExecutor, int numWorker) {
        super(fieldInfo, scorerSupplier, M, beamWidth);
        this.taskExecutor = taskExecutor;
        this.numWorker = numWorker;
    }

    @Override
    protected HnswBuilder createBuilder(KnnVectorValues mergedVectorValues, int maxOrd) throws IOException {
        OnHeapHnswGraph graph;
        FixedBitSet initializedNodes = null;
        if (this.largestGraphReader == null) {
            graph = new OnHeapHnswGraph(this.M, maxOrd);
        } else {
            KnnVectorsReader initReader = this.largestGraphReader.reader();
            MergeState.DocMap initDocMap = this.largestGraphReader.initDocMap();
            int initGraphSize = this.largestGraphReader.graphSize();
            HnswGraph initializerGraph = ((HnswGraphProvider)((Object)initReader)).getGraph(this.fieldInfo.name);
            if (initializerGraph.size() == 0) {
                graph = new OnHeapHnswGraph(this.M, maxOrd);
            } else {
                initializedNodes = new FixedBitSet(maxOrd);
                int[] oldToNewOrdinalMap = ConcurrentHnswMerger.getNewOrdMapping(this.fieldInfo, initReader, initDocMap, initGraphSize, mergedVectorValues, initializedNodes);
                graph = InitializedHnswGraphBuilder.initGraph(initializerGraph, oldToNewOrdinalMap, maxOrd, this.beamWidth, this.scorerSupplier);
            }
        }
        return new HnswConcurrentMergeBuilder(this.taskExecutor, this.numWorker, this.scorerSupplier, this.M, this.beamWidth, graph, initializedNodes);
    }

    private static int[] getNewOrdMapping(FieldInfo fieldInfo, KnnVectorsReader initReader, MergeState.DocMap initDocMap, int initGraphSize, KnnVectorValues mergedVectorValues, BitSet initializedNodes) throws IOException {
        KnnVectorValues.DocIndexIterator initializerIterator = null;
        switch (fieldInfo.getVectorEncoding()) {
            case BYTE: {
                initializerIterator = initReader.getByteVectorValues(fieldInfo.name).iterator();
                break;
            }
            case FLOAT32: {
                initializerIterator = initReader.getFloatVectorValues(fieldInfo.name).iterator();
            }
        }
        IntIntHashMap newIdToOldOrdinal = new IntIntHashMap(initGraphSize);
        int maxNewDocID = -1;
        int docId = initializerIterator.nextDoc();
        while (docId != Integer.MAX_VALUE) {
            int newId = initDocMap.get(docId);
            if (newId != -1) {
                maxNewDocID = Math.max(newId, maxNewDocID);
                assert (!newIdToOldOrdinal.containsKey(newId));
                newIdToOldOrdinal.put(newId, initializerIterator.index());
            }
            docId = initializerIterator.nextDoc();
        }
        if (maxNewDocID == -1) {
            return new int[0];
        }
        int[] oldToNewOrdinalMap = new int[initGraphSize];
        Arrays.fill(oldToNewOrdinalMap, -1);
        KnnVectorValues.DocIndexIterator mergedVectorIterator = mergedVectorValues.iterator();
        int newDocId = mergedVectorIterator.nextDoc();
        while (newDocId <= maxNewDocID) {
            int oldOrd = newIdToOldOrdinal.getOrDefault(newDocId, -1);
            if (oldOrd != -1) {
                int newOrd = mergedVectorIterator.index();
                initializedNodes.set(newOrd);
                oldToNewOrdinalMap[oldOrd] = newOrd;
            }
            newDocId = mergedVectorIterator.nextDoc();
        }
        return oldToNewOrdinalMap;
    }
}

