/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.internal.hppc.IntCursor;

public abstract class HnswGraph {
    public static final int UNKNOWN_MAX_CONN = -1;
    public static final HnswGraph EMPTY = new HnswGraph(){

        @Override
        public int nextNeighbor() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void seek(int level, int target) {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int numLevels() {
            return 0;
        }

        @Override
        public int entryNode() {
            return 0;
        }

        @Override
        public int neighborCount() {
            return 0;
        }

        @Override
        public int maxConn() {
            return -1;
        }

        @Override
        public NodesIterator getNodesOnLevel(int level) {
            return DenseNodesIterator.EMPTY;
        }
    };

    protected HnswGraph() {
    }

    public abstract void seek(int var1, int var2) throws IOException;

    public abstract int size();

    public int maxNodeId() {
        return this.size() - 1;
    }

    public abstract int nextNeighbor() throws IOException;

    public abstract int numLevels() throws IOException;

    public abstract int maxConn();

    public abstract int entryNode() throws IOException;

    public abstract NodesIterator getNodesOnLevel(int var1) throws IOException;

    public abstract int neighborCount();

    public NodesIterator getSortedNodes(int level) throws IOException {
        if (level == 0) {
            return new DenseNodesIterator(this.size());
        }
        NodesIterator nodesOnLevel = this.getNodesOnLevel(level);
        int[] sortedNodes = new int[nodesOnLevel.size()];
        int n = 0;
        while (nodesOnLevel.hasNext()) {
            sortedNodes[n] = nodesOnLevel.nextInt();
            ++n;
        }
        Arrays.sort(sortedNodes);
        return new ArrayNodesIterator(sortedNodes);
    }

    public static class DenseNodesIterator
    extends NodesIterator {
        private static final NodesIterator EMPTY = new DenseNodesIterator(0);
        private int cur = 0;

        public DenseNodesIterator(int size) {
            super(size);
        }

        @Override
        public int consume(int[] dest) {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int numToCopy = Math.min(this.size - this.cur, dest.length);
            for (int i = 0; i < numToCopy; ++i) {
                dest[i] = this.cur + i;
            }
            return numToCopy;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.cur++;
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.size;
        }
    }

    public static abstract class NodesIterator
    implements PrimitiveIterator.OfInt {
        protected final int size;

        public NodesIterator(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }

        public abstract int consume(int[] var1);
    }

    public static class ArrayNodesIterator
    extends NodesIterator {
        private final int[] nodes;
        private int cur = 0;

        public ArrayNodesIterator(int[] nodes) {
            this(nodes, nodes.length);
        }

        public ArrayNodesIterator(int[] nodes, int size) {
            super(size);
            this.nodes = nodes;
        }

        @Override
        public int consume(int[] dest) {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int numToCopy = Math.min(this.size - this.cur, dest.length);
            System.arraycopy(this.nodes, this.cur, dest, 0, numToCopy);
            this.cur += numToCopy;
            return numToCopy;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nodes[this.cur++];
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.size;
        }
    }

    public static class CollectionNodesIterator
    extends NodesIterator {
        Iterator<IntCursor> nodes;

        public CollectionNodesIterator(IntArrayList nodes) {
            super(nodes.size());
            this.nodes = nodes.iterator();
        }

        @Override
        public int consume(int[] dest) {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int destIndex = 0;
            while (this.hasNext() && destIndex < dest.length) {
                dest[destIndex++] = this.nextInt();
            }
            return destIndex;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nodes.next().value;
        }

        @Override
        public boolean hasNext() {
            return this.nodes.hasNext();
        }
    }
}

