/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.TopKnnCollector;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.hnsw.AbstractHnswGraphSearcher;
import org.apache.lucene.util.hnsw.FilteredHnswGraphSearcher;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.NeighborQueue;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.SeededHnswGraphSearcher;

public class HnswGraphSearcher
extends AbstractHnswGraphSearcher {
    protected final NeighborQueue candidates;
    protected BitSet visited;
    protected int[] bulkNodes = null;
    protected float[] bulkScores = null;

    public static int expectedVisitedNodes(int k, int graphSize) {
        return (int)(Math.log(graphSize) * (double)k);
    }

    static BitSet createBitSet(int k, int graphSize) {
        return HnswGraphSearcher.expectedVisitedNodes(k, graphSize) < graphSize >>> 7 ? new SparseFixedBitSet(graphSize) : new FixedBitSet(graphSize);
    }

    public HnswGraphSearcher(NeighborQueue candidates, BitSet visited) {
        this.candidates = candidates;
        this.visited = visited;
    }

    public static void search(RandomVectorScorer scorer, KnnCollector knnCollector, HnswGraph graph, Bits acceptOrds) throws IOException {
        int filteredDocCount = 0;
        if (acceptOrds instanceof BitSet) {
            BitSet bitSet = (BitSet)acceptOrds;
            filteredDocCount = Math.min(bitSet.approximateCardinality(), graph.size());
        }
        HnswGraphSearcher.search(scorer, knnCollector, graph, acceptOrds, filteredDocCount);
    }

    public static void search(RandomVectorScorer scorer, KnnCollector knnCollector, HnswGraph graph, Bits acceptOrds, int filteredDocCount) throws IOException {
        KnnSearchStrategy.Seeded seeded;
        KnnSearchStrategy.Hnsw hnsw;
        KnnSearchStrategy.Seeded seeded2;
        KnnSearchStrategy.Hnsw hnsw2;
        assert (filteredDocCount >= 0 && filteredDocCount <= graph.size());
        KnnSearchStrategy knnSearchStrategy = knnCollector.getSearchStrategy();
        KnnSearchStrategy.Hnsw hnswStrategy = knnSearchStrategy instanceof KnnSearchStrategy.Hnsw ? (hnsw2 = (KnnSearchStrategy.Hnsw)knnSearchStrategy) : ((knnSearchStrategy = knnCollector.getSearchStrategy()) instanceof KnnSearchStrategy.Seeded && (knnSearchStrategy = (seeded2 = (KnnSearchStrategy.Seeded)knnSearchStrategy).originalStrategy()) instanceof KnnSearchStrategy.Hnsw ? (hnsw = (KnnSearchStrategy.Hnsw)knnSearchStrategy) : KnnSearchStrategy.Hnsw.DEFAULT);
        HnswGraphSearcher innerSearcher = acceptOrds != null && graph.maxConn() != -1 && filteredDocCount > 0 && hnswStrategy.useFilteredSearch((float)filteredDocCount / (float)graph.size()) ? FilteredHnswGraphSearcher.create(knnCollector.k(), graph, filteredDocCount, acceptOrds) : new HnswGraphSearcher(new NeighborQueue(knnCollector.k(), true), HnswGraphSearcher.createBitSet(knnCollector.k(), HnswGraphSearcher.getGraphSize(graph)));
        knnSearchStrategy = knnCollector.getSearchStrategy();
        AbstractHnswGraphSearcher graphSearcher = knnSearchStrategy instanceof KnnSearchStrategy.Seeded && (seeded = (KnnSearchStrategy.Seeded)knnSearchStrategy).numberOfEntryPoints() > 0 ? SeededHnswGraphSearcher.fromEntryPoints(innerSearcher, seeded.numberOfEntryPoints(), seeded.entryPoints(), graph.size()) : innerSearcher;
        ((AbstractHnswGraphSearcher)graphSearcher).search(knnCollector, scorer, graph, acceptOrds);
    }

    public static KnnCollector search(RandomVectorScorer scorer, int topK, OnHeapHnswGraph graph, Bits acceptOrds, int visitedLimit) throws IOException {
        TopKnnCollector knnCollector = new TopKnnCollector(topK, visitedLimit, null);
        OnHeapHnswGraphSearcher graphSearcher = new OnHeapHnswGraphSearcher(new NeighborQueue(topK, true), new SparseFixedBitSet(HnswGraphSearcher.getGraphSize(graph)));
        graphSearcher.search(knnCollector, scorer, graph, acceptOrds);
        return knnCollector;
    }

    public HnswGraphBuilder.GraphBuilderKnnCollector searchLevel(RandomVectorScorer scorer, int topK, int level, int[] eps, HnswGraph graph) throws IOException {
        HnswGraphBuilder.GraphBuilderKnnCollector results = new HnswGraphBuilder.GraphBuilderKnnCollector(topK);
        this.searchLevel(results, scorer, level, eps, graph, null);
        return results;
    }

    @Override
    int[] findBestEntryPoint(RandomVectorScorer scorer, HnswGraph graph, KnnCollector collector) throws IOException {
        int[] nArray;
        int currentEp = graph.entryNode();
        if (currentEp == -1 || graph.numLevels() == 1) {
            return new int[]{currentEp};
        }
        int size = HnswGraphSearcher.getGraphSize(graph);
        this.prepareScratchState(size, graph.maxConn() * 2);
        float currentScore = scorer.score(currentEp);
        collector.incVisitedCount(1);
        for (int level = graph.numLevels() - 1; level >= 1; --level) {
            boolean foundBetter = true;
            this.visited.set(currentEp);
            while (foundBetter) {
                int friendOrd;
                foundBetter = false;
                this.graphSeek(graph, level, currentEp);
                int numNodes = 0;
                while ((friendOrd = this.graphNextNeighbor(graph)) != Integer.MAX_VALUE) {
                    assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                    if (this.visited.getAndSet(friendOrd)) continue;
                    if (collector.earlyTerminated()) {
                        return new int[]{-1};
                    }
                    this.bulkNodes[numNodes++] = friendOrd;
                }
                float maxScore = numNodes > 0 ? scorer.bulkScore(this.bulkNodes, this.bulkScores, numNodes) : Float.NEGATIVE_INFINITY;
                collector.incVisitedCount(numNodes);
                if (!(maxScore > currentScore)) continue;
                for (int i = 0; i < numNodes; ++i) {
                    float score = this.bulkScores[i];
                    if (!(score > currentScore)) continue;
                    currentScore = score;
                    currentEp = this.bulkNodes[i];
                    foundBetter = true;
                }
            }
        }
        if (collector.earlyTerminated()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = currentEp;
        }
        return nArray;
    }

    @Override
    void searchLevel(KnnCollector results, RandomVectorScorer scorer, int level, int[] eps, HnswGraph graph, Bits acceptOrds) throws IOException {
        int size = HnswGraphSearcher.getGraphSize(graph);
        this.prepareScratchState(size, graph.maxConn() * 2);
        if (this.bulkScores == null || this.bulkScores.length < eps.length) {
            this.bulkScores = new float[eps.length];
        }
        if (results.earlyTerminated()) {
            return;
        }
        HnswGraphSearcher.scoreEntryPoints(results, scorer, this.visited, eps, acceptOrds, this.candidates, this.bulkScores);
        if (results.earlyTerminated()) {
            return;
        }
        float minAcceptedSimilarity = Math.nextUp(results.minCompetitiveSimilarity());
        boolean shouldExploreMinSim = true;
        while (this.candidates.size() > 0 && !results.earlyTerminated()) {
            int friendOrd;
            float topCandidateSimilarity = this.candidates.topScore();
            if (topCandidateSimilarity < minAcceptedSimilarity) {
                if (!shouldExploreMinSim || Math.nextUp(topCandidateSimilarity) != minAcceptedSimilarity) break;
                shouldExploreMinSim = false;
            }
            int topCandidateNode = this.candidates.pop();
            this.graphSeek(graph, level, topCandidateNode);
            int numNodes = 0;
            while ((friendOrd = this.graphNextNeighbor(graph)) != Integer.MAX_VALUE) {
                assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                if (this.visited.getAndSet(friendOrd)) continue;
                if (results.earlyTerminated()) break;
                this.bulkNodes[numNodes++] = friendOrd;
            }
            numNodes = (int)Math.min((long)numNodes, results.visitLimit() - results.visitedCount());
            results.incVisitedCount(numNodes);
            if (numNodes > 0 && scorer.bulkScore(this.bulkNodes, this.bulkScores, numNodes) > results.minCompetitiveSimilarity()) {
                for (int i = 0; i < numNodes; ++i) {
                    int node = this.bulkNodes[i];
                    float score = this.bulkScores[i];
                    if (!(score >= minAcceptedSimilarity)) continue;
                    this.candidates.add(node, score);
                    if (acceptOrds != null && !acceptOrds.get(node) || !results.collect(node, score)) continue;
                    float oldMinAcceptedSimilarity = minAcceptedSimilarity;
                    minAcceptedSimilarity = Math.nextUp(results.minCompetitiveSimilarity());
                    if (!(minAcceptedSimilarity > oldMinAcceptedSimilarity)) continue;
                    shouldExploreMinSim = true;
                }
            }
            if (results.getSearchStrategy() == null) continue;
            results.getSearchStrategy().nextVectorsBlock();
        }
    }

    private void prepareScratchState(int capacity, int bulkScoreSize) {
        this.candidates.clear();
        if (this.visited.length() < capacity) {
            this.visited = FixedBitSet.ensureCapacityAndClear((FixedBitSet)this.visited, capacity);
        } else {
            this.visited.clear();
        }
        if (this.bulkNodes == null || this.bulkNodes.length < bulkScoreSize) {
            this.bulkNodes = new int[bulkScoreSize];
            this.bulkScores = new float[bulkScoreSize];
        }
    }

    void graphSeek(HnswGraph graph, int level, int targetNode) throws IOException {
        graph.seek(level, targetNode);
    }

    int graphNextNeighbor(HnswGraph graph) throws IOException {
        return graph.nextNeighbor();
    }

    static int getGraphSize(HnswGraph graph) {
        return graph.maxNodeId() + 1;
    }

    private static class OnHeapHnswGraphSearcher
    extends HnswGraphSearcher {
        private NeighborArray cur;
        private int upto;

        private OnHeapHnswGraphSearcher(NeighborQueue candidates, BitSet visited) {
            super(candidates, visited);
        }

        @Override
        void graphSeek(HnswGraph graph, int level, int targetNode) {
            this.cur = ((OnHeapHnswGraph)graph).getNeighbors(level, targetNode);
            this.upto = -1;
        }

        @Override
        int graphNextNeighbor(HnswGraph graph) {
            if (++this.upto < this.cur.size()) {
                return this.cur.nodes()[this.upto];
            }
            return Integer.MAX_VALUE;
        }
    }
}

