/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.internal.hppc.IntCursor;
import org.apache.lucene.internal.hppc.IntHashSet;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.TermQuery;

public final class DrillDownQuery
extends Query {
    private final FacetsConfig config;
    private final Query baseQuery;
    private final List<BooleanQuery.Builder> dimQueries = new ArrayList<BooleanQuery.Builder>();
    private final Map<String, Integer> drillDownDims = new LinkedHashMap<String, Integer>();
    private final List<Query> builtDimQueries = new ArrayList<Query>();
    private final IntHashSet dirtyDimQueryIndex = new IntHashSet();

    public static Term term(String field, String dim, String ... path) {
        return new Term(field, FacetsConfig.pathToString(dim, path));
    }

    DrillDownQuery(FacetsConfig config, Query baseQuery, List<BooleanQuery.Builder> dimQueries, Map<String, Integer> drillDownDims) {
        this.baseQuery = baseQuery;
        this.dimQueries.addAll(dimQueries);
        this.drillDownDims.putAll(drillDownDims);
        this.config = config;
        for (int i = 0; i < this.dimQueries.size(); ++i) {
            this.builtDimQueries.add(null);
            this.dirtyDimQueryIndex.add(i);
        }
    }

    DrillDownQuery(FacetsConfig config, Query filter, DrillDownQuery other) {
        this.baseQuery = new BooleanQuery.Builder().add((Query)(other.baseQuery == null ? MatchAllDocsQuery.INSTANCE : other.baseQuery), BooleanClause.Occur.MUST).add(filter, BooleanClause.Occur.FILTER).build();
        this.dimQueries.addAll(other.dimQueries);
        this.drillDownDims.putAll(other.drillDownDims);
        this.config = config;
        for (int i = 0; i < this.dimQueries.size(); ++i) {
            this.builtDimQueries.add(null);
            this.dirtyDimQueryIndex.add(i);
        }
    }

    public DrillDownQuery(FacetsConfig config) {
        this(config, null);
    }

    public DrillDownQuery(FacetsConfig config, Query baseQuery) {
        this.baseQuery = baseQuery;
        this.config = config;
    }

    public void add(String dim, String ... path) {
        String indexedField = this.config.getDimConfig((String)dim).indexFieldName;
        this.add(dim, (Query)new TermQuery(DrillDownQuery.term(indexedField, dim, path)));
    }

    public void add(String dim, Query subQuery) {
        assert (this.dimQueries.size() == this.builtDimQueries.size());
        assert (this.drillDownDims.size() == this.dimQueries.size());
        if (!this.drillDownDims.containsKey(dim)) {
            this.drillDownDims.put(dim, this.drillDownDims.size());
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            this.dimQueries.add(builder);
            this.builtDimQueries.add(null);
        }
        int index = this.drillDownDims.get(dim);
        this.dimQueries.get(index).add(subQuery, BooleanClause.Occur.SHOULD);
        this.dirtyDimQueryIndex.add(index);
    }

    public DrillDownQuery clone() {
        return new DrillDownQuery(this.config, this.baseQuery, this.dimQueries, this.drillDownDims);
    }

    public int hashCode() {
        return this.classHash() + Objects.hash(this.baseQuery, this.dimQueries);
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DrillDownQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(DrillDownQuery other) {
        return Objects.equals(this.baseQuery, other.baseQuery) && this.dimQueries.equals(other.dimQueries);
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        BooleanQuery rewritten = this.getBooleanQuery();
        if (rewritten.clauses().isEmpty()) {
            return MatchAllDocsQuery.INSTANCE;
        }
        return rewritten;
    }

    public String toString(String field) {
        return this.getBooleanQuery().toString(field);
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    private BooleanQuery getBooleanQuery() {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        if (this.baseQuery != null) {
            bq.add(this.baseQuery, BooleanClause.Occur.MUST);
        }
        for (Query query : this.getDrillDownQueries()) {
            bq.add(query, BooleanClause.Occur.FILTER);
        }
        return bq.build();
    }

    public Query getBaseQuery() {
        return this.baseQuery;
    }

    public Query[] getDrillDownQueries() {
        for (IntCursor dirtyDimIndex : this.dirtyDimQueryIndex) {
            this.builtDimQueries.set(dirtyDimIndex.value, (Query)this.dimQueries.get(dirtyDimIndex.value).build());
        }
        this.dirtyDimQueryIndex.clear();
        return this.builtDimQueries.toArray(new Query[0]);
    }

    Map<String, Integer> getDims() {
        return this.drillDownDims;
    }
}

