/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;

public class ToParentBlockJoinQuery
extends Query {
    private final BitSetProducer parentsFilter;
    private final Query childQuery;
    private final ScoreMode scoreMode;

    public ToParentBlockJoinQuery(Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode) {
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public Weight createWeight(IndexSearcher searcher, org.apache.lucene.search.ScoreMode weightScoreMode, float boost) throws IOException {
        ScoreMode childScoreMode;
        ScoreMode scoreMode = childScoreMode = weightScoreMode.needsScores() ? this.scoreMode : ScoreMode.None;
        Weight childWeight = childScoreMode == ScoreMode.None ? searcher.rewrite((Query)new ConstantScoreQuery(this.childQuery)).createWeight(searcher, weightScoreMode, 0.0f) : this.childQuery.createWeight(searcher, weightScoreMode.needsScores() && childScoreMode != ScoreMode.Max ? org.apache.lucene.search.ScoreMode.COMPLETE : weightScoreMode, boost);
        return new BlockJoinWeight(this, childWeight, this.parentsFilter, childScoreMode);
    }

    public Query getChildQuery() {
        return this.childQuery;
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query childRewrite = this.childQuery.rewrite(indexSearcher);
        if (childRewrite != this.childQuery) {
            return new ToParentBlockJoinQuery(childRewrite, this.parentsFilter, this.scoreMode);
        }
        return super.rewrite(indexSearcher);
    }

    public String toString(String field) {
        return "ToParentBlockJoinQuery (" + this.childQuery.toString() + ")";
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((ToParentBlockJoinQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(ToParentBlockJoinQuery other) {
        return this.childQuery.equals((Object)other.childQuery) && this.parentsFilter.equals(other.parentsFilter) && this.scoreMode == other.scoreMode;
    }

    public int hashCode() {
        int prime = 31;
        int hash = this.classHash();
        hash = 31 * hash + this.childQuery.hashCode();
        hash = 31 * hash + this.scoreMode.hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    private static class BlockJoinWeight
    extends FilterWeight {
        private final BitSetProducer parentsFilter;
        private final ScoreMode scoreMode;

        public BlockJoinWeight(Query joinQuery, Weight childWeight, BitSetProducer parentsFilter, ScoreMode scoreMode) {
            super(joinQuery, childWeight);
            this.parentsFilter = parentsFilter;
            this.scoreMode = scoreMode;
        }

        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            final ScorerSupplier childScorerSupplier = this.in.scorerSupplier(context);
            if (childScorerSupplier == null) {
                return null;
            }
            final BitSet parents = this.parentsFilter.getBitSet(context);
            if (parents == null) {
                return null;
            }
            return new ScorerSupplier(){

                public Scorer get(long leadCost) throws IOException {
                    return new BlockJoinScorer(childScorerSupplier.get(leadCost), parents, scoreMode);
                }

                public BulkScorer bulkScorer() throws IOException {
                    if (scoreMode == ScoreMode.None) {
                        return super.bulkScorer();
                    }
                    return new BlockJoinBulkScorer(childScorerSupplier.bulkScorer(), parents, scoreMode);
                }

                public long cost() {
                    return childScorerSupplier.cost();
                }

                public void setTopLevelScoringClause() throws IOException {
                    if (scoreMode == ScoreMode.Max) {
                        childScorerSupplier.setTopLevelScoringClause();
                    }
                }
            };
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            BlockJoinScorer scorer = (BlockJoinScorer)this.scorer(context);
            if (scorer != null && scorer.iterator().advance(doc) == doc) {
                return scorer.explain(context, this.in, this.scoreMode);
            }
            return Explanation.noMatch((String)"Not a match", (Explanation[])new Explanation[0]);
        }

        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            Scorer scorer = this.scorer(context);
            if (scorer == null) {
                return null;
            }
            TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
            if (twoPhase == null ? scorer.iterator().advance(doc) != doc : twoPhase.approximation().advance(doc) != doc || !twoPhase.matches()) {
                return null;
            }
            return MatchesUtils.MATCH_WITH_NO_TERMS;
        }

        public int count(LeafReaderContext context) {
            return -1;
        }
    }

    private static class BlockJoinBulkScorer
    extends BulkScorer {
        private final BulkScorer childBulkScorer;
        private final ScoreMode scoreMode;
        private final BitSet parents;
        private final int parentsLength;

        public BlockJoinBulkScorer(BulkScorer childBulkScorer, BitSet parents, ScoreMode scoreMode) {
            this.childBulkScorer = childBulkScorer;
            this.scoreMode = scoreMode;
            this.parents = parents;
            this.parentsLength = parents.length();
        }

        public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
            int prevParent;
            if (min == max) {
                return this.scoringCompleteCheck(max, max);
            }
            int lastParent = this.parents.prevSetBit(Math.min(this.parentsLength, max) - 1);
            int n = prevParent = min == 0 ? -1 : this.parents.prevSetBit(min - 1);
            if (lastParent == prevParent) {
                return this.scoringCompleteCheck(max, max);
            }
            BatchAwareLeafCollector wrappedCollector = this.wrapCollector(collector);
            this.childBulkScorer.score((LeafCollector)wrappedCollector, acceptDocs, prevParent + 1, lastParent + 1);
            wrappedCollector.endBatch();
            return this.scoringCompleteCheck(lastParent + 1, max);
        }

        private int scoringCompleteCheck(int innerMax, int returnedMax) {
            return innerMax >= this.parentsLength ? Integer.MAX_VALUE : returnedMax;
        }

        public long cost() {
            return this.childBulkScorer.cost();
        }

        private BatchAwareLeafCollector wrapCollector(LeafCollector collector) {
            return new BatchAwareLeafCollector(collector){
                private final Score currentParentScore;
                private int currentParent;
                private Scorable scorer;
                {
                    super(in);
                    this.currentParentScore = new Score(scoreMode);
                    this.currentParent = -1;
                    this.scorer = null;
                }

                public void setScorer(final Scorable scorer) throws IOException {
                    assert (scorer != null);
                    this.scorer = scorer;
                    super.setScorer(new Scorable(){

                        public float score() {
                            return currentParentScore.score();
                        }

                        public void setMinCompetitiveScore(float minScore) throws IOException {
                            if (scoreMode == ScoreMode.None || scoreMode == ScoreMode.Max) {
                                scorer.setMinCompetitiveScore(minScore);
                            }
                        }
                    });
                }

                public void collect(int doc) throws IOException {
                    if (doc > this.currentParent) {
                        if (this.currentParent >= 0) {
                            this.in.collect(this.currentParent);
                        }
                        this.currentParent = parents.nextSetBit(doc);
                        this.currentParentScore.reset(this.scorer);
                    } else {
                        if (doc == this.currentParent) {
                            throw new IllegalStateException("Child query must not match same docs with parent filter. Combine them as must clauses (+) to find a problem doc. docId=" + doc + ", " + String.valueOf(childBulkScorer.getClass()));
                        }
                        this.currentParentScore.addChildScore(this.scorer);
                    }
                }

                @Override
                public void endBatch() throws IOException {
                    if (this.currentParent >= 0) {
                        this.in.collect(this.currentParent);
                    }
                }
            };
        }
    }

    private static abstract class BatchAwareLeafCollector
    extends FilterLeafCollector {
        public BatchAwareLeafCollector(LeafCollector in) {
            super(in);
        }

        public void endBatch() throws IOException {
        }
    }

    static class BlockJoinScorer
    extends Scorer {
        private final Scorer childScorer;
        private final BitSet parentBits;
        private final ScoreMode scoreMode;
        private final DocIdSetIterator childApproximation;
        private final TwoPhaseIterator childTwoPhase;
        private final ParentApproximation parentApproximation;
        private final ParentTwoPhase parentTwoPhase;
        private final Score parentScore;

        public BlockJoinScorer(Scorer childScorer, BitSet parentBits, ScoreMode scoreMode) {
            this.parentBits = parentBits;
            this.childScorer = childScorer;
            this.scoreMode = scoreMode;
            this.parentScore = new Score(scoreMode);
            this.childTwoPhase = childScorer.twoPhaseIterator();
            if (this.childTwoPhase == null) {
                this.childApproximation = childScorer.iterator();
                this.parentApproximation = new ParentApproximation(this.childApproximation, parentBits);
                this.parentTwoPhase = null;
            } else {
                this.childApproximation = this.childTwoPhase.approximation();
                this.parentApproximation = new ParentApproximation(this.childTwoPhase.approximation(), parentBits);
                this.parentTwoPhase = new ParentTwoPhase(this.parentApproximation, this.childTwoPhase);
            }
        }

        public Collection<Scorable.ChildScorable> getChildren() {
            return Collections.singleton(new Scorable.ChildScorable((Scorable)this.childScorer, "BLOCK_JOIN"));
        }

        public DocIdSetIterator iterator() {
            if (this.parentTwoPhase == null) {
                return this.parentApproximation;
            }
            return TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.parentTwoPhase);
        }

        public TwoPhaseIterator twoPhaseIterator() {
            return this.parentTwoPhase;
        }

        public int docID() {
            return this.parentApproximation.docID();
        }

        public float score() throws IOException {
            return this.scoreChildDocs();
        }

        public float getMaxScore(int upTo) throws IOException {
            if (this.scoreMode == ScoreMode.None) {
                return this.childScorer.getMaxScore(upTo);
            }
            return Float.POSITIVE_INFINITY;
        }

        public void setMinCompetitiveScore(float minScore) throws IOException {
            if (this.scoreMode == ScoreMode.None || this.scoreMode == ScoreMode.Max) {
                this.childScorer.setMinCompetitiveScore(minScore);
            }
        }

        private float scoreChildDocs() throws IOException {
            if (this.childApproximation.docID() >= this.parentApproximation.docID()) {
                return this.parentScore.score();
            }
            float score = 0.0f;
            if (this.scoreMode != ScoreMode.None) {
                this.parentScore.reset((Scorable)this.childScorer);
                while (this.childApproximation.nextDoc() < this.parentApproximation.docID()) {
                    if (this.childTwoPhase != null && !this.childTwoPhase.matches()) continue;
                    this.parentScore.addChildScore((Scorable)this.childScorer);
                }
                score = this.parentScore.score();
            }
            if (this.childApproximation.docID() == this.parentApproximation.docID() && (this.childTwoPhase == null || this.childTwoPhase.matches())) {
                throw new IllegalStateException("Child query must not match same docs with parent filter. Combine them as must clauses (+) to find a problem doc. docId=" + this.parentApproximation.docID() + ", " + String.valueOf(this.childScorer.getClass()));
            }
            return score;
        }

        public Explanation explain(LeafReaderContext context, Weight childWeight, ScoreMode scoreMode) throws IOException {
            int prevParentDoc = this.parentBits.prevSetBit(this.parentApproximation.docID() - 1);
            int start = context.docBase + prevParentDoc + 1;
            int end = context.docBase + this.parentApproximation.docID() - 1;
            Explanation bestChild = null;
            Explanation worstChild = null;
            int matches = 0;
            for (int childDoc = start; childDoc <= end; ++childDoc) {
                Explanation child = childWeight.explain(context, childDoc - context.docBase);
                if (!child.isMatch()) continue;
                ++matches;
                if (bestChild == null || child.getValue().doubleValue() > bestChild.getValue().doubleValue()) {
                    bestChild = child;
                }
                if (worstChild != null && !(child.getValue().doubleValue() < worstChild.getValue().doubleValue())) continue;
                worstChild = child;
            }
            assert (matches > 0) : "No matches should be handled before.";
            Explanation subExplain = scoreMode == ScoreMode.Min ? worstChild : bestChild;
            return Explanation.match((Number)Float.valueOf(this.score()), (String)this.formatScoreExplanation(matches, start, end, scoreMode), subExplain == null ? Collections.emptyList() : Collections.singleton(subExplain));
        }

        private String formatScoreExplanation(int matches, int start, int end, ScoreMode scoreMode) {
            return String.format(Locale.ROOT, "Score based on %d child docs in range from %d to %d, using score mode %s", new Object[]{matches, start, end, scoreMode});
        }
    }

    private static class Score
    extends Scorable {
        private final ScoreMode scoreMode;
        private double score;
        private int freq;

        public Score(ScoreMode scoreMode) {
            this.scoreMode = scoreMode;
            this.score = 0.0;
            this.freq = 0;
        }

        public void reset(Scorable firstChildScorer) throws IOException {
            this.score = this.scoreMode == ScoreMode.None ? 0.0 : (double)firstChildScorer.score();
            this.freq = 1;
        }

        public void addChildScore(Scorable childScorer) throws IOException {
            float childScore = this.scoreMode == ScoreMode.None ? 0.0f : childScorer.score();
            ++this.freq;
            switch (this.scoreMode) {
                case Total: 
                case Avg: {
                    this.score += (double)childScore;
                    break;
                }
                case Min: {
                    this.score = Math.min(this.score, (double)childScore);
                    break;
                }
                case Max: {
                    this.score = Math.max(this.score, (double)childScore);
                    break;
                }
                case None: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public float score() {
            assert (this.freq > 0);
            double score = this.score;
            if (this.scoreMode == ScoreMode.Avg) {
                score /= (double)this.freq;
            }
            return (float)score;
        }
    }

    private static class ParentTwoPhase
    extends TwoPhaseIterator {
        private final ParentApproximation parentApproximation;
        private final DocIdSetIterator childApproximation;
        private final TwoPhaseIterator childTwoPhase;

        ParentTwoPhase(ParentApproximation parentApproximation, TwoPhaseIterator childTwoPhase) {
            super((DocIdSetIterator)parentApproximation);
            this.parentApproximation = parentApproximation;
            this.childApproximation = childTwoPhase.approximation();
            this.childTwoPhase = childTwoPhase;
        }

        public boolean matches() throws IOException {
            assert (this.childApproximation.docID() < this.parentApproximation.docID());
            do {
                if (!this.childTwoPhase.matches()) continue;
                return true;
            } while (this.childApproximation.nextDoc() < this.parentApproximation.docID());
            return false;
        }

        public float matchCost() {
            return this.childTwoPhase.matchCost() + 10.0f;
        }
    }

    private static class ParentApproximation
    extends DocIdSetIterator {
        private final DocIdSetIterator childApproximation;
        private final BitSet parentBits;
        private int doc = -1;

        ParentApproximation(DocIdSetIterator childApproximation, BitSet parentBits) {
            this.childApproximation = childApproximation;
            this.parentBits = parentBits;
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        public int advance(int target) throws IOException {
            if (target >= this.parentBits.length()) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            int firstChildTarget = target == 0 ? 0 : this.parentBits.prevSetBit(target - 1) + 1;
            int childDoc = this.childApproximation.docID();
            if (childDoc < firstChildTarget) {
                childDoc = this.childApproximation.advance(firstChildTarget);
            }
            if (childDoc >= this.parentBits.length() - 1) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = this.parentBits.nextSetBit(childDoc + 1);
            return this.doc;
        }

        public long cost() {
            return this.childApproximation.cost();
        }
    }
}

