/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.asserting;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingDocValuesFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingKnnVectorsFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingLiveDocsFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingNormsFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingPointsFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingPostingsFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingStoredFieldsFormat;
import org.apache.lucene.tests.codecs.asserting.AssertingTermVectorsFormat;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;

public class AssertingCodec
extends FilterCodec {
    private final EnumSet<Format> suppressedFormats;
    private final PostingsFormat postings = new PerFieldPostingsFormat(){

        public PostingsFormat getPostingsFormatForField(String field) {
            return AssertingCodec.this.getPostingsFormatForField(field);
        }
    };
    private final DocValuesFormat docValues = new PerFieldDocValuesFormat(){

        public DocValuesFormat getDocValuesFormatForField(String field) {
            return AssertingCodec.this.getDocValuesFormatForField(field);
        }
    };
    private final KnnVectorsFormat knnVectorsFormat = new PerFieldKnnVectorsFormat(){

        public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
            return AssertingCodec.this.getKnnVectorsFormatForField(field);
        }
    };
    private final TermVectorsFormat vectors = new AssertingTermVectorsFormat();
    private final StoredFieldsFormat storedFields = new AssertingStoredFieldsFormat();
    private final NormsFormat norms = new AssertingNormsFormat();
    private final LiveDocsFormat liveDocs = new AssertingLiveDocsFormat();
    private final PostingsFormat defaultFormat = new AssertingPostingsFormat();
    private final DocValuesFormat defaultDVFormat = new AssertingDocValuesFormat();
    private final PointsFormat pointsFormat = new AssertingPointsFormat();
    private final KnnVectorsFormat defaultKnnVectorsFormat = new AssertingKnnVectorsFormat();

    private boolean isSuppressed(Format format) {
        return this.suppressedFormats.contains((Object)format);
    }

    static void assertThread(String object, Thread creationThread) {
        if (creationThread != Thread.currentThread()) {
            throw new AssertionError((Object)(object + " are only supposed to be consumed in the thread in which they have been acquired. But was acquired in " + String.valueOf(creationThread) + " and consumed in " + String.valueOf(Thread.currentThread()) + "."));
        }
    }

    public AssertingCodec() {
        super("Asserting", TestUtil.getDefaultCodec());
        Class targetClass;
        EnumSet<Format> suppressedFormats = EnumSet.noneOf(Format.class);
        try {
            targetClass = RandomizedContext.current().getTargetClass();
        }
        catch (IllegalStateException ignored) {
            targetClass = null;
        }
        if (targetClass != null && targetClass.isAnnotationPresent(LuceneTestCase.SuppressAssertingFormats.class)) {
            suppressedFormats.addAll(Arrays.asList(targetClass.getAnnotation(LuceneTestCase.SuppressAssertingFormats.class).value()));
        }
        this.suppressedFormats = suppressedFormats;
    }

    public PostingsFormat postingsFormat() {
        return this.postings;
    }

    public TermVectorsFormat termVectorsFormat() {
        return this.isSuppressed(Format.TERM_VECTORS) ? this.delegate.termVectorsFormat() : this.vectors;
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.isSuppressed(Format.STORED_FIELDS) ? this.delegate.storedFieldsFormat() : this.storedFields;
    }

    public DocValuesFormat docValuesFormat() {
        return this.docValues;
    }

    public NormsFormat normsFormat() {
        return this.isSuppressed(Format.NORMS) ? this.delegate.normsFormat() : this.norms;
    }

    public LiveDocsFormat liveDocsFormat() {
        return this.isSuppressed(Format.LIVE_DOCS) ? this.delegate.liveDocsFormat() : this.liveDocs;
    }

    public PointsFormat pointsFormat() {
        return this.isSuppressed(Format.POINTS) ? this.delegate.pointsFormat() : this.pointsFormat;
    }

    public KnnVectorsFormat knnVectorsFormat() {
        return this.isSuppressed(Format.KNN_VECTORS) ? this.delegate.knnVectorsFormat() : this.knnVectorsFormat;
    }

    public String toString() {
        return "Asserting(" + String.valueOf(this.delegate) + (String)(this.suppressedFormats.isEmpty() ? "" : ", suppressed: " + this.suppressedFormats.stream().map(Enum::toString).collect(Collectors.joining(", "))) + ")";
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        return this.defaultFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.defaultDVFormat;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        return this.defaultKnnVectorsFormat;
    }

    public static enum Format {
        STORED_FIELDS,
        TERM_VECTORS,
        NORMS,
        LIVE_DOCS,
        POINTS,
        KNN_VECTORS;

    }
}

