/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.util;

import java.io.ObjectInputFilter;
import java.util.function.BinaryOperator;

public final class TestObjectInputFilterFactory
implements BinaryOperator<ObjectInputFilter> {
    public static final ObjectInputFilter DENY_ALL_FILTER = info -> ObjectInputFilter.Status.REJECTED;

    @Override
    public ObjectInputFilter apply(ObjectInputFilter curr, ObjectInputFilter next) {
        if (StackWalker.getInstance().walk(s -> s.anyMatch(TestObjectInputFilterFactory::isGradleSerializerStackFrame)).booleanValue()) {
            return next;
        }
        if (curr == null && next == null) {
            return DENY_ALL_FILTER;
        }
        return next;
    }

    private static boolean isGradleSerializerStackFrame(StackWalker.StackFrame f) {
        String methodName = f.getMethodName();
        String className = f.getClassName();
        return "deserializeWorker".equals(methodName) && "org.gradle.process.internal.worker.messaging.WorkerConfigSerializer".equals(className);
    }
}

