/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.transfer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.maven.cli.transfer.TransferResourceIdentifier;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimplexTransferListener
extends AbstractTransferListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplexTransferListener.class);
    private static final int QUEUE_SIZE = 1024;
    private static final int BATCH_MAX_SIZE = 500;
    private final TransferListener delegate;
    private final int batchMaxSize;
    private final boolean blockOnLastEvent;
    private final ArrayBlockingQueue<Exchange> eventQueue;
    private final ConcurrentHashMap<TransferResourceIdentifier, Boolean> ongoing = new ConcurrentHashMap();

    public SimplexTransferListener(TransferListener delegate) {
        this(delegate, 1024, 500, true);
    }

    public SimplexTransferListener(TransferListener delegate, int queueSize, int batchMaxSize, boolean blockOnLastEvent) {
        this.delegate = Objects.requireNonNull(delegate);
        if (queueSize < 1 || batchMaxSize < 1) {
            throw new IllegalArgumentException("Queue and batch sizes must be greater than 1");
        }
        this.batchMaxSize = batchMaxSize;
        this.blockOnLastEvent = blockOnLastEvent;
        this.eventQueue = new ArrayBlockingQueue(queueSize);
        Thread updater = new Thread(this::feedConsumer);
        updater.setDaemon(true);
        updater.start();
    }

    public TransferListener getDelegate() {
        return this.delegate;
    }

    private void feedConsumer() {
        ArrayList<Exchange> batch = new ArrayList<Exchange>(this.batchMaxSize);
        try {
            while (true) {
                batch.clear();
                if (this.eventQueue.drainTo(batch, 500) == 0) {
                    batch.add(this.eventQueue.take());
                }
                this.demux(batch);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void demux(List<Exchange> exchanges) {
        for (Exchange exchange : exchanges) {
            exchange.process(transferEvent -> {
                TransferEvent.EventType type = transferEvent.getType();
                try {
                    switch (type) {
                        case INITIATED: {
                            this.delegate.transferInitiated(transferEvent);
                            break;
                        }
                        case STARTED: {
                            this.delegate.transferStarted(transferEvent);
                            break;
                        }
                        case PROGRESSED: {
                            this.delegate.transferProgressed(transferEvent);
                            break;
                        }
                        case CORRUPTED: {
                            this.delegate.transferCorrupted(transferEvent);
                            break;
                        }
                        case SUCCEEDED: {
                            this.delegate.transferSucceeded(transferEvent);
                            break;
                        }
                        case FAILED: {
                            this.delegate.transferFailed(transferEvent);
                            break;
                        }
                        default: {
                            LOGGER.warn("Invalid TransferEvent.EventType={}; ignoring it", (Object)type);
                            break;
                        }
                    }
                }
                catch (TransferCancelledException e) {
                    this.ongoing.put(new TransferResourceIdentifier(transferEvent.getResource()), Boolean.FALSE);
                }
            });
        }
    }

    private void put(TransferEvent event, boolean last) {
        try {
            Exchange exchange = this.blockOnLastEvent && last ? new BlockingExchange(event) : new Exchange(event);
            this.eventQueue.put(exchange);
            exchange.waitForProcessed();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void transferInitiated(TransferEvent event) {
        this.ongoing.putIfAbsent(new TransferResourceIdentifier(event.getResource()), Boolean.TRUE);
        this.put(event, false);
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        if (this.ongoing.get(new TransferResourceIdentifier(event.getResource())) == Boolean.FALSE) {
            throw new TransferCancelledException();
        }
        this.put(event, false);
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        if (this.ongoing.get(new TransferResourceIdentifier(event.getResource())) == Boolean.FALSE) {
            throw new TransferCancelledException();
        }
        this.put(event, false);
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        if (this.ongoing.get(new TransferResourceIdentifier(event.getResource())) == Boolean.FALSE) {
            throw new TransferCancelledException();
        }
        this.put(event, false);
    }

    public void transferSucceeded(TransferEvent event) {
        this.ongoing.remove(new TransferResourceIdentifier(event.getResource()));
        this.put(event, this.ongoing.isEmpty());
    }

    public void transferFailed(TransferEvent event) {
        this.ongoing.remove(new TransferResourceIdentifier(event.getResource()));
        this.put(event, this.ongoing.isEmpty());
    }

    private static class Exchange {
        private final TransferEvent event;

        private Exchange(TransferEvent event) {
            this.event = event;
        }

        public void process(Consumer<TransferEvent> consumer) {
            consumer.accept(this.event);
        }

        public void waitForProcessed() throws InterruptedException {
        }
    }

    private static class BlockingExchange
    extends Exchange {
        private final CountDownLatch latch = new CountDownLatch(1);

        private BlockingExchange(TransferEvent event) {
            super(event);
        }

        @Override
        public void process(Consumer<TransferEvent> consumer) {
            super.process(consumer);
            this.latch.countDown();
        }

        @Override
        public void waitForProcessed() throws InterruptedException {
            this.latch.await();
        }
    }
}

