/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.tools.javac.api.ClientCodeWrapper;
import jpt.sun.tools.javac.code.Source;
import jpt30.tools.FileObject;
import jpt30.tools.JavaFileManager;
import jpt30.tools.JavaFileObject;
import jpt30.tools.StandardLocation;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.AptSourceFileManager;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.ModuleFileManager;
import org.netbeans.modules.java.source.parsing.ModuleLocation;
import org.netbeans.modules.java.source.parsing.ModuleSourceFileManager;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.parsing.PatchModuleFileManager;
import org.netbeans.modules.java.source.parsing.ProcessorGenerated;
import org.netbeans.modules.java.source.parsing.SiblingSource;
import org.netbeans.modules.java.source.parsing.SourceFileManager;
import org.netbeans.modules.java.source.parsing.TreeLoaderOutputFileManager;
import org.netbeans.modules.java.source.util.Iterators;
import org.openide.util.Parameters;

@ClientCodeWrapper.Trusted
public final class ProxyFileManager
implements JavaFileManager {
    private static final Logger LOG = Logger.getLogger(ProxyFileManager.class.getName());
    private static final Function<URL, Collection<? extends URL>> ROOT_TO_COLLECTION = u -> Collections.singleton(u);
    private static final JavaFileManager.Location ALL = new JavaFileManager.Location(){

        @Override
        public String getName() {
            return "ALL";
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }
    };
    private static final JavaFileManager.Location SOURCE_PATH_WRITE = new JavaFileManager.Location(){

        @Override
        public String getName() {
            return "SOURCE_PATH_WRITE";
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }
    };
    private final Configuration cfg;
    private final Object ownerThreadLock = new Object();
    private JavaFileObject lastInfered;
    private String lastInferedResult;
    private Thread ownerThread;

    public ProxyFileManager(@NonNull Configuration cfg) {
        assert (cfg != null);
        this.cfg = cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Iterable<JavaFileObject> list(@NonNull JavaFileManager.Location l, @NonNull String packageName, @NonNull Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        this.checkSingleOwnerThread();
        try {
            JavaFileManager[] fms = this.cfg.getFileManagers(l, null);
            ArrayList<Iterable<JavaFileObject>> iterables = new ArrayList<Iterable<JavaFileObject>>(fms.length);
            for (JavaFileManager fm : fms) {
                iterables.add(fm.list(l, packageName, kinds, recurse));
            }
            Iterable<JavaFileObject> result = Iterators.chained(iterables);
            if (LOG.isLoggable(Level.FINER)) {
                StringBuilder urls = new StringBuilder();
                for (JavaFileObject jfo : result) {
                    urls.append(jfo.toUri().toString());
                    urls.append(", ");
                }
                LOG.log(Level.FINER, "List {0} Package: {1} Kinds: {2} -> {3}", new Object[]{l, packageName, kinds, urls});
            }
            Iterable<JavaFileObject> iterable = result;
            return iterable;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public FileObject getFileForInput(@NonNull JavaFileManager.Location l, @NonNull String packageName, @NonNull String relativeName) throws IOException {
        this.checkSingleOwnerThread();
        try {
            JavaFileManager[] fms;
            for (JavaFileManager fm : fms = this.cfg.getFileManagers(l, null)) {
                FileObject result = fm.getFileForInput(l, packageName, relativeName);
                if (result == null) continue;
                FileObject fileObject = result;
                return fileObject;
            }
            JavaFileManager[] javaFileManagerArray = null;
            return javaFileManagerArray;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public FileObject getFileForOutput(@NonNull JavaFileManager.Location l, @NonNull String packageName, @NonNull String relativeName, @NullAllowed FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        this.checkSingleOwnerThread();
        try {
            JavaFileManager[] fms = this.cfg.getFileManagers(l == StandardLocation.SOURCE_PATH ? SOURCE_PATH_WRITE : l, null);
            if (fms.length == 0) {
                throw new UnsupportedOperationException("No JavaFileManager for location: " + l);
            }
            FileObject fileObject = this.mark(fms[0].getFileForOutput(l, packageName, relativeName, sibling), l);
            return fileObject;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    @Override
    @CheckForNull
    public ClassLoader getClassLoader(@NonNull JavaFileManager.Location l) {
        this.checkSingleOwnerThread();
        try {
            ClassLoader classLoader = null;
            return classLoader;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        this.checkSingleOwnerThread();
        try {
            for (JavaFileManager fm : this.cfg.getFileManagers(ALL, null)) {
                fm.flush();
            }
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.checkSingleOwnerThread();
        try {
            for (JavaFileManager fm : this.cfg.getFileManagers(ALL, null)) {
                fm.close();
            }
        }
        finally {
            this.clearOwnerThread();
        }
    }

    @Override
    public int isSupportedOption(@NonNull String string) {
        this.checkSingleOwnerThread();
        try {
            int n = -1;
            return n;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleOption(@NonNull String current, @NonNull Iterator<String> remains) {
        this.checkSingleOwnerThread();
        try {
            if ("apt-origin".equals(current)) {
                if (!remains.hasNext()) {
                    throw new IllegalArgumentException("The apt-source-root requires folder.");
                }
                String sib = remains.next();
                if (sib.length() != 0) {
                    URL sibling = ProxyFileManager.asURL(sib);
                    boolean inSourceRoot = this.cfg.getProcessorGeneratedFiles().findSibling(Collections.singleton(sibling)) != null;
                    this.cfg.getSiblings().push(sibling, inSourceRoot);
                } else {
                    this.cfg.getSiblings().pop();
                }
                boolean sibling = true;
                return sibling;
            }
            boolean isSourceElement = "apt-source-element".equals(current);
            if (isSourceElement || "apt-resource-element".equals(current)) {
                if (remains.hasNext()) {
                    Collection<? extends URL> urls = ProxyFileManager.asURLs(remains);
                    URL sibling = this.cfg.getProcessorGeneratedFiles().findSibling(urls);
                    boolean inSourceRoot = true;
                    if (sibling == null) {
                        sibling = this.cfg.getSiblings().getProvider().getSibling();
                        inSourceRoot = this.cfg.getSiblings().getProvider().isInSourceRoot();
                    }
                    this.cfg.getSiblings().push(sibling, inSourceRoot);
                    if (LOG.isLoggable(Level.INFO) && isSourceElement && urls.size() > 1) {
                        StringBuilder sb = new StringBuilder();
                        for (URL uRL : urls) {
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(uRL);
                        }
                        LOG.log(Level.FINE, "Multiple source files passed as ORIGIN_SOURCE_ELEMENT_URL: {0}; using: {1}", new Object[]{sb, this.cfg.getSiblings().getProvider().getSibling()});
                    }
                } else {
                    this.cfg.getSiblings().pop();
                }
                boolean urls = true;
                return urls;
            }
            RepeatableIterator<String> it = RepeatableIterator.create(remains);
            boolean res = false;
            for (JavaFileManager javaFileManager : this.cfg.getFileManagers(ALL, current)) {
                res |= javaFileManager.handleOption(current, it);
                it.reset();
            }
            boolean bl = res;
            return bl;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    @Override
    public boolean hasLocation(@NonNull JavaFileManager.Location location) {
        this.checkSingleOwnerThread();
        try {
            boolean bl = this.cfg.hasLocations(location);
            return bl;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        this.checkSingleOwnerThread();
        try {
            for (JavaFileManager jfm : this.cfg.getFileManagers(location, null)) {
                JavaFileManager.Location res = jfm.getLocationForModule(location, moduleName);
                if (res == null) continue;
                JavaFileManager.Location location2 = res;
                return location2;
            }
            JavaFileManager[] javaFileManagerArray = null;
            return javaFileManagerArray;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        this.checkSingleOwnerThread();
        try {
            for (JavaFileManager jfm : this.cfg.getFileManagers(location, null)) {
                JavaFileManager.Location res = jfm.getLocationForModule(location, fo);
                if (res == null) continue;
                JavaFileManager.Location location2 = res;
                return location2;
            }
            JavaFileManager[] javaFileManagerArray = null;
            return javaFileManagerArray;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public String inferModuleName(@NonNull JavaFileManager.Location location) throws IOException {
        this.checkSingleOwnerThread();
        try {
            for (JavaFileManager jfm : this.cfg.getFileManagers(location, null)) {
                String modName = jfm.inferModuleName(location);
                if (modName == null) continue;
                String string = modName;
                return string;
            }
            JavaFileManager[] javaFileManagerArray = null;
            return javaFileManagerArray;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(@NonNull JavaFileManager.Location location) throws IOException {
        this.checkSingleOwnerThread();
        try {
            JavaFileManager[] jfms = this.cfg.getFileManagers(location, null);
            switch (jfms.length) {
                case 0: {
                    Set<Set<JavaFileManager.Location>> set = Collections.emptySet();
                    return set;
                }
                case 1: {
                    Iterable<Set<JavaFileManager.Location>> iterable = jfms[0].listLocationsForModules(location);
                    return iterable;
                }
            }
            ArrayList<Set<JavaFileManager.Location>> res = new ArrayList<Set<JavaFileManager.Location>>();
            for (JavaFileManager jfm : jfms) {
                jfm.listLocationsForModules(location).forEach(res::add);
            }
            ArrayList<Set<JavaFileManager.Location>> arrayList = res;
            return arrayList;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public JavaFileObject getJavaFileForInput(@NonNull JavaFileManager.Location l, @NonNull String className, @NonNull JavaFileObject.Kind kind) throws IOException {
        this.checkSingleOwnerThread();
        try {
            JavaFileManager[] fms;
            for (JavaFileManager fm : fms = this.cfg.getFileManagers(l, null)) {
                JavaFileObject result = fm.getJavaFileForInput(l, className, kind);
                if (result == null) continue;
                JavaFileObject javaFileObject = result;
                return javaFileObject;
            }
            JavaFileManager[] javaFileManagerArray = null;
            return javaFileManagerArray;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public JavaFileObject getJavaFileForOutput(@NonNull JavaFileManager.Location l, @NonNull String className, @NonNull JavaFileObject.Kind kind, @NonNull FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        this.checkSingleOwnerThread();
        try {
            JavaFileManager[] fms = this.cfg.getFileManagers(l, null);
            if (fms.length == 0) {
                throw new UnsupportedOperationException("No JavaFileManager for location: " + l);
            }
            JavaFileObject javaFileObject = this.mark(fms[0].getJavaFileForOutput(l, className, kind, sibling), l);
            return javaFileObject;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public String inferBinaryName(@NonNull JavaFileManager.Location location, @NonNull JavaFileObject javaFileObject) {
        this.checkSingleOwnerThread();
        try {
            JavaFileManager[] fms;
            InferableJavaFileObject ifo;
            String result;
            assert (javaFileObject != null);
            if (javaFileObject == this.lastInfered) {
                String string = this.lastInferedResult;
                return string;
            }
            if (javaFileObject instanceof InferableJavaFileObject && (result = (ifo = (InferableJavaFileObject)javaFileObject).inferBinaryName()) != null) {
                this.lastInfered = javaFileObject;
                this.lastInferedResult = result;
                String string = result;
                return string;
            }
            for (JavaFileManager fm : fms = this.cfg.getFileManagers(location, null)) {
                result = fm.inferBinaryName(location, javaFileObject);
                if (result == null || result.length() <= 0) continue;
                this.lastInfered = javaFileObject;
                this.lastInferedResult = result;
                String string = result;
                return string;
            }
            JavaFileManager[] javaFileManagerArray = null;
            return javaFileManagerArray;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject0) {
        this.checkSingleOwnerThread();
        try {
            JavaFileManager[] fms;
            for (JavaFileManager fm : fms = this.cfg.getFileManagers(ALL, null)) {
                if (!fm.isSameFile(fileObject, fileObject0)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = fileObject.toUri().equals(fileObject0.toUri());
            return bl;
        }
        finally {
            this.clearOwnerThread();
        }
    }

    @NonNull
    private <T extends FileObject> T mark(@NonNull T result, @NonNull JavaFileManager.Location l) throws MalformedURLException {
        if (ModuleLocation.isInstance(l)) {
            l = ModuleLocation.cast(l).getBaseLocation();
        }
        boolean valid = true;
        ProcessorGenerated.Type type = null;
        if (l == StandardLocation.CLASS_OUTPUT) {
            type = ProcessorGenerated.Type.RESOURCE;
        } else if (l == StandardLocation.SOURCE_OUTPUT) {
            type = ProcessorGenerated.Type.SOURCE;
        }
        if (this.cfg.getSiblings().getProvider().hasSibling() && this.cfg.getSiblings().getProvider().isInSourceRoot()) {
            if (type == ProcessorGenerated.Type.SOURCE) {
                this.cfg.getProcessorGeneratedFiles().register(this.cfg.getSiblings().getProvider().getSibling(), result, type);
            } else if (type == ProcessorGenerated.Type.RESOURCE) {
                try {
                    result.openInputStream().close();
                }
                catch (IOException ioe) {
                    this.cfg.getProcessorGeneratedFiles().register(this.cfg.getSiblings().getProvider().getSibling(), result, type);
                }
            }
            if (!FileObjects.isValidFileName(result)) {
                LOG.log(Level.WARNING, "Cannot write Annotation Processor generated file: {0} ({1})", new Object[]{result.getName(), result.toUri()});
                valid = false;
            }
        }
        return (T)(valid && (this.cfg.getProcessorGeneratedFiles().canWrite() || !this.cfg.getSiblings().getProvider().hasSibling()) ? result : FileObjects.nullWriteFileObject((InferableJavaFileObject)result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSingleOwnerThread() {
        Thread currentThread = Thread.currentThread();
        Object object = this.ownerThreadLock;
        synchronized (object) {
            if (this.ownerThread == null) {
                this.ownerThread = currentThread;
            } else if (this.ownerThread != currentThread) {
                throw new ConcurrentModificationException(String.format("Current owner: %s, New Owner: %s", Arrays.asList(this.ownerThread.getStackTrace()), Arrays.asList(currentThread.getStackTrace())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOwnerThread() {
        Object object = this.ownerThreadLock;
        synchronized (object) {
            this.ownerThread = null;
        }
    }

    private static URL asURL(String url) throws IllegalArgumentException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid path argument: " + url, ex);
        }
    }

    private static Collection<? extends URL> asURLs(Iterator<? extends String> surls) {
        ArrayDeque<URL> result = new ArrayDeque<URL>();
        while (surls.hasNext()) {
            String surl = surls.next();
            if (!"java".equals(FileObjects.getExtension(surl))) continue;
            result.add(ProxyFileManager.asURL(surl));
        }
        return result;
    }

    @Override
    public boolean contains(JavaFileManager.Location l, FileObject f) {
        return true;
    }

    public static final class Configuration {
        private static final int BOOT = 0;
        private static final int COMPILE = 1;
        private static final int OUTPUT = 2;
        private static final int TREE_LOADER = 3;
        private static final int SRC = 4;
        private static final int APT_SRC = 5;
        private static final int MEM = 6;
        private static final int SYS_MODULES = 7;
        private static final int USER_MODULES = 8;
        private static final int SRC_MODULES = 9;
        private static final int MODULE_PATCHES = 10;
        private static final JavaFileManager[] EMPTY = new JavaFileManager[0];
        private final CachingArchiveProvider cap;
        private final ClassPath moduleBoot;
        private final ClassPath moduleCompile;
        private final ClassPath bootCached;
        private final ClassPath compiledCached;
        private final ClassPath src;
        private final ClassPath srcCached;
        private final ClassPath moduleSrcCached;
        private final ClassPath outputCached;
        private final ClassPath aptSrcCached;
        private final Map<JavaFileManager.Location, Entry> fileManagers;
        private final JavaFileManager[] emitted;
        private final SiblingSource siblings;
        private final FileManagerTransaction fmTx;
        private final ProcessorGenerated processorGeneratedFiles;
        private final Map<ClassPath, Function<URL, Collection<? extends URL>>> peersMap;
        private boolean useModifiedFiles = true;
        private JavaFileFilterImplementation filter;
        private boolean ignoreExcludes;
        private Function<JavaFileManager.Location, JavaFileManager> jfmProvider;
        private Source sourceLevel;

        private Configuration(@NonNull ClassPath moduleBoot, @NonNull ClassPath moduleCompile, @NonNull ClassPath bootCached, @NonNull ClassPath compiledCached, @NonNull ClassPath src, @NonNull ClassPath srcCached, @NonNull ClassPath moduleSrcCached, @NonNull ClassPath outputCached, @NonNull ClassPath aptSrcCached, @NonNull SiblingSource siblings, @NonNull FileManagerTransaction fmTx, @NonNull ProcessorGenerated processorGeneratedFiles) {
            assert (moduleBoot != null);
            assert (moduleCompile != null);
            assert (bootCached != null);
            assert (compiledCached != null);
            assert (src != null);
            assert (srcCached != null);
            assert (outputCached != null);
            assert (aptSrcCached != null);
            assert (siblings != null);
            assert (fmTx != null);
            assert (processorGeneratedFiles != null);
            this.cap = CachingArchiveProvider.getDefault();
            this.moduleBoot = moduleBoot;
            this.moduleCompile = moduleCompile;
            this.bootCached = bootCached;
            this.compiledCached = compiledCached;
            this.src = src;
            this.srcCached = srcCached;
            this.moduleSrcCached = moduleSrcCached;
            this.outputCached = outputCached;
            this.aptSrcCached = aptSrcCached;
            this.siblings = siblings;
            this.fmTx = fmTx;
            this.processorGeneratedFiles = processorGeneratedFiles;
            this.fileManagers = this.createFactories();
            this.emitted = new JavaFileManager[11];
            this.peersMap = new IdentityHashMap<ClassPath, Function<URL, Collection<? extends URL>>>();
        }

        public void setUseModifiedFiles(boolean useModifiedFiles) {
            this.useModifiedFiles = useModifiedFiles;
        }

        public boolean isUseModifiedFiles() {
            return this.useModifiedFiles;
        }

        public void setFilter(@NullAllowed JavaFileFilterImplementation filter) {
            this.filter = filter;
        }

        @CheckForNull
        public JavaFileFilterImplementation getFilter() {
            return this.filter;
        }

        public void setIgnoreExcludes(boolean ignoreExcludes) {
            this.ignoreExcludes = ignoreExcludes;
        }

        public boolean isIgnoreExcludes() {
            return this.ignoreExcludes;
        }

        public void setPeers(@NonNull ClassPath cachedPath, @NonNull Function<URL, Collection<? extends URL>> provider) {
            Parameters.notNull("cachedPath", cachedPath);
            Parameters.notNull("provider", provider);
            this.peersMap.put(cachedPath, provider);
        }

        public void setCustomFileManagerProvider(@NullAllowed Function<JavaFileManager.Location, JavaFileManager> jfmProvider) {
            this.jfmProvider = jfmProvider;
        }

        public void setSourceLevel(@NullAllowed String sourceLevel) {
            this.sourceLevel = sourceLevel == null ? null : Source.lookup(sourceLevel);
        }

        @NonNull
        JavaFileManager[] getFileManagers(@NonNull JavaFileManager.Location location, @NullAllowed String hint) {
            if (ModuleLocation.isInstance(location)) {
                location = ModuleLocation.cast(location).getBaseLocation();
            }
            if (location == ALL) {
                if ("output-root".equals(hint)) {
                    this.createTreeLoaderFileManager();
                }
                if ("--patch-module".equals(hint) || hint != null && hint.startsWith("-Xnb-Xmodule:")) {
                    this.createPatchFileManager();
                    this.createModuleSrcFileManager();
                }
                ArrayList<JavaFileManager> res = new ArrayList<JavaFileManager>(this.emitted.length);
                for (JavaFileManager jfm : this.emitted) {
                    if (jfm == null) continue;
                    res.add(jfm);
                }
                return res.toArray(new JavaFileManager[0]);
            }
            Entry result = this.fileManagers.get(location);
            return result == null ? EMPTY : result.get();
        }

        boolean hasLocations(@NonNull JavaFileManager.Location l) {
            Entry e;
            if (ModuleLocation.isInstance(l)) {
                l = ModuleLocation.cast(l).getBaseLocation();
            }
            return (e = this.fileManagers.get(l)) != null ? e.hasLocation() : false;
        }

        @NonNull
        SiblingSource getSiblings() {
            return this.siblings;
        }

        @NonNull
        ProcessorGenerated getProcessorGeneratedFiles() {
            return this.processorGeneratedFiles;
        }

        @NonNull
        private Map<JavaFileManager.Location, Entry> createFactories() {
            HashMap<JavaFileManager.Location, Entry> m = new HashMap<JavaFileManager.Location, Entry>();
            m.put(StandardLocation.PLATFORM_CLASS_PATH, new Entry(() -> new JavaFileManager[]{this.createBootFileManager()}));
            m.put(StandardLocation.CLASS_PATH, new Entry(() -> {
                JavaFileManager[] javaFileManagerArray;
                JavaFileManager output;
                JavaFileManager compile = this.createCompileFileManager();
                JavaFileManager javaFileManager = output = this.createModuleSrcFileManager() == null ? this.createOutputFileManager() : null;
                if (output == null) {
                    JavaFileManager[] javaFileManagerArray2 = new JavaFileManager[1];
                    javaFileManagerArray = javaFileManagerArray2;
                    javaFileManagerArray2[0] = compile;
                } else {
                    JavaFileManager[] javaFileManagerArray3 = new JavaFileManager[2];
                    javaFileManagerArray3[0] = output;
                    javaFileManagerArray = javaFileManagerArray3;
                    javaFileManagerArray3[1] = compile;
                }
                return javaFileManagerArray;
            }));
            m.put(StandardLocation.SOURCE_PATH, new Entry(() -> {
                JavaFileManager[] javaFileManagerArray;
                JavaFileManager src = this.createSrcFileManager();
                JavaFileManager mem = this.createMemFileManager();
                if (src == null) {
                    javaFileManagerArray = EMPTY;
                } else if (mem == null) {
                    JavaFileManager[] javaFileManagerArray2 = new JavaFileManager[1];
                    javaFileManagerArray = javaFileManagerArray2;
                    javaFileManagerArray2[0] = src;
                } else {
                    JavaFileManager[] javaFileManagerArray3 = new JavaFileManager[2];
                    javaFileManagerArray3[0] = src;
                    javaFileManagerArray = javaFileManagerArray3;
                    javaFileManagerArray3[1] = mem;
                }
                return javaFileManagerArray;
            }));
            m.put(StandardLocation.CLASS_OUTPUT, new Entry(() -> {
                JavaFileManager[] javaFileManagerArray;
                JavaFileManager output = this.createOutputFileManager();
                JavaFileManager treeLoader = this.createTreeLoaderFileManager();
                JavaFileManager patches = this.createPatchFileManager();
                if (output == null) {
                    JavaFileManager[] javaFileManagerArray2 = new JavaFileManager[2];
                    javaFileManagerArray2[0] = treeLoader;
                    javaFileManagerArray = javaFileManagerArray2;
                    javaFileManagerArray2[1] = patches;
                } else {
                    JavaFileManager[] javaFileManagerArray3 = new JavaFileManager[3];
                    javaFileManagerArray3[0] = treeLoader;
                    javaFileManagerArray3[1] = output;
                    javaFileManagerArray = javaFileManagerArray3;
                    javaFileManagerArray3[2] = patches;
                }
                return javaFileManagerArray;
            }, fms -> {
                BitSet active = new BitSet(((JavaFileManager[])fms).length);
                int bc = 0;
                for (int i = 0; i < ((JavaFileManager[])fms).length; ++i) {
                    if (!fms[i].hasLocation(StandardLocation.CLASS_OUTPUT)) continue;
                    active.set(i);
                    ++bc;
                }
                if (bc == 0) {
                    return EMPTY;
                }
                JavaFileManager[] res = new JavaFileManager[bc];
                int i = active.nextSetBit(0);
                int j = 0;
                while (i >= 0) {
                    res[j++] = fms[i];
                    i = active.nextSetBit(i + 1);
                }
                return res;
            }));
            m.put(StandardLocation.SOURCE_OUTPUT, new Entry(() -> {
                JavaFileManager[] javaFileManagerArray;
                JavaFileManager aptSrcOut = this.createAptSrcOutputFileManager();
                if (aptSrcOut == null) {
                    javaFileManagerArray = EMPTY;
                } else {
                    JavaFileManager[] javaFileManagerArray2 = new JavaFileManager[1];
                    javaFileManagerArray = javaFileManagerArray2;
                    javaFileManagerArray2[0] = aptSrcOut;
                }
                return javaFileManagerArray;
            }));
            m.put(SOURCE_PATH_WRITE, new Entry(() -> {
                JavaFileManager[] javaFileManagerArray;
                JavaFileManager src = this.createSrcFileManager();
                if (src == null) {
                    javaFileManagerArray = EMPTY;
                } else {
                    JavaFileManager[] javaFileManagerArray2 = new JavaFileManager[1];
                    javaFileManagerArray = javaFileManagerArray2;
                    javaFileManagerArray2[0] = src;
                }
                return javaFileManagerArray;
            }));
            m.put(StandardLocation.SYSTEM_MODULES, new Entry(() -> new JavaFileManager[]{this.createSystemModuleFileManager()}));
            m.put(StandardLocation.MODULE_PATH, new Entry(() -> new JavaFileManager[]{this.createModuleFileManager()}));
            m.put(StandardLocation.MODULE_SOURCE_PATH, new Entry(() -> {
                JavaFileManager[] javaFileManagerArray;
                ModuleSourceFileManager moduleSrc = this.createModuleSrcFileManager();
                if (moduleSrc == null) {
                    javaFileManagerArray = EMPTY;
                } else {
                    JavaFileManager[] javaFileManagerArray2 = new JavaFileManager[1];
                    javaFileManagerArray = javaFileManagerArray2;
                    javaFileManagerArray2[0] = moduleSrc;
                }
                return javaFileManagerArray;
            }));
            m.put(StandardLocation.PATCH_MODULE_PATH, new Entry(() -> new JavaFileManager[]{this.createPatchFileManager()}));
            return m;
        }

        @NonNull
        private JavaFileManager createBootFileManager() {
            if (this.emitted[0] == null) {
                this.emitted[0] = new CachingFileManager(this.cap, this.bootCached, this.sourceLevel, true, true);
            }
            return this.emitted[0];
        }

        @NonNull
        private JavaFileManager createCompileFileManager() {
            if (this.emitted[1] == null) {
                this.emitted[1] = new CachingFileManager(this.cap, this.compiledCached, this.sourceLevel, false, true);
            }
            return this.emitted[1];
        }

        @CheckForNull
        private JavaFileManager createSrcFileManager() {
            if (this.emitted[4] == null) {
                boolean hasSources;
                boolean srcNonEmpty = !this.srcCached.entries().isEmpty();
                boolean hasModules = srcNonEmpty && this.moduleSrcCached != ClassPath.EMPTY;
                boolean bl = hasSources = !hasModules && srcNonEmpty;
                this.emitted[4] = hasSources ? (!this.useModifiedFiles ? new CachingFileManager(this.cap, this.srcCached, this.filter, null, false, this.ignoreExcludes) : new SourceFileManager(this.srcCached, this.ignoreExcludes)) : null;
            }
            return this.emitted[4];
        }

        @CheckForNull
        private JavaFileManager createOutputFileManager() {
            if (this.emitted[2] == null) {
                JavaFileManager tmp;
                boolean hasSources;
                boolean bl = hasSources = !this.srcCached.entries().isEmpty();
                JavaFileManager outFm = hasSources ? (this.jfmProvider != null && (tmp = this.jfmProvider.apply(StandardLocation.CLASS_OUTPUT)) != null ? tmp : new OutputFileManager(this.cap, this.outputCached, this.srcCached, this.aptSrcCached, this.siblings.getProvider(), this.fmTx, this.createModuleSrcFileManager())) : null;
                this.emitted[2] = outFm;
            }
            return this.emitted[2];
        }

        @NonNull
        private JavaFileManager createTreeLoaderFileManager() {
            if (this.emitted[3] == null) {
                this.emitted[3] = new TreeLoaderOutputFileManager(this.cap, this.fmTx);
            }
            return this.emitted[3];
        }

        @CheckForNull
        private JavaFileManager createAptSrcOutputFileManager() {
            if (this.emitted[5] == null) {
                boolean hasAptSources = this.aptSrcCached != ClassPath.EMPTY;
                this.emitted[5] = hasAptSources ? new AptSourceFileManager(this.srcCached, this.aptSrcCached, this.siblings.getProvider(), this.fmTx, this.createModuleSrcFileManager()) : null;
            }
            return this.emitted[5];
        }

        @CheckForNull
        private JavaFileManager createMemFileManager() {
            return this.emitted[6];
        }

        @NonNull
        private JavaFileManager createSystemModuleFileManager() {
            if (this.emitted[7] == null) {
                this.emitted[7] = new ModuleFileManager(this.cap, this.moduleBoot, this.peersMap.getOrDefault(this.moduleBoot, ROOT_TO_COLLECTION), this.sourceLevel, StandardLocation.SYSTEM_MODULES, true);
            }
            return this.emitted[7];
        }

        @NonNull
        private JavaFileManager createModuleFileManager() {
            if (this.emitted[8] == null) {
                this.emitted[8] = new ModuleFileManager(this.cap, this.moduleCompile, this.peersMap.getOrDefault(this.moduleCompile, ROOT_TO_COLLECTION), this.sourceLevel, StandardLocation.MODULE_PATH, false);
            }
            return this.emitted[8];
        }

        @CheckForNull
        private ModuleSourceFileManager createModuleSrcFileManager() {
            if (this.emitted[9] == null) {
                boolean hasModules = !this.srcCached.entries().isEmpty() && this.moduleSrcCached != ClassPath.EMPTY;
                this.emitted[9] = hasModules ? new ModuleSourceFileManager(this.srcCached, this.moduleSrcCached, this.ignoreExcludes) : null;
            }
            return (ModuleSourceFileManager)this.emitted[9];
        }

        @CheckForNull
        private JavaFileManager createPatchFileManager() {
            if (this.emitted[10] == null) {
                this.emitted[10] = new PatchModuleFileManager(new ModuleFileManager(this.cap, ClassPath.EMPTY, ROOT_TO_COLLECTION, this.sourceLevel, StandardLocation.MODULE_PATH, false), new ModuleSourceFileManager(ClassPath.EMPTY, ClassPath.EMPTY, this.ignoreExcludes), this.src);
            }
            return this.emitted[10];
        }

        @NonNull
        public static Configuration create(@NonNull ClassPath moduleBoot, @NonNull ClassPath moduleCompile, @NonNull ClassPath bootCached, @NonNull ClassPath compiledCached, @NonNull ClassPath src, @NonNull ClassPath srcCached, @NonNull ClassPath moduleSrcCached, @NonNull ClassPath outputCached, @NonNull ClassPath aptSrcCached, @NonNull SiblingSource siblings, @NonNull FileManagerTransaction fmTx, @NonNull ProcessorGenerated processorGeneratedFiles) {
            return new Configuration(moduleBoot, moduleCompile, bootCached, compiledCached, src, srcCached, moduleSrcCached, outputCached, aptSrcCached, siblings, fmTx, processorGeneratedFiles);
        }

        private static final class Entry {
            private JavaFileManager[] fileManagers;
            private Supplier<JavaFileManager[]> factory;
            private final Function<JavaFileManager[], JavaFileManager[]> filter;

            private Entry(@NonNull Supplier<JavaFileManager[]> factory) {
                this(factory, null);
            }

            private Entry(@NonNull Supplier<JavaFileManager[]> factory, @NullAllowed Function<JavaFileManager[], JavaFileManager[]> filter) {
                assert (factory != null);
                this.factory = factory;
                this.filter = filter;
            }

            boolean hasLocation() {
                return this.get().length > 0;
            }

            @NonNull
            JavaFileManager[] get() {
                JavaFileManager[] res;
                if (this.fileManagers != null) {
                    res = this.fileManagers;
                } else {
                    this.fileManagers = this.factory.get();
                    assert (this.fileManagers != null);
                    this.factory = null;
                    res = this.fileManagers;
                }
                if (this.filter != null) {
                    res = this.filter.apply(res);
                }
                return res;
            }
        }
    }

    static final class RepeatableIterator<T>
    implements Iterator<T> {
        private final Iterator<T> base;
        private final List<T> seen = new ArrayList<T>();
        private Iterator<T> current;

        private RepeatableIterator(@NonNull Iterator<T> base) {
            Parameters.notNull("base", base);
            this.base = base;
            this.reset();
        }

        @Override
        public boolean hasNext() {
            boolean res = this.current.hasNext();
            if (!res && this.current != this.base) {
                this.current = this.base;
                res = this.current.hasNext();
            }
            return res;
        }

        @Override
        @NullUnknown
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T res = this.current.next();
            if (this.current == this.base) {
                this.seen.add(res);
            }
            return res;
        }

        void reset() {
            this.current = this.seen.iterator();
        }

        @NonNull
        static <T> RepeatableIterator<T> create(@NonNull Iterator<T> base) {
            return new RepeatableIterator<T>(base);
        }
    }
}

