/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.nifi.processors.evtx.parser.bxml;

import org.apache.nifi.processors.evtx.parser.BxmlNodeVisitor;
import org.apache.nifi.processors.evtx.parser.bxml.value.VariantTypeNode;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import java.io.IOException;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertInstanceOf;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;

public class RootNodeTest extends BxmlNodeTestBase {

    private String testString = "testString";
    private RootNode rootNode;

    @Override
    @BeforeEach
    public void setup() throws IOException {
        super.setup();
        testBinaryReaderBuilder.put((byte) BxmlNode.END_OF_STREAM_TOKEN);
        testBinaryReaderBuilder.putDWord(1);

        testBinaryReaderBuilder.putWord(testString.length() + 1);
        testBinaryReaderBuilder.putWord(2);
        testBinaryReaderBuilder.putString(testString);
        testBinaryReaderBuilder.put((byte) 0);

        rootNode = new RootNode(testBinaryReaderBuilder.build(), chunkHeader, parent);
    }

    @Test
    public void testInit() {
        List<BxmlNode> children = rootNode.getChildren();
        assertEquals(1, children.size());
        assertInstanceOf(EndOfStreamNode.class, children.get(0));

        List<VariantTypeNode> substitutions = rootNode.getSubstitutions();
        assertEquals(1, substitutions.size());
        assertEquals(testString, substitutions.get(0).getValue());
    }

    @Test
    public void testVisitor() throws IOException {
        BxmlNodeVisitor mock = mock(BxmlNodeVisitor.class);
        rootNode.accept(mock);
        verify(mock).visit(rootNode);
        verifyNoMoreInteractions(mock);
    }
}
