/****************************************************************************
 * libs/libnx/nxfonts/nxfonts_serif29x37.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __LIBS_LIBNX_NXFONTS_NXFONTS_SERIF29X37_H
#define __LIBS_LIBNX_NXFONTS_NXFONTS_SERIF29X37_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

/****************************************************************************
 * Pre-Processor Definitions
 ****************************************************************************/

/* Font ID */

#define NXFONT_ID         FONTID_SERIF29X37

/* Ranges of 7-bit and 8-bit fonts */

#define NXFONT_MIN7BIT    33
#define NXFONT_MAX7BIT    126

#define NXFONT_MIN8BIT    161
#define NXFONT_MAX8BIT    255

/* Maximum height and width of any glyph in the set */

#define NXFONT_MAXHEIGHT  37
#define NXFONT_MAXWIDTH   29

/* The width of a space */

#define NXFONT_SPACEWIDTH 6

/* exclam (33) */
#define NXFONT_METRICS_33 {1, 3, 17, 3, 11, 0}
#define NXFONT_BITMAP_33 {0x40, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x40, 0x40, 0x40, 0x40, 0x0, 0x0, 0x0, 0xc0, 0xc0}

/* quotedbl (34) */
#define NXFONT_METRICS_34 {1, 6, 5, 1, 11, 0}
#define NXFONT_BITMAP_34 {0xcc, 0xcc, 0xcc, 0xcc, 0x88}

/* numbersign (35) */
#define NXFONT_METRICS_35 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_35 {0x8, 0x80, 0x8, 0x80, 0x8, 0x80, 0x8, 0x80, 0x8, 0x80, 0x7f, 0xe0, 0x7f, 0xe0, 0x11, 0x0, 0x11, 0x0, 0x11, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0x22, 0x0, 0x22, 0x0, 0x22, 0x0, 0x22, 0x0, 0x22, 0x0}

/* dollar (36) */
#define NXFONT_METRICS_36 {2, 11, 21, 0, 9, 0}
#define NXFONT_BITMAP_36 {0x4, 0x0, 0x4, 0x0, 0x3f, 0x0, 0x65, 0xc0, 0xc4, 0xc0, 0xc4, 0x40, 0xc4, 0x40, 0xe4, 0x0, 0x7c, 0x0, 0x1e, 0x0, 0x7, 0x80, 0x5, 0xc0, 0x4, 0xe0, 0x4, 0x60, 0x84, 0x60, 0x84, 0x60, 0xc4, 0xc0, 0xe5, 0xc0, 0x3f, 0x0, 0x4, 0x0, 0x4, 0x0}

/* percent (37) */
#define NXFONT_METRICS_37 {3, 17, 16, 1, 12, 0}
#define NXFONT_BITMAP_37 {0x1e, 0xc, 0x0, 0x33, 0xfc, 0x0, 0x61, 0x18, 0x0, 0xc1, 0x10, 0x0, 0xc1, 0x30, 0x0, 0xc2, 0x60, 0x0, 0xe4, 0x40, 0x0, 0x78, 0xc0, 0x0, 0x1, 0x8f, 0x0, 0x1, 0x19, 0x80, 0x3, 0x30, 0x80, 0x6, 0x60, 0x80, 0x4, 0x60, 0x80, 0xc, 0x61, 0x0, 0x18, 0x72, 0x0, 0x10, 0x3c, 0x0}

/* ampersand (38) */
#define NXFONT_METRICS_38 {3, 17, 17, 1, 11, 0}
#define NXFONT_BITMAP_38 {0x7, 0xc0, 0x0, 0x8, 0x60, 0x0, 0x18, 0x20, 0x0, 0x18, 0x20, 0x0, 0x18, 0x60, 0x0, 0xc, 0xc0, 0x0, 0xf, 0x9e, 0x0, 0x7, 0xc, 0x0, 0xf, 0x8, 0x0, 0x33, 0x88, 0x0, 0x61, 0x90, 0x0, 0xc0, 0xd0, 0x0, 0xc0, 0xe0, 0x0, 0xc0, 0x60, 0x0, 0xe0, 0xf0, 0x80, 0x7f, 0xbf, 0x0, 0x3e, 0xe, 0x0}

/* quotesingle (39) */
#define NXFONT_METRICS_39 {1, 2, 5, 2, 11, 0}
#define NXFONT_BITMAP_39 {0xc0, 0xc0, 0xc0, 0xc0, 0x80}

/* parenleft (40) */
#define NXFONT_METRICS_40 {1, 6, 22, 1, 11, 0}
#define NXFONT_BITMAP_40 {0x4, 0x8, 0x10, 0x30, 0x20, 0x60, 0x60, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x60, 0x60, 0x20, 0x30, 0x10, 0x8, 0x4}

/* parenright (41) */
#define NXFONT_METRICS_41 {1, 6, 22, 1, 11, 0}
#define NXFONT_BITMAP_41 {0x80, 0x40, 0x20, 0x30, 0x10, 0x18, 0x18, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0x18, 0x18, 0x10, 0x30, 0x20, 0x40, 0x80}

/* asterisk (42) */
#define NXFONT_METRICS_42 {2, 9, 9, 2, 11, 0}
#define NXFONT_BITMAP_42 {0x1c, 0x0, 0x1c, 0x0, 0xc9, 0x80, 0xeb, 0x80, 0x1c, 0x0, 0xeb, 0x80, 0xc9, 0x80, 0x1c, 0x0, 0x1c, 0x0}

/* plus (43) */
#define NXFONT_METRICS_43 {2, 12, 12, 0, 16, 0}
#define NXFONT_BITMAP_43 {0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0xff, 0xf0, 0xff, 0xf0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0}

/* comma (44) */
#define NXFONT_METRICS_44 {1, 3, 5, 2, 26, 0}
#define NXFONT_BITMAP_44 {0xc0, 0xe0, 0x20, 0x60, 0xc0}

/* hyphen (45) */
#define NXFONT_METRICS_45 {1, 6, 2, 0, 21, 0}
#define NXFONT_BITMAP_45 {0xfc, 0xfc}

/* period (46) */
#define NXFONT_METRICS_46 {1, 2, 2, 2, 26, 0}
#define NXFONT_BITMAP_46 {0xc0, 0xc0}

/* slash (47) */
#define NXFONT_METRICS_47 {2, 9, 21, 0, 11, 0}
#define NXFONT_BITMAP_47 {0x1, 0x80, 0x1, 0x80, 0x1, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x6, 0x0, 0x6, 0x0, 0x4, 0x0, 0xc, 0x0, 0xc, 0x0, 0x8, 0x0, 0x18, 0x0, 0x18, 0x0, 0x10, 0x0, 0x30, 0x0, 0x30, 0x0, 0x60, 0x0, 0x60, 0x0, 0x40, 0x0, 0xc0, 0x0}

/* zero (48) */
#define NXFONT_METRICS_48 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_48 {0x1e, 0x0, 0x33, 0x0, 0x61, 0x80, 0x61, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe1, 0xc0, 0x61, 0x80, 0x61, 0x80, 0x33, 0x0, 0x1e, 0x0}

/* one (49) */
#define NXFONT_METRICS_49 {1, 8, 17, 2, 11, 0}
#define NXFONT_BITMAP_49 {0x8, 0x18, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff}

/* two (50) */
#define NXFONT_METRICS_50 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_50 {0x1c, 0x0, 0x7f, 0x0, 0x43, 0x80, 0x81, 0x80, 0x81, 0x80, 0x1, 0x80, 0x1, 0x80, 0x3, 0x0, 0x3, 0x0, 0x6, 0x0, 0x4, 0x0, 0xc, 0x0, 0x18, 0x0, 0x30, 0x0, 0x60, 0x40, 0xff, 0xc0, 0xff, 0x80}

/* three (51) */
#define NXFONT_METRICS_51 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_51 {0x1c, 0x0, 0x7e, 0x0, 0x47, 0x0, 0x83, 0x0, 0x83, 0x0, 0x6, 0x0, 0xc, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x3, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x0, 0xc3, 0x0, 0xe6, 0x0, 0x78, 0x0}

/* four (52) */
#define NXFONT_METRICS_52 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_52 {0x3, 0x0, 0x7, 0x0, 0x7, 0x0, 0xb, 0x0, 0x1b, 0x0, 0x13, 0x0, 0x33, 0x0, 0x23, 0x0, 0x63, 0x0, 0x43, 0x0, 0xc3, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0}

/* five (53) */
#define NXFONT_METRICS_53 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_53 {0x1f, 0xc0, 0x1f, 0x80, 0x20, 0x0, 0x20, 0x0, 0x60, 0x0, 0x78, 0x0, 0x7e, 0x0, 0xf, 0x80, 0x3, 0x80, 0x1, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0xc1, 0x80, 0xe3, 0x80, 0x7e, 0x0}

/* six (54) */
#define NXFONT_METRICS_54 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_54 {0x3, 0xc0, 0xe, 0x0, 0x18, 0x0, 0x30, 0x0, 0x70, 0x0, 0x60, 0x0, 0xee, 0x0, 0xf3, 0x80, 0xc1, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe0, 0xc0, 0x61, 0x80, 0x7b, 0x80, 0x1e, 0x0}

/* seven (55) */
#define NXFONT_METRICS_55 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_55 {0x7f, 0xc0, 0xff, 0xc0, 0xc0, 0xc0, 0x81, 0x80, 0x1, 0x80, 0x1, 0x0, 0x3, 0x0, 0x3, 0x0, 0x2, 0x0, 0x6, 0x0, 0x6, 0x0, 0x4, 0x0, 0xc, 0x0, 0xc, 0x0, 0xc, 0x0, 0x18, 0x0, 0x18, 0x0}

/* eight (56) */
#define NXFONT_METRICS_56 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_56 {0x1e, 0x0, 0x33, 0x0, 0x61, 0x80, 0x61, 0x80, 0x61, 0x80, 0x73, 0x0, 0x3e, 0x0, 0x1e, 0x0, 0x3f, 0x0, 0x63, 0x80, 0x41, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe1, 0x80, 0x73, 0x80, 0x1e, 0x0}

/* nine (57) */
#define NXFONT_METRICS_57 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_57 {0x1e, 0x0, 0x77, 0x80, 0x61, 0x80, 0xc1, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x61, 0xc0, 0x73, 0xc0, 0x1d, 0x80, 0x1, 0x80, 0x3, 0x80, 0x3, 0x0, 0x6, 0x0, 0x1c, 0x0, 0xf0, 0x0}

/* colon (58) */
#define NXFONT_METRICS_58 {1, 2, 11, 2, 17, 0}
#define NXFONT_BITMAP_58 {0xc0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0, 0xc0}

/* semicolon (59) */
#define NXFONT_METRICS_59 {1, 3, 14, 2, 17, 0}
#define NXFONT_BITMAP_59 {0xc0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc0, 0xe0, 0x20, 0x60, 0xc0}

/* less (60) */
#define NXFONT_METRICS_60 {2, 11, 11, 1, 17, 0}
#define NXFONT_BITMAP_60 {0x0, 0x60, 0x1, 0xc0, 0x7, 0x0, 0x1c, 0x0, 0x70, 0x0, 0xc0, 0x0, 0x70, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x1, 0xc0, 0x0, 0x60}

/* equal (61) */
#define NXFONT_METRICS_61 {2, 9, 5, 2, 20, 0}
#define NXFONT_BITMAP_61 {0xff, 0x80, 0xff, 0x80, 0x0, 0x0, 0xff, 0x80, 0xff, 0x80}

/* greater (62) */
#define NXFONT_METRICS_62 {2, 11, 11, 1, 17, 0}
#define NXFONT_BITMAP_62 {0xc0, 0x0, 0x70, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x1, 0xc0, 0x0, 0x60, 0x1, 0xc0, 0x7, 0x0, 0x1c, 0x0, 0x70, 0x0, 0xc0, 0x0}

/* question (63) */
#define NXFONT_METRICS_63 {1, 8, 17, 2, 11, 0}
#define NXFONT_BITMAP_63 {0x7c, 0xc6, 0x83, 0xc3, 0xc3, 0x7, 0xe, 0xc, 0x1c, 0x18, 0x18, 0x10, 0x10, 0x0, 0x0, 0x30, 0x30}

/* at (64) */
#define NXFONT_METRICS_64 {3, 18, 20, 2, 11, 0}
#define NXFONT_BITMAP_64 {0x3, 0xf8, 0x0, 0xf, 0xe, 0x0, 0x1c, 0x3, 0x0, 0x38, 0x1, 0x80, 0x70, 0x0, 0x80, 0x60, 0xec, 0xc0, 0xe1, 0xfc, 0x40, 0xc3, 0x8c, 0x40, 0xc3, 0xc, 0x40, 0xc6, 0xc, 0x40, 0xc6, 0x18, 0x40, 0xc6, 0x18, 0xc0, 0xc6, 0x18, 0x80, 0xc6, 0x39, 0x80, 0x63, 0x7b, 0x0, 0x61, 0xde, 0x0, 0x30, 0x0, 0x0, 0x18, 0x0, 0x0, 0xe, 0xc, 0x0, 0x3, 0xf0, 0x0}

/* A (65) */
#define NXFONT_METRICS_65 {3, 17, 17, 0, 11, 0}
#define NXFONT_BITMAP_65 {0x0, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0x60, 0x0, 0x2, 0x60, 0x0, 0x2, 0x30, 0x0, 0x6, 0x30, 0x0, 0x4, 0x30, 0x0, 0x4, 0x18, 0x0, 0xc, 0x18, 0x0, 0xf, 0xf8, 0x0, 0x8, 0xc, 0x0, 0x18, 0xc, 0x0, 0x10, 0xc, 0x0, 0x10, 0x6, 0x0, 0x30, 0x6, 0x0, 0xfc, 0x1f, 0x80}

/* B (66) */
#define NXFONT_METRICS_66 {2, 14, 17, 1, 11, 0}
#define NXFONT_BITMAP_66 {0xff, 0xc0, 0x30, 0x70, 0x30, 0x30, 0x30, 0x18, 0x30, 0x18, 0x30, 0x18, 0x30, 0x30, 0x30, 0x40, 0x3f, 0xe0, 0x30, 0x38, 0x30, 0x18, 0x30, 0xc, 0x30, 0xc, 0x30, 0xc, 0x30, 0x18, 0x30, 0x78, 0xff, 0xe0}

/* C (67) */
#define NXFONT_METRICS_67 {2, 14, 17, 1, 11, 0}
#define NXFONT_BITMAP_67 {0x7, 0xe4, 0x1c, 0x3c, 0x38, 0xc, 0x60, 0x4, 0x60, 0x4, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0x60, 0x0, 0x60, 0x4, 0x38, 0x8, 0x1e, 0x38, 0x7, 0xe0}

/* D (68) */
#define NXFONT_METRICS_68 {2, 15, 17, 1, 11, 0}
#define NXFONT_BITMAP_68 {0xff, 0xc0, 0x30, 0x70, 0x30, 0x38, 0x30, 0xc, 0x30, 0xc, 0x30, 0x6, 0x30, 0x6, 0x30, 0x6, 0x30, 0x6, 0x30, 0x6, 0x30, 0x6, 0x30, 0x6, 0x30, 0xc, 0x30, 0xc, 0x30, 0x38, 0x30, 0x70, 0xff, 0xc0}

/* E (69) */
#define NXFONT_METRICS_69 {2, 13, 17, 1, 11, 0}
#define NXFONT_BITMAP_69 {0xff, 0xf0, 0x30, 0x30, 0x30, 0x10, 0x30, 0x10, 0x30, 0x0, 0x30, 0x0, 0x30, 0x40, 0x30, 0x40, 0x3f, 0xc0, 0x30, 0x40, 0x30, 0x40, 0x30, 0x0, 0x30, 0x0, 0x30, 0x8, 0x30, 0x8, 0x30, 0x18, 0xff, 0xf8}

/* F (70) */
#define NXFONT_METRICS_70 {2, 12, 17, 1, 11, 0}
#define NXFONT_BITMAP_70 {0xff, 0xf0, 0x30, 0x30, 0x30, 0x10, 0x30, 0x10, 0x30, 0x0, 0x30, 0x0, 0x30, 0x20, 0x30, 0x20, 0x3f, 0xe0, 0x30, 0x20, 0x30, 0x20, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0xfc, 0x0}

/* G (71) */
#define NXFONT_METRICS_71 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_71 {0x7, 0xe4, 0x1c, 0x3c, 0x38, 0xc, 0x60, 0x4, 0x60, 0x4, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x3f, 0xc0, 0xc, 0xc0, 0xc, 0x60, 0xc, 0x60, 0xc, 0x38, 0x1c, 0x1e, 0x38, 0x7, 0xe0}

/* H (72) */
#define NXFONT_METRICS_72 {3, 17, 17, 1, 11, 0}
#define NXFONT_BITMAP_72 {0xfc, 0x1f, 0x80, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x3f, 0xfe, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0x30, 0x6, 0x0, 0xfc, 0x1f, 0x80}

/* I (73) */
#define NXFONT_METRICS_73 {1, 6, 17, 1, 11, 0}
#define NXFONT_BITMAP_73 {0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xfc}

/* J (74) */
#define NXFONT_METRICS_74 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_74 {0x1f, 0x80, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0x6, 0x0, 0xc6, 0x0, 0xcc, 0x0, 0x78, 0x0}

/* K (75) */
#define NXFONT_METRICS_75 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_75 {0xfc, 0x7e, 0x30, 0x18, 0x30, 0x30, 0x30, 0x60, 0x30, 0xc0, 0x31, 0x80, 0x33, 0x0, 0x3e, 0x0, 0x3f, 0x0, 0x33, 0x80, 0x31, 0xc0, 0x30, 0xe0, 0x30, 0x70, 0x30, 0x38, 0x30, 0x1c, 0x30, 0xe, 0xfc, 0x1f}

/* L (76) */
#define NXFONT_METRICS_76 {2, 13, 17, 1, 11, 0}
#define NXFONT_BITMAP_76 {0xfc, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x8, 0x30, 0x8, 0x30, 0x18, 0xff, 0xf8}

/* M (77) */
#define NXFONT_METRICS_77 {3, 21, 17, 1, 11, 0}
#define NXFONT_BITMAP_77 {0xf0, 0x0, 0xf8, 0x30, 0x0, 0xe0, 0x38, 0x1, 0x60, 0x38, 0x1, 0x60, 0x2c, 0x2, 0x60, 0x2c, 0x2, 0x60, 0x26, 0x2, 0x60, 0x26, 0x4, 0x60, 0x23, 0x4, 0x60, 0x23, 0x8, 0x60, 0x21, 0x88, 0x60, 0x21, 0x88, 0x60, 0x20, 0xd0, 0x60, 0x20, 0xd0, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0xf8, 0x61, 0xf8}

/* N (78) */
#define NXFONT_METRICS_78 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_78 {0xf0, 0x1f, 0x30, 0x4, 0x38, 0x4, 0x38, 0x4, 0x2c, 0x4, 0x26, 0x4, 0x26, 0x4, 0x23, 0x4, 0x21, 0x84, 0x21, 0x84, 0x20, 0xc4, 0x20, 0x64, 0x20, 0x64, 0x20, 0x34, 0x20, 0x1c, 0x20, 0x1c, 0xf8, 0xc}

/* O (79) */
#define NXFONT_METRICS_79 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_79 {0x7, 0xe0, 0x1c, 0x38, 0x38, 0x1c, 0x60, 0x6, 0x60, 0x6, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0x60, 0x6, 0x60, 0x6, 0x38, 0x1c, 0x1c, 0x38, 0x7, 0xe0}

/* P (80) */
#define NXFONT_METRICS_80 {2, 13, 17, 1, 11, 0}
#define NXFONT_BITMAP_80 {0xff, 0xc0, 0x30, 0x70, 0x30, 0x30, 0x30, 0x18, 0x30, 0x18, 0x30, 0x18, 0x30, 0x30, 0x30, 0x70, 0x3f, 0xc0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0xfc, 0x0}

/* Q (81) */
#define NXFONT_METRICS_81 {2, 16, 22, 1, 11, 0}
#define NXFONT_BITMAP_81 {0x7, 0xe0, 0x1c, 0x38, 0x38, 0x1c, 0x60, 0x6, 0x60, 0x6, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0x60, 0x6, 0x60, 0x6, 0x38, 0x1c, 0x1c, 0x38, 0x7, 0xe0, 0x1, 0xc0, 0x0, 0xe0, 0x0, 0x70, 0x0, 0x38, 0x0, 0xf}

/* R (82) */
#define NXFONT_METRICS_82 {2, 15, 17, 1, 11, 0}
#define NXFONT_BITMAP_82 {0xff, 0xc0, 0x30, 0x70, 0x30, 0x30, 0x30, 0x18, 0x30, 0x18, 0x30, 0x18, 0x30, 0x30, 0x30, 0x70, 0x3f, 0xc0, 0x33, 0x80, 0x31, 0x80, 0x30, 0xc0, 0x30, 0x60, 0x30, 0x70, 0x30, 0x38, 0x30, 0x1c, 0xfc, 0x1e}

/* S (83) */
#define NXFONT_METRICS_83 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_83 {0x1e, 0x40, 0x63, 0xc0, 0xc0, 0xc0, 0xc0, 0x40, 0xc0, 0x40, 0xe0, 0x0, 0x78, 0x0, 0x1e, 0x0, 0xf, 0x80, 0x3, 0xc0, 0x0, 0xe0, 0x0, 0x60, 0x80, 0x60, 0x80, 0x60, 0xc0, 0xc0, 0xf1, 0x80, 0x9e, 0x0}

/* T (84) */
#define NXFONT_METRICS_84 {2, 14, 17, 1, 11, 0}
#define NXFONT_BITMAP_84 {0xff, 0xfc, 0xc3, 0xc, 0x83, 0x4, 0x83, 0x4, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0xf, 0xc0}

/* U (85) */
#define NXFONT_METRICS_85 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_85 {0xfc, 0x1f, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x8, 0x18, 0x8, 0x1c, 0x30, 0x7, 0xe0}

/* V (86) */
#define NXFONT_METRICS_86 {3, 17, 17, 0, 11, 0}
#define NXFONT_BITMAP_86 {0xfc, 0x1f, 0x80, 0x30, 0x6, 0x0, 0x30, 0x4, 0x0, 0x18, 0xc, 0x0, 0x18, 0x8, 0x0, 0x18, 0x8, 0x0, 0xc, 0x18, 0x0, 0xc, 0x10, 0x0, 0x6, 0x30, 0x0, 0x6, 0x20, 0x0, 0x6, 0x20, 0x0, 0x3, 0x60, 0x0, 0x3, 0x40, 0x0, 0x3, 0xc0, 0x0, 0x1, 0x80, 0x0, 0x1, 0x80, 0x0, 0x1, 0x80, 0x0}

/* W (87) */
#define NXFONT_METRICS_87 {3, 23, 17, 0, 11, 0}
#define NXFONT_BITMAP_87 {0xfc, 0x7e, 0x7e, 0x30, 0x18, 0x18, 0x30, 0x18, 0x10, 0x18, 0x18, 0x10, 0x18, 0x18, 0x30, 0x18, 0x2c, 0x20, 0xc, 0x2c, 0x20, 0xc, 0x2c, 0x60, 0x6, 0x4c, 0x60, 0x6, 0x4c, 0x40, 0x6, 0x46, 0x40, 0x3, 0x46, 0xc0, 0x3, 0x46, 0x80, 0x3, 0x87, 0x80, 0x1, 0x83, 0x80, 0x1, 0x83, 0x0, 0x1, 0x83, 0x0}

/* X (88) */
#define NXFONT_METRICS_88 {3, 18, 17, 0, 11, 0}
#define NXFONT_BITMAP_88 {0x7e, 0xf, 0x80, 0x1c, 0x6, 0x0, 0xe, 0xc, 0x0, 0x6, 0x8, 0x0, 0x3, 0x10, 0x0, 0x1, 0xa0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0xe0, 0x0, 0x1, 0x70, 0x0, 0x2, 0x38, 0x0, 0x6, 0x18, 0x0, 0x4, 0xc, 0x0, 0x8, 0xe, 0x0, 0x18, 0x7, 0x0, 0x30, 0x3, 0x80, 0xfc, 0xf, 0xc0}

/* Y (89) */
#define NXFONT_METRICS_89 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_89 {0xfc, 0x3f, 0x30, 0xc, 0x38, 0x8, 0x18, 0x18, 0x1c, 0x10, 0xc, 0x30, 0x6, 0x20, 0x6, 0x60, 0x3, 0x40, 0x3, 0xc0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x7, 0xe0}

/* Z (90) */
#define NXFONT_METRICS_90 {2, 13, 17, 1, 11, 0}
#define NXFONT_BITMAP_90 {0xff, 0xf0, 0xc0, 0x70, 0x80, 0xe0, 0x80, 0xc0, 0x1, 0xc0, 0x3, 0x80, 0x3, 0x0, 0x7, 0x0, 0x6, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x38, 0x0, 0x30, 0x8, 0x70, 0x8, 0xe0, 0x18, 0xff, 0xf8}

/* bracketleft (91) */
#define NXFONT_METRICS_91 {1, 5, 21, 2, 11, 0}
#define NXFONT_BITMAP_91 {0xf8, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xf8}

/* backslash (92) */
#define NXFONT_METRICS_92 {1, 7, 17, 0, 11, 0}
#define NXFONT_BITMAP_92 {0xc0, 0xc0, 0x40, 0x60, 0x60, 0x20, 0x30, 0x30, 0x10, 0x18, 0x18, 0x8, 0xc, 0xc, 0x4, 0x6, 0x6}

/* bracketright (93) */
#define NXFONT_METRICS_93 {1, 5, 21, 1, 11, 0}
#define NXFONT_BITMAP_93 {0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8}

/* asciicircum (94) */
#define NXFONT_METRICS_94 {2, 9, 9, 1, 11, 0}
#define NXFONT_BITMAP_94 {0x8, 0x0, 0x1c, 0x0, 0x14, 0x0, 0x36, 0x0, 0x22, 0x0, 0x63, 0x0, 0x41, 0x0, 0xc1, 0x80, 0x80, 0x80}

/* underscore (95) */
#define NXFONT_METRICS_95 {2, 12, 2, 0, 31, 0}
#define NXFONT_BITMAP_95 {0xff, 0xf0, 0xff, 0xf0}

/* grave (96) */
#define NXFONT_METRICS_96 {1, 5, 4, 1, 11, 0}
#define NXFONT_BITMAP_96 {0xc0, 0xe0, 0x70, 0x18}

/* a (97) */
#define NXFONT_METRICS_97 {2, 9, 12, 1, 16, 0}
#define NXFONT_BITMAP_97 {0x3e, 0x0, 0x67, 0x0, 0x63, 0x0, 0x3, 0x0, 0xf, 0x0, 0x3b, 0x0, 0x63, 0x0, 0xc3, 0x0, 0xc3, 0x0, 0xc7, 0x0, 0xfb, 0x0, 0x71, 0x80}

/* b (98) */
#define NXFONT_METRICS_98 {2, 11, 17, 0, 11, 0}
#define NXFONT_BITMAP_98 {0x30, 0x0, 0xf0, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x37, 0x0, 0x39, 0xc0, 0x30, 0xc0, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xc0, 0x39, 0xc0, 0x2f, 0x0}

/* c (99) */
#define NXFONT_METRICS_99 {2, 9, 12, 1, 16, 0}
#define NXFONT_BITMAP_99 {0x1f, 0x0, 0x63, 0x80, 0x41, 0x80, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0x70, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* d (100) */
#define NXFONT_METRICS_100 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_100 {0x1, 0x80, 0x7, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1d, 0x80, 0x73, 0x80, 0x61, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0x63, 0x80, 0x7f, 0x80, 0x19, 0xc0}

/* e (101) */
#define NXFONT_METRICS_101 {2, 9, 12, 1, 16, 0}
#define NXFONT_BITMAP_101 {0x1e, 0x0, 0x63, 0x0, 0x41, 0x80, 0xc1, 0x80, 0xff, 0x80, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0x70, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* f (102) */
#define NXFONT_METRICS_102 {1, 7, 17, 0, 11, 0}
#define NXFONT_BITMAP_102 {0xe, 0x16, 0x30, 0x30, 0x30, 0xfe, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78}

/* g (103) */
#define NXFONT_METRICS_103 {2, 11, 18, 1, 16, 0}
#define NXFONT_BITMAP_103 {0x1e, 0xc0, 0x23, 0xc0, 0x61, 0x0, 0x61, 0x80, 0x61, 0x80, 0x61, 0x80, 0x61, 0x80, 0x33, 0x0, 0x3c, 0x0, 0x40, 0x0, 0x60, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0x40, 0xe0, 0xc0, 0x60, 0xc0, 0x60, 0xe1, 0xc0, 0x7f, 0x0}

/* h (104) */
#define NXFONT_METRICS_104 {2, 12, 17, 0, 11, 0}
#define NXFONT_BITMAP_104 {0x30, 0x0, 0xf0, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x33, 0x80, 0x37, 0xc0, 0x38, 0xe0, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x78, 0xf0}

/* i (105) */
#define NXFONT_METRICS_105 {1, 4, 17, 1, 11, 0}
#define NXFONT_BITMAP_105 {0x60, 0x60, 0x0, 0x0, 0x0, 0x60, 0xe0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0}

/* j (106) - NOTE: Xoffset should be -2, not 0. */
#define NXFONT_METRICS_106 {1, 6, 23, 0, 11, 0}
#define NXFONT_BITMAP_106 {0xc, 0xc, 0x0, 0x0, 0x0, 0xc, 0x1c, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xcc, 0xc8, 0x70}

/* k (107) */
#define NXFONT_METRICS_107 {2, 12, 17, 0, 11, 0}
#define NXFONT_BITMAP_107 {0x30, 0x0, 0xf0, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x33, 0xe0, 0x31, 0x80, 0x33, 0x0, 0x32, 0x0, 0x34, 0x0, 0x3c, 0x0, 0x36, 0x0, 0x37, 0x0, 0x33, 0x80, 0x31, 0xc0, 0x30, 0xe0, 0x79, 0xf0}

/* l (108) */
#define NXFONT_METRICS_108 {1, 5, 17, 0, 11, 0}
#define NXFONT_BITMAP_108 {0x30, 0xf0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78}

/* m (109) */
#define NXFONT_METRICS_109 {3, 18, 12, 1, 16, 0}
#define NXFONT_BITMAP_109 {0x67, 0xe, 0x0, 0xef, 0x9f, 0x0, 0x71, 0xe3, 0x80, 0x60, 0xc1, 0x80, 0x60, 0xc1, 0x80, 0x60, 0xc1, 0x80, 0x60, 0xc1, 0x80, 0x60, 0xc1, 0x80, 0x60, 0xc1, 0x80, 0x60, 0xc1, 0x80, 0x60, 0xc1, 0x80, 0xf1, 0xe3, 0xc0}

/* n (110) */
#define NXFONT_METRICS_110 {2, 11, 12, 1, 16, 0}
#define NXFONT_BITMAP_110 {0x67, 0x0, 0xef, 0x80, 0x71, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0xf1, 0xe0}

/* o (111) */
#define NXFONT_METRICS_111 {2, 10, 12, 1, 16, 0}
#define NXFONT_BITMAP_111 {0x1e, 0x0, 0x73, 0x80, 0x61, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x61, 0x80, 0x73, 0x80, 0x1e, 0x0}

/* p (112) */
#define NXFONT_METRICS_112 {2, 10, 18, 1, 16, 0}
#define NXFONT_BITMAP_112 {0x6e, 0x0, 0xf3, 0x80, 0x61, 0x80, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x61, 0x80, 0x73, 0x80, 0x6e, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0xf0, 0x0}

/* q (113) */
#define NXFONT_METRICS_113 {2, 10, 18, 1, 16, 0}
#define NXFONT_BITMAP_113 {0x1d, 0x80, 0x73, 0x80, 0x61, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0xc1, 0x80, 0x61, 0x80, 0x73, 0x80, 0x1d, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x3, 0xc0}

/* r (114) */
#define NXFONT_METRICS_114 {1, 6, 12, 1, 16, 0}
#define NXFONT_BITMAP_114 {0x6c, 0xec, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0}

/* s (115) */
#define NXFONT_METRICS_115 {1, 8, 12, 1, 16, 0}
#define NXFONT_BITMAP_115 {0x3e, 0x46, 0xc2, 0xe0, 0x70, 0x7c, 0x1e, 0x7, 0x3, 0x83, 0xc6, 0xf8}

/* t (116) */
#define NXFONT_METRICS_116 {1, 7, 15, 0, 13, 0}
#define NXFONT_BITMAP_116 {0x10, 0x30, 0x70, 0xfe, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32, 0x1c}

/* u (117) */
#define NXFONT_METRICS_117 {2, 11, 12, 1, 16, 0}
#define NXFONT_BITMAP_117 {0xe1, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x71, 0xc0, 0x3e, 0xc0, 0x1c, 0xe0}

/* v (118) */
#define NXFONT_METRICS_118 {2, 11, 12, 0, 16, 0}
#define NXFONT_BITMAP_118 {0xf1, 0xe0, 0x60, 0xc0, 0x60, 0x80, 0x30, 0x80, 0x30, 0x80, 0x31, 0x0, 0x19, 0x0, 0x19, 0x0, 0x1a, 0x0, 0xe, 0x0, 0xe, 0x0, 0x4, 0x0}

/* w (119) */
#define NXFONT_METRICS_119 {3, 17, 12, 0, 16, 0}
#define NXFONT_BITMAP_119 {0xf1, 0xe7, 0x80, 0x60, 0xc3, 0x0, 0x60, 0xc2, 0x0, 0x30, 0xc2, 0x0, 0x30, 0xc2, 0x0, 0x31, 0x64, 0x0, 0x19, 0x64, 0x0, 0x1a, 0x64, 0x0, 0x1a, 0x28, 0x0, 0xe, 0x38, 0x0, 0xe, 0x38, 0x0, 0x4, 0x10, 0x0}

/* x (120) */
#define NXFONT_METRICS_120 {2, 11, 12, 1, 16, 0}
#define NXFONT_BITMAP_120 {0xf1, 0xe0, 0x60, 0xc0, 0x31, 0x80, 0x39, 0x0, 0x1a, 0x0, 0xc, 0x0, 0xe, 0x0, 0x1b, 0x0, 0x33, 0x80, 0x21, 0x80, 0x60, 0xc0, 0xf1, 0xe0}

/* y (121) */
#define NXFONT_METRICS_121 {2, 12, 18, 0, 16, 0}
#define NXFONT_BITMAP_121 {0x78, 0xf0, 0x30, 0x60, 0x30, 0x40, 0x18, 0x40, 0x18, 0x40, 0x18, 0x80, 0xc, 0x80, 0xc, 0x80, 0xd, 0x0, 0x7, 0x0, 0x7, 0x0, 0x2, 0x0, 0x6, 0x0, 0x4, 0x0, 0xc, 0x0, 0xc8, 0x0, 0xf0, 0x0, 0x60, 0x0}

/* z (122) */
#define NXFONT_METRICS_122 {1, 8, 12, 1, 16, 0}
#define NXFONT_BITMAP_122 {0xff, 0xc3, 0x86, 0xe, 0x1c, 0x18, 0x38, 0x30, 0x70, 0x61, 0xc3, 0xff}

/* braceleft (123) */
#define NXFONT_METRICS_123 {1, 8, 22, 1, 11, 0}
#define NXFONT_BITMAP_123 {0x7, 0xc, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 0x30, 0x20, 0xc0, 0x20, 0x30, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xc, 0x7}

/* bar (124) */
#define NXFONT_METRICS_124 {1, 2, 17, 1, 11, 0}
#define NXFONT_BITMAP_124 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* braceright (125) */
#define NXFONT_METRICS_125 {1, 8, 22, 1, 11, 0}
#define NXFONT_BITMAP_125 {0xe0, 0x30, 0x18, 0x18, 0x18, 0x18, 0x18, 0x8, 0xc, 0x4, 0x3, 0x4, 0xc, 0x8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0xe0}

/* asciitilde (126) */
#define NXFONT_METRICS_126 {2, 11, 4, 1, 20, 0}
#define NXFONT_BITMAP_126 {0x38, 0x20, 0x7c, 0x60, 0xc7, 0xc0, 0x83, 0x80}

/* exclamdown (161) */
#define NXFONT_METRICS_161 {1, 3, 17, 3, 16, 0}
#define NXFONT_BITMAP_161 {0x60, 0x60, 0x0, 0x0, 0x0, 0x40, 0x40, 0x40, 0x40, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x40}

/* cent (162) */
#define NXFONT_METRICS_162 {2, 9, 16, 1, 14, 0}
#define NXFONT_BITMAP_162 {0x2, 0x0, 0x2, 0x0, 0xf, 0x0, 0x33, 0x80, 0x65, 0x80, 0xc4, 0x0, 0xc4, 0x0, 0xc8, 0x0, 0xc8, 0x0, 0xc8, 0x0, 0xd0, 0x0, 0x70, 0x80, 0x71, 0x0, 0x3e, 0x0, 0x40, 0x0, 0x40, 0x0}

/* sterling (163) */
#define NXFONT_METRICS_163 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_163 {0xf, 0x0, 0x19, 0x80, 0x31, 0x80, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0xfc, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x78, 0x40, 0xbe, 0xc0, 0xe7, 0x80}

/* currency (164) */
#define NXFONT_METRICS_164 {2, 11, 12, 1, 13, 0}
#define NXFONT_BITMAP_164 {0xc0, 0x60, 0xee, 0xe0, 0x7f, 0xc0, 0x31, 0x80, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x31, 0x80, 0x7f, 0xc0, 0xee, 0xe0, 0xc0, 0x60}

/* yen (165) */
#define NXFONT_METRICS_165 {2, 14, 17, 0, 11, 0}
#define NXFONT_BITMAP_165 {0xf8, 0x7c, 0x70, 0x30, 0x30, 0x20, 0x18, 0x60, 0x18, 0x40, 0xc, 0xc0, 0xc, 0x80, 0x7, 0x80, 0x3, 0x0, 0x1f, 0xe0, 0x3, 0x0, 0x1f, 0xe0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0x3, 0x0, 0xf, 0xc0}

/* brokenbar (166) */
#define NXFONT_METRICS_166 {1, 2, 17, 2, 11, 0}
#define NXFONT_BITMAP_166 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x0, 0x0, 0x0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* section (167) */
#define NXFONT_METRICS_167 {1, 8, 20, 2, 11, 0}
#define NXFONT_BITMAP_167 {0x1c, 0x26, 0x46, 0x60, 0x70, 0x38, 0x3c, 0x4e, 0x87, 0x83, 0xc3, 0xe2, 0x74, 0x38, 0x1c, 0xe, 0x6, 0x62, 0x64, 0x38}

/* dieresis (168) */
#define NXFONT_METRICS_168 {1, 6, 2, 1, 12, 0}
#define NXFONT_BITMAP_168 {0xcc, 0xcc}

/* copyright (169) */
#define NXFONT_METRICS_169 {3, 17, 17, 1, 11, 0}
#define NXFONT_BITMAP_169 {0x7, 0xf0, 0x0, 0x1c, 0x1c, 0x0, 0x30, 0x6, 0x0, 0x61, 0xe3, 0x0, 0x47, 0x31, 0x0, 0xc4, 0x19, 0x80, 0x8c, 0x0, 0x80, 0x88, 0x0, 0x80, 0x88, 0x0, 0x80, 0x88, 0x0, 0x80, 0x8c, 0x0, 0x80, 0xc4, 0x19, 0x80, 0x47, 0x71, 0x0, 0x61, 0xc3, 0x0, 0x30, 0x6, 0x0, 0x1c, 0x1c, 0x0, 0x7, 0xf0, 0x0}

/* ordfeminine (170) */
#define NXFONT_METRICS_170 {1, 7, 9, 0, 11, 0}
#define NXFONT_BITMAP_170 {0x78, 0xcc, 0xc, 0x7c, 0xcc, 0xcc, 0x76, 0x0, 0xfe}

/* guillemotleft (171) */
#define NXFONT_METRICS_171 {2, 9, 10, 1, 17, 0}
#define NXFONT_BITMAP_171 {0x8, 0x80, 0x19, 0x80, 0x33, 0x0, 0x66, 0x0, 0xcc, 0x0, 0xcc, 0x0, 0x66, 0x0, 0x33, 0x0, 0x19, 0x80, 0x8, 0x80}

/* logicalnot (172) */
#define NXFONT_METRICS_172 {2, 11, 7, 2, 20, 0}
#define NXFONT_BITMAP_172 {0xff, 0xe0, 0xff, 0xe0, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60}

/* hyphen (173) */
#define NXFONT_METRICS_173 {1, 6, 2, 0, 21, 0}
#define NXFONT_BITMAP_173 {0xfc, 0xfc}

/* registered (174) */
#define NXFONT_METRICS_174 {3, 17, 17, 1, 11, 0}
#define NXFONT_BITMAP_174 {0x7, 0xf0, 0x0, 0x1c, 0x1c, 0x0, 0x30, 0x6, 0x0, 0x67, 0xe3, 0x0, 0x42, 0x31, 0x0, 0xc2, 0x11, 0x80, 0x82, 0x10, 0x80, 0x82, 0x30, 0x80, 0x83, 0xe0, 0x80, 0x82, 0x40, 0x80, 0x82, 0x20, 0x80, 0xc2, 0x31, 0x80, 0x47, 0x19, 0x0, 0x60, 0x3, 0x0, 0x30, 0x6, 0x0, 0x1c, 0x1c, 0x0, 0x7, 0xf0, 0x0}

/* macron (175) */
#define NXFONT_METRICS_175 {1, 7, 2, 1, 12, 0}
#define NXFONT_BITMAP_175 {0xfe, 0xfe}

/* degree (176) */
#define NXFONT_METRICS_176 {1, 7, 7, 1, 11, 0}
#define NXFONT_BITMAP_176 {0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x38}

/* plusminus (177) */
#define NXFONT_METRICS_177 {2, 10, 11, 2, 17, 0}
#define NXFONT_BITMAP_177 {0xc, 0x0, 0xc, 0x0, 0xc, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0xc, 0x0, 0xc, 0x0, 0xc, 0x0, 0x0, 0x0, 0xff, 0xc0, 0xff, 0xc0}

/* twosuperior (178) */
#define NXFONT_METRICS_178 {1, 6, 10, 0, 11, 0}
#define NXFONT_BITMAP_178 {0x38, 0x4c, 0x8c, 0xc, 0x8, 0x10, 0x30, 0x20, 0x44, 0xfc}

/* threesuperior (179) */
#define NXFONT_METRICS_179 {1, 6, 10, 0, 11, 0}
#define NXFONT_BITMAP_179 {0x38, 0x4c, 0x8c, 0x8, 0x30, 0x8, 0xc, 0x8c, 0x88, 0x70}

/* acute (180) */
#define NXFONT_METRICS_180 {1, 5, 4, 2, 11, 0}
#define NXFONT_BITMAP_180 {0x18, 0x38, 0x70, 0xc0}

/* mu (181) */
#define NXFONT_METRICS_181 {2, 11, 17, 1, 16, 0}
#define NXFONT_BITMAP_181 {0xe1, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x71, 0xc0, 0x7e, 0xc0, 0x5c, 0xe0, 0x40, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0x40, 0x0}

/* paragraph (182) */
#define NXFONT_METRICS_182 {2, 9, 21, 1, 11, 0}
#define NXFONT_BITMAP_182 {0x1f, 0x80, 0x39, 0x0, 0x79, 0x0, 0x79, 0x0, 0xf9, 0x0, 0xf9, 0x0, 0xf9, 0x0, 0x79, 0x0, 0x79, 0x0, 0x39, 0x0, 0x19, 0x0, 0x9, 0x0, 0x9, 0x0, 0x9, 0x0, 0x9, 0x0, 0x9, 0x0, 0x9, 0x0, 0x9, 0x0, 0x9, 0x0, 0x9, 0x0, 0x9, 0x0}

/* periodcentered (183) */
#define NXFONT_METRICS_183 {1, 2, 3, 2, 20, 0}
#define NXFONT_BITMAP_183 {0xc0, 0xc0, 0xc0}

/* cedilla (184) */
#define NXFONT_METRICS_184 {1, 6, 6, 1, 28, 0}
#define NXFONT_BITMAP_184 {0x10, 0x30, 0x3c, 0xc, 0xcc, 0x78}

/* onesuperior (185) */
#define NXFONT_METRICS_185 {1, 5, 10, 1, 11, 0}
#define NXFONT_BITMAP_185 {0x20, 0x60, 0xa0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xf8}

/* ordmasculine (186) */
#define NXFONT_METRICS_186 {1, 7, 9, 0, 11, 0}
#define NXFONT_BITMAP_186 {0x38, 0x44, 0xc6, 0xc6, 0xc6, 0x44, 0x38, 0x0, 0xfe}

/* guillemotright (187) */
#define NXFONT_METRICS_187 {2, 9, 10, 2, 17, 0}
#define NXFONT_BITMAP_187 {0x88, 0x0, 0xcc, 0x0, 0x66, 0x0, 0x33, 0x0, 0x19, 0x80, 0x19, 0x80, 0x33, 0x0, 0x66, 0x0, 0xcc, 0x0, 0x88, 0x0}

/* onequarter (188) */
#define NXFONT_METRICS_188 {2, 16, 17, 1, 11, 0}
#define NXFONT_BITMAP_188 {0x20, 0x18, 0x60, 0x18, 0xa0, 0x30, 0x20, 0x60, 0x20, 0x60, 0x20, 0xc0, 0x20, 0xc0, 0x21, 0x84, 0x23, 0xc, 0xfb, 0x1c, 0x6, 0x14, 0x6, 0x24, 0xc, 0x64, 0x18, 0x44, 0x18, 0xff, 0x30, 0x4, 0x30, 0x4}

/* onehalf (189) */
#define NXFONT_METRICS_189 {2, 15, 17, 1, 11, 0}
#define NXFONT_BITMAP_189 {0x20, 0x18, 0x60, 0x18, 0xa0, 0x30, 0x20, 0x60, 0x20, 0x60, 0x20, 0xc0, 0x20, 0xc0, 0x21, 0x9c, 0x23, 0x26, 0xfb, 0x46, 0x6, 0x6, 0x6, 0x4, 0xc, 0x8, 0x18, 0x18, 0x18, 0x10, 0x30, 0x22, 0x30, 0x7e}

/* threequarters (190) */
#define NXFONT_METRICS_190 {3, 17, 17, 0, 11, 0}
#define NXFONT_BITMAP_190 {0x38, 0xc, 0x0, 0x4c, 0xc, 0x0, 0x8c, 0x18, 0x0, 0x8, 0x30, 0x0, 0x30, 0x30, 0x0, 0x8, 0x60, 0x0, 0xc, 0x60, 0x0, 0x8c, 0xc2, 0x0, 0x89, 0x86, 0x0, 0x71, 0x8e, 0x0, 0x3, 0xa, 0x0, 0x3, 0x12, 0x0, 0x6, 0x32, 0x0, 0xc, 0x22, 0x0, 0xc, 0x7f, 0x80, 0x18, 0x2, 0x0, 0x18, 0x2, 0x0}

/* questiondown (191) */
#define NXFONT_METRICS_191 {1, 8, 17, 1, 16, 0}
#define NXFONT_BITMAP_191 {0xc, 0xc, 0x0, 0x0, 0x8, 0x8, 0x18, 0x18, 0x38, 0x30, 0x70, 0xe0, 0xc3, 0xc3, 0xc1, 0x63, 0x3e}

/* Agrave (192) */
#define NXFONT_METRICS_192 {3, 17, 22, 0, 6, 0}
#define NXFONT_BITMAP_192 {0xc, 0x0, 0x0, 0xe, 0x0, 0x0, 0x7, 0x0, 0x0, 0x1, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0x60, 0x0, 0x2, 0x60, 0x0, 0x2, 0x30, 0x0, 0x6, 0x30, 0x0, 0x4, 0x30, 0x0, 0x4, 0x18, 0x0, 0xc, 0x18, 0x0, 0xf, 0xf8, 0x0, 0x8, 0xc, 0x0, 0x18, 0xc, 0x0, 0x10, 0xc, 0x0, 0x10, 0x6, 0x0, 0x30, 0x6, 0x0, 0xfc, 0x1f, 0x80}

/* Aacute (193) */
#define NXFONT_METRICS_193 {3, 17, 22, 0, 6, 0}
#define NXFONT_BITMAP_193 {0x0, 0x18, 0x0, 0x0, 0x38, 0x0, 0x0, 0x70, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0x60, 0x0, 0x2, 0x60, 0x0, 0x2, 0x30, 0x0, 0x6, 0x30, 0x0, 0x4, 0x30, 0x0, 0x4, 0x18, 0x0, 0xc, 0x18, 0x0, 0xf, 0xf8, 0x0, 0x8, 0xc, 0x0, 0x18, 0xc, 0x0, 0x10, 0xc, 0x0, 0x10, 0x6, 0x0, 0x30, 0x6, 0x0, 0xfc, 0x1f, 0x80}

/* Acircumflex (194) */
#define NXFONT_METRICS_194 {3, 17, 22, 0, 6, 0}
#define NXFONT_BITMAP_194 {0x1, 0x80, 0x0, 0x3, 0xc0, 0x0, 0x6, 0x60, 0x0, 0x4, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0x60, 0x0, 0x2, 0x60, 0x0, 0x2, 0x30, 0x0, 0x6, 0x30, 0x0, 0x4, 0x30, 0x0, 0x4, 0x18, 0x0, 0xc, 0x18, 0x0, 0xf, 0xf8, 0x0, 0x8, 0xc, 0x0, 0x18, 0xc, 0x0, 0x10, 0xc, 0x0, 0x10, 0x6, 0x0, 0x30, 0x6, 0x0, 0xfc, 0x1f, 0x80}

/* Atilde (195) */
#define NXFONT_METRICS_195 {3, 17, 21, 0, 7, 0}
#define NXFONT_BITMAP_195 {0x3, 0x20, 0x0, 0x7, 0xe0, 0x0, 0x4, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0x60, 0x0, 0x2, 0x60, 0x0, 0x2, 0x30, 0x0, 0x6, 0x30, 0x0, 0x4, 0x30, 0x0, 0x4, 0x18, 0x0, 0xc, 0x18, 0x0, 0xf, 0xf8, 0x0, 0x8, 0xc, 0x0, 0x18, 0xc, 0x0, 0x10, 0xc, 0x0, 0x10, 0x6, 0x0, 0x30, 0x6, 0x0, 0xfc, 0x1f, 0x80}

/* Adieresis (196) */
#define NXFONT_METRICS_196 {3, 17, 21, 0, 7, 0}
#define NXFONT_BITMAP_196 {0x6, 0x60, 0x0, 0x6, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0x60, 0x0, 0x2, 0x60, 0x0, 0x2, 0x30, 0x0, 0x6, 0x30, 0x0, 0x4, 0x30, 0x0, 0x4, 0x18, 0x0, 0xc, 0x18, 0x0, 0xf, 0xf8, 0x0, 0x8, 0xc, 0x0, 0x18, 0xc, 0x0, 0x10, 0xc, 0x0, 0x10, 0x6, 0x0, 0x30, 0x6, 0x0, 0xfc, 0x1f, 0x80}

/* Aring (197) */
#define NXFONT_METRICS_197 {3, 17, 23, 0, 5, 0}
#define NXFONT_BITMAP_197 {0x1, 0xc0, 0x0, 0x2, 0x20, 0x0, 0x2, 0x20, 0x0, 0x2, 0x20, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80, 0x0, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x0, 0x1, 0x60, 0x0, 0x2, 0x60, 0x0, 0x2, 0x30, 0x0, 0x6, 0x30, 0x0, 0x4, 0x30, 0x0, 0x4, 0x18, 0x0, 0xc, 0x18, 0x0, 0xf, 0xf8, 0x0, 0x8, 0xc, 0x0, 0x18, 0xc, 0x0, 0x10, 0xc, 0x0, 0x10, 0x6, 0x0, 0x30, 0x6, 0x0, 0xfc, 0x1f, 0x80}

/* AE (198) */
#define NXFONT_METRICS_198 {3, 21, 17, 0, 11, 0}
#define NXFONT_BITMAP_198 {0x3, 0xff, 0xf0, 0x0, 0xf0, 0x30, 0x1, 0xb0, 0x10, 0x1, 0x30, 0x10, 0x3, 0x30, 0x0, 0x2, 0x30, 0x0, 0x6, 0x30, 0x40, 0x4, 0x30, 0x40, 0x4, 0x3f, 0xc0, 0xc, 0x30, 0x40, 0xf, 0xf0, 0x40, 0x8, 0x30, 0x0, 0x18, 0x30, 0x0, 0x10, 0x30, 0x8, 0x30, 0x30, 0x8, 0x20, 0x30, 0x18, 0xf8, 0xff, 0xf8}

/* Ccedilla (199) */
#define NXFONT_METRICS_199 {2, 14, 23, 1, 11, 0}
#define NXFONT_BITMAP_199 {0x7, 0xe4, 0x1c, 0x3c, 0x38, 0xc, 0x60, 0x4, 0x60, 0x4, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0x60, 0x0, 0x60, 0x4, 0x38, 0x8, 0x1e, 0x38, 0x7, 0xe0, 0x1, 0x0, 0x3, 0x0, 0x3, 0xc0, 0x0, 0xc0, 0xc, 0xc0, 0x7, 0x80}

/* Egrave (200) */
#define NXFONT_METRICS_200 {2, 13, 22, 1, 6, 0}
#define NXFONT_BITMAP_200 {0x18, 0x0, 0x1c, 0x0, 0xe, 0x0, 0x3, 0x0, 0x0, 0x0, 0xff, 0xf0, 0x30, 0x30, 0x30, 0x10, 0x30, 0x10, 0x30, 0x0, 0x30, 0x0, 0x30, 0x40, 0x30, 0x40, 0x3f, 0xc0, 0x30, 0x40, 0x30, 0x40, 0x30, 0x0, 0x30, 0x0, 0x30, 0x8, 0x30, 0x8, 0x30, 0x18, 0xff, 0xf8}

/* Eacute (201) */
#define NXFONT_METRICS_201 {2, 13, 22, 1, 6, 0}
#define NXFONT_BITMAP_201 {0x0, 0x60, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x0, 0x0, 0x0, 0xff, 0xf0, 0x30, 0x30, 0x30, 0x10, 0x30, 0x10, 0x30, 0x0, 0x30, 0x0, 0x30, 0x40, 0x30, 0x40, 0x3f, 0xc0, 0x30, 0x40, 0x30, 0x40, 0x30, 0x0, 0x30, 0x0, 0x30, 0x8, 0x30, 0x8, 0x30, 0x18, 0xff, 0xf8}

/* Ecircumflex (202) */
#define NXFONT_METRICS_202 {2, 13, 22, 1, 6, 0}
#define NXFONT_BITMAP_202 {0x6, 0x0, 0xf, 0x0, 0x19, 0x80, 0x10, 0x80, 0x0, 0x0, 0xff, 0xf0, 0x30, 0x30, 0x30, 0x10, 0x30, 0x10, 0x30, 0x0, 0x30, 0x0, 0x30, 0x40, 0x30, 0x40, 0x3f, 0xc0, 0x30, 0x40, 0x30, 0x40, 0x30, 0x0, 0x30, 0x0, 0x30, 0x8, 0x30, 0x8, 0x30, 0x18, 0xff, 0xf8}

/* Edieresis (203) */
#define NXFONT_METRICS_203 {2, 13, 21, 1, 7, 0}
#define NXFONT_BITMAP_203 {0x19, 0x80, 0x19, 0x80, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf0, 0x30, 0x30, 0x30, 0x10, 0x30, 0x10, 0x30, 0x0, 0x30, 0x0, 0x30, 0x40, 0x30, 0x40, 0x3f, 0xc0, 0x30, 0x40, 0x30, 0x40, 0x30, 0x0, 0x30, 0x0, 0x30, 0x8, 0x30, 0x8, 0x30, 0x18, 0xff, 0xf8}

/* Igrave (204) */
#define NXFONT_METRICS_204 {1, 7, 22, 0, 6, 0}
#define NXFONT_BITMAP_204 {0xc0, 0xe0, 0x70, 0x18, 0x0, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e}

/* Iacute (205) */
#define NXFONT_METRICS_205 {1, 7, 22, 1, 6, 0}
#define NXFONT_BITMAP_205 {0x6, 0xe, 0x1c, 0x30, 0x0, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xfc}

/* Icircumflex (206) */
#define NXFONT_METRICS_206 {1, 6, 22, 1, 6, 0}
#define NXFONT_BITMAP_206 {0x30, 0x78, 0xcc, 0x84, 0x0, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xfc}

/* Idieresis (207) */
#define NXFONT_METRICS_207 {1, 6, 21, 1, 7, 0}
#define NXFONT_BITMAP_207 {0xcc, 0xcc, 0x0, 0x0, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xfc}

/* Eth (208) */
#define NXFONT_METRICS_208 {2, 16, 17, 0, 11, 0}
#define NXFONT_BITMAP_208 {0x7f, 0xe0, 0x18, 0x38, 0x18, 0x1c, 0x18, 0x6, 0x18, 0x6, 0x18, 0x3, 0x18, 0x3, 0xff, 0x3, 0xff, 0x3, 0x18, 0x3, 0x18, 0x3, 0x18, 0x3, 0x18, 0x6, 0x18, 0x6, 0x18, 0x1c, 0x18, 0x38, 0x7f, 0xe0}

/* Ntilde (209) */
#define NXFONT_METRICS_209 {2, 16, 21, 1, 7, 0}
#define NXFONT_BITMAP_209 {0x3, 0x20, 0x7, 0xe0, 0x4, 0xc0, 0x0, 0x0, 0xf0, 0x1f, 0x30, 0x4, 0x38, 0x4, 0x38, 0x4, 0x2c, 0x4, 0x26, 0x4, 0x26, 0x4, 0x23, 0x4, 0x21, 0x84, 0x21, 0x84, 0x20, 0xc4, 0x20, 0x64, 0x20, 0x64, 0x20, 0x34, 0x20, 0x1c, 0x20, 0x1c, 0xf8, 0xc}

/* Ograve (210) */
#define NXFONT_METRICS_210 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_210 {0xc, 0x0, 0xe, 0x0, 0x7, 0x0, 0x1, 0x80, 0x0, 0x0, 0x7, 0xe0, 0x1c, 0x38, 0x38, 0x1c, 0x60, 0x6, 0x60, 0x6, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0x60, 0x6, 0x60, 0x6, 0x38, 0x1c, 0x1c, 0x38, 0x7, 0xe0}

/* Oacute (211) */
#define NXFONT_METRICS_211 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_211 {0x0, 0x30, 0x0, 0x70, 0x0, 0xe0, 0x1, 0x80, 0x0, 0x0, 0x7, 0xe0, 0x1c, 0x38, 0x38, 0x1c, 0x60, 0x6, 0x60, 0x6, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0x60, 0x6, 0x60, 0x6, 0x38, 0x1c, 0x1c, 0x38, 0x7, 0xe0}

/* Ocircumflex (212) */
#define NXFONT_METRICS_212 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_212 {0x1, 0x80, 0x3, 0xc0, 0x6, 0x60, 0x4, 0x20, 0x0, 0x0, 0x7, 0xe0, 0x1c, 0x38, 0x38, 0x1c, 0x60, 0x6, 0x60, 0x6, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0x60, 0x6, 0x60, 0x6, 0x38, 0x1c, 0x1c, 0x38, 0x7, 0xe0}

/* Otilde (213) */
#define NXFONT_METRICS_213 {2, 16, 21, 1, 7, 0}
#define NXFONT_BITMAP_213 {0x3, 0x20, 0x7, 0xe0, 0x4, 0xc0, 0x0, 0x0, 0x7, 0xe0, 0x1c, 0x38, 0x38, 0x1c, 0x60, 0x6, 0x60, 0x6, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0x60, 0x6, 0x60, 0x6, 0x38, 0x1c, 0x1c, 0x38, 0x7, 0xe0}

/* Odieresis (214) */
#define NXFONT_METRICS_214 {2, 16, 21, 1, 7, 0}
#define NXFONT_BITMAP_214 {0x6, 0x60, 0x6, 0x60, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x1c, 0x38, 0x38, 0x1c, 0x60, 0x6, 0x60, 0x6, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0x60, 0x6, 0x60, 0x6, 0x38, 0x1c, 0x1c, 0x38, 0x7, 0xe0}

/* multiply (215) */
#define NXFONT_METRICS_215 {2, 10, 9, 1, 18, 0}
#define NXFONT_BITMAP_215 {0xc0, 0xc0, 0x61, 0x80, 0x33, 0x0, 0x1e, 0x0, 0xc, 0x0, 0x1e, 0x0, 0x33, 0x0, 0x61, 0x80, 0xc0, 0xc0}

/* Oslash (216) */
#define NXFONT_METRICS_216 {2, 16, 19, 1, 10, 0}
#define NXFONT_BITMAP_216 {0x0, 0x4, 0x7, 0xe4, 0x1c, 0x38, 0x38, 0x1c, 0x60, 0x26, 0x60, 0x46, 0xc0, 0x43, 0xc0, 0x83, 0xc0, 0x83, 0xc1, 0x3, 0xc1, 0x3, 0xc2, 0x3, 0xc2, 0x3, 0x64, 0x6, 0x68, 0x6, 0x38, 0x1c, 0x1c, 0x38, 0x27, 0xe0, 0x20, 0x0}

/* Ugrave (217) */
#define NXFONT_METRICS_217 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_217 {0x6, 0x0, 0x7, 0x0, 0x3, 0x80, 0x0, 0xc0, 0x0, 0x0, 0xfc, 0x1f, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x8, 0x18, 0x8, 0x1c, 0x30, 0x7, 0xe0}

/* Uacute (218) */
#define NXFONT_METRICS_218 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_218 {0x0, 0x30, 0x0, 0x70, 0x0, 0xe0, 0x1, 0x80, 0x0, 0x0, 0xfc, 0x1f, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x8, 0x18, 0x8, 0x1c, 0x30, 0x7, 0xe0}

/* Ucircumflex (219) */
#define NXFONT_METRICS_219 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_219 {0x1, 0x80, 0x3, 0xc0, 0x6, 0x60, 0x4, 0x20, 0x0, 0x0, 0xfc, 0x1f, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x8, 0x18, 0x8, 0x1c, 0x30, 0x7, 0xe0}

/* Udieresis (220) */
#define NXFONT_METRICS_220 {2, 16, 21, 1, 7, 0}
#define NXFONT_BITMAP_220 {0x6, 0x60, 0x6, 0x60, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x1f, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x4, 0x30, 0x8, 0x18, 0x8, 0x1c, 0x30, 0x7, 0xe0}

/* Yacute (221) */
#define NXFONT_METRICS_221 {2, 16, 22, 1, 6, 0}
#define NXFONT_BITMAP_221 {0x0, 0x30, 0x0, 0x70, 0x0, 0xe0, 0x1, 0x80, 0x0, 0x0, 0xfc, 0x3f, 0x30, 0xc, 0x38, 0x8, 0x18, 0x18, 0x1c, 0x10, 0xc, 0x30, 0x6, 0x20, 0x6, 0x60, 0x3, 0x40, 0x3, 0xc0, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80, 0x7, 0xe0}

/* Thorn (222) */
#define NXFONT_METRICS_222 {2, 13, 17, 1, 11, 0}
#define NXFONT_BITMAP_222 {0xfc, 0x0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0x3f, 0xc0, 0x30, 0x70, 0x30, 0x30, 0x30, 0x18, 0x30, 0x18, 0x30, 0x18, 0x30, 0x30, 0x30, 0x70, 0x3f, 0xc0, 0x30, 0x0, 0x30, 0x0, 0x30, 0x0, 0xfc, 0x0}

/* germandbls (223) */
#define NXFONT_METRICS_223 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_223 {0x1e, 0x0, 0x33, 0x0, 0x61, 0x80, 0x61, 0x80, 0x61, 0x80, 0x61, 0x80, 0x63, 0x0, 0x6c, 0x0, 0x67, 0x0, 0x63, 0x80, 0x61, 0x80, 0x61, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x6c, 0xc0, 0x6c, 0x80, 0xe7, 0x0}

/* agrave (224) */
#define NXFONT_METRICS_224 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_224 {0x60, 0x0, 0x70, 0x0, 0x38, 0x0, 0xc, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x67, 0x0, 0x63, 0x0, 0x3, 0x0, 0xf, 0x0, 0x3b, 0x0, 0x63, 0x0, 0xc3, 0x0, 0xc3, 0x0, 0xc7, 0x0, 0xfb, 0x0, 0x71, 0x80}

/* aacute (225) */
#define NXFONT_METRICS_225 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_225 {0x3, 0x0, 0x7, 0x0, 0xe, 0x0, 0x18, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x67, 0x0, 0x63, 0x0, 0x3, 0x0, 0xf, 0x0, 0x3b, 0x0, 0x63, 0x0, 0xc3, 0x0, 0xc3, 0x0, 0xc7, 0x0, 0xfb, 0x0, 0x71, 0x80}

/* acircumflex (226) */
#define NXFONT_METRICS_226 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_226 {0xc, 0x0, 0x1e, 0x0, 0x33, 0x0, 0x21, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x67, 0x0, 0x63, 0x0, 0x3, 0x0, 0xf, 0x0, 0x3b, 0x0, 0x63, 0x0, 0xc3, 0x0, 0xc3, 0x0, 0xc7, 0x0, 0xfb, 0x0, 0x71, 0x80}

/* atilde (227) */
#define NXFONT_METRICS_227 {2, 9, 16, 1, 12, 0}
#define NXFONT_BITMAP_227 {0x32, 0x0, 0x7e, 0x0, 0x4c, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x67, 0x0, 0x63, 0x0, 0x3, 0x0, 0xf, 0x0, 0x3b, 0x0, 0x63, 0x0, 0xc3, 0x0, 0xc3, 0x0, 0xc7, 0x0, 0xfb, 0x0, 0x71, 0x80}

/* adieresis (228) */
#define NXFONT_METRICS_228 {2, 9, 16, 1, 12, 0}
#define NXFONT_BITMAP_228 {0x66, 0x0, 0x66, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x67, 0x0, 0x63, 0x0, 0x3, 0x0, 0xf, 0x0, 0x3b, 0x0, 0x63, 0x0, 0xc3, 0x0, 0xc3, 0x0, 0xc7, 0x0, 0xfb, 0x0, 0x71, 0x80}

/* aring (229) */
#define NXFONT_METRICS_229 {2, 9, 18, 1, 10, 0}
#define NXFONT_BITMAP_229 {0x1c, 0x0, 0x22, 0x0, 0x22, 0x0, 0x22, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x67, 0x0, 0x63, 0x0, 0x3, 0x0, 0xf, 0x0, 0x3b, 0x0, 0x63, 0x0, 0xc3, 0x0, 0xc3, 0x0, 0xc7, 0x0, 0xfb, 0x0, 0x71, 0x80}

/* ae (230) */
#define NXFONT_METRICS_230 {2, 14, 12, 1, 16, 0}
#define NXFONT_BITMAP_230 {0x3c, 0xf0, 0x67, 0x98, 0x63, 0xc, 0x3, 0xc, 0xf, 0xfc, 0x3b, 0x0, 0x63, 0x0, 0xc3, 0x0, 0xc3, 0x0, 0xc7, 0x84, 0xfb, 0xf8, 0x70, 0xf0}

/* ccedilla (231) */
#define NXFONT_METRICS_231 {2, 9, 18, 1, 16, 0}
#define NXFONT_BITMAP_231 {0x1f, 0x0, 0x63, 0x80, 0x41, 0x80, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0x70, 0x80, 0x7f, 0x0, 0x1e, 0x0, 0x8, 0x0, 0x18, 0x0, 0x1e, 0x0, 0x6, 0x0, 0x66, 0x0, 0x3c, 0x0}

/* egrave (232) */
#define NXFONT_METRICS_232 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_232 {0x60, 0x0, 0x70, 0x0, 0x38, 0x0, 0xc, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x63, 0x0, 0x41, 0x80, 0xc1, 0x80, 0xff, 0x80, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0x70, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* eacute (233) */
#define NXFONT_METRICS_233 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_233 {0x3, 0x0, 0x7, 0x0, 0xe, 0x0, 0x18, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x63, 0x0, 0x41, 0x80, 0xc1, 0x80, 0xff, 0x80, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0x70, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* ecircumflex (234) */
#define NXFONT_METRICS_234 {2, 9, 17, 1, 11, 0}
#define NXFONT_BITMAP_234 {0xc, 0x0, 0x1e, 0x0, 0x33, 0x0, 0x21, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x63, 0x0, 0x41, 0x80, 0xc1, 0x80, 0xff, 0x80, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0x70, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* edieresis (235) */
#define NXFONT_METRICS_235 {2, 9, 16, 1, 12, 0}
#define NXFONT_BITMAP_235 {0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x63, 0x0, 0x41, 0x80, 0xc1, 0x80, 0xff, 0x80, 0xc0, 0x0, 0xc0, 0x0, 0xc0, 0x0, 0xe0, 0x0, 0x70, 0x80, 0x7f, 0x0, 0x1e, 0x0}

/* igrave (236) */
#define NXFONT_METRICS_236 {1, 6, 17, 0, 11, 0}
#define NXFONT_BITMAP_236 {0xc0, 0xe0, 0x70, 0x18, 0x0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c}

/* iacute (237) */
#define NXFONT_METRICS_237 {1, 5, 17, 1, 11, 0}
#define NXFONT_BITMAP_237 {0x18, 0x38, 0x70, 0xc0, 0x0, 0x60, 0xe0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0xf0}

/* icircumflex (238) */
#define NXFONT_METRICS_238 {1, 6, 17, 0, 11, 0}
#define NXFONT_BITMAP_238 {0x30, 0x78, 0xcc, 0x84, 0x0, 0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78}

/* idieresis (239) */
#define NXFONT_METRICS_239 {1, 6, 16, 0, 12, 0}
#define NXFONT_BITMAP_239 {0xcc, 0xcc, 0x0, 0x0, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78}

/* eth (240) */
#define NXFONT_METRICS_240 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_240 {0xc0, 0x0, 0x71, 0x80, 0x1e, 0x0, 0x3c, 0x0, 0xc6, 0x0, 0x1f, 0x0, 0x73, 0x80, 0x61, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x61, 0x80, 0x73, 0x80, 0x1e, 0x0}

/* ntilde (241) */
#define NXFONT_METRICS_241 {2, 11, 16, 1, 12, 0}
#define NXFONT_BITMAP_241 {0x19, 0x0, 0x3f, 0x0, 0x26, 0x0, 0x0, 0x0, 0x67, 0x0, 0xef, 0x80, 0x71, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0xf1, 0xe0}

/* ograve (242) */
#define NXFONT_METRICS_242 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_242 {0x60, 0x0, 0x70, 0x0, 0x38, 0x0, 0xc, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x73, 0x80, 0x61, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x61, 0x80, 0x73, 0x80, 0x1e, 0x0}

/* oacute (243) */
#define NXFONT_METRICS_243 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_243 {0x3, 0x0, 0x7, 0x0, 0xe, 0x0, 0x18, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x73, 0x80, 0x61, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x61, 0x80, 0x73, 0x80, 0x1e, 0x0}

/* ocircumflex (244) */
#define NXFONT_METRICS_244 {2, 10, 17, 1, 11, 0}
#define NXFONT_BITMAP_244 {0xc, 0x0, 0x1e, 0x0, 0x33, 0x0, 0x21, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x73, 0x80, 0x61, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x61, 0x80, 0x73, 0x80, 0x1e, 0x0}

/* otilde (245) */
#define NXFONT_METRICS_245 {2, 10, 16, 1, 12, 0}
#define NXFONT_BITMAP_245 {0x19, 0x0, 0x3f, 0x0, 0x26, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x73, 0x80, 0x61, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x61, 0x80, 0x73, 0x80, 0x1e, 0x0}

/* odieresis (246) */
#define NXFONT_METRICS_246 {2, 10, 16, 1, 12, 0}
#define NXFONT_BITMAP_246 {0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x73, 0x80, 0x61, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x61, 0x80, 0x73, 0x80, 0x1e, 0x0}

/* divide (247) */
#define NXFONT_METRICS_247 {2, 10, 10, 1, 17, 0}
#define NXFONT_BITMAP_247 {0xc, 0x0, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0xc, 0x0}

/* oslash (248) */
#define NXFONT_METRICS_248 {2, 10, 14, 1, 15, 0}
#define NXFONT_BITMAP_248 {0x0, 0xc0, 0x1e, 0xc0, 0x73, 0x80, 0x63, 0x80, 0xc6, 0xc0, 0xc4, 0xc0, 0xcc, 0xc0, 0xc8, 0xc0, 0xd8, 0xc0, 0xd0, 0xc0, 0x71, 0x80, 0x73, 0x80, 0xde, 0x0, 0xc0, 0x0}

/* ugrave (249) */
#define NXFONT_METRICS_249 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_249 {0x60, 0x0, 0x70, 0x0, 0x38, 0x0, 0xc, 0x0, 0x0, 0x0, 0xe1, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x71, 0xc0, 0x3e, 0xc0, 0x1c, 0xe0}

/* uacute (250) */
#define NXFONT_METRICS_250 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_250 {0x1, 0x80, 0x3, 0x80, 0x7, 0x0, 0xc, 0x0, 0x0, 0x0, 0xe1, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x71, 0xc0, 0x3e, 0xc0, 0x1c, 0xe0}

/* ucircumflex (251) */
#define NXFONT_METRICS_251 {2, 11, 17, 1, 11, 0}
#define NXFONT_BITMAP_251 {0xc, 0x0, 0x1e, 0x0, 0x33, 0x0, 0x21, 0x0, 0x0, 0x0, 0xe1, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x71, 0xc0, 0x3e, 0xc0, 0x1c, 0xe0}

/* udieresis (252) */
#define NXFONT_METRICS_252 {2, 11, 16, 1, 12, 0}
#define NXFONT_BITMAP_252 {0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe1, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x71, 0xc0, 0x3e, 0xc0, 0x1c, 0xe0}

/* yacute (253) */
#define NXFONT_METRICS_253 {2, 11, 22, 0, 11, 0}
#define NXFONT_BITMAP_253 {0x1, 0x80, 0x3, 0x80, 0x7, 0x0, 0xc, 0x0, 0x0, 0x0, 0xf1, 0xe0, 0x60, 0xc0, 0x60, 0x80, 0x30, 0x80, 0x30, 0x80, 0x31, 0x0, 0x19, 0x0, 0x19, 0x0, 0x1a, 0x0, 0xe, 0x0, 0xe, 0x0, 0x4, 0x0, 0xc, 0x0, 0x8, 0x0, 0x18, 0x0, 0xf0, 0x0, 0xe0, 0x0}

/* thorn (254) */
#define NXFONT_METRICS_254 {2, 10, 22, 1, 11, 0}
#define NXFONT_BITMAP_254 {0x60, 0x0, 0xe0, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x6e, 0x0, 0x73, 0x80, 0x61, 0x80, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x60, 0xc0, 0x61, 0x80, 0x73, 0x80, 0x6e, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0x60, 0x0, 0xf0, 0x0}

/* ydieresis (255) */
#define NXFONT_METRICS_255 {2, 11, 21, 0, 12, 0}
#define NXFONT_BITMAP_255 {0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf1, 0xe0, 0x60, 0xc0, 0x60, 0x80, 0x30, 0x80, 0x30, 0x80, 0x31, 0x0, 0x19, 0x0, 0x19, 0x0, 0x1a, 0x0, 0xe, 0x0, 0xe, 0x0, 0x4, 0x0, 0xc, 0x0, 0x8, 0x0, 0x18, 0x0, 0xf0, 0x0, 0xe0, 0x0}

/****************************************************************************
 * Public Types
 ****************************************************************************/

/****************************************************************************
 * Public Data
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
#define EXTERN extern "C"
extern "C"
{
#else
#define EXTERN extern
#endif

/****************************************************************************
 * Public Functions Definitions
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
}
#endif

#endif /* __LIBS_LIBNX_NXFONTS_NXFONTS_SERIF29X37_H */
